/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.types;

import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.FSStatement;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.types.AbstractColumn;
import com.sas.tkts.types.ByteArrayColumn;
import com.sas.tkts.types.DateColumn;
import com.sas.tkts.types.LobColumn;
import com.sas.tkts.types.NumberColumnBigDecimal;
import com.sas.tkts.types.NumberColumnByte;
import com.sas.tkts.types.NumberColumnDouble;
import com.sas.tkts.types.NumberColumnFloat;
import com.sas.tkts.types.NumberColumnInteger;
import com.sas.tkts.types.NumberColumnLong;
import com.sas.tkts.types.NumberColumnShort;
import com.sas.tkts.types.StringColumn;
import com.sas.tkts.types.TimeColumn;
import com.sas.tkts.types.TimestampColumn;
import com.sas.tkts.util.ParameterInfoHelper;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public final class ColumnFactory {
    private static String thisClassName = ColumnFactory.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);

    private ColumnFactory() {
    }

    public static AbstractColumn createStringColunn(String data) throws SQLException {
        return new StringColumn(data);
    }

    public static AbstractColumn createIntegerColumn(int data) throws SQLException {
        return new NumberColumnInteger(new Integer(data));
    }

    public static AbstractColumn createByteColumn(byte data) throws SQLException {
        return new NumberColumnByte(data);
    }

    public static AbstractColumn createByteArrayColumn(byte[] data) throws SQLException {
        return new ByteArrayColumn(data);
    }

    public static AbstractColumn createShortColumn(short data) throws SQLException {
        return new NumberColumnShort(data);
    }

    public static AbstractColumn createLongColumn(long data) throws SQLException {
        return new NumberColumnLong(data);
    }

    public static AbstractColumn createDoubleColumn(double data) throws SQLException {
        NumberColumnDouble out = new NumberColumnDouble(data);
        return out;
    }

    public static AbstractColumn createFloatRealColumn(float data, int sqlType) throws SQLException {
        if (sqlType == 7) {
            return new NumberColumnFloat(data);
        }
        return new NumberColumnDouble(data);
    }

    public static AbstractColumn createBigDecimalColumn(BigDecimal data) throws SQLException {
        return new NumberColumnBigDecimal(data);
    }

    public static AbstractColumn createDateColumn(Date data) throws SQLException {
        return new DateColumn(data);
    }

    public static AbstractColumn createTimeColumn(Time data) throws SQLException {
        return new TimeColumn(data);
    }

    public static AbstractColumn createTimestampColumn(Timestamp data) throws SQLException {
        return new TimestampColumn(data);
    }

    public static AbstractColumn createBlobColumn(FSStatement stmtHandle, int colNumber, int rowNumber, int sqlType) throws SQLException {
        return new LobColumn(stmtHandle, colNumber, rowNumber, sqlType);
    }

    public static AbstractColumn createNullValueColumn(int type, long indicator) throws SQLException {
        AbstractColumn returnfield = null;
        switch (type) {
            case -7: {
                LocalizedErrorHandler.throwLocalizedException("TKTSResultSet.badTypeError.txt", logger);
                break;
            }
            case -6: {
                returnfield = new NumberColumnByte(0);
                returnfield.setNull();
                break;
            }
            case 5: {
                returnfield = new NumberColumnShort(0);
                returnfield.setNull();
                break;
            }
            case 4: {
                returnfield = new NumberColumnInteger(0);
                returnfield.setNull();
                break;
            }
            case -5: {
                returnfield = new NumberColumnLong(0L);
                returnfield.setNull();
                break;
            }
            case 6: {
                returnfield = new NumberColumnFloat(0.0f);
                returnfield.setNull();
                break;
            }
            case 7: {
                returnfield = new NumberColumnFloat(0.0f);
                returnfield.setNull();
                break;
            }
            case 8: {
                Double dObj = ParameterInfoHelper.indicatorToMissingValue(indicator);
                double d = dObj == null ? Double.NaN : dObj;
                NumberColumnDouble cd = new NumberColumnDouble(d);
                cd.setNull(d);
                returnfield = cd;
                break;
            }
            case 2: 
            case 3: {
                returnfield = new NumberColumnBigDecimal(null);
                break;
            }
            case -9: 
            case -8: 
            case 1: 
            case 12: {
                if (indicator == -1L) {
                    returnfield = new StringColumn(null);
                    break;
                }
                returnfield = new StringColumn("");
                break;
            }
            case -1: {
                returnfield = new StringColumn(null);
                break;
            }
            case -3: 
            case -2: {
                returnfield = new ByteArrayColumn(null);
                break;
            }
            case -4: {
                returnfield = new LobColumn();
                break;
            }
            case 91: {
                returnfield = new DateColumn(null);
                break;
            }
            case 92: {
                returnfield = new TimeColumn(null);
                break;
            }
            case 93: {
                returnfield = new TimestampColumn(null);
            }
        }
        return returnfield;
    }
}

