/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.types;

import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.types.BlobFedSrv;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class BlobOutputStream
extends OutputStream {
    private transient BlobFedSrv blob;
    private transient int currentPosition;
    private transient boolean closed;

    protected BlobOutputStream(BlobFedSrv blob, int position) throws SQLException {
        this.blob = blob;
        this.currentPosition = position;
        this.closed = false;
    }

    private SQLException closedException() throws IOException {
        String ei = "TKTSBlobOutputStream.closed.txt";
        String es = LocalizedErrorHandler.getLocalizedError("TKTSBlobOutputStream.closed.txt", null);
        IOException outEx = new IOException(es);
        throw outEx;
    }

    private IOException invalidDataIOException() {
        String ei = "TKTSBlobOutputStream.nullData.txt";
        String es = LocalizedErrorHandler.getLocalizedError("TKTSBlobOutputStream.nullData.txt", null);
        IOException outEx = new IOException(es);
        return outEx;
    }

    private IOException invalidOffsetOException(int off, int dataLen) {
        String ei = "TKTSBlobOutputStream.invalidOffset.fmt";
        Object[] args = new String[]{Integer.toString(off), Integer.toString(dataLen)};
        String es = LocalizedErrorHandler.getLocalizedError("TKTSBlobOutputStream.invalidOffset.fmt", args);
        IOException outEx = new IOException(es);
        return outEx;
    }

    private IOException SqlToIOException(SQLException se) {
        String exMsg = se.getLocalizedMessage();
        IOException outEx = new IOException(exMsg);
        return outEx;
    }

    private void checkStatus() throws IOException {
        if (this.closed) {
            this.closedException();
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public void flush() throws IOException {
        this.checkStatus();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.checkStatus();
        if (b == null) {
            throw this.invalidDataIOException();
        }
        try {
            this.currentPosition += this.blob.setBytes(this.currentPosition, b);
        }
        catch (SQLException se) {
            throw this.SqlToIOException(se);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkStatus();
        if (b == null) {
            throw this.invalidDataIOException();
        }
        if (off < 0 || off >= b.length) {
            throw this.invalidOffsetOException(off, b.length);
        }
        try {
            this.currentPosition += this.blob.setBytes(this.currentPosition, b, off, len);
        }
        catch (SQLException se) {
            throw this.SqlToIOException(se);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkStatus();
        int byteMask = 255;
        byte[] inBytes = new byte[]{(byte)(b & 0xFF)};
        try {
            this.currentPosition += this.blob.setBytes(this.currentPosition, inBytes);
        }
        catch (SQLException se) {
            throw this.SqlToIOException(se);
        }
    }
}

