/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.sql;

import com.sas.SASTableServer.IEnvironment;
import com.sas.SASTableServer.TKTS_ERROR;
import com.sas.SASTableServer.TKTS_INVALID_HANDLE;
import com.sas.SASTableServer.TKTS_NO_DATA;
import com.sas.SASTableServer.TKTS_STILL_EXECUTING;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.tkts.iom.ConnectionWrapper;
import com.sas.tkts.iom.StatementWrapper;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.sql.FSException;
import com.sas.tkts.util.VendorSpecificErrorCode;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.omg.CORBA.BAD_PARAM;

public class LocalizedErrorHandler {
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.sas.tkts.Resources");
    private static final String DEFAULT_SQL_STATE = "HY000";
    private static final String BRACKET_LEFT = " [";
    private static final String BRACKET_RIGHT = "]";
    private static final String SQLSTATE = " SQLSTATE:[";
    private static final String MESSAGE = "] MESSAGE:[";
    private static final String NATIVE_ERROR = "] NATIVEERROR:[";

    public static String getLocalizedError(String messageKey, Object[] args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null) continue;
                args[i] = "<_?_>";
            }
        }
        return MessageFormat.format(LocalizedErrorHandler.getString(messageKey), args);
    }

    public static String getLocalizedErrorParms(String messageKey, Object ... args) {
        String out = MessageFormat.format(LocalizedErrorHandler.getString(messageKey), args);
        return out;
    }

    public static String getString(String messageKey) {
        try {
            messageKey = resourceBundle.getString(messageKey);
        }
        catch (MissingResourceException e) {
            System.err.println("Missing Resource String:" + messageKey);
            System.err.flush();
            messageKey = "";
        }
        return messageKey;
    }

    public static SQLException createExceptionsInFunction(String method, Exception exception, Object wrapperObject, AbstractLogger logger) {
        String messageKey = "GenericError.fmt";
        Exception tException = null;
        if (exception instanceof TKTS_ERROR) {
            messageKey = "TKTS_ERROR.fmt";
        } else if (exception instanceof TKTS_INVALID_HANDLE) {
            messageKey = "TKTS_INVALID_HANDLE.fmt";
        } else if (exception instanceof TKTS_STILL_EXECUTING) {
            messageKey = "TKTS_STILL_EXECUTING.fmt";
        } else if (exception instanceof TKTS_NO_DATA) {
            messageKey = "TKTS_NO_DATA.fmt";
        } else if (exception instanceof BAD_PARAM) {
            messageKey = "IOM_BAD_PARAM.fmt";
        } else {
            tException = exception;
        }
        if (tException == null && exception != null) {
            String tEx = exception.getMessage();
            FSException se = new FSException(tEx);
            tException = se;
        }
        Object[] args = new String[]{method};
        SQLException sqlException = LocalizedErrorHandler.getLocalizedSQLException(messageKey, args, tException, wrapperObject, DEFAULT_SQL_STATE);
        if (logger != null) {
            logger.error(sqlException.toString(), sqlException);
        }
        return sqlException;
    }

    public static void handleExceptionsInFunction(String method, Exception exception, Object wrapperObject, AbstractLogger logger) throws SQLException {
        SQLException se = LocalizedErrorHandler.createExceptionsInFunction(method, exception, wrapperObject, logger);
        throw se;
    }

    public static void throwLocalizedException(String messageKey, AbstractLogger logger) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException(messageKey, logger, DEFAULT_SQL_STATE);
    }

    public static void throwLocalizedException(String messageKey, AbstractLogger logger, String sqlState) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException(messageKey, null, null, null, logger, sqlState);
    }

    public static void throwLocalizedException(String messageKey, Object[] args, AbstractLogger logger) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException(messageKey, args, logger, DEFAULT_SQL_STATE);
    }

    public static void throwLocalizedException(String messageKey, Object[] args, AbstractLogger logger, String sqlState) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException(messageKey, args, null, null, logger, sqlState);
    }

    public static void throwLocalizedException(String messageKey, Object[] args, Exception theException, AbstractLogger logger) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException(messageKey, args, theException, logger, DEFAULT_SQL_STATE);
    }

    public static void throwLocalizedException(String messageKey, Object[] args, Exception theException, AbstractLogger logger, String sqlState) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException(messageKey, args, theException, null, logger, sqlState);
    }

    public static void throwLocalizedException(String messageKey, Object[] args, Exception theException, Object wrapperObject, AbstractLogger logger) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException(messageKey, args, theException, wrapperObject, logger, DEFAULT_SQL_STATE);
    }

    public static void throwLocalizedException(String messageKey, Object[] args, Exception theException, Object wrapperObject, AbstractLogger logger, String sqlState) throws SQLException {
        SQLException sqlException = LocalizedErrorHandler.getLocalizedSQLException(messageKey, args, theException, wrapperObject, sqlState);
        if (logger != null) {
            logger.error(sqlException.toString(), sqlException);
        }
        throw sqlException;
    }

    public static SQLWarning createLocalizedWarning(String messageKey, Object[] args, Exception theException, Object wrapperObject, AbstractLogger logger) {
        SQLWarning sqlWarning = LocalizedErrorHandler.getLocalizedSQLWarning(messageKey, args, theException, wrapperObject);
        if (logger != null) {
            logger.warn(sqlWarning.toString(), sqlWarning);
        }
        return sqlWarning;
    }

    public static SQLWarning createLocalizedWarnnigs(Object wrapperObject) {
        return LocalizedErrorHandler.getLocalizedSQLWarning("GenericWarning.txt", null, null, wrapperObject);
    }

    public static VendorSpecificErrorCode getVendorSpecificErrorCode(Object wrapperObject) {
        int[] recNumbers = new int[]{};
        StringSeqHolder sqlStates = new StringSeqHolder();
        LongSeqHolder nativeErrors = new LongSeqHolder();
        StringSeqHolder messageTexts = new StringSeqHolder();
        LongSeqHolder status = new LongSeqHolder();
        VendorSpecificErrorCode vendorCodes = new VendorSpecificErrorCode();
        if (wrapperObject != null) {
            try {
                if (wrapperObject instanceof StatementWrapper) {
                    ((StatementWrapper)wrapperObject).GetDiagRecs(recNumbers, sqlStates, nativeErrors, messageTexts, status);
                } else if (wrapperObject instanceof ConnectionWrapper) {
                    ((ConnectionWrapper)wrapperObject).GetDiagRecs(recNumbers, sqlStates, nativeErrors, messageTexts, status);
                } else if (wrapperObject instanceof IEnvironment) {
                    ((IEnvironment)wrapperObject).GetDiagRecs(recNumbers, sqlStates, nativeErrors, messageTexts, status);
                }
            }
            catch (Exception e) {
                return vendorCodes;
            }
            if (messageTexts != null && messageTexts.value != null && messageTexts.value.length > 0) {
                vendorCodes.setMessageText(messageTexts.value);
                vendorCodes.setErrorCode(nativeErrors.value);
                vendorCodes.setSqlState(sqlStates.value);
            }
        }
        return vendorCodes;
    }

    public static SQLException getLocalizedSQLException(String messageKey, Object[] args, Exception theException, Object wrapperObject, String sqlState) {
        int[] recNumbers = new int[]{};
        SQLException sqlException = null;
        StringBuffer buffer = new StringBuffer();
        StringSeqHolder sqlStates = new StringSeqHolder();
        LongSeqHolder nativeErrors = new LongSeqHolder();
        StringSeqHolder messageTexts = new StringSeqHolder();
        LongSeqHolder status = new LongSeqHolder();
        if (wrapperObject != null) {
            try {
                if (wrapperObject instanceof StatementWrapper) {
                    ((StatementWrapper)wrapperObject).GetDiagRecs(recNumbers, sqlStates, nativeErrors, messageTexts, status);
                } else if (wrapperObject instanceof ConnectionWrapper) {
                    ((ConnectionWrapper)wrapperObject).GetDiagRecs(recNumbers, sqlStates, nativeErrors, messageTexts, status);
                } else if (wrapperObject instanceof IEnvironment) {
                    ((IEnvironment)wrapperObject).GetDiagRecs(recNumbers, sqlStates, nativeErrors, messageTexts, status);
                }
            }
            catch (Exception e) {
                messageTexts.value = null;
            }
        }
        buffer.append(LocalizedErrorHandler.getLocalizedError(messageKey, args));
        if (theException != null && messageTexts.value != null && messageTexts.value.length > 0) {
            buffer.append(BRACKET_LEFT);
            buffer.append(theException.toString());
            buffer.append(BRACKET_RIGHT);
            buffer.append(SQLSTATE);
            buffer.append(sqlStates.value[0]);
            buffer.append(MESSAGE);
            buffer.append(messageTexts.value[0]);
            buffer.append(NATIVE_ERROR);
            buffer.append(nativeErrors.value[0]);
            buffer.append(BRACKET_RIGHT);
            sqlException = new SQLException(buffer.toString(), sqlStates.value[0], nativeErrors.value[0]);
            if (theException instanceof SQLException) {
                sqlException.setNextException((SQLException)theException);
            }
            LocalizedErrorHandler.putTogetherServerExceptions(sqlException, messageTexts, nativeErrors, sqlStates);
        } else if (messageTexts.value != null && messageTexts.value.length > 0) {
            buffer.append(SQLSTATE);
            buffer.append(sqlStates.value[0]);
            buffer.append(MESSAGE);
            buffer.append(messageTexts.value[0]);
            buffer.append(NATIVE_ERROR);
            buffer.append(nativeErrors.value[0]);
            buffer.append(BRACKET_RIGHT);
            sqlException = new SQLException(buffer.toString(), sqlStates.value[0], nativeErrors.value[0]);
            LocalizedErrorHandler.putTogetherServerExceptions(sqlException, messageTexts, nativeErrors, sqlStates);
        } else if (theException != null) {
            buffer.append(BRACKET_LEFT);
            buffer.append(theException.toString());
            buffer.append(BRACKET_RIGHT);
            sqlException = new SQLException(buffer.toString(), sqlState);
            if (theException instanceof SQLException) {
                sqlException.setNextException((SQLException)theException);
            }
        } else {
            sqlException = new SQLException(buffer.toString(), sqlState);
        }
        LocalizedErrorHandler.adjustStack(sqlException);
        return sqlException;
    }

    private static SQLWarning getLocalizedSQLWarning(String messageKey, Object[] args, Exception theException, Object wrapperObject) {
        int[] recNumbers = new int[]{};
        SQLWarning sqlWarning = null;
        StringBuffer buffer = new StringBuffer();
        int index = 1;
        StringSeqHolder sqlStates = new StringSeqHolder();
        LongSeqHolder nativeErrors = new LongSeqHolder();
        StringSeqHolder messageTexts = new StringSeqHolder();
        LongSeqHolder status = new LongSeqHolder();
        if (wrapperObject != null) {
            try {
                if (wrapperObject instanceof StatementWrapper) {
                    ((StatementWrapper)wrapperObject).GetDiagRecs(recNumbers, sqlStates, nativeErrors, messageTexts, status);
                } else if (wrapperObject instanceof ConnectionWrapper) {
                    ((ConnectionWrapper)wrapperObject).GetDiagRecs(recNumbers, sqlStates, nativeErrors, messageTexts, status);
                } else if (wrapperObject instanceof IEnvironment) {
                    ((IEnvironment)wrapperObject).GetDiagRecs(recNumbers, sqlStates, nativeErrors, messageTexts, status);
                }
            }
            catch (Exception e) {
                sqlWarning = new SQLWarning(e.getLocalizedMessage(), DEFAULT_SQL_STATE);
            }
        }
        buffer.append(LocalizedErrorHandler.getLocalizedError(messageKey, args));
        if (theException != null && messageTexts.value != null && messageTexts.value.length > 0) {
            buffer.append(BRACKET_LEFT);
            buffer.append(theException.toString());
            buffer.append(BRACKET_RIGHT);
            buffer.append(SQLSTATE);
            buffer.append(sqlStates.value[0]);
            buffer.append(MESSAGE);
            buffer.append(messageTexts.value[0]);
            buffer.append(NATIVE_ERROR);
            buffer.append(nativeErrors.value[0]);
            buffer.append(BRACKET_RIGHT);
            sqlWarning = new SQLWarning(buffer.toString(), sqlStates.value[0], nativeErrors.value[0]);
            if (theException instanceof SQLException) {
                sqlWarning.setNextException((SQLException)theException);
            }
            LocalizedErrorHandler.putTogetherServerWarning(sqlWarning, messageTexts, nativeErrors, sqlStates, index);
        } else if (messageTexts.value != null && messageTexts.value.length > 0) {
            index = 0;
            sqlWarning = new SQLWarning(buffer.toString(), DEFAULT_SQL_STATE);
            LocalizedErrorHandler.putTogetherServerWarning(sqlWarning, messageTexts, nativeErrors, sqlStates, index);
        } else if (theException != null) {
            buffer.append(BRACKET_LEFT);
            buffer.append(theException.toString());
            buffer.append(BRACKET_RIGHT);
            sqlWarning = new SQLWarning(buffer.toString(), DEFAULT_SQL_STATE);
            if (theException instanceof SQLException) {
                sqlWarning.setNextException((SQLException)theException);
            }
        } else {
            sqlWarning = new SQLWarning(buffer.toString(), DEFAULT_SQL_STATE);
        }
        return sqlWarning;
    }

    private static SQLException putTogetherServerExceptions(SQLException sqlException, StringSeqHolder messageTexts, LongSeqHolder nativeErrors, StringSeqHolder sqlStates) {
        for (int i = 1; i < sqlStates.value.length; ++i) {
            SQLException ex = new SQLException(messageTexts.value[i], sqlStates.value[i], nativeErrors.value[i]);
            sqlException.setNextException(ex);
        }
        return sqlException;
    }

    private static SQLException putTogetherServerWarning(SQLWarning sqlWarning, StringSeqHolder messageTexts, LongSeqHolder nativeErrors, StringSeqHolder sqlStates, int index) {
        for (int i = index; i < sqlStates.value.length; ++i) {
            SQLWarning ex = new SQLWarning(messageTexts.value[i], sqlStates.value[i], nativeErrors.value[i]);
            sqlWarning.setNextException(ex);
        }
        return sqlWarning;
    }

    public SQLFeatureNotSupportedException getSQLFeatureNotSupportedExceptionNI(String methodDesc) {
        String messageKey = "General.methodNotImplemented.fmt";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        Object[] args = new String[]{methodDesc};
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", args);
        ex = new SQLFeatureNotSupportedException(lMsg);
        return ex;
    }

    private static void adjustStack(SQLException se) {
        int e;
        if (se == null) {
            return;
        }
        StackTraceElement[] oldStackArray = se.getStackTrace();
        int oldEntries = oldStackArray.length;
        for (e = oldEntries - 1; e > 0; --e) {
            StackTraceElement ste = oldStackArray[e];
            String className = ste.getClassName();
            int i = className.indexOf("com.sas.tkts.sql.LocalizedErrorHandler");
            if (i == -1) continue;
            ++e;
            break;
        }
        int newEntries = oldEntries - e;
        StackTraceElement[] newStackArray = new StackTraceElement[newEntries];
        e = oldEntries - 1;
        for (int l = newEntries - 1; l >= 0; --l) {
            newStackArray[l] = oldStackArray[e];
            --e;
        }
        se.setStackTrace(newStackArray);
    }
}

