/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.sql;

import com.sas.tkts.caching.AbstractRowCache;
import com.sas.tkts.iom.StatementWrapper;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.FSResultSetMetaData;
import com.sas.tkts.sql.LocalizedErrorHandler;
import java.sql.SQLException;
import javax.sql.RowSetMetaData;

public class FSRowSetMetaData
extends FSResultSetMetaData
implements RowSetMetaData {
    private static String thisClassName = FSRowSetMetaData.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);

    protected FSRowSetMetaData() {
    }

    public FSRowSetMetaData(AbstractRowCache abstractRowCache, StatementWrapper stmtWrapper) throws SQLException {
        this.statementWrapper = stmtWrapper;
        this.numberOfColumns = abstractRowCache.getColumnCount();
        this.columnTypes = new int[this.numberOfColumns];
        this.columnLengths = new int[this.numberOfColumns];
        this.columnNames = new String[this.numberOfColumns];
        for (int i = 1; i <= this.numberOfColumns; ++i) {
            this.columnTypes[i - 1] = abstractRowCache.getColumnType(i);
            this.columnLengths[i - 1] = abstractRowCache.getColumnLength(i);
            this.columnNames[i - 1] = abstractRowCache.getColumnName(i);
        }
        this.populateColumnAttributes(this.numberOfColumns);
    }

    @Override
    public void setColumnCount(int value) throws SQLException {
        String method = "setColumnCount";
        if (value < 0) {
            LocalizedErrorHandler.throwLocalizedException("TKTSResultSetMetaData.invalidColumnCountValue.fmt", new String[]{method}, logger);
        }
        if (value != this.numberOfColumns) {
            this.numberOfColumns = value;
            this.reInitializeArrays();
        }
    }

    @Override
    public void setColumnDisplaySize(int index, int value) throws SQLException {
        String method = "setColumnDisplaySize";
        this.validateColumnIndex(method, index);
        this.columnLengths[index - 1] = value;
    }

    @Override
    public void setColumnType(int index, int value) throws SQLException {
        String method = "setColumnType";
        this.validateColumnIndex(method, index);
        this.columnTypes[index - 1] = value;
    }

    @Override
    public void setNullable(int index, int value) throws SQLException {
        String method = "setNullable";
        this.validateColumnIndex(method, index);
        this.columnNullables[index - 1] = value;
    }

    @Override
    public void setPrecision(int index, int value) throws SQLException {
        String method = "setPrecision";
        this.validateColumnIndex(method, index);
        this.columnPrecisions[index - 1] = value;
    }

    @Override
    public void setScale(int index, int value) throws SQLException {
        String method = "setScale";
        this.validateColumnIndex(method, index);
        this.columnScales[index - 1] = value;
    }

    @Override
    public void setAutoIncrement(int index, boolean value) throws SQLException {
        String method = "setAutoIncrement";
        this.validateColumnIndex(method, index);
        this.columnIsAutoIncrement[index - 1] = value;
    }

    @Override
    public void setCaseSensitive(int index, boolean value) throws SQLException {
        String method = "setCaseSensitive";
        this.validateColumnIndex(method, index);
        this.columnIsCaseSensitive[index - 1] = value;
    }

    @Override
    public void setCurrency(int index, boolean value) throws SQLException {
        String method = "setCurrency";
        this.validateColumnIndex(method, index);
        this.columnIsCurrency[index - 1] = value;
    }

    @Override
    public void setSearchable(int index, boolean value) throws SQLException {
        String method = "setSearchable";
        this.validateColumnIndex(method, index);
        this.columnIsSearchable[index - 1] = value;
    }

    @Override
    public void setSigned(int index, boolean value) throws SQLException {
        String method = "setSigned";
        this.validateColumnIndex(method, index);
        this.columnIsUnsigned[index - 1] = value;
    }

    @Override
    public void setCatalogName(int index, String value) throws SQLException {
        String method = "setCatalogName";
        this.validateColumnIndex(method, index);
        this.columnCatalogNames[index - 1] = value;
    }

    @Override
    public void setColumnLabel(int index, String value) throws SQLException {
        String method = "setColumnLabel";
        this.validateColumnIndex(method, index);
        this.columnLabels[index - 1] = value;
    }

    @Override
    public void setColumnName(int index, String value) throws SQLException {
        String method = "setColumnName";
        this.validateColumnIndex(method, index);
        this.columnNames[index - 1] = value;
    }

    @Override
    public void setColumnTypeName(int index, String value) throws SQLException {
        String method = "setColumnTypeName";
        this.validateColumnIndex(method, index);
        this.columnTypeNames[index - 1] = value;
    }

    @Override
    public void setSchemaName(int index, String value) throws SQLException {
        String method = "setSchemaName";
        this.validateColumnIndex(method, index);
        this.columnSchemaNames[index - 1] = value;
    }

    @Override
    public void setTableName(int index, String value) throws SQLException {
        String method = "setTableName";
        this.validateColumnIndex(method, index);
        this.columnTableNames[index - 1] = value;
    }

    private void reInitializeArrays() {
        this.columnTypes = new int[this.numberOfColumns];
        this.columnLengths = new int[this.numberOfColumns];
        this.columnNames = new String[this.numberOfColumns];
        this.columnCatalogNames = new String[this.numberOfColumns];
        this.columnLabels = new String[this.numberOfColumns];
        this.columnTypeNames = new String[this.numberOfColumns];
        this.columnPrecisions = new int[this.numberOfColumns];
        this.columnScales = new int[this.numberOfColumns];
        this.columnSchemaNames = new String[this.numberOfColumns];
        this.columnTableNames = new String[this.numberOfColumns];
        this.columnIsAutoIncrement = new boolean[this.numberOfColumns];
        this.columnIsCaseSensitive = new boolean[this.numberOfColumns];
        this.columnIsWritable = new boolean[this.numberOfColumns];
        this.columnIsDefWritable = new boolean[this.numberOfColumns];
        this.columnIsReadOnly = new boolean[this.numberOfColumns];
        this.columnIsCurrency = new boolean[this.numberOfColumns];
        this.columnNullables = new int[this.numberOfColumns];
        this.columnIsSearchable = new boolean[this.numberOfColumns];
        this.columnIsUnsigned = new boolean[this.numberOfColumns];
    }
}

