/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.sql;

import com.sas.iom.SASIOMDefs.AnySeqHolder;
import com.sas.iom.SASIOMDefs.LongSeqHelper;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHelper;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfLongHolder;
import com.sas.tkts.caching.AbstractRowCache;
import com.sas.tkts.caching.MetaDataRowCache;
import com.sas.tkts.iom.StatementWrapper;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.ExceptionsLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.Constants;
import com.sas.tkts.sql.FSConnection;
import com.sas.tkts.sql.FSResultSet;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.util.UtilityFunctions;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import org.omg.CORBA.Any;
import org.omg.CORBA.IntHolder;

public class FSResultSetMetaData
implements ResultSetMetaData {
    private static String thisClassName = FSResultSetMetaData.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    private static final int ATTRIBUTE_COUNT = 14;
    private static final int CATALOG_NAME = 0;
    private static final int LABEL = 1;
    private static final int TYPE_NAME = 2;
    private static final int PRECISION = 3;
    private static final int SCALE = 4;
    private static final int SCHEMA_NAME = 5;
    private static final int TABLE_NAME = 6;
    private static final int AUTO_UNIQUE_VALUE = 7;
    private static final int CASE_SENSITIVE = 8;
    private static final int FIXED_PREC_SCALE = 9;
    private static final int UPDATABLE = 10;
    private static final int NULLABLE = 11;
    private static final int SEARCHABLE = 12;
    private static final int UNSIGNED = 13;
    private transient String[] sqlStates;
    private String[] errorMessages;
    protected transient int numberOfColumns;
    protected transient StatementWrapper statementWrapper;
    protected transient int[] columnTypes;
    protected transient int[] columnLengths;
    protected transient int[] columnPrecisions;
    protected transient int[] columnScales;
    protected transient int[] columnNullables;
    protected transient String[] columnNames;
    protected transient String[] columnCatalogNames;
    protected transient String[] columnLabels;
    protected transient String[] columnTypeNames;
    protected transient String[] columnSchemaNames;
    protected transient String[] columnTableNames;
    protected transient boolean[] columnIsAutoIncrement;
    protected transient boolean[] columnIsCaseSensitive;
    protected transient boolean[] columnIsWritable;
    protected transient boolean[] columnIsDefWritable;
    protected transient boolean[] columnIsReadOnly;
    protected transient boolean[] columnIsCurrency;
    protected transient boolean[] columnIsSearchable;
    protected transient boolean[] columnIsUnsigned;

    protected FSResultSetMetaData() {
    }

    protected FSResultSetMetaData(FSResultSet rSet) throws SQLException {
        AbstractRowCache abstRowCache = rSet.getAbstractRowCache();
        this.statementWrapper = rSet.getStatementWrapper();
        this.numberOfColumns = abstRowCache.getColumnCount();
        int boundColumns = abstRowCache.getBoundColumns();
        if (AbstractLogger.isTrace) {
            logger.trace("FSResultSetMetaData statementWrapper[" + this.statementWrapper + "] numberOfColumns[" + this.numberOfColumns + "] ");
        }
        this.columnTypes = new int[this.numberOfColumns];
        this.columnLengths = new int[this.numberOfColumns];
        this.columnNames = new String[this.numberOfColumns];
        for (int i = 1; i <= this.numberOfColumns; ++i) {
            this.columnTypes[i - 1] = abstRowCache.getColumnType(i);
            this.columnLengths[i - 1] = abstRowCache.getColumnLength(i);
            this.columnNames[i - 1] = abstRowCache.getColumnName(i);
        }
        this.populateColumnAttributes(boundColumns);
        if (abstRowCache instanceof MetaDataRowCache) {
            MetaDataRowCache tMetaDataRowCache = (MetaDataRowCache)abstRowCache;
            Constants.mdTypes tMetaDataType = tMetaDataRowCache.getMetaDataType();
            switch (tMetaDataType) {
                case CATALOGS: {
                    this.correctCatalogs();
                    break;
                }
                case CLIENTINFOPROPERTIES: {
                    this.correctCatalogs();
                    break;
                }
                case SCHEMAS: {
                    this.correctSchemas();
                    break;
                }
                case TABLES: {
                    this.correctTables();
                    break;
                }
                case UDT: {
                    this.correctUDT();
                    break;
                }
            }
        }
    }

    protected FSResultSetMetaData(StatementWrapper stmtWrapper, int[] colTypes, String[] colNames, long[] colLengths) throws SQLException {
        int oLen = colTypes.length;
        this.columnTypes = Arrays.copyOf(colTypes, oLen);
        oLen = colNames.length;
        this.columnNames = Arrays.copyOf(colNames, oLen);
        oLen = colLengths.length;
        this.columnLengths = new int[colLengths.length];
        this.numberOfColumns = this.columnNames.length;
        this.statementWrapper = stmtWrapper;
        oLen = this.columnLengths.length;
        for (int i = 0; i < oLen; ++i) {
            this.columnLengths[i] = (int)colLengths[i];
        }
        this.populateColumnAttributes(this.numberOfColumns);
    }

    @Override
    public String getCatalogName(int index) throws SQLException {
        String method = "getCatalogName";
        this.validateColumnIndex("getCatalogName", index);
        if (this.columnCatalogNames == null) {
            return null;
        }
        return this.columnCatalogNames[index - 1];
    }

    @Override
    public String getColumnClassName(int index) throws SQLException {
        String method = "getColumnClassName";
        this.validateColumnIndex("getColumnClassName", index);
        return UtilityFunctions.getJavaTypeClassName(this.columnTypes[index - 1]);
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.numberOfColumns;
    }

    @Override
    public int getColumnDisplaySize(int index) throws SQLException {
        String method = "getColumnDisplaySize";
        this.validateColumnIndex("getColumnDisplaySize", index);
        return this.columnLengths[index - 1];
    }

    @Override
    public String getColumnLabel(int index) throws SQLException {
        String method = "getColumnLabel";
        this.validateColumnIndex("getColumnLabel", index);
        if (this.columnLabels == null) {
            return null;
        }
        return this.columnLabels[index - 1];
    }

    @Override
    public String getColumnName(int index) throws SQLException {
        String method = "getColumnName";
        this.validateColumnIndex("getColumnName", index);
        return this.columnNames[index - 1];
    }

    @Override
    public int getColumnType(int index) throws SQLException {
        String method = "getColumnType";
        this.validateColumnIndex("getColumnType", index);
        return this.columnTypes[index - 1];
    }

    @Override
    public String getColumnTypeName(int index) throws SQLException {
        String method = "getColumnTypeName";
        this.validateColumnIndex("getColumnTypeName", index);
        if (this.columnTypeNames == null) {
            return null;
        }
        return this.columnTypeNames[index - 1];
    }

    @Override
    public int getPrecision(int index) throws SQLException {
        String method = "getPrecision";
        this.validateColumnIndex("getPrecision", index);
        if (this.columnPrecisions == null) {
            return 0;
        }
        return this.columnPrecisions[index - 1];
    }

    @Override
    public int getScale(int index) throws SQLException {
        String method = "getScale";
        this.validateColumnIndex("getScale", index);
        if (this.columnScales == null) {
            return 0;
        }
        return this.columnScales[index - 1];
    }

    @Override
    public String getSchemaName(int index) throws SQLException {
        String method = "getSchemaName";
        this.validateColumnIndex("getSchemaName", index);
        if (this.columnSchemaNames == null) {
            return null;
        }
        return this.columnSchemaNames[index - 1];
    }

    @Override
    public String getTableName(int index) throws SQLException {
        String method = "getTableName";
        this.validateColumnIndex("getTableName", index);
        if (this.columnTableNames == null) {
            return null;
        }
        return this.columnTableNames[index - 1];
    }

    @Override
    public boolean isAutoIncrement(int index) throws SQLException {
        String method = "isAutoIncrement";
        this.validateColumnIndex("isAutoIncrement", index);
        if (this.columnIsAutoIncrement == null) {
            return false;
        }
        return this.columnIsAutoIncrement[index - 1] && this.isReadOnly(index);
    }

    @Override
    public boolean isCaseSensitive(int index) throws SQLException {
        String method = "isCaseSensitive";
        this.validateColumnIndex("isCaseSensitive", index);
        if (this.columnIsCaseSensitive == null) {
            return false;
        }
        return this.columnIsCaseSensitive[index - 1];
    }

    @Override
    public boolean isCurrency(int index) throws SQLException {
        String method = "isCurrency";
        this.validateColumnIndex("isCurrency", index);
        if (this.columnIsCurrency == null) {
            return false;
        }
        return this.columnIsCurrency[index - 1];
    }

    @Override
    public boolean isDefinitelyWritable(int index) throws SQLException {
        String method = "isDefinitelyWritable";
        this.validateColumnIndex("isDefinitelyWritable", index);
        if (this.columnIsDefWritable == null) {
            return false;
        }
        return this.columnIsDefWritable[index - 1];
    }

    @Override
    public int isNullable(int index) throws SQLException {
        String method = "isNullable";
        this.validateColumnIndex("isNullable", index);
        if (this.columnNullables == null) {
            return 0;
        }
        return this.columnNullables[index - 1];
    }

    @Override
    public boolean isReadOnly(int index) throws SQLException {
        String method = "isReadOnly";
        this.validateColumnIndex("isReadOnly", index);
        if (this.columnIsReadOnly == null) {
            return false;
        }
        return this.columnIsReadOnly[index - 1];
    }

    @Override
    public boolean isSearchable(int index) throws SQLException {
        String method = "isSearchable";
        this.validateColumnIndex("isSearchable", index);
        if (this.columnIsSearchable == null) {
            return false;
        }
        return this.columnIsSearchable[index - 1];
    }

    @Override
    public boolean isSigned(int index) throws SQLException {
        String method = "isSigned";
        this.validateColumnIndex("isSigned", index);
        if (this.columnIsUnsigned == null) {
            return false;
        }
        return !this.columnIsUnsigned[index - 1];
    }

    @Override
    public boolean isWritable(int index) throws SQLException {
        String method = "isWritable";
        this.validateColumnIndex("isWritable", index);
        if (this.columnIsWritable == null) {
            return false;
        }
        return this.columnIsWritable[index - 1];
    }

    void populateColumnAttributes(int boundColumns) throws SQLException {
        String method = "populateColumnAttributes";
        if (AbstractLogger.isTrace) {
            logger.entry("populateColumnAttributes");
        }
        if (this.statementWrapper != null) {
            try {
                int[] columnNumbers = new int[this.numberOfColumns];
                int[] columnIndicators = new int[14];
                int[] columnIdentifiers = new int[14];
                this.sqlStates = new String[14];
                this.errorMessages = new String[14];
                for (int z = 0; z < this.numberOfColumns; ++z) {
                    columnNumbers[z] = z + 1;
                }
                columnIdentifiers[0] = 17;
                columnIndicators[0] = -3;
                columnIdentifiers[1] = 18;
                columnIndicators[1] = -3;
                columnIdentifiers[2] = 14;
                columnIndicators[2] = -3;
                columnIdentifiers[3] = 1005;
                columnIndicators[3] = -6;
                columnIdentifiers[4] = 1006;
                columnIndicators[4] = -6;
                columnIdentifiers[5] = 16;
                columnIndicators[5] = -3;
                columnIdentifiers[6] = 15;
                columnIndicators[6] = -3;
                columnIdentifiers[7] = 11;
                columnIndicators[7] = -5;
                columnIdentifiers[8] = 12;
                columnIndicators[8] = -6;
                columnIdentifiers[9] = 9;
                columnIndicators[9] = -6;
                columnIdentifiers[10] = 10;
                columnIndicators[10] = -6;
                columnIdentifiers[11] = 1008;
                columnIndicators[11] = -6;
                columnIdentifiers[12] = 13;
                columnIndicators[12] = -6;
                columnIdentifiers[13] = 8;
                columnIndicators[13] = -6;
                AnySeqHolder attrValuesHolder = new AnySeqHolder();
                VariableArray2dOfLongHolder attributeStatus = new VariableArray2dOfLongHolder();
                IntHolder bogus = new IntHolder();
                if (boundColumns < this.numberOfColumns) {
                    int[] tColumnNumbers = new int[boundColumns];
                    for (int b = 0; b < boundColumns; ++b) {
                        tColumnNumbers[b] = columnNumbers[b];
                    }
                    this.statementWrapper.ColAttributes(tColumnNumbers, columnIdentifiers, columnIndicators, attrValuesHolder, attributeStatus, bogus);
                } else {
                    this.statementWrapper.ColAttributes(columnNumbers, columnIdentifiers, columnIndicators, attrValuesHolder, attributeStatus, bogus);
                }
                Any[] attributesValue = attrValuesHolder.value;
                String[] stringAttributes = null;
                int[] integerAttributes = null;
                this.checkForFailures(attributeStatus.value);
                block23: for (int index = 0; index < 14; ++index) {
                    if (attributeStatus.value[index][0] == -2130708478) {
                        stringAttributes = null;
                        integerAttributes = null;
                    } else {
                        switch (index) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 5: 
                            case 6: {
                                stringAttributes = StringSeqHelper.extract((Any)attributesValue[index]);
                                break;
                            }
                            default: {
                                integerAttributes = LongSeqHelper.extract((Any)attributesValue[index]);
                            }
                        }
                    }
                    switch (index) {
                        case 0: {
                            this.columnCatalogNames = this.fillStrAttributeArray(stringAttributes);
                            if (this.columnCatalogNames != null) continue block23;
                            this.columnCatalogNames = UtilityFunctions.defaultStringArray(this.numberOfColumns, "");
                            continue block23;
                        }
                        case 1: {
                            this.columnLabels = this.fillStrAttributeArray(stringAttributes);
                            if (this.columnLabels != null) continue block23;
                            this.columnLabels = UtilityFunctions.defaultStringArray(this.numberOfColumns, "");
                            continue block23;
                        }
                        case 2: {
                            this.columnTypeNames = this.fillStrAttributeArray(stringAttributes);
                            if (this.columnTypeNames != null) continue block23;
                            this.columnTypeNames = UtilityFunctions.defaultStringArray(this.numberOfColumns, "");
                            continue block23;
                        }
                        case 3: {
                            this.columnPrecisions = this.fillIntAttributeArray(integerAttributes);
                            continue block23;
                        }
                        case 4: {
                            this.columnScales = this.fillIntAttributeArray(integerAttributes);
                            continue block23;
                        }
                        case 5: {
                            this.columnSchemaNames = this.fillStrAttributeArray(stringAttributes);
                            if (this.columnSchemaNames != null) continue block23;
                            this.columnSchemaNames = UtilityFunctions.defaultStringArray(this.numberOfColumns, "");
                            continue block23;
                        }
                        case 6: {
                            this.columnTableNames = this.fillStrAttributeArray(stringAttributes);
                            if (this.columnTableNames != null) continue block23;
                            this.columnTableNames = UtilityFunctions.defaultStringArray(this.numberOfColumns, "");
                            continue block23;
                        }
                        case 7: {
                            this.columnIsAutoIncrement = this.fillFlagAttributeArray(integerAttributes);
                            continue block23;
                        }
                        case 8: {
                            this.columnIsCaseSensitive = this.fillFlagAttributeArray(integerAttributes);
                            continue block23;
                        }
                        case 9: {
                            this.columnIsCurrency = this.fillFlagAttributeArray(integerAttributes);
                            continue block23;
                        }
                        case 10: {
                            int i;
                            if (integerAttributes == null) {
                                this.columnIsWritable = null;
                                this.columnIsDefWritable = null;
                                this.columnIsReadOnly = null;
                                continue block23;
                            }
                            int numberValues = integerAttributes.length;
                            this.columnIsWritable = new boolean[this.numberOfColumns];
                            this.columnIsDefWritable = new boolean[this.numberOfColumns];
                            this.columnIsReadOnly = new boolean[this.numberOfColumns];
                            for (i = 0; i < this.numberOfColumns; ++i) {
                                if (i < numberValues && integerAttributes[i] == 1) {
                                    this.columnIsWritable[i] = true;
                                    this.columnIsDefWritable[i] = true;
                                    this.columnIsReadOnly[i] = false;
                                    continue;
                                }
                                this.columnIsWritable[i] = false;
                                this.columnIsDefWritable[i] = false;
                                this.columnIsReadOnly[i] = true;
                            }
                            continue block23;
                        }
                        case 11: {
                            this.columnNullables = this.fillIntAttributeArray(integerAttributes);
                            continue block23;
                        }
                        case 12: {
                            int i;
                            if (integerAttributes == null) {
                                this.columnIsSearchable = null;
                                continue block23;
                            }
                            this.columnIsSearchable = new boolean[this.numberOfColumns];
                            int numberIntValues = integerAttributes.length;
                            for (i = 0; i < this.numberOfColumns; ++i) {
                                if (i < numberIntValues) {
                                    if (integerAttributes[i] == 0) {
                                        this.columnIsSearchable[i] = false;
                                        continue;
                                    }
                                    this.columnIsSearchable[i] = true;
                                    continue;
                                }
                                this.columnIsSearchable[i] = false;
                            }
                            continue block23;
                        }
                        case 13: {
                            this.columnIsUnsigned = this.fillFlagAttributeArray(integerAttributes);
                        }
                    }
                }
            }
            catch (Exception e) {
                LocalizedErrorHandler.handleExceptionsInFunction("populateColumnAttributes", e, this.statementWrapper, logger);
            }
        } else {
            this.columnPrecisions = new int[this.numberOfColumns];
            this.columnScales = new int[this.numberOfColumns];
            this.columnNullables = new int[this.numberOfColumns];
            this.columnCatalogNames = new String[this.numberOfColumns];
            this.columnLabels = new String[this.numberOfColumns];
            this.columnTypeNames = new String[this.numberOfColumns];
            this.columnSchemaNames = new String[this.numberOfColumns];
            this.columnTableNames = new String[this.numberOfColumns];
            this.columnIsAutoIncrement = new boolean[this.numberOfColumns];
            this.columnIsCaseSensitive = new boolean[this.numberOfColumns];
            this.columnIsWritable = new boolean[this.numberOfColumns];
            this.columnIsDefWritable = new boolean[this.numberOfColumns];
            this.columnIsReadOnly = new boolean[this.numberOfColumns];
            this.columnIsCurrency = new boolean[this.numberOfColumns];
            this.columnIsSearchable = new boolean[this.numberOfColumns];
            this.columnIsUnsigned = new boolean[this.numberOfColumns];
            for (int i = 0; i < this.numberOfColumns; ++i) {
                this.setDefaults(i);
            }
        }
        FSConnection tConn = null;
        if (this.statementWrapper != null) {
            tConn = this.statementWrapper.getFSConnection();
        }
        if (tConn != null) {
            for (int i = 0; i < this.numberOfColumns; ++i) {
                int sqlType;
                String sqlTypeStr;
                if (this.columnTypeNames[i] == null) {
                    this.columnTypeNames[i] = "";
                }
                if (this.columnTypeNames[i].length() != 0 || (sqlTypeStr = tConn.getServerDataTypeName(sqlType = this.columnTypes[i])) == null) continue;
                this.columnTypeNames[i] = sqlTypeStr;
            }
        }
        if (AbstractLogger.isTrace) {
            logger.exit("populateColumnAttributes");
        }
    }

    private boolean[] fillFlagAttributeArray(int[] metadata) {
        boolean[] tBool;
        if (metadata == null) {
            tBool = null;
        } else {
            tBool = new boolean[this.numberOfColumns];
            int numberMetadataValues = metadata.length;
            for (int i = 0; i < this.numberOfColumns; ++i) {
                tBool[i] = i < numberMetadataValues && metadata[i] == 1;
            }
        }
        return tBool;
    }

    private int[] fillIntAttributeArray(int[] metadata) {
        int[] tInt;
        if (metadata == null) {
            tInt = null;
        } else {
            tInt = new int[this.numberOfColumns];
            int numberMetadataValues = metadata.length;
            for (int i = 0; i < this.numberOfColumns; ++i) {
                tInt[i] = i < numberMetadataValues ? metadata[i] : 0;
            }
        }
        return tInt;
    }

    private String[] fillStrAttributeArray(String[] metadata) {
        String[] tStr;
        if (metadata == null) {
            tStr = null;
        } else {
            tStr = new String[this.numberOfColumns];
            int numberMetadataValues = metadata.length;
            for (int i = 0; i < this.numberOfColumns; ++i) {
                tStr[i] = i < numberMetadataValues ? metadata[i] : null;
            }
        }
        return tStr;
    }

    protected void validateColumnIndex(String method, int index) throws SQLException {
        if (index < 1 || index > this.numberOfColumns) {
            LocalizedErrorHandler.throwLocalizedException("TKTSResultSetMetaData.invalidIndex.fmt", new String[]{method}, logger);
        }
    }

    private void checkForFailures(int[][] status) {
        int errors = 0;
        for (int x = 0; x < 14; ++x) {
            if (status[x][0] != -2130708478) continue;
            ++errors;
        }
        if (errors > 0) {
            StringSeqHolder messageTexts;
            StringSeqHolder sqlStateHolder;
            block8: {
                int[] recNumbers = new int[]{};
                sqlStateHolder = new StringSeqHolder();
                LongSeqHolder nativeErrors = new LongSeqHolder();
                messageTexts = new StringSeqHolder();
                LongSeqHolder statx = new LongSeqHolder();
                try {
                    this.statementWrapper.GetDiagRecs(recNumbers, sqlStateHolder, nativeErrors, messageTexts, statx);
                }
                catch (Exception f) {
                    if (!AbstractLogger.isTrace) break block8;
                    ExceptionsLogger.log(f);
                }
            }
            int recordCount = sqlStateHolder.value.length;
            int idx = 0;
            int recordsPerError = recordCount / errors;
            if (recordCount > 0) {
                for (int x = 0; x < 14; ++x) {
                    if (status[x][0] != -2130708478) continue;
                    if (idx < sqlStateHolder.value.length) {
                        this.sqlStates[x] = sqlStateHolder.value[idx];
                    }
                    if (idx < messageTexts.value.length) {
                        this.errorMessages[x] = messageTexts.value[idx];
                    }
                    idx += recordsPerError;
                }
            }
        }
    }

    private void copyDefaults(int inCol, int outCol) {
        this.columnCatalogNames[outCol] = this.columnCatalogNames[inCol];
        this.columnIsAutoIncrement[outCol] = this.columnIsAutoIncrement[inCol];
        this.columnIsCaseSensitive[outCol] = this.columnIsCaseSensitive[inCol];
        this.columnIsCurrency[outCol] = this.columnIsCurrency[inCol];
        this.columnIsDefWritable[outCol] = this.columnIsDefWritable[inCol];
        this.columnIsReadOnly[outCol] = this.columnIsReadOnly[inCol];
        this.columnIsSearchable[outCol] = this.columnIsSearchable[inCol];
        this.columnIsUnsigned[outCol] = this.columnIsUnsigned[inCol];
        this.columnIsWritable[outCol] = this.columnIsWritable[inCol];
        this.columnLengths[outCol] = this.columnLengths[inCol];
        this.columnNullables[outCol] = this.columnNullables[inCol];
        this.columnPrecisions[outCol] = this.columnPrecisions[inCol];
        this.columnScales[outCol] = this.columnScales[inCol];
        this.columnSchemaNames[outCol] = this.columnSchemaNames[inCol];
        this.columnTableNames[outCol] = this.columnTableNames[inCol];
        this.columnTypeNames[outCol] = this.columnTypeNames[inCol];
        this.columnTypes[outCol] = this.columnTypes[inCol];
    }

    private void setDefaults(int colNum) {
        String typeName;
        boolean isUnsigned;
        int precision;
        int sqlType = this.columnTypes[colNum];
        int DEFAULT_LENGTH = 256;
        switch (sqlType) {
            case 16: {
                precision = 1;
                isUnsigned = true;
                typeName = "BOOLEAN";
                break;
            }
            case 4: {
                precision = 11;
                isUnsigned = false;
                typeName = "INTEGER";
                break;
            }
            case 5: {
                precision = 6;
                isUnsigned = false;
                typeName = "SMALLINT";
                break;
            }
            case -6: {
                isUnsigned = false;
                precision = 4;
                typeName = "TINYINT";
                break;
            }
            case 1: {
                precision = 256;
                isUnsigned = true;
                typeName = "CHAR";
                break;
            }
            case -1: 
            case 12: {
                precision = 256;
                isUnsigned = true;
                typeName = "VARCHAR";
                break;
            }
            case -15: {
                precision = 256;
                isUnsigned = true;
                typeName = "NCHAR";
                break;
            }
            case -16: 
            case -9: {
                precision = 256;
                isUnsigned = true;
                typeName = "NVARCHAR";
                break;
            }
            default: {
                precision = 0;
                isUnsigned = true;
                typeName = "";
            }
        }
        this.columnIsAutoIncrement[colNum] = false;
        this.columnIsCaseSensitive[colNum] = false;
        this.columnIsCurrency[colNum] = false;
        this.columnIsDefWritable[colNum] = false;
        this.columnIsReadOnly[colNum] = true;
        this.columnIsSearchable[colNum] = false;
        this.columnIsUnsigned[colNum] = isUnsigned;
        this.columnIsWritable[colNum] = false;
        if (this.columnLabels[colNum] == null) {
            this.columnLabels[colNum] = this.columnNames[colNum];
        }
        if (this.columnLengths[colNum] == 0) {
            this.columnPrecisions[colNum] = precision;
            this.columnLengths[colNum] = precision;
        } else {
            this.columnPrecisions[colNum] = this.columnLengths[colNum];
        }
        this.columnCatalogNames[colNum] = "";
        this.columnNullables[colNum] = 0;
        this.columnScales[colNum] = 0;
        this.columnSchemaNames[colNum] = "";
        this.columnTableNames[colNum] = "";
        this.columnTypeNames[colNum] = typeName;
    }

    private void correctTables() {
        String type_cat = "TYPE_CAT";
        String type_schem = "TYPE_SCHEM";
        String type_name = "TYPE_NAME";
        String self_referencing_col_name = "SELF_REFERENCING_COL_NAME";
        String ref_generation = "REF_GENERATION";
        String native_cat = "NATIVE_CAT";
        String security = "SECURITY";
        String service = "SERVICE";
        this.copyDefaults(0, 5);
        this.columnNames[5] = "TYPE_CAT";
        this.columnLabels[5] = "TYPE_CAT";
        this.copyDefaults(0, 6);
        this.columnNames[6] = "TYPE_SCHEM";
        this.columnLabels[6] = "TYPE_SCHEM";
        this.copyDefaults(0, 7);
        this.columnNames[7] = "TYPE_NAME";
        this.columnLabels[7] = "TYPE_NAME";
        this.copyDefaults(0, 8);
        this.columnNames[8] = "SELF_REFERENCING_COL_NAME";
        this.columnLabels[8] = "SELF_REFERENCING_COL_NAME";
        this.copyDefaults(0, 9);
        this.columnNames[9] = "REF_GENERATION";
        this.columnLabels[9] = "REF_GENERATION";
        this.copyDefaults(0, 10);
        this.columnNames[10] = "NATIVE_CAT";
        this.columnLabels[10] = "NATIVE_CAT";
        this.copyDefaults(0, 11);
        this.columnNames[11] = "SECURITY";
        this.columnLabels[11] = "SECURITY";
        this.copyDefaults(0, 12);
        this.columnNames[12] = "SERVICE";
        this.columnLabels[12] = "SERVICE";
    }

    private void correctCatalogs() {
        this.columnLabels[1] = this.columnNames[1];
    }

    protected void correctSchemas() {
        this.columnLabels[0] = "TABLE_SCHEM";
        this.columnNames[0] = "TABLE_SCHEM";
        this.columnTypeNames[0] = "VARCHAR";
        this.columnLabels[1] = "TABLE_CATALOG";
        this.columnNames[1] = "TABLE_CATALOG";
        this.columnTypeNames[1] = "VARCHAR";
    }

    private void correctUDT() {
    }

    @Override
    public <T> T unwrap(Class<T> ResultSetMetaData2) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> inClass) throws SQLException {
        return inClass == FSResultSetMetaData.class;
    }

    public String toString() {
        String outStr = "numberOfColumns: + " + this.numberOfColumns;
        outStr = outStr + "\nsqlStates: " + this.sqlStates;
        outStr = outStr + "\nerrorMessages: " + this.errorMessages;
        outStr = outStr + "\nStates: ";
        outStr = outStr + "\n columnNames, columnLabels, columnCatalogNames, columnSchemaNames, columnTableNames, columnTypeNames: ";
        for (int i = 0; i < this.numberOfColumns; ++i) {
            outStr = outStr + "\n " + this.columnNames[i] + ", " + this.columnLabels[i] + ", " + this.columnCatalogNames[i] + ", " + this.columnSchemaNames[i] + ", " + this.columnTableNames[i] + ", " + this.columnTypeNames[i];
        }
        return outStr;
    }

    protected void correct() {
        System.out.println("FSResultSetMetaData.correct");
    }

    public void close() {
        if (this.statementWrapper != null) {
            this.statementWrapper = null;
        }
    }
}

