/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.sql;

import com.sas.tkts.FedSrvJDBC;
import com.sas.tkts.caching.AbstractRowCache;
import com.sas.tkts.caching.MetaDataRowCache;
import com.sas.tkts.caching.Row;
import com.sas.tkts.caching.RowCache;
import com.sas.tkts.iom.StatementWrapper;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.Constants;
import com.sas.tkts.sql.FSDatabaseMetaData;
import com.sas.tkts.sql.FSResultSetMetaData;
import com.sas.tkts.sql.FSStatement;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.sql.LocalizedMessageHandler;
import com.sas.tkts.types.AbstractColumn;
import com.sas.tkts.types.BlobFedSrv;
import com.sas.tkts.util.DataTypeConversions;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;

public class FSResultSet
extends FedSrvJDBC
implements ResultSet {
    private static String thisClassName = FSResultSet.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    private static final String RSC = "TKTSResultSet.closedError.txt";
    private transient int hintFetchSize;
    protected transient AbstractRowCache abstractRowCache;
    protected transient int numberColumns;
    protected transient boolean wasNull;
    protected transient boolean isClosed;
    protected transient int rSetType;
    protected transient int rSetConcurrency;
    private transient StatementWrapper statementWrapper;
    private transient SQLWarning sqlWarnings;
    private transient FSStatement fsstatement;
    protected transient FSResultSetMetaData rsmd;
    protected transient FSDatabaseMetaData dbmd;
    protected transient SQLFeatureNotSupportedException nsEx;

    protected void initFields(StatementWrapper inStmtWrapper) {
        this.hintFetchSize = -1;
        this.numberColumns = -1;
        this.rSetType = 1003;
        this.rSetConcurrency = 1007;
        this.rsmd = null;
        this.dbmd = null;
        this.nsEx = null;
        this.statementWrapper = inStmtWrapper;
    }

    protected FSResultSet() {
        this.initFields(null);
    }

    protected FSResultSet(StatementWrapper inStmtWrapper, FSStatement inStmt) throws SQLException {
        this(inStmtWrapper, inStmt, 0, false);
    }

    protected FSResultSet(StatementWrapper inStmtWrapper, FSStatement inStmt, int columnCount, boolean isUseBookmarks) throws SQLException {
        this.initFields(inStmtWrapper);
        this.fsstatement = inStmt;
        this.setFetchSize(inStmt.getFetchSize());
        this.rSetType = inStmt.getResultSetType();
        this.rSetConcurrency = inStmt.getResultSetConcurrency();
        this.numberColumns = columnCount;
        this.abstractRowCache = new RowCache(inStmt, inStmtWrapper, columnCount, isUseBookmarks);
    }

    protected FSResultSet(Constants.mdTypes mdType, StatementWrapper inStmtWrapper, FSDatabaseMetaData dbmd) throws SQLException {
        this.initFields(inStmtWrapper);
        this.abstractRowCache = mdType == Constants.mdTypes.NOSPECIALBINDING ? new RowCache(this.statementWrapper) : new MetaDataRowCache(mdType, this.statementWrapper);
        this.numberColumns = this.abstractRowCache.getColumnCount();
        this.abstractRowCache.setResultSetType(this.rSetType);
        this.abstractRowCache.setResultSetConcurrency(this.rSetConcurrency);
        this.dbmd = dbmd;
    }

    protected FSResultSet(Constants.mdTypes mdType, FSDatabaseMetaData dbmd) throws SQLException {
        this.initFields(null);
        this.abstractRowCache = new MetaDataRowCache(mdType);
        this.abstractRowCache.setResultSetType(this.rSetType);
        this.abstractRowCache.setResultSetConcurrency(this.rSetConcurrency);
        this.dbmd = dbmd;
    }

    protected FSResultSet(Constants.mdTypes mdType, StatementWrapper inStmtWrapper) throws SQLException {
        this.initFields(inStmtWrapper);
        this.abstractRowCache = mdType != Constants.mdTypes.NOSPECIALBINDING ? new MetaDataRowCache(mdType, inStmtWrapper) : new RowCache(inStmtWrapper);
        this.numberColumns = this.abstractRowCache.getColumnCount();
        this.abstractRowCache.setResultSetType(this.rSetType);
        this.abstractRowCache.setResultSetConcurrency(this.rSetConcurrency);
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        if (this.isClosed) {
            LocalizedErrorHandler.throwLocalizedException(RSC, logger);
        }
        this.sqlWarnings = null;
        this.abstractRowCache.clearWarnings();
    }

    @Override
    public synchronized void close() throws SQLException {
        String method = "close";
        if (AbstractLogger.isInfo) {
            LocalizedMessageHandler.logInfoMessage(method, "FSResultSet.close.txt", logger);
        }
        if (this.isClosed) {
            return;
        }
        this.releaseOutgoingResources();
        this.releaseIncomingResources();
        this.isClosed = true;
    }

    public synchronized void close(boolean cleanIncomingResources) throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.releaseOutgoingResources();
        if (cleanIncomingResources) {
            this.releaseIncomingResources();
        }
        if (this.dbmd != null) {
            this.dbmd = null;
        }
        this.isClosed = true;
    }

    public void releaseOutgoingResources() throws SQLException {
        boolean releaseCache = true;
        if (this.abstractRowCache != null) {
            this.abstractRowCache.close(releaseCache);
        }
        this.abstractRowCache = null;
        if (this.statementWrapper != null) {
            this.statementWrapper = null;
        }
        if (this.rsmd != null) {
            this.rsmd.close();
            this.rsmd = null;
        }
    }

    public void releaseIncomingResources() {
        if (this.fsstatement != null) {
            this.fsstatement.deleteGlobalResultSet();
            this.fsstatement = null;
        }
        if (this.dbmd != null) {
            this.dbmd.removeFromFSResultSetList(this);
            this.dbmd = null;
        }
    }

    @Override
    public synchronized int findColumn(String columnName) throws SQLException {
        int columnNumber;
        if (this.isClosed) {
            LocalizedErrorHandler.throwLocalizedException(RSC, logger);
        }
        if (columnName == null) {
            LocalizedErrorHandler.throwLocalizedException("TKTSResultSet.findColumnError.fmt", new String[]{columnName}, logger);
        }
        if ((columnNumber = this.abstractRowCache.getColumnIndex(columnName.trim())) < 1) {
            LocalizedErrorHandler.throwLocalizedException("TKTSResultSet.findColumnError.fmt", new String[]{columnName}, logger);
        }
        return columnNumber;
    }

    @Override
    public int getHoldability() throws SQLException {
        int holdability = 2;
        if (this.fsstatement != null) {
            holdability = this.fsstatement.getResultSetHoldability();
        }
        return holdability;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        String method = "getNCharacterStream(columnIndex)";
        this.genFeatureNotSupportedException("getNCharacterStream(columnIndex)");
        throw this.nsEx;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        String method = "getNCharacterStream(columnLabel)";
        this.genFeatureNotSupportedException("getNCharacterStream(columnLabel)");
        throw this.nsEx;
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        String method = "getNClob(columnIndex)";
        this.genFeatureNotSupportedException("getNClob(columnIndex)");
        throw this.nsEx;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        String method = "getNClob(columnLabel)";
        this.genFeatureNotSupportedException("getNClob(columnLabel)");
        throw this.nsEx;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        String method = "getNString(columnIndex)";
        this.genFeatureNotSupportedException("getNString(columnIndex)");
        throw this.nsEx;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        String method = "getNString(columnLabel)";
        this.genFeatureNotSupportedException("getNString(columnLabel)");
        throw this.nsEx;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        String method = "getRowId(columnIndex)";
        this.genFeatureNotSupportedException("getRowId(columnIndex)");
        throw this.nsEx;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        String method = "getRowId(columnLabel)";
        this.genFeatureNotSupportedException("getRowId(columnLabel)");
        throw this.nsEx;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        String method = "getSQLXML(columnIndex)";
        this.genFeatureNotSupportedException("getSQLXML(columnIndex)");
        throw this.nsEx;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        String method = "getSQLXML(columnLabel)";
        this.genFeatureNotSupportedException("getSQLXML(columnLabel)");
        throw this.nsEx;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.isClosed) {
            LocalizedErrorHandler.throwLocalizedException(RSC, logger);
        }
        SQLWarning warnings = this.abstractRowCache.getWarnings();
        this.abstractRowCache.clearWarnings();
        if (this.sqlWarnings == null) {
            this.sqlWarnings = warnings;
        } else {
            this.sqlWarnings.setNextWarning(warnings);
        }
        return this.sqlWarnings;
    }

    public void addWarnings(SQLWarning newSQLWarning) {
        if (this.sqlWarnings == null) {
            this.sqlWarnings = newSQLWarning;
        } else {
            this.sqlWarnings.setNextWarning(newSQLWarning);
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public synchronized void beforeFirst() throws SQLException {
        this.validateResultSetForwardOnly();
        this.clearWarnings();
        this.abstractRowCache.beforeFirst();
    }

    @Override
    public synchronized boolean first() throws SQLException {
        this.validateResultSetForwardOnly();
        this.clearWarnings();
        return this.abstractRowCache.first();
    }

    @Override
    public synchronized boolean next() throws SQLException {
        if (this.isClosed) {
            LocalizedErrorHandler.throwLocalizedException(RSC, logger);
        }
        this.clearWarnings();
        boolean hasData = this.abstractRowCache.next();
        this.numberColumns = this.abstractRowCache.getColumnCount();
        return hasData;
    }

    @Override
    public synchronized boolean previous() throws SQLException {
        this.validateResultSetForwardOnly();
        this.clearWarnings();
        return this.abstractRowCache.previous();
    }

    @Override
    public synchronized boolean last() throws SQLException {
        this.validateResultSetForwardOnly();
        this.clearWarnings();
        return this.abstractRowCache.last();
    }

    @Override
    public synchronized void afterLast() throws SQLException {
        this.validateResultSetForwardOnly();
        this.clearWarnings();
        this.abstractRowCache.afterLast();
    }

    @Override
    public synchronized boolean absolute(int row) throws SQLException {
        this.validateResultSetForwardOnly();
        this.clearWarnings();
        return this.abstractRowCache.absolute(row);
    }

    @Override
    public synchronized boolean relative(int rows) throws SQLException {
        this.validateResultSetForwardOnly();
        this.clearWarnings();
        return this.abstractRowCache.relative(rows);
    }

    @Override
    public synchronized boolean isBeforeFirst() throws SQLException {
        return this.abstractRowCache.isBeforeFirst();
    }

    @Override
    public synchronized boolean isFirst() throws SQLException {
        return this.abstractRowCache.isFirst();
    }

    @Override
    public synchronized boolean isLast() throws SQLException {
        return this.abstractRowCache.isLast();
    }

    @Override
    public synchronized boolean isAfterLast() throws SQLException {
        return this.abstractRowCache.isAfterLast();
    }

    @Override
    public synchronized int getRow() throws SQLException {
        return this.abstractRowCache.getRow();
    }

    @Override
    public synchronized void refreshRow() throws SQLException {
        String method = "refreshRow";
        if (AbstractLogger.isTrace) {
            logger.entry("refreshRow");
        }
        this.abstractRowCache.refreshRow();
        if (AbstractLogger.isTrace) {
            logger.exit("refreshRow");
        }
    }

    @Override
    public synchronized int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public synchronized void setFetchDirection(int direction) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException("General.methodNotImplemented.fmt", logger);
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        if (this.hintFetchSize == -1) {
            this.hintFetchSize = this.fsstatement == null ? 1 : this.fsstatement.getFetchSize();
        }
        if (AbstractLogger.isTrace) {
            logger.trace("FetchSize:" + this.hintFetchSize);
        }
        return this.hintFetchSize;
    }

    public synchronized int getRealFetchSize() throws SQLException {
        int out = -1;
        if (this.fsstatement != null) {
            out = this.fsstatement.getFetchSize();
        }
        return out;
    }

    @Override
    public synchronized void setFetchSize(int size) throws SQLException {
        String method = "setFetchSize";
        if (AbstractLogger.isInfo) {
            String[] args = new String[]{String.valueOf(size)};
            LocalizedMessageHandler.logInfoMessage(method, "FSResultSet.setFetchSize.fmt", args, logger);
        }
        if (this.isClosed) {
            LocalizedErrorHandler.throwLocalizedException(RSC, logger);
        }
        if (size < 0) {
            LocalizedErrorHandler.throwLocalizedException("TKTSStatement.fetchSizeLowError.txt", logger);
        }
        this.hintFetchSize = size;
        if (AbstractLogger.isTrace) {
            logger.trace("hintFetchSize:" + this.hintFetchSize);
        }
    }

    public synchronized int getRowsInCache() {
        return this.abstractRowCache.getRowCount();
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.isClosed) {
            LocalizedErrorHandler.throwLocalizedException(RSC, logger);
        }
        return this.wasNull;
    }

    @Override
    public Array getArray(int i) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException("General.methodNotImplemented.fmt", logger);
        return null;
    }

    @Override
    public Array getArray(String columnName) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException("General.methodNotImplemented.fmt", logger);
        return null;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.validateColumnIndex(columnIndex);
        AbstractColumn tfield = this.abstractRowCache.getColumnData(columnIndex);
        if (tfield.isNull()) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        return tfield.getAsciiStream();
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        int ci = this.findColumn(columnName);
        return this.getAsciiStream(ci);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.validateColumnIndex(columnIndex);
        AbstractColumn tfield = this.abstractRowCache.getColumnData(columnIndex);
        if (tfield.isNull()) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        return tfield.getBigDecimal();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException("General.methodNotImplemented.fmt", logger);
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        int ci = this.findColumn(columnName);
        return this.getBigDecimal(ci);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException("General.methodNotImplemented.fmt", logger);
        return null;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.validateColumnIndex(columnIndex);
        AbstractColumn tfield = this.abstractRowCache.getColumnData(columnIndex);
        if (tfield.isNull()) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        return tfield.getBinaryStream();
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        int ci = this.findColumn(columnName);
        return this.getBinaryStream(ci);
    }

    @Override
    public Blob getBlob(int index) throws SQLException {
        String method = "getBlob";
        BlobFedSrv outBlob = null;
        if (AbstractLogger.isTrace) {
            logger.entry("getBlob", "columnIndex[" + index + "]");
        }
        this.validateColumnIndex(index);
        AbstractColumn absColumn = this.abstractRowCache.getColumnData(index);
        if (absColumn.isNull()) {
            if (AbstractLogger.isTrace) {
                logger.exit("getBlob", "blob[Null]");
            }
            this.wasNull = true;
            return outBlob;
        }
        int sqlType = this.abstractRowCache.getColumnType(index);
        if (!FSResultSet.isBinaryType(sqlType)) {
            String si = "TKTSResultSet.UnableConvertToBLOBError.txt";
            throw new SQLException(LocalizedErrorHandler.getLocalizedError("TKTSResultSet.UnableConvertToBLOBError.txt", null));
        }
        byte[] dataBytes = absColumn.getBytes();
        this.wasNull = false;
        outBlob = new BlobFedSrv(dataBytes);
        if (AbstractLogger.isTrace) {
            outBlob.logData(false);
            logger.exit("getBlob");
        }
        return outBlob;
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        String method = "getBlob";
        Blob outBlob = null;
        if (AbstractLogger.isTrace) {
            logger.entry("getBlob", "colName[" + colName + "]");
        }
        outBlob = this.getBlob(this.findColumn(colName));
        return outBlob;
    }

    @Override
    public boolean getBoolean(int index) throws SQLException {
        this.validateColumnIndex(index);
        boolean out = false;
        AbstractColumn absColumn = this.abstractRowCache.getColumnData(index);
        this.wasNull = absColumn.isNull();
        out = absColumn.getBoolean();
        if (absColumn.getDataTruncation()) {
            Object inObj = absColumn.getObject();
            Boolean outObj = out ? Boolean.TRUE : Boolean.FALSE;
            this.createDataTruncation(index, this.abstractRowCache.getColumnName(index), inObj, outObj);
        }
        return out;
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        int ci = this.findColumn(columnName);
        return this.getBoolean(ci);
    }

    @Override
    public byte getByte(int index) throws SQLException {
        this.validateColumnIndex(index);
        AbstractColumn absColumn = this.abstractRowCache.getColumnData(index);
        this.wasNull = absColumn.isNull();
        byte out = absColumn.getByte();
        if (absColumn.getDataTruncation()) {
            Object inObj = absColumn.getObject();
            Byte outObj = new Byte(out);
            this.createDataTruncation(index, this.abstractRowCache.getColumnName(index), inObj, outObj);
        }
        return out;
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        int ci = this.findColumn(columnName);
        return this.getByte(ci);
    }

    @Override
    public byte[] getBytes(int index) throws SQLException {
        this.validateColumnIndex(index);
        AbstractColumn absColumn = this.abstractRowCache.getColumnData(index);
        byte[] returnValue = absColumn.getBytes();
        if (absColumn.isNull()) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        return returnValue;
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        int ci = this.findColumn(columnName);
        return this.getBytes(ci);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.validateColumnIndex(columnIndex);
        AbstractColumn tfield = this.abstractRowCache.getColumnData(columnIndex);
        if (tfield.isNull()) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        Reader out = tfield.getCharacterStream();
        return out;
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        int ci = this.findColumn(columnName);
        return this.getCharacterStream(ci);
    }

    @Override
    public Clob getClob(int index) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException("General.methodNotImplemented.fmt", logger);
        return null;
    }

    @Override
    public Clob getClob(String columnName) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException("General.methodNotImplemented.fmt", logger);
        return null;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.rSetConcurrency;
    }

    @Override
    public String getCursorName() throws SQLException {
        LocalizedErrorHandler.throwLocalizedException("General.methodNotImplemented.fmt", logger);
        return null;
    }

    @Override
    public Date getDate(int index) throws SQLException {
        this.validateColumnIndex(index);
        AbstractColumn absColumn = this.abstractRowCache.getColumnData(index);
        this.wasNull = absColumn.isNull();
        return absColumn.getDate();
    }

    @Override
    public Date getDate(int index, Calendar cal) throws SQLException {
        this.validateColumnIndex(index);
        AbstractColumn absColumn = this.abstractRowCache.getColumnData(index);
        if (absColumn.isNull()) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        return absColumn.getDate(cal);
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        int ci = this.findColumn(columnName);
        return this.getDate(ci);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        int ci = this.findColumn(columnName);
        return this.getDate(ci, cal);
    }

    @Override
    public double getDouble(int index) throws SQLException {
        double out;
        this.validateColumnIndex(index);
        AbstractColumn absColumn = this.abstractRowCache.getColumnData(index);
        if (absColumn.isNull()) {
            this.wasNull = true;
            out = 0.0;
        } else {
            this.wasNull = false;
            out = absColumn.getDouble();
            if (absColumn.getDataTruncation()) {
                Object inObj = absColumn.getObject();
                Double outObj = new Double(out);
                this.createDataTruncation(index, this.abstractRowCache.getColumnName(index), inObj, outObj);
            }
        }
        return out;
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        int ci = this.findColumn(columnName);
        return this.getDouble(ci);
    }

    @Override
    public float getFloat(int index) throws SQLException {
        float out;
        this.validateColumnIndex(index);
        AbstractColumn absColumn = this.abstractRowCache.getColumnData(index);
        if (absColumn.isNull()) {
            this.wasNull = true;
            out = 0.0f;
        } else {
            this.wasNull = false;
            out = absColumn.getFloat();
            if (absColumn.getDataTruncation()) {
                Object inObj = absColumn.getObject();
                Float outObj = new Float(out);
                this.createDataTruncation(index, this.abstractRowCache.getColumnName(index), inObj, outObj);
            }
        }
        return out;
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        int ci = this.findColumn(columnName);
        return this.getFloat(ci);
    }

    @Override
    public int getInt(int index) throws SQLException {
        this.validateColumnIndex(index);
        AbstractColumn absColumn = this.abstractRowCache.getColumnData(index);
        this.wasNull = absColumn.isNull();
        int out = absColumn.getInt();
        if (absColumn.getDataTruncation()) {
            Object inObj = absColumn.getObject();
            Integer outObj = new Integer(out);
            this.createDataTruncation(index, this.abstractRowCache.getColumnName(index), inObj, outObj);
        }
        return out;
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        int ci = this.findColumn(columnName);
        return this.getInt(ci);
    }

    @Override
    public long getLong(int index) throws SQLException {
        this.validateColumnIndex(index);
        AbstractColumn absColumn = this.abstractRowCache.getColumnData(index);
        this.wasNull = absColumn.isNull();
        long out = absColumn.getLong();
        if (absColumn.getDataTruncation()) {
            Object inObj = absColumn.getObject();
            Long outObj = new Long(out);
            this.createDataTruncation(index, this.abstractRowCache.getColumnName(index), inObj, outObj);
        }
        return out;
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        int ci = this.findColumn(columnName);
        return this.getLong(ci);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        String method = "getMetaData";
        if (AbstractLogger.isInfo) {
            LocalizedMessageHandler.logInfoMessage(method, "FSResultSet.getMetaData.txt", logger);
        }
        if (this.rsmd == null) {
            if (this.isClosed) {
                LocalizedErrorHandler.throwLocalizedException(RSC, logger);
            }
            this.rsmd = new FSResultSetMetaData(this);
        }
        return this.rsmd;
    }

    @Override
    public Object getObject(int index) throws SQLException {
        this.validateColumnIndex(index);
        AbstractColumn ac = this.abstractRowCache.getColumnData(index);
        Object obj = ac == null ? null : ac.getObject();
        this.wasNull = obj == null;
        return obj;
    }

    public Object getObject(int i, Map map) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException("General.methodNotImplemented.fmt", logger);
        return null;
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        int ci = this.findColumn(columnName);
        return this.getObject(ci);
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        int ci = this.findColumn(columnName);
        return this.getObject(ci, map);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException("General.methodNotImplemented.fmt", logger);
        return null;
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        return this.getRef(this.findColumn(colName));
    }

    @Override
    public short getShort(int index) throws SQLException {
        this.validateColumnIndex(index);
        AbstractColumn absColumn = this.abstractRowCache.getColumnData(index);
        this.wasNull = absColumn.isNull();
        short out = absColumn.getShort();
        if (absColumn.getDataTruncation()) {
            Object inObj = absColumn.getObject();
            Short outObj = new Short(out);
            this.createDataTruncation(index, this.abstractRowCache.getColumnName(index), inObj, outObj);
        }
        return out;
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        int ci = this.findColumn(columnName);
        return this.getShort(ci);
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.isClosed) {
            LocalizedErrorHandler.throwLocalizedException(RSC, logger);
        }
        return this.fsstatement;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.validateColumnIndex(columnIndex);
        String returnValue = null;
        AbstractColumn absColumn = this.abstractRowCache.getColumnData(columnIndex);
        if (absColumn == null) {
            this.wasNull = true;
            return null;
        }
        returnValue = absColumn.getString();
        this.wasNull = returnValue == null;
        return returnValue;
    }

    @Override
    public String getString(String columnName) throws SQLException {
        int ci = this.findColumn(columnName);
        return this.getString(ci);
    }

    @Override
    public Time getTime(int index) throws SQLException {
        this.validateColumnIndex(index);
        AbstractColumn absColumn = this.abstractRowCache.getColumnData(index);
        this.wasNull = absColumn.isNull();
        Time out = absColumn.getTime();
        if (absColumn.getDataTruncation()) {
            Object inObj = absColumn.getObject();
            Time outObj = out;
            this.createDataTruncation(index, this.abstractRowCache.getColumnName(index), inObj, outObj);
        }
        return out;
    }

    @Override
    public Time getTime(int index, Calendar cal) throws SQLException {
        this.validateColumnIndex(index);
        AbstractColumn absColumn = this.abstractRowCache.getColumnData(index);
        this.wasNull = absColumn.isNull();
        Time out = absColumn.getTime(cal);
        if (absColumn.getDataTruncation()) {
            Object inObj = absColumn.getObject();
            Time outObj = out;
            this.createDataTruncation(index, this.abstractRowCache.getColumnName(index), inObj, outObj);
        }
        return out;
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        int ci = this.findColumn(columnName);
        return this.getTime(ci);
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        int ci = this.findColumn(columnName);
        return this.getTime(ci, cal);
    }

    @Override
    public Timestamp getTimestamp(int index) throws SQLException {
        this.validateColumnIndex(index);
        AbstractColumn absColumn = this.abstractRowCache.getColumnData(index);
        this.wasNull = absColumn.isNull();
        Timestamp out = absColumn.getTimestamp();
        if (absColumn.getDataTruncation()) {
            Object inObj = absColumn.getObject();
            Timestamp outObj = out;
            this.createDataTruncation(index, this.abstractRowCache.getColumnName(index), inObj, outObj);
        }
        return out;
    }

    @Override
    public Timestamp getTimestamp(int index, Calendar cal) throws SQLException {
        AbstractColumn absColumn = this.abstractRowCache.getColumnData(index);
        this.wasNull = absColumn.isNull();
        Timestamp out = absColumn.getTimestamp(cal);
        if (absColumn.getDataTruncation()) {
            Object inObj = absColumn.getObject();
            Timestamp outObj = out;
            this.createDataTruncation(index, this.abstractRowCache.getColumnName(index), inObj, outObj);
        }
        return out;
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        int ci = this.findColumn(columnName);
        return this.getTimestamp(ci);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        int ci = this.findColumn(columnName);
        return this.getTimestamp(ci, cal);
    }

    @Override
    public int getType() throws SQLException {
        return this.rSetType;
    }

    @Override
    public InputStream getUnicodeStream(int index) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException("General.methodNotImplemented.fmt", logger);
        return null;
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException("General.methodNotImplemented.fmt", logger);
        return null;
    }

    @Override
    public URL getURL(int index) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException("General.methodNotImplemented.fmt", logger);
        return null;
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        int ci = this.findColumn(columnName);
        return this.getURL(ci);
    }

    private void validateColumnIndex(int index) throws SQLException {
        if (this.isClosed) {
            LocalizedErrorHandler.throwLocalizedException(RSC, logger);
        }
        if (index < 1 || index > this.numberColumns) {
            if (AbstractLogger.isTrace) {
                logger.trace("validateColumnIndex ColumnCount:" + this.numberColumns + "index:" + index);
            }
            LocalizedErrorHandler.throwLocalizedException("Generic.InvalidIndex.fmt", new String[]{"" + index}, logger);
        }
    }

    private void validateResultSetForwardOnly() throws SQLException {
        if (this.rSetType == 1003) {
            LocalizedErrorHandler.throwLocalizedException("TKTSResultSet.invalidForwardOnlyRSOperation.txt", logger, "HY106");
        }
    }

    private void validateUpdateParameter(int index) throws SQLException {
        this.validateConcurrency();
        this.validateColumnIndex(index);
    }

    private void validateConcurrency() throws SQLException {
        if (this.rSetConcurrency == 1007) {
            LocalizedErrorHandler.throwLocalizedException("TKTSResultSet.invalidReadOnlyRSOperation.txt", logger);
        }
    }

    private AbstractColumn getColumnData(int index) throws SQLException {
        return this.abstractRowCache.getColumnData(index);
    }

    @Override
    public synchronized void insertRow() throws SQLException {
        String method = "insertRow";
        if (AbstractLogger.isTrace) {
            logger.entry("insertRow");
        }
        this.validateConcurrency();
        this.abstractRowCache.insertRow();
        if (AbstractLogger.isTrace) {
            logger.exit("insertRow");
        }
    }

    @Override
    public synchronized void updateRow() throws SQLException {
        String method = "updateRow";
        if (AbstractLogger.isTrace) {
            logger.entry("updateRow");
        }
        this.validateConcurrency();
        this.abstractRowCache.updateRow();
        if (AbstractLogger.isTrace) {
            logger.exit("updateRow");
        }
    }

    @Override
    public synchronized void updateRowId(int columnIndex, RowId rowID) throws SQLException {
        String method = "getNString(columnIndex, rowID)";
        this.genFeatureNotSupportedException("getNString(columnIndex, rowID)");
        throw this.nsEx;
    }

    @Override
    public synchronized void updateRowId(String columnLabel, RowId rowID) throws SQLException {
        String method = "getNString(columnLabel, rowID)";
        this.genFeatureNotSupportedException("getNString(columnLabel, rowID)");
        throw this.nsEx;
    }

    @Override
    public synchronized void deleteRow() throws SQLException {
        String method = "deleteRow";
        if (AbstractLogger.isTrace) {
            logger.entry("deleteRow");
        }
        this.validateConcurrency();
        this.abstractRowCache.deleteRow();
        if (AbstractLogger.isTrace) {
            logger.exit("deleteRow");
        }
    }

    @Override
    public synchronized void cancelRowUpdates() throws SQLException {
        this.validateConcurrency();
        String method = "cancelRowUpdates()";
        this.genFeatureNotSupportedException("cancelRowUpdates()");
        throw this.nsEx;
    }

    @Override
    public synchronized boolean rowInserted() throws SQLException {
        String method = "rowInserted()";
        this.genFeatureNotSupportedException("rowInserted()");
        throw this.nsEx;
    }

    @Override
    public synchronized boolean rowUpdated() throws SQLException {
        String method = "rowUpdated()";
        this.genFeatureNotSupportedException("rowUpdated()");
        throw this.nsEx;
    }

    @Override
    public synchronized boolean rowDeleted() throws SQLException {
        String method = "rowDeleted()";
        this.genFeatureNotSupportedException("rowDeleted()");
        throw this.nsEx;
    }

    @Override
    public synchronized void moveToCurrentRow() throws SQLException {
        String method = "moveToCurrentRow()";
        this.genFeatureNotSupportedException("moveToCurrentRow()");
        throw this.nsEx;
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        String method = "moveToInsertRow()";
        this.genFeatureNotSupportedException("moveToInsertRow()");
        throw this.nsEx;
    }

    @Override
    public synchronized void updateArray(int index, Array value) throws SQLException {
        this.validateUpdateParameter(index);
        AbstractColumn column = this.getColumnData(index);
        column.setArray(value);
    }

    @Override
    public synchronized void updateArray(String columnName, Array value) throws SQLException {
        int ci = this.findColumn(columnName);
        this.updateArray(ci, value);
    }

    @Override
    public synchronized void updateAsciiStream(int columnindex, InputStream value) throws SQLException {
        this.validateUpdateParameter(columnindex);
        AbstractColumn column = this.getColumnData(columnindex);
        int intLength = 0;
        column.setAsciiStream(value, intLength);
    }

    @Override
    public synchronized void updateAsciiStream(int columnindex, InputStream value, int length) throws SQLException {
        this.validateUpdateParameter(columnindex);
        AbstractColumn column = this.getColumnData(columnindex);
        column.setAsciiStream(value, length);
    }

    @Override
    public synchronized void updateAsciiStream(int columnindex, InputStream value, long length) throws SQLException {
        int intLength = (int)length;
        this.validateUpdateParameter(columnindex);
        AbstractColumn column = this.getColumnData(columnindex);
        column.setAsciiStream(value, intLength);
    }

    @Override
    public synchronized void updateAsciiStream(String columnName, InputStream value) throws SQLException {
        int intLength = 0;
        int ci = this.findColumn(columnName);
        this.updateAsciiStream(ci, value, intLength);
    }

    @Override
    public synchronized void updateAsciiStream(String columnName, InputStream value, int length) throws SQLException {
        int ci = this.findColumn(columnName);
        this.updateAsciiStream(ci, value, length);
    }

    @Override
    public synchronized void updateAsciiStream(String columnName, InputStream value, long length) throws SQLException {
        int ci = this.findColumn(columnName);
        this.updateAsciiStream(ci, value, length);
    }

    @Override
    public synchronized void updateBigDecimal(int index, BigDecimal value) throws SQLException {
        this.validateUpdateParameter(index);
        AbstractColumn column = this.getColumnData(index);
        int sqlType = this.abstractRowCache.getColumnType(index);
        if (sqlType == 8) {
            column.setDouble(value.doubleValue());
        } else {
            column.setBigDecimal(value);
        }
    }

    @Override
    public synchronized void updateBigDecimal(String columnName, BigDecimal value) throws SQLException {
        int ci = this.findColumn(columnName);
        this.updateBigDecimal(ci, value);
    }

    @Override
    public synchronized void updateBinaryStream(int columnIndex, InputStream value) throws SQLException {
        this.validateUpdateParameter(columnIndex);
        AbstractColumn column = this.getColumnData(columnIndex);
        int intLength = 0;
        column.setBinaryStream(value, intLength);
    }

    @Override
    public synchronized void updateBinaryStream(int columnIndex, InputStream value, int length) throws SQLException {
        this.validateUpdateParameter(columnIndex);
        AbstractColumn column = this.getColumnData(columnIndex);
        column.setBinaryStream(value, length);
    }

    @Override
    public synchronized void updateBinaryStream(int columnIndex, InputStream value, long length) throws SQLException {
        this.validateUpdateParameter(columnIndex);
        AbstractColumn column = this.getColumnData(columnIndex);
        column.setBinaryStream(value, (int)length);
    }

    @Override
    public synchronized void updateBinaryStream(String columnName, InputStream value) throws SQLException {
        int ci = this.findColumn(columnName);
        this.updateBinaryStream(ci, value);
    }

    @Override
    public synchronized void updateBinaryStream(String columnName, InputStream value, int length) throws SQLException {
        int ci = this.findColumn(columnName);
        this.updateBinaryStream(ci, value, length);
    }

    @Override
    public synchronized void updateBinaryStream(String columnName, InputStream value, long length) throws SQLException {
        int ci = this.findColumn(columnName);
        this.updateBinaryStream(ci, value, (int)length);
    }

    @Override
    public synchronized void updateBlob(int columnIndex, Blob value) throws SQLException {
        this.validateUpdateParameter(columnIndex);
        AbstractColumn column = this.getColumnData(columnIndex);
        column.setBlob(value);
    }

    @Override
    public synchronized void updateBlob(int columnIndex, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        String method = "updateBlob(columnIndex, inputStream)";
        this.genFeatureNotSupportedException("updateBlob(columnIndex, inputStream)");
        throw this.nsEx;
    }

    @Override
    public synchronized void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException, SQLFeatureNotSupportedException {
        String method = "updateBlob(columnIndex, inputStream, length)";
        this.genFeatureNotSupportedException("updateBlob(columnIndex, inputStream, length)");
        throw this.nsEx;
    }

    @Override
    public synchronized void updateBlob(String columnName, Blob value) throws SQLException {
        int ci = this.findColumn(columnName);
        this.updateBlob(ci, value);
    }

    @Override
    public synchronized void updateBlob(String columnName, InputStream inputStream) throws SQLException {
        String method = "updateBlob(columnName, inputStream)";
        this.genFeatureNotSupportedException("updateBlob(columnName, inputStream)");
        throw this.nsEx;
    }

    @Override
    public synchronized void updateBlob(String columnName, InputStream inputStream, long length) throws SQLException {
        String method = "updateBlob(columnName, inputStream, length)";
        this.genFeatureNotSupportedException("updateBlob(columnName, inputStream, length)");
        throw this.nsEx;
    }

    @Override
    public synchronized void updateBoolean(int columnIndex, boolean value) throws SQLException {
        this.validateUpdateParameter(columnIndex);
        AbstractColumn column = this.getColumnData(columnIndex);
        column.setBoolean(value);
    }

    @Override
    public synchronized void updateBoolean(String columnName, boolean value) throws SQLException {
        int ci = this.findColumn(columnName);
        this.updateBoolean(ci, value);
    }

    @Override
    public synchronized void updateByte(int columnIndex, byte value) throws SQLException {
        this.validateUpdateParameter(columnIndex);
        AbstractColumn column = this.getColumnData(columnIndex);
        column.setByte(value);
    }

    @Override
    public synchronized void updateByte(String columnName, byte value) throws SQLException {
        int ci = this.findColumn(columnName);
        this.updateByte(ci, value);
    }

    @Override
    public synchronized void updateBytes(int columnIndex, byte[] value) throws SQLException {
        this.validateUpdateParameter(columnIndex);
        AbstractColumn column = this.getColumnData(columnIndex);
        column.setBytes(value);
    }

    @Override
    public synchronized void updateBytes(String columnName, byte[] value) throws SQLException {
        int ci = this.findColumn(columnName);
        this.updateBytes(ci, value);
    }

    @Override
    public synchronized void updateCharacterStream(int columnIndex, Reader value) throws SQLException {
        String method = "updateCharacterStream(columnindex, reader)";
        this.genFeatureNotSupportedException("updateCharacterStream(columnindex, reader)");
        throw this.nsEx;
    }

    @Override
    public synchronized void updateCharacterStream(int columnIndex, Reader value, int length) throws SQLException {
        this.validateUpdateParameter(columnIndex);
        AbstractColumn column = this.getColumnData(columnIndex);
        column.setCharacterStream(value, length);
    }

    @Override
    public synchronized void updateCharacterStream(int columnIndex, Reader value, long length) throws SQLException {
        this.validateUpdateParameter(columnIndex);
        AbstractColumn column = this.getColumnData(columnIndex);
        column.setCharacterStream(value, (int)length);
    }

    @Override
    public synchronized void updateCharacterStream(String columnLabel, Reader value) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), value);
    }

    @Override
    public synchronized void updateCharacterStream(String columnLabel, Reader value, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), value, length);
    }

    @Override
    public synchronized void updateCharacterStream(String columnLabel, Reader value, long length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), value, (int)length);
    }

    @Override
    public synchronized void updateClob(int columnIndex, Clob value) throws SQLException {
        this.validateUpdateParameter(columnIndex);
        AbstractColumn column = this.getColumnData(columnIndex);
        column.setClob(value);
    }

    @Override
    public synchronized void updateClob(int columnIndex, Reader reader) throws SQLException {
        String method = "updateClob(columnindex, reader)";
        this.genFeatureNotSupportedException("updateClob(columnindex, reader)");
        throw this.nsEx;
    }

    @Override
    public synchronized void updateClob(int columnindex, Reader reader, long length) throws SQLException {
        String method = "updateClob(columnindex, reader)";
        this.genFeatureNotSupportedException("updateClob(columnindex, reader)");
        throw this.nsEx;
    }

    @Override
    public synchronized void updateClob(String columnName, Clob value) throws SQLException {
        int ci = this.findColumn(columnName);
        this.updateClob(ci, value);
    }

    @Override
    public synchronized void updateClob(String columnLabel, Reader reader) throws SQLException {
        String method = "updateClob(columnLabel, reader)";
        this.genFeatureNotSupportedException("updateClob(columnLabel, reader)");
        throw this.nsEx;
    }

    @Override
    public synchronized void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        String method = "updateClob(columnLabel, reader, length)";
        this.genFeatureNotSupportedException("updateClob(columnLabel, reader, length)");
        throw this.nsEx;
    }

    @Override
    public synchronized void updateDate(int index, Date value) throws SQLException {
        this.validateUpdateParameter(index);
        AbstractColumn column = this.getColumnData(index);
        column.setDate(value);
    }

    @Override
    public synchronized void updateDate(String columnName, Date value) throws SQLException {
        int ci = this.findColumn(columnName);
        this.updateDate(ci, value);
    }

    @Override
    public synchronized void updateDouble(int index, double value) throws SQLException {
        this.validateUpdateParameter(index);
        AbstractColumn column = this.getColumnData(index);
        int sqlType = this.abstractRowCache.getColumnType(index);
        if (sqlType == 6 || sqlType == 7) {
            column.setFloat((float)value);
        } else {
            column.setDouble(value);
        }
    }

    @Override
    public synchronized void updateDouble(String columnName, double value) throws SQLException {
        int ci = this.findColumn(columnName);
        this.updateDouble(ci, value);
    }

    @Override
    public synchronized void updateFloat(int index, float value) throws SQLException {
        this.validateUpdateParameter(index);
        AbstractColumn column = this.getColumnData(index);
        int sqlType = this.abstractRowCache.getColumnType(index);
        if (sqlType == 8) {
            column.setDouble(value);
        } else {
            column.setFloat(value);
        }
    }

    @Override
    public synchronized void updateFloat(String columnName, float value) throws SQLException {
        int ci = this.findColumn(columnName);
        this.updateFloat(ci, value);
    }

    @Override
    public synchronized void updateInt(int index, int value) throws SQLException {
        this.validateUpdateParameter(index);
        AbstractColumn column = this.getColumnData(index);
        column.setInt(value);
    }

    @Override
    public synchronized void updateInt(String columnName, int value) throws SQLException {
        int ci = this.findColumn(columnName);
        this.updateInt(ci, value);
    }

    @Override
    public synchronized void updateLong(int index, long value) throws SQLException {
        this.validateUpdateParameter(index);
        AbstractColumn column = this.getColumnData(index);
        column.setLong(value);
    }

    @Override
    public synchronized void updateLong(String columnName, long value) throws SQLException {
        int ci = this.findColumn(columnName);
        this.updateLong(ci, value);
    }

    @Override
    public synchronized void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        String method = "updateNCharacterStream(columnIndex, reader)";
        this.genFeatureNotSupportedException("updateNCharacterStream(columnIndex, reader)");
        throw this.nsEx;
    }

    @Override
    public synchronized void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        String method = "updateNCharacterStream(columnIndex, reader, length)";
        this.genFeatureNotSupportedException("updateNCharacterStream(columnIndex, reader, length)");
        throw this.nsEx;
    }

    @Override
    public synchronized void updateNCharacterStream(String columnLabel, Reader x) throws SQLException {
        String method = "updateNCharacterStream(columnLabel, reader)";
        this.genFeatureNotSupportedException("updateNCharacterStream(columnLabel, reader)");
        throw this.nsEx;
    }

    @Override
    public synchronized void updateNCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        String method = "updateNCharacterStream(columnLabel, reader, length)";
        this.genFeatureNotSupportedException("updateNCharacterStream(columnLabel, reader, length)");
        throw this.nsEx;
    }

    @Override
    public synchronized void updateNString(int columnIndex, String string) throws SQLException {
        String method = "updateNString(columnIndex, string)";
        this.genFeatureNotSupportedException("updateNString(columnIndex, string)");
        throw this.nsEx;
    }

    @Override
    public synchronized void updateNString(String columnLabel, String string) throws SQLException {
        String method = "updateNString(columnLabel, string)";
        this.genFeatureNotSupportedException("updateNString(columnLabel, string)");
        throw this.nsEx;
    }

    @Override
    public synchronized void updateNull(int index) throws SQLException {
        this.validateUpdateParameter(index);
        AbstractColumn column = this.getColumnData(index);
        column.setNull();
    }

    @Override
    public synchronized void updateNull(String columnName) throws SQLException {
        int ci = this.findColumn(columnName);
        this.updateNull(ci);
    }

    @Override
    public synchronized void updateObject(int index, Object value) throws SQLException {
        this.validateUpdateParameter(index);
        AbstractColumn column = this.getColumnData(index);
        column.setObject(value);
    }

    @Override
    public synchronized void updateObject(String columnName, Object value) throws SQLException {
        int ci = this.findColumn(columnName);
        this.updateObject(ci, value);
    }

    @Override
    public synchronized void updateObject(int index, Object value, int scale) throws SQLException {
        this.validateUpdateParameter(index);
        AbstractColumn column = this.getColumnData(index);
        column.setObject(value, scale);
    }

    @Override
    public synchronized void updateObject(String columnName, Object value, int scale) throws SQLException {
        int ci = this.findColumn(columnName);
        this.updateObject(ci, value, scale);
    }

    @Override
    public synchronized void updateRef(int index, Ref value) throws SQLException {
        this.validateUpdateParameter(index);
        AbstractColumn column = this.getColumnData(index);
        column.setRef(value);
    }

    @Override
    public synchronized void updateRef(String columnName, Ref value) throws SQLException {
        int ci = this.findColumn(columnName);
        this.updateRef(ci, value);
    }

    @Override
    public synchronized void updateShort(int index, short value) throws SQLException {
        this.validateUpdateParameter(index);
        AbstractColumn column = this.getColumnData(index);
        column.setShort(value);
    }

    @Override
    public synchronized void updateShort(String columnName, short value) throws SQLException {
        int ci = this.findColumn(columnName);
        this.updateShort(ci, value);
    }

    @Override
    public synchronized void updateString(int index, String value) throws SQLException {
        this.validateUpdateParameter(index);
        AbstractColumn column = this.getColumnData(index);
        column.setString(value);
    }

    @Override
    public synchronized void updateString(String columnName, String value) throws SQLException {
        int ci = this.findColumn(columnName);
        this.updateString(ci, value);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        String method = "updateSQLXML(columnIndex, xmlObject)";
        this.genFeatureNotSupportedException("updateSQLXML(columnIndex, xmlObject)");
        throw this.nsEx;
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        String method = "updateSQLXML(String, xmlObject)";
        this.genFeatureNotSupportedException("updateSQLXML(String, xmlObject)");
        throw this.nsEx;
    }

    @Override
    public synchronized void updateTime(int index, Time value) throws SQLException {
        this.validateUpdateParameter(index);
        AbstractColumn column = this.getColumnData(index);
        column.setTime(value);
    }

    @Override
    public synchronized void updateTime(String columnName, Time value) throws SQLException {
        int ci = this.findColumn(columnName);
        this.updateTime(ci, value);
    }

    @Override
    public synchronized void updateTimestamp(int index, Timestamp value) throws SQLException {
        this.validateUpdateParameter(index);
        AbstractColumn column = this.getColumnData(index);
        column.setTimestamp(value);
    }

    @Override
    public synchronized void updateTimestamp(String columnName, Timestamp value) throws SQLException {
        int ci = this.findColumn(columnName);
        this.updateTimestamp(ci, value);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        String method = "updateNClob(columnIndex, NClob)";
        this.genFeatureNotSupportedException("updateNClob(columnIndex, NClob)");
        throw this.nsEx;
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        String method = "updateNClob(columnIndex, reader)";
        this.genFeatureNotSupportedException("updateNClob(columnIndex, reader)");
        throw this.nsEx;
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        String method = "updateNClob(columnIndex, reader, length)";
        this.genFeatureNotSupportedException("updateNClob(columnIndex, reader, length)");
        throw this.nsEx;
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        String method = "updateNClob(columnLabel, NClob)";
        this.genFeatureNotSupportedException("updateNClob(columnLabel, NClob)");
        throw this.nsEx;
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        String method = "updateNClob(columnLabel, reader)";
        this.genFeatureNotSupportedException("updateNClob(columnLabel, reader)");
        throw this.nsEx;
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        String method = "updateNClob(columnLabel, reader, length)";
        this.genFeatureNotSupportedException("updateNClob(columnLabel, reader, length)");
        throw this.nsEx;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        String method = "unwrap(Class<T>)";
        this.genFeatureNotSupportedException("unwrap(Class<T>)");
        throw this.nsEx;
    }

    public void logIt() {
        System.out.println("logIt method ran");
    }

    public void createDataTruncation(int index, String colName, Object inObj, Object outObj) {
        DataTruncation dt = DataTypeConversions.createDataTruncation(inObj, outObj, colName, index, false, true);
        this.addWarnings(dt);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        String method = "getObject(columnIndex, type)";
        this.genFeatureNotSupportedException("getObject(columnIndex, type)");
        throw this.nsEx;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        String method = "getObject(columnLabel, classType)";
        this.genFeatureNotSupportedException("getObject(columnLabel, classType)");
        throw this.nsEx;
    }

    protected synchronized void closeCursor() throws SQLException {
        boolean cleanCache = true;
        try {
            this.abstractRowCache.close(cleanCache);
        }
        catch (Exception e) {
            LocalizedErrorHandler.throwLocalizedException("TKTSResultSet.AbstractRowCache.ClosedError.fmt", (Object[])new String[]{e.getMessage()}, e, logger);
        }
    }

    protected void genFeatureNotSupportedException(String methodName) {
        this.nsEx = null;
        String lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{methodName});
        this.nsEx = new SQLFeatureNotSupportedException(lMsg, "HY000");
    }

    public synchronized AbstractRowCache getAbstractRowCache() {
        return this.abstractRowCache;
    }

    protected synchronized StatementWrapper getStatementWrapper() {
        return this.statementWrapper;
    }

    protected synchronized void populateCache(ArrayList<Row> rowList) throws SQLException {
        this.abstractRowCache.populateCache(rowList);
    }

    public int estimateRowBytes() {
        return this.abstractRowCache.estimateRowBytes();
    }

    public String toString() {
        String outStr = "RS ID:" + this.myID;
        outStr = this.isClosed ? outStr + " Closed" : outStr + " Open";
        return outStr;
    }
}

