/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.sql;

import com.sas.tkts.logging.ExceptionsLogger;
import com.sas.tkts.sql.FSConnectionPoolDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class ConnectionPoolManager
implements ConnectionEventListener {
    private static ConnectionPoolManager datasource;
    private static byte[] poolLock;
    private static List<PooledConnection> _CONNECTION_POOL_INUSE;
    private static List<PooledConnection> _CONNECTION_POOL_AVAILABLE;
    private transient String propHostName = "dev000633.us.dataflux.com";
    private transient int propPortNumber = 21032;
    private transient String propUserID = "root";
    private transient String propConnectionString = "DSN=DSN_BENCH1";

    private ConnectionPoolManager() {
        _CONNECTION_POOL_INUSE = new ArrayList<PooledConnection>();
        _CONNECTION_POOL_AVAILABLE = new ArrayList<PooledConnection>();
    }

    public static synchronized ConnectionPoolManager getInstance() {
        if (datasource == null) {
            datasource = new ConnectionPoolManager();
        }
        return datasource;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnectionFromPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionClosed(ConnectionEvent event) {
        PooledConnection pooledConnection = (PooledConnection)event.getSource();
        byte[] byArray = poolLock;
        synchronized (poolLock) {
            _CONNECTION_POOL_INUSE.remove(pooledConnection);
            _CONNECTION_POOL_AVAILABLE.add(pooledConnection);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        SQLException se = event.getSQLException();
        if (se != null) {
            ExceptionsLogger.logSql(se);
        }
        this.connectionClosed(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHardCloseAllConnections() {
        byte[] byArray = poolLock;
        synchronized (poolLock) {
            this.closePooleConnections(_CONNECTION_POOL_AVAILABLE);
            this.closePooleConnections(_CONNECTION_POOL_INUSE);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void closePooleConnections(List<PooledConnection> _LIST) {
        while (!_LIST.isEmpty()) {
            PooledConnection pooledConnection = _LIST.remove(0);
            try {
                pooledConnection.close();
            }
            catch (SQLException se) {
                ExceptionsLogger.logSql(se);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnectionFromPool() throws SQLException {
        PooledConnection pooledConnection = null;
        byte[] byArray = poolLock;
        synchronized (poolLock) {
            if (_CONNECTION_POOL_AVAILABLE.isEmpty()) {
                pooledConnection = this.createNewConnection();
                _CONNECTION_POOL_INUSE.add(pooledConnection);
            } else {
                pooledConnection = _CONNECTION_POOL_AVAILABLE.remove(0);
                _CONNECTION_POOL_INUSE.add(pooledConnection);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return pooledConnection.getConnection();
        }
    }

    private PooledConnection createNewConnection() throws SQLException {
        FSConnectionPoolDataSource connPoolDatasource = new FSConnectionPoolDataSource();
        connPoolDatasource.setConnectionString(this.propConnectionString);
        connPoolDatasource.setServerName(this.propHostName);
        connPoolDatasource.setPortNumber(this.propPortNumber);
        PooledConnection pooledConnection = connPoolDatasource.getPooledConnection(this.propUserID, "");
        pooledConnection.addConnectionEventListener(this);
        return pooledConnection;
    }

    public String toString() {
        String outStr = _CONNECTION_POOL_INUSE == null ? "CONNECTION_POOL_INUSE:NULL" : "CONNECTION_POOL_INUSE:" + _CONNECTION_POOL_INUSE.size();
        outStr = _CONNECTION_POOL_INUSE == null ? outStr + "\nCONNECTION_POOL_AVAILABLE:NULL" : outStr + "\nCONNECTION_POOL_AVAILABLE:" + _CONNECTION_POOL_AVAILABLE.size();
        if (datasource == null) {
            outStr = outStr + "\nDatasource:NULL";
        } else {
            outStr = outStr + "\nDatasource:";
            outStr = outStr + "\n  HostName:" + ConnectionPoolManager.datasource.propHostName;
            outStr = outStr + "\n  PortNumber:" + ConnectionPoolManager.datasource.propPortNumber;
            outStr = outStr + "\n  UserID:" + ConnectionPoolManager.datasource.propUserID;
            outStr = outStr + "\n  ConnString:" + ConnectionPoolManager.datasource.propConnectionString;
        }
        return outStr;
    }

    static {
        poolLock = new byte[0];
    }
}

