/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.sql;

import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.util.SafeStore;
import com.sas.tkts.util.UtilityFunctions;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Properties;

public class BaseDataSource {
    private static String thisClassName = BaseDataSource.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    protected transient String dataSourceName;
    protected transient String description;
    protected transient boolean isTrusted;
    protected transient int portNumber;
    protected transient String serverName;
    protected transient String safetoLogConnStr;
    protected transient String safetoLogURL;
    protected transient SafeStore safeC = null;
    protected transient SafeStore safeU = null;
    protected transient SafeStore safeP = null;
    protected transient SafeStore safeURL = null;
    protected transient boolean useSSPI;
    protected transient String secpackagelist;
    protected transient String cursorType = "TKTS_CUR_USE_IF_NEEDED";
    protected transient int statementPoolSize;
    protected transient int defaultFetchSize;
    protected int loginTimeout;
    protected transient PrintWriter logWriter = null;

    public String getConnectionString() {
        if (this.safeC == null) {
            return null;
        }
        return this.safeC.getValue();
    }

    public String getCursorType() {
        return this.cursorType;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public int getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    public String getDescription() {
        return this.description;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public String getPassword() {
        if (this.safeP == null) {
            return null;
        }
        return this.safeP.getValue();
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    private String getPortNumberString() {
        String out = "";
        try {
            out = Integer.toString(this.portNumber);
        }
        catch (Exception ex) {
            logger.error(ex);
        }
        return out;
    }

    public String getSecpackagelist() {
        return this.secpackagelist;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerURL() {
        if (this.safeURL == null) {
            String s = this.getServerName();
            if (s == null) {
                s = "";
            }
            String pn = this.getPortNumberString();
            return "jdbc:sastkts://" + s + ":" + pn;
        }
        return this.safeURL.getValue();
    }

    public boolean getSSPI() {
        return this.useSSPI;
    }

    public int getStatementPoolSize() {
        return this.statementPoolSize;
    }

    public boolean getTrusted() {
        return this.isTrusted;
    }

    public String getUser() {
        return this.getUserName();
    }

    public String getUserName() {
        if (this.safeU == null) {
            return null;
        }
        return this.safeU.getValue();
    }

    public void logError(String eStr) {
        if (this.logWriter != null) {
            this.logWriter.print(eStr);
            this.logWriter.flush();
        }
    }

    public void setConnectionString(String connectionString) {
        if (connectionString == null) {
            this.safeC = null;
        } else {
            this.safetoLogConnStr = UtilityFunctions.safeToLog(connectionString, "");
            this.safeC = new SafeStore(connectionString);
            connectionString = null;
        }
    }

    public void setCursorType(String type) {
        this.cursorType = type;
    }

    public void setDataSourceName(String name) {
        this.dataSourceName = name;
    }

    public void setDefaultFetchSize(int defaultFetchSize) {
        this.defaultFetchSize = defaultFetchSize;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    public void setLogWriter(PrintWriter writer) {
        this.logWriter = writer;
    }

    public void setPassword(String p) {
        if (p == null) {
            this.safeP = null;
        } else {
            this.safeP = new SafeStore(p);
            p = null;
        }
    }

    public void setPortNumber(int number) {
        this.portNumber = number;
    }

    public void setSecpackagelist(String packagelist) {
        this.secpackagelist = packagelist;
    }

    public void setServerName(String name) {
        this.serverName = name;
    }

    public void setServerURL(String url) {
        if (url == null) {
            this.safeURL = null;
        } else {
            this.safetoLogURL = UtilityFunctions.safeToLog(url, "");
            this.safeURL = new SafeStore(url);
            url = null;
        }
    }

    public void setSSPI(boolean sspi) {
        this.useSSPI = sspi;
    }

    public void setStatementPoolSize(int size) {
        this.statementPoolSize = size;
    }

    public void setTrusted(boolean trusted) {
        this.isTrusted = trusted;
    }

    public void setUser(String name) {
        this.setUserName(name);
    }

    public void setUserName(String u) {
        if (u == null) {
            this.safeU = null;
        } else {
            this.safeU = new SafeStore(u);
            u = null;
        }
    }

    protected Properties populateProperties(SafeStore safeC, SafeStore safeP, SafeStore safeU, String user, String pwd) {
        int sl;
        Properties properties = new Properties();
        SafeStore u = safeU;
        SafeStore p = safeP;
        if (user == null) {
            u = safeU;
        } else {
            sl = user.length();
            u = new SafeStore(user);
            user = null;
            UtilityFunctions.attemptStringClear(sl);
        }
        if (u != null) {
            properties.put("suser", u.getSealedString());
            u = null;
        }
        if (pwd == null) {
            p = safeP;
        } else {
            sl = pwd.length();
            p = new SafeStore(pwd);
            pwd = null;
            UtilityFunctions.attemptStringClear(sl);
        }
        if (p != null) {
            properties.put("spassword", p.getSealedString());
            p = null;
        }
        if (safeC != null) {
            properties.put("sconstr", safeC.getSealedString());
        }
        properties.setProperty("cursorType", this.cursorType);
        if (this.defaultFetchSize != 0) {
            properties.setProperty("defaultFetchSize", Integer.toString(this.defaultFetchSize));
        }
        return properties;
    }

    public String toString() {
        String fmt0 = "name:%s description:%s ";
        String fmt1 = "\nconnectionString:[%s] ";
        String fmt2 = "\nurl:[%s] ";
        String fmt3 = "\nhost:%s port:%d  ";
        String fmt4 = "\nCredentialSet[%s,%s]  ";
        String fmt5 = "\nUseSSPI:%s SECPACKAGELIST:%s ";
        String fmt6 = "\nStatementPoolSize:%d ";
        String fmt7 = "\ncursorType:%s statementPoolSize:%d ";
        String fmt8 = "\ndefaultFetchSize:%d loginTimeout:%d ";
        String out = String.format("name:%s description:%s ", this.dataSourceName, this.description);
        out = out + String.format("\nconnectionString:[%s] ", this.safetoLogConnStr);
        out = out + String.format("\nurl:[%s] ", this.safetoLogURL);
        out = out + String.format("\nhost:%s port:%d  ", this.serverName, this.portNumber);
        out = out + String.format("\nCredentialSet[%s,%s]  ", this.safeU != null, this.safeP != null);
        out = out + String.format("\nUseSSPI:%s SECPACKAGELIST:%s ", this.useSSPI, this.secpackagelist);
        out = out + String.format("\nStatementPoolSize:%d ", this.statementPoolSize);
        out = out + String.format("\ncursorType:%s statementPoolSize:%d ", this.cursorType, this.statementPoolSize);
        out = out + String.format("\ndefaultFetchSize:%d loginTimeout:%d ", this.defaultFetchSize, this.loginTimeout);
        return out;
    }
}

