/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.logging;

import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.ConcreteLogger;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;

public class LoggerFactory {
    private LoggerFactory() {
    }

    public static synchronized AbstractLogger getLogger(String loggerName) {
        return new ConcreteLogger(loggerName);
    }

    public static void displayCurrentLoggers() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Iterator allLoggers = ctx.getLoggers().iterator();
        System.out.println("--------- List of Active Loggers ---------");
        while (allLoggers.hasNext()) {
            Logger logger = (Logger)allLoggers.next();
            System.out.println("Logger: " + logger.getName() + " " + logger.getLevel() + " ");
            Map ma = logger.getAppenders();
            for (Map.Entry entry : ma.entrySet()) {
                System.out.println("  [" + (String)entry.getKey() + "]:[" + entry.getValue() + "]");
            }
        }
        System.out.println("");
    }
}

