/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.logging;

import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.util.TypesHelper;
import com.sas.tkts.util.UtilityFunctions;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Properties;
import org.omg.CORBA.Any;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;

public class CommonLogger {
    public static final int MAX_BYTES_TO_LOG = 4096;

    public static void logProperties(String name, AbstractLogger inLogger, Properties p) {
        if (inLogger != null) {
            inLogger.trace(name + " Properties:");
        }
        if (p == null) {
            if (inLogger != null) {
                inLogger.trace(" null pointer");
            }
        } else {
            Enumeration<Object> keys = p.keys();
            if (keys != null) {
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = (String)p.get(key);
                    if (inLogger == null) continue;
                    inLogger.trace(" [" + key + "]=[" + value + "] ");
                }
            }
        }
    }

    public static void logBytes(AbstractLogger inLogger, byte[] bl, int startOffset, int bytesToLog, boolean logSystem) throws SQLException {
        int bytesPerRow = UtilityFunctions.getFormatBytesRowSize();
        if (bytesToLog > 0 && inLogger != null) {
            int bytesToFormat = bytesToLog > bytesPerRow ? bytesPerRow : bytesToLog;
            while (bytesToLog > 0) {
                String s = UtilityFunctions.formatBytes(bl, startOffset, bytesToFormat);
                if (inLogger != null) {
                    inLogger.trace(s);
                }
                if (logSystem) {
                    System.out.println(s);
                }
                if (bytesToFormat > (bytesToLog -= bytesToFormat)) {
                    bytesToFormat = bytesToLog;
                }
                startOffset += bytesPerRow;
            }
        }
    }

    public static String getSQLTypeString(int sqlType) {
        String out = TypesHelper.getSQLTypeString(sqlType);
        if (out == null) {
            out = "????";
        }
        return out;
    }

    public static String getSQLTypeStringAndNumber(int sqlType) {
        String out = TypesHelper.getSQLTypeString(sqlType);
        if (out == null) {
            out = "????";
        }
        Integer intObj = new Integer(sqlType);
        out = out + "(" + intObj + ")";
        return out;
    }

    public static String getCTypeString(int cType) {
        String outString;
        String t_tkts_c_binary = "TKTS_C_BINARY";
        String t_tkts_c_bit = "TKTS_C_BIT";
        String t_tkts_c_bookmark = "TKTS_C_BOOKMARK";
        String t_tkts_c_char = "TKTS_C_CHAR";
        String t_tkts_c_default = "TKTS_C_DEFAULT";
        String t_tkts_c_fdnum = "TKTS_C_FDNUM";
        String t_tkts_c_double = "TKTS_C_DOUBLE";
        String t_tkts_c_float = "TKTS_C_FLOAT";
        String t_tkts_c_numeric = "TKTS_C_NUMERIC";
        String t_tkts_c_sbigint = "TKTS_C_SBIGINT";
        String t_tkts_c_slong = "TKTS_C_SLONG";
        String t_tkts_c_sshort = "TKTS_C_SSHORT";
        String t_tkts_c_stinyint = "TKTS_C_STINYINT";
        String t_tkts_c_type_date = "TKTS_C_TYPE_DATE";
        String t_tkts_c_type_time = "TKTS_C_TYPE_TIME";
        String t_tkts_c_type_timestamp = "TKTS_C_TYPE_TIMESTAMP";
        String t_tkts_c_ubigint = "TKTS_C_UBIGINT";
        String t_tkts_c_ulong = "TKTS_C_ULONG";
        String t_tkts_c_ushort = "TKTS_C_USHORT";
        String t_tkts_c_utinyint = "TKTS_C_UTINYINT";
        String t_tkts_c_wchar = "TKTS_C_WCHAR";
        String t_unknown = "?????";
        switch (cType) {
            case 2: {
                outString = "TKTS_C_BINARY";
                break;
            }
            case 7: {
                outString = "TKTS_C_BIT";
                break;
            }
            case 16: {
                outString = "TKTS_C_BOOKMARK";
                break;
            }
            case 1: {
                outString = "TKTS_C_CHAR";
                break;
            }
            case 0: {
                outString = "TKTS_C_DEFAULT";
                break;
            }
            case 34: {
                outString = "TKTS_C_FDNUM";
                break;
            }
            case 6: {
                outString = "TKTS_C_DOUBLE";
                break;
            }
            case 4: {
                outString = "TKTS_C_FLOAT";
                break;
            }
            case 5: {
                outString = "TKTS_C_NUMERIC";
                break;
            }
            case 8: {
                outString = "TKTS_C_SBIGINT";
                break;
            }
            case 10: {
                outString = "TKTS_C_SLONG";
                break;
            }
            case 12: {
                outString = "TKTS_C_SSHORT";
                break;
            }
            case 14: {
                outString = "TKTS_C_STINYINT";
                break;
            }
            case 17: {
                outString = "TKTS_C_TYPE_DATE";
                break;
            }
            case 18: {
                outString = "TKTS_C_TYPE_TIME";
                break;
            }
            case 19: {
                outString = "TKTS_C_TYPE_TIMESTAMP";
                break;
            }
            case 9: {
                outString = "TKTS_C_UBIGINT";
                break;
            }
            case 11: {
                outString = "TKTS_C_ULONG";
                break;
            }
            case 13: {
                outString = "TKTS_C_USHORT";
                break;
            }
            case 15: {
                outString = "TKTS_C_UTINYINT";
                break;
            }
            case 3: {
                outString = "TKTS_C_WCHAR";
                break;
            }
            default: {
                outString = "?????";
            }
        }
        return outString;
    }

    public static String getCTypeStringAndNumber(int cType) {
        String out = CommonLogger.getCTypeString(cType);
        out = out + "(" + cType + ")";
        return out;
    }

    public static void logSQLWarnings(AbstractLogger inLogger, SQLWarning warning) {
        while (warning != null) {
            if (inLogger != null) {
                inLogger.warn("sqlWarning:" + warning);
            }
            warning = warning.getNextWarning();
        }
    }

    public static String getFreeOptionString(int option) {
        String outString;
        String t_tkts_close = "TKTS_CLOSE";
        String t_tkts_drop = "TKTS_DROP";
        String t_tkts_reset_params = "TKTS_RESET_PARAMS";
        String t_tkts_reset_parallel = "TKTS_RESET_PARALLEL_FETCH";
        String t_tkts_unbind = "TKTS_UNBIND";
        String t_tkts_unprepare = "TKTS_UNPREPARE";
        String t_unknown = "?????";
        switch (option) {
            case 0: {
                outString = "TKTS_CLOSE";
                break;
            }
            case 1: {
                outString = "TKTS_DROP";
                break;
            }
            case 100: {
                outString = "TKTS_RESET_PARALLEL_FETCH";
                break;
            }
            case 3: {
                outString = "TKTS_RESET_PARAMS";
                break;
            }
            case 2: {
                outString = "TKTS_UNBIND";
                break;
            }
            case 101: {
                outString = "TKTS_UNPREPARE";
                break;
            }
            default: {
                outString = "?????";
            }
        }
        return outString;
    }

    public static String bindDirection(int option) {
        String outString;
        String t_tkts_col_input = "TKTS_COL_INPUT";
        String t_tkts_col_input_output = "TKTS_COL_INPUT_OUTPUT";
        String t_tkts_col_output = "TKTS_COL_OUTPUT";
        String t_tkts_param_input = "TKTS_PARAM_INPUT";
        String t_tkts_param_input_output = "TKTS_PARAM_INPUT_OUTPUT";
        String t_tkts_param_output = "TKTS_PARAM_OUTPUT";
        String t_tkts_param_type_unknown = "TKTS_PARAM_TYPE_UNKNOWN";
        String t_unknown = "?????";
        switch (option) {
            case 11: {
                outString = "TKTS_COL_INPUT";
                break;
            }
            case 12: {
                outString = "TKTS_COL_INPUT_OUTPUT";
                break;
            }
            case 13: {
                outString = "TKTS_COL_OUTPUT";
                break;
            }
            case 1: {
                outString = "TKTS_PARAM_INPUT";
                break;
            }
            case 2: {
                outString = "TKTS_PARAM_INPUT_OUTPUT";
                break;
            }
            case 4: {
                outString = "TKTS_PARAM_OUTPUT";
                break;
            }
            case 0: {
                outString = "TKTS_PARAM_TYPE_UNKNOWN";
                break;
            }
            default: {
                outString = "?????";
            }
        }
        return outString;
    }

    public static String paramsetBehavior(int inParamsetBehavior) {
        String outParamsetBehavior = null;
        String t_tkts_pb_unsupported = "TKTS_PB_UNSUPPORTED";
        String t_tkts_pb_emulate = "TKTS_PB_EMULATE";
        String t_tkts_pb_direct_bind = "TKTS_PB_DIRECT_BIND";
        String t_tkts_pb_set_before_prepare = "TKTS_PB_SET_BEFORE_PREPARE";
        String t_tkts_unk = "????";
        switch (inParamsetBehavior) {
            case -1: {
                outParamsetBehavior = "TKTS_PB_UNSUPPORTED";
                break;
            }
            case 0: {
                outParamsetBehavior = "TKTS_PB_EMULATE";
                break;
            }
            case 1: {
                outParamsetBehavior = "TKTS_PB_DIRECT_BIND";
                break;
            }
            case 2: {
                outParamsetBehavior = "TKTS_PB_SET_BEFORE_PREPARE";
                break;
            }
            default: {
                outParamsetBehavior = "????";
            }
        }
        return outParamsetBehavior;
    }

    public static String[] getStmtAttribute(int number, Any anyValue) {
        String[] outStrings = new String[2];
        String outAttr = null;
        String outVal = null;
        boolean hasValue = false;
        int inVal = 0;
        if (anyValue != null) {
            TypeCode anyTC = anyValue.type();
            TCKind tcKind = anyTC.kind();
            int tcKindVal = tcKind.value();
            hasValue = true;
            switch (tcKindVal) {
                case 6: 
                case 7: {
                    double t = anyValue.extract_double();
                    inVal = (int)t;
                    break;
                }
                case 3: {
                    inVal = anyValue.extract_long();
                    break;
                }
                case 5: {
                    inVal = anyValue.extract_ulong();
                    break;
                }
                case 23: {
                    inVal = (int)anyValue.extract_longlong();
                    break;
                }
                case 24: {
                    inVal = (int)anyValue.extract_ulonglong();
                }
                default: {
                    inVal = -9999999;
                    hasValue = false;
                }
            }
        }
        block7 : switch (number) {
            case 20012: {
                outAttr = "TKTS_ATTR_CHAR_CEI";
                break;
            }
            case 7: {
                outAttr = "TKTS_ATTR_CONCURRENCY";
                if (!hasValue) break;
                switch (inVal) {
                    case 0: {
                        outVal = "TKTS_CONCUR_UNSPECIFIED";
                        break block7;
                    }
                    case 1: {
                        outVal = "TKTS_CONCUR_READ_ONLY";
                        break block7;
                    }
                    case 2: {
                        outVal = "TKTS_CONCUR_LOCK";
                        break block7;
                    }
                    case 3: {
                        outVal = "TKTS_CONCUR_ROWVER";
                        break block7;
                    }
                    case 4: {
                        outVal = "TKTS_CONCUR_VALUES";
                        break block7;
                    }
                }
                outVal = "????";
                break;
            }
            case -1: {
                outAttr = "TKTS_ATTR_CURSOR_SCROLLABLE";
                if (!hasValue) break;
                switch (inVal) {
                    case 0: {
                        outVal = "TKTS_NONSCROLLABLE";
                        break block7;
                    }
                    case 1: {
                        outVal = "TKTS_SCROLLABLE";
                        break block7;
                    }
                    case 255: {
                        outVal = "TKTS_SCROLLABLE_UNSPECIFIED";
                        break block7;
                    }
                }
                outVal = "????";
                break;
            }
            case -2: {
                outAttr = "TKTS_ATTR_CURSOR_SENSITIVITY";
                if (!hasValue) break;
                switch (inVal) {
                    case 0: {
                        outVal = "TKTS_UNSPECIFIED";
                        break block7;
                    }
                    case 1: {
                        outVal = "TKTS_INSENSITIVE";
                        break block7;
                    }
                    case 2: {
                        outVal = "TKTS_SENSITIVE";
                        break block7;
                    }
                }
                outVal = "????";
                break;
            }
            case 1: {
                outAttr = "TKTS_ATTR_MAX_ROWS";
                break;
            }
            case 22: {
                outAttr = "TKTS_ATTR_PARAMSET_SIZE";
                break;
            }
            case 27: {
                outAttr = "TKTS_ATTR_ROW_ARRAY_SIZE";
                break;
            }
            case 20123: {
                outAttr = "TKTS_ATTR_TKSQL_PARAMSET_BEHAVIOR";
                if (!hasValue) break;
                outVal = CommonLogger.paramsetBehavior(inVal);
                break;
            }
            default: {
                outAttr = "TKTS_ATTR_????:" + number;
            }
        }
        outStrings[0] = outAttr;
        outStrings[1] = outVal;
        return outStrings;
    }

    public static String getNullBehavior(int number) {
        String outStr;
        switch (number) {
            case 0: {
                outStr = "TKTS_NB_ANSI";
                break;
            }
            case 1: {
                outStr = "TKTS_NB_MISSING";
                break;
            }
            case -2: {
                outStr = "TKTS_NB_DEFAULT";
                break;
            }
            default: {
                outStr = "TKTS_NB_????:" + number;
            }
        }
        return outStr;
    }

    public static String getIndicator(int number) {
        String t_tkts_is_unknown = "TKTS_IS_????";
        String t_tkts_is_bigint = "TKTS_IS_BIGINT";
        String t_tkts_is_integer = "TKTS_IS_INTEGER";
        String t_tkts_is_smallint = "TKTS_IS_SMALLINT";
        String t_tkts_is_ubigint = "TKTS_IS_UBIGINT";
        String t_tkts_is_uinteger = "TKTS_IS_UINTEGER";
        String t_tkts_is_usmallint = "TKTS_IS_USMALLINT";
        String outStr = "TKTS_IS_????";
        switch (number) {
            case -9: {
                outStr = "TKTS_IS_BIGINT";
                break;
            }
            case -6: {
                outStr = "TKTS_IS_INTEGER";
                break;
            }
            case -8: {
                outStr = "TKTS_IS_SMALLINT";
                break;
            }
            case -10: {
                outStr = "TKTS_IS_UBIGINT";
                break;
            }
            case -5: {
                outStr = "TKTS_IS_UINTEGER";
                break;
            }
            case -7: {
                outStr = "TKTS_IS_USMALLINT";
                break;
            }
        }
        return outStr;
    }

    public static String getAnyString(Any anyValue) {
        TypeCode anyTC = anyValue.type();
        TCKind tcKind = anyTC.kind();
        int tcKindVal = tcKind.value();
        String outStr = null;
        switch (tcKindVal) {
            case 8: {
                boolean t = anyValue.extract_boolean();
                Boolean to = t ? Boolean.TRUE : Boolean.FALSE;
                outStr = to.toString();
                break;
            }
            case 6: 
            case 7: {
                double t = anyValue.extract_double();
                Double to = new Double(t);
                outStr = to.toString();
                break;
            }
            case 3: {
                int t = anyValue.extract_long();
                Integer to = new Integer(t);
                outStr = to.toString();
                break;
            }
            case 5: {
                int t = anyValue.extract_ulong();
                Integer to = new Integer(t);
                outStr = to.toString();
                break;
            }
            case 23: {
                long t = anyValue.extract_longlong();
                Long to = new Long(t);
                outStr = to.toString();
                break;
            }
            case 24: {
                long t = anyValue.extract_ulonglong();
                Long to = new Long(t);
                outStr = to.toString();
                break;
            }
        }
        return outStr;
    }

    public static String getXCodeString(int xcode) {
        String out;
        String XCODE_UNKNOWN = "UNKNOWN";
        String XCODE_ERROR = "ERROR";
        String XCODE_WARN = "TKTS_C_BIT";
        String XCODE_IGNORE = "TKTS_C_BOOKMARK";
        switch (xcode) {
            case 0: {
                out = "ERROR";
                break;
            }
            case 1: {
                out = "TKTS_C_BIT";
                break;
            }
            case 2: {
                out = "TKTS_C_BOOKMARK";
                break;
            }
            default: {
                out = "UNKNOWN";
            }
        }
        return out;
    }
}

