/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.logging;

import com.sas.tkts.stats.StatisticItem;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Level;

public abstract class AbstractLogger {
    public static final String TRACE = "TRACE";
    public static final String DEBUG = "DEBUG";
    public static final String INFO = "INFO";
    public static final String WARN = "WARN";
    public static final String ERROR = "ERROR";
    public static final String FATAL = "FATAL";
    public static final String ALL = "ALL";
    public static final String OFF = "OFF";
    public static final String TRACE_TO_NULL = "null";
    public static final String LOG4G2_PACKAGE_ROOT = "com.sas.tkts";
    public static final String LOG4G2_INIT = "com.sas.tkts.init";
    public static final String LOG4G2_COM_SAS = "com.sas";
    public static final String LOG4G2_PREFETCH = "com.sas.tkts.prefetch";
    public static final String LOG4G2_PREFETCH_SUMMARY = "com.sas.tkts.prefetch.Summary";
    public static final String LOG4G2_MEASUREMENTS = "com.sas.tkts.measurements";
    public static final String LOG4G2_THRESHOLDS = "com.sas.tkts.thresholds";
    public static String jvmTempDirectory;
    public static String jvmFileSeparator;
    public static String JDBC_LOG;
    public static String JDBC_MEASUREMENTS_LOG;
    protected static final int DEFAULT_MEASUREMENT = 2;
    public static boolean isTrace;
    public static boolean isDebug;
    public static boolean isInfo;
    public static boolean isWarn;
    public static boolean isError;
    public static boolean isFatal;
    public static boolean isOff;
    public static boolean isTraceToNull;
    public static boolean isMeasurements;
    public static boolean isMeasurementsDetails;
    public static Level DEFAULT_LEVEL;
    public static boolean flush;
    public static int measurementThreshold;
    public static int measurementUnit;
    public static boolean measurementAppend;
    public static boolean debugInit;

    public abstract void debug(String var1);

    public abstract void error(Object var1);

    public abstract void error(Object var1, Throwable var2);

    public abstract void errorMethod(String var1, Object var2);

    public abstract void info(Object var1);

    public abstract void info(Object var1, Throwable var2);

    public abstract void info(String var1, Object var2);

    public abstract void warn(Object var1);

    public abstract void warn(String var1, Object var2);

    public abstract void fatal(Object var1);

    public abstract void fatal(Object var1, Throwable var2);

    public abstract void trace(String var1, Object var2);

    public abstract void trace(Object var1);

    public abstract void trace(Object var1, Throwable var2);

    public abstract void entry(String var1);

    public abstract void entry(String var1, Object var2);

    public abstract void exit(String var1);

    public abstract void exit(String var1, Object var2);

    public abstract void logStatistics(String var1, StatisticItem var2);

    public abstract void logStatistics(StatisticItem var1);

    public abstract void logOverallStatistics(StatisticItem var1);

    public abstract void logOverallStatisticsTotals(String var1, long var2, double var4, double var6, double var8, long var10, long var12);

    public abstract Object getResourceBundle();

    public abstract void setResourceBundle(ResourceBundle var1);

    public static boolean setLevel(String level) {
        boolean out = true;
        if (level == null) {
            isOff = true;
            return out;
        }
        if (level.equalsIgnoreCase(TRACE_TO_NULL)) {
            isTraceToNull = true;
            isTrace = true;
            isInfo = true;
            isWarn = true;
            isError = true;
            isFatal = true;
            isDebug = true;
            isOff = false;
        } else if (level.equalsIgnoreCase(TRACE)) {
            isTrace = true;
            isInfo = true;
            isWarn = true;
            isError = true;
            isFatal = true;
            isOff = false;
        } else if (level.equalsIgnoreCase(DEBUG)) {
            isDebug = true;
            isInfo = true;
            isWarn = true;
            isError = true;
            isFatal = true;
            isOff = false;
        } else if (level.equalsIgnoreCase(INFO)) {
            isInfo = true;
            isWarn = true;
            isError = true;
            isFatal = true;
            isOff = false;
        } else if (level.equalsIgnoreCase(WARN)) {
            isWarn = true;
            isError = true;
            isFatal = true;
            isOff = false;
        } else if (level.equalsIgnoreCase(ERROR)) {
            isError = true;
            isFatal = true;
            isOff = false;
        } else if (level.equalsIgnoreCase(FATAL)) {
            isFatal = true;
            isOff = false;
        } else if (level.equalsIgnoreCase(ALL)) {
            isTrace = true;
            isInfo = true;
            isWarn = true;
            isError = true;
            isFatal = true;
            isOff = false;
        } else if (level.equalsIgnoreCase(OFF)) {
            isOff = true;
        } else {
            out = false;
        }
        return out;
    }

    public static boolean setMeasurements(String newValue) {
        boolean valid = true;
        if (newValue.equalsIgnoreCase("summary")) {
            isMeasurements = true;
            isMeasurementsDetails = false;
        } else if (newValue.equalsIgnoreCase("details")) {
            isMeasurements = true;
            isMeasurementsDetails = true;
        } else {
            isMeasurements = false;
            isMeasurementsDetails = false;
            if (!newValue.equalsIgnoreCase("off")) {
                valid = false;
            }
        }
        return valid;
    }

    private static boolean verifyBoolean(String option, boolean defaultValue) {
        boolean out = defaultValue;
        if (option == null) {
            return out;
        }
        out = option.equalsIgnoreCase("true") ? true : !option.equalsIgnoreCase("false");
        return out;
    }

    public static void setFlush(String option) {
        flush = AbstractLogger.verifyBoolean(option, true);
    }

    public static void setMeasurementsThreshold(int seconds) {
        measurementThreshold = seconds;
    }

    public static void setMeasurementsAppend(String option) {
        measurementAppend = AbstractLogger.verifyBoolean(option, false);
    }

    public static boolean setMeasurementsUnit(String unit) {
        boolean valid = true;
        if (unit == null) {
            measurementUnit = 2;
            return valid;
        }
        if (unit.equalsIgnoreCase("ns")) {
            measurementUnit = 0;
        } else if (unit.equalsIgnoreCase("ms")) {
            measurementUnit = 1;
        } else if (unit.equalsIgnoreCase("min")) {
            measurementUnit = 3;
        } else if (unit.equalsIgnoreCase("s")) {
            measurementUnit = 2;
        } else {
            measurementUnit = 2;
            valid = false;
        }
        return valid;
    }

    public static boolean getFlush() {
        return flush;
    }

    public static String getFlushType() {
        if (flush) {
            return "true";
        }
        return "false";
    }

    public static int getMeasurementsUnit() {
        return measurementUnit;
    }

    public static int getMeasurementsThreshold() {
        return measurementThreshold;
    }

    public static boolean getMeasurementsAppend() {
        return measurementAppend;
    }

    public static String getMeasurementsUnitString() {
        switch (measurementUnit) {
            case 1: {
                return "ms";
            }
            case 0: {
                return "ns";
            }
            case 3: {
                return "min";
            }
            case 2: {
                return "s";
            }
        }
        return "s";
    }

    public static void setDebugInitialization(String newValue) {
        debugInit = AbstractLogger.verifyBoolean(newValue, false);
    }

    public static boolean getDebugInitialization() {
        return debugInit;
    }

    static {
        JDBC_LOG = "dfs_jdbc.log";
        JDBC_MEASUREMENTS_LOG = "dfs_jdbc_measurements.log";
        isTrace = false;
        isDebug = false;
        isInfo = false;
        isWarn = false;
        isError = false;
        isFatal = false;
        isOff = false;
        isTraceToNull = false;
        isMeasurements = false;
        isMeasurementsDetails = false;
        DEFAULT_LEVEL = Level.OFF;
        measurementUnit = 2;
        measurementAppend = false;
        try {
            jvmTempDirectory = System.getProperty("java.io.tmpdir");
        }
        catch (Exception ex) {
            System.out.println("Exception in reading System Property java.io.tmpdir");
            System.out.println(ex);
            jvmTempDirectory = "";
        }
        try {
            jvmFileSeparator = System.getProperty("file.separator");
        }
        catch (Exception ex) {
            System.out.println("Exception in reading System Property file.separator");
            System.out.println(ex);
            jvmFileSeparator = "";
        }
    }
}

