/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.iom;

import com.sas.SASTableServer.TKTS_ERROR;
import com.sas.SASTableServer.TKTS_INVALID_HANDLE;
import com.sas.SASTableServer.TKTS_NO_DATA;
import com.sas.iom.SASIOMDefs.AnySeqHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfLongHolder;
import com.sas.tkts.FedSrvJDBC;
import com.sas.tkts.iom.ConnectionWrapper;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.util.TypesHelper;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;

public abstract class AbstractIOMWrapper
extends FedSrvJDBC {
    private static String thisClassName = AbstractIOMWrapper.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);

    public abstract void createWarning(SQLWarning var1);

    public abstract void GetAttr(int var1, int var2, AnyHolder var3, IntHolder var4) throws TKTS_ERROR, TKTS_INVALID_HANDLE, GenericError;

    public abstract void GetDiagFields(int[] var1, int[] var2, int[] var3, AnySeqHolder var4, VariableArray2dOfLongHolder var5) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NO_DATA, GenericError;

    public abstract void GetDiagRecs(int[] var1, StringSeqHolder var2, LongSeqHolder var3, StringSeqHolder var4, LongSeqHolder var5) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NO_DATA, GenericError;

    public abstract void SetAttr(int var1, int var2, Any var3, IntHolder var4) throws TKTS_ERROR, TKTS_INVALID_HANDLE, GenericError;

    public abstract ORB getORBHandle();

    public static void createWarning(AbstractIOMWrapper iomWrapper, String[] args) {
        String ei = "Generic.unableToSetAttributeError.fmt";
        SQLWarning sqw = LocalizedErrorHandler.createLocalizedWarning("Generic.unableToSetAttributeError.fmt", args, null, iomWrapper, logger);
        iomWrapper.createWarning(sqw);
    }

    public static void createStringWarning(AbstractIOMWrapper iomWrapper, int aN, String aV, int status) {
        String[] args = new String[]{Integer.toString(aN), aV, TypesHelper.getTktsStatus(status)};
        AbstractIOMWrapper.createWarning(iomWrapper, args);
    }

    public static int setStringAttribute(AbstractIOMWrapper iomWrapper, int attributeNumber, String attributeValue, String debugText) throws SQLException {
        int result = 0;
        Any value = iomWrapper.getORBHandle().create_any();
        if (attributeValue == null) {
            attributeValue = "";
        }
        value.insert_string(attributeValue);
        result = AbstractIOMWrapper.setAttribute(iomWrapper, attributeNumber, attributeValue.length(), value);
        if (result != 0) {
            AbstractIOMWrapper.createStringWarning(iomWrapper, attributeNumber, attributeValue, result);
        }
        return result;
    }

    public static String getStringAttribute(AbstractIOMWrapper iomWrapper, int attributeNumber) throws SQLException {
        String method = "getStringAttribute(iomWrapper,attributeNumber)";
        Any value = AbstractIOMWrapper.getAttribute(iomWrapper, attributeNumber, 0);
        String outString = value.extract_string();
        if (AbstractLogger.isTrace) {
            logger.exit(method, "getStringAttribute=" + outString);
        }
        return outString;
    }

    public static void createIntegerWarning(AbstractIOMWrapper iomWrapper, int aN, int aV, int status) {
        String[] args = new String[]{Integer.toString(aN), Integer.toString(aV), TypesHelper.getTktsStatus(status)};
        AbstractIOMWrapper.createWarning(iomWrapper, args);
    }

    public static int setIntegerAttribute(AbstractIOMWrapper iomWrapper, int attributeNumber, int attributeValue, boolean addWarning) throws SQLException {
        Any value = iomWrapper.getORBHandle().create_any();
        value.insert_long(attributeValue);
        int result = AbstractIOMWrapper.setAttribute(iomWrapper, attributeNumber, -5, value);
        if (result != 0 && addWarning) {
            AbstractIOMWrapper.createIntegerWarning(iomWrapper, attributeNumber, attributeValue, result);
        }
        return result;
    }

    public static int setBigIntAttribute(AbstractIOMWrapper iomWrapper, int attributeNumber, int attributeValue) throws SQLException {
        Any value = iomWrapper.getORBHandle().create_any();
        value.insert_longlong((long)attributeValue);
        int result = AbstractIOMWrapper.setAttribute(iomWrapper, attributeNumber, -9, value);
        if (result != 0) {
            AbstractIOMWrapper.createIntegerWarning(iomWrapper, attributeNumber, attributeValue, result);
        }
        return result;
    }

    public static int getIntegerAttribute(AbstractIOMWrapper iomWrapper, int attributeNumber) throws SQLException {
        String method = "getIntegerAttribute(iomWrapper,attributeNumber)";
        Any value = AbstractIOMWrapper.getAttribute(iomWrapper, attributeNumber, -5);
        int outInt = value.extract_long();
        if (AbstractLogger.isTrace) {
            logger.exit(method, "getIntegerAttribute[" + outInt + "]");
        }
        return outInt;
    }

    public static long getBigIntAttribute(AbstractIOMWrapper iomWrapper, int attributeNumber) throws SQLException {
        String method = "getBigIntAttribute(iomWrapper,attributeNumber)";
        Any value = AbstractIOMWrapper.getAttribute(iomWrapper, attributeNumber, -9);
        long outLong = value.extract_longlong();
        if (AbstractLogger.isTrace) {
            logger.exit(method, "getBigIntAttribute[" + outLong + "]");
        }
        return outLong;
    }

    public static Any getAttribute(AbstractIOMWrapper iomWrapper, int attributeNumber, int indicator) throws SQLException {
        String method = "getAttribute(iomWrapper,attributeNumber,indicator)";
        AnyHolder value = new AnyHolder();
        IntHolder status = new IntHolder();
        try {
            iomWrapper.GetAttr(attributeNumber, indicator, value, status);
        }
        catch (Exception e) {
            LocalizedErrorHandler.handleExceptionsInFunction("getAttribute(iomWrapper,attributeNumber,indicator)", e, iomWrapper, logger);
        }
        if (status.value != 0) {
            SQLWarning sqw = LocalizedErrorHandler.createLocalizedWarning("unableToGetAttributeError.fmt", new String[]{"" + attributeNumber, "" + status.value}, null, iomWrapper, logger);
            iomWrapper.createWarning(sqw);
        }
        return value.value;
    }

    public static int setAttribute(AbstractIOMWrapper iomWrapper, int attributeNumber, int indicator, Any attributeValue) throws SQLException {
        String method = "setAttribute(iomWrapper,attributeNumber,indicator,attributeValue)";
        IntHolder status = new IntHolder();
        try {
            iomWrapper.SetAttr(attributeNumber, indicator, attributeValue, status);
        }
        catch (Exception e) {
            LocalizedErrorHandler.handleExceptionsInFunction(method, e, iomWrapper, logger);
        }
        if (AbstractLogger.isTrace) {
            logger.trace(method, " number=[" + attributeNumber + "] indicator=[" + indicator + "] attributeValue=[" + attributeValue + "] status[" + TypesHelper.getTktsStatus(status.value) + "]");
        }
        return status.value;
    }

    public static int getIntegerConnectionInformation(ConnectionWrapper wrapper, int attribute, int indicator, String callerMethod) throws SQLException {
        Any returnedValue = AbstractIOMWrapper.getServerConnectionInformation(wrapper, attribute, indicator, callerMethod);
        long out = returnedValue.extract_long();
        return (int)out;
    }

    public static String getStringConnectionInformation(ConnectionWrapper wrapper, int attribute, int indicator, String callerMethod) throws SQLException {
        Any returnedValue = AbstractIOMWrapper.getServerConnectionInformation(wrapper, attribute, indicator, callerMethod);
        String out = returnedValue.extract_string();
        return out;
    }

    public static Any getServerConnectionInformation(ConnectionWrapper wrapper, int attribute, int indicator, String callerMethod) throws SQLException {
        boolean error = false;
        boolean debugCI = false;
        Exception exception = null;
        AnySeqHolder returnedValues = new AnySeqHolder();
        LongSeqHolder status = new LongSeqHolder();
        try {
            wrapper.GetInformation(new int[]{attribute}, new int[]{indicator}, returnedValues, status);
            if (status.value.length > 0) {
                error = true;
            }
        }
        catch (Exception ex) {
            exception = ex;
            error = true;
            logger.error(ex);
        }
        if (error && AbstractLogger.isTrace) {
            logger.trace("ServerConnectionInformation exception:" + exception);
        }
        if (debugCI && !error) {
            String out;
            if (attribute == -1) {
                System.out.println("Debug");
            }
            switch (indicator) {
                case -6: 
                case -5: {
                    int outInt = returnedValues.value[0].extract_long();
                    out = String.format("ConnectionInfo: %6d => %10d", attribute, outInt);
                    break;
                }
                case -9: {
                    long outlong = (int)returnedValues.value[0].extract_longlong();
                    out = String.format("ConnectionInfo: %6d => %10d", attribute, (int)outlong);
                    break;
                }
                case -3: 
                case 0: {
                    String attrStr = returnedValues.value[0].extract_string();
                    out = String.format("ConnectionInfo: %6d => %s", attribute, attrStr);
                    break;
                }
                default: {
                    out = "ConnectionInfo indicator: " + indicator;
                }
            }
            System.out.println(out);
        }
        return returnedValues.value[0];
    }
}

