/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.info;

import com.sas.tkts.info.PackedParameterSetBufferPT0;
import com.sas.tkts.info.PackedParameterSetBufferPT1;
import com.sas.tkts.info.ParameterInfo;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.sql.LocalizedMessageHandler;
import com.sas.tkts.util.TimeRepresentation;
import com.sas.tkts.util.UtilityFunctions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;
import java.util.zip.Deflater;

public abstract class PackedParameterSetBuffer {
    public static final int parameter_type_null = 0;
    public static final int parameter_type_double = 1;
    public static final int parameter_type_float = 2;
    public static final int parameter_type_byte = 3;
    public static final int parameter_type_short = 4;
    public static final int parameter_type_integer = 5;
    public static final int parameter_type_long = 6;
    public static final int parameter_type_date = 7;
    public static final int parameter_type_time = 8;
    public static final int parameter_type_timestamp = 9;
    public static final int parameter_type_string_f = 10;
    public static final int parameter_type_string_v = 11;
    public static final int parameter_type_array_f = 12;
    public static final int parameter_type_array_v = 13;
    public static final int parameter_type_numeric = 14;
    public static final int parameter_type_big_dec = 15;
    public static final int parameter_type_string_l = 16;
    public static final int parameter_type_array_l = 17;
    public static final int parameter_type_unknown = 18;
    public static ParameterType PARAMETER_TYPE_NULL = new ParameterType("Null", 0);
    public static ParameterType PARAMETER_TYPE_DOUBLE = new ParameterType("Double", 1);
    public static ParameterType PARAMETER_TYPE_FLOAT = new ParameterType("Float", 2);
    public static ParameterType PARAMETER_TYPE_BYTE = new ParameterType("Byte", 3);
    public static ParameterType PARAMETER_TYPE_SHORT = new ParameterType("Short", 4);
    public static ParameterType PARAMETER_TYPE_INTEGER = new ParameterType("Integer", 5);
    public static ParameterType PARAMETER_TYPE_LONG = new ParameterType("Long", 6);
    public static ParameterType PARAMETER_TYPE_DATE = new ParameterType("Date", 7);
    public static ParameterType PARAMETER_TYPE_TIME = new ParameterType("Time", 8);
    public static ParameterType PARAMETER_TYPE_TIMESTAMP = new ParameterType("Timestamp", 9);
    public static ParameterType PARAMETER_TYPE_STRING_F = new ParameterType("StringFixed", 10);
    public static ParameterType PARAMETER_TYPE_STRING_V = new ParameterType("StringVarying", 11);
    public static ParameterType PARAMETER_TYPE_ARRAY_F = new ParameterType("ArrayFixed", 12);
    public static ParameterType PARAMETER_TYPE_ARRAY_V = new ParameterType("ArrayVarying", 13);
    public static ParameterType PARAMETER_TYPE_NUMERIC = new ParameterType("Numeric", 14);
    public static ParameterType PARAMETER_TYPE_BIG_DEC = new ParameterType("BigDecimal", 15);
    public static ParameterType PARAMETER_TYPE_STRING_L = new ParameterType("String(long)", 16);
    public static ParameterType PARAMETER_TYPE_ARRAY_L = new ParameterType("Array(long)", 17);
    public static ParameterType PARAMETER_TYPE_UNKNOWN = new ParameterType("Unknown", 18);
    protected static final transient int DEFAULT_CAPACITY = 123000;
    protected static transient Calendar calendar = null;
    protected static final transient int BUFFER_START_POSITION = 4;
    protected static String thisClassName = PackedParameterSetBuffer.class.getName();
    protected static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    protected transient ByteBuffer packedByteBuffer;
    protected transient boolean isCleanedUp = false;
    protected transient boolean isPackType1 = false;
    protected transient Vector<Integer> globalPackedBatchSizes;
    protected transient int offset = 4;
    protected final transient ByteOrder DEFAULT_BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    protected transient ByteOrder byteOrder;

    public static PackedParameterSetBuffer create(int packedBufferSize, boolean isPackType1) {
        PackedParameterSetBuffer out = packedBufferSize <= 0 ? (isPackType1 ? new PackedParameterSetBufferPT1() : new PackedParameterSetBufferPT0()) : (isPackType1 ? new PackedParameterSetBufferPT1(packedBufferSize) : new PackedParameterSetBufferPT0(packedBufferSize));
        return out;
    }

    public PackedParameterSetBuffer() {
        this.packedByteBuffer = ByteBuffer.allocate(123000);
        this.packedByteBuffer.order(this.DEFAULT_BYTE_ORDER);
        this.setCurrentPosition(4);
        this.setByteOrder(this.DEFAULT_BYTE_ORDER);
    }

    public PackedParameterSetBuffer(int capacity) {
        this.packedByteBuffer = ByteBuffer.allocate(capacity);
        this.packedByteBuffer.order(this.DEFAULT_BYTE_ORDER);
        this.setCurrentPosition(4);
        this.setByteOrder(this.DEFAULT_BYTE_ORDER);
    }

    public PackedParameterSetBuffer(int capacity, ByteOrder order) {
        this.packedByteBuffer = ByteBuffer.allocate(capacity);
        this.packedByteBuffer.order(order);
        this.setCurrentPosition(4);
        this.setByteOrder(order);
    }

    private void setByteOrder(ByteOrder order) {
        this.byteOrder = order;
    }

    private ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void checkCapacity(long bytesNeeded) {
        String method = "checkCapacity";
        int oldPosition = this.getCurrentPosition();
        int limit = this.getLimit();
        long bytesAvailableTillLimit = limit - oldPosition;
        long bytesAvailableTillCapacity = this.getCapacity() - oldPosition;
        if (bytesAvailableTillLimit - bytesNeeded < 0L) {
            if (bytesAvailableTillCapacity - bytesNeeded < 0L) {
                int newCapacity = this.getCapacity() * 2;
                if ((long)newCapacity < bytesNeeded) {
                    int inBN = (int)bytesNeeded;
                    newCapacity = inBN * 2;
                }
                ByteBuffer largerBuffer = ByteBuffer.allocate(newCapacity);
                largerBuffer.order(this.getByteOrder());
                largerBuffer.put(this.packedByteBuffer.array());
                this.packedByteBuffer = largerBuffer;
                this.setCurrentPosition(oldPosition);
                if (AbstractLogger.isTrace) {
                    logger.trace("checkCapacity", "No space left in the buffer. Allocated a larger buffer with capacity= [" + newCapacity + "] and currentPosition= [" + oldPosition + "].");
                }
            } else if (bytesAvailableTillLimit < bytesNeeded) {
                int newLimit = (int)(bytesNeeded - bytesAvailableTillLimit) + limit;
                this.setLimit(newLimit);
            }
        } else {
            this.setLimit(this.getCapacity());
        }
    }

    public void addBufferSize(int bufferSize) {
        this.packedByteBuffer.flip();
        this.packedByteBuffer.putInt(bufferSize);
    }

    public synchronized int calculateParamDataPackedBytesSize() {
        return this.getCurrentPosition();
    }

    public ByteBuffer getParamSetBuffer() {
        return this.packedByteBuffer;
    }

    public byte[] getParamSetByteArray() throws SQLException {
        ByteBuffer compactBuffer = null;
        if (this.packedByteBuffer != null) {
            if (this.packedByteBuffer.hasRemaining()) {
                compactBuffer = ByteBuffer.allocate(this.getLimit());
                if (this.getCurrentPosition() != 0) {
                    this.setCurrentPosition(0);
                }
                compactBuffer.put(this.packedByteBuffer.slice());
                this.resetPosition();
            } else {
                this.packedByteBuffer.flip();
                this.checkIsBackedUpByArray();
                return this.packedByteBuffer.array();
            }
        }
        this.checkIsBackedUpByArray(compactBuffer);
        return compactBuffer.array();
    }

    public byte[] getParamSetByteArray(int bufferSize) throws SQLException {
        ByteBuffer compactBuffer = null;
        if (bufferSize != 0) {
            compactBuffer = ByteBuffer.allocate(bufferSize);
            compactBuffer.order(this.getByteOrder());
            compactBuffer.put(this.packedByteBuffer.array(), 0, bufferSize);
        }
        this.checkIsBackedUpByArray(compactBuffer);
        return compactBuffer.array();
    }

    private void resetPosition() {
        this.setCurrentPosition(4);
    }

    private void checkIsBackedUpByArray() throws SQLException {
        if (!this.packedByteBuffer.hasArray()) {
            LocalizedErrorHandler.throwLocalizedException("PackedParameterSetBuffer.unableToConvertBufferToArray.txt", logger);
        }
    }

    private void checkIsBackedUpByArray(ByteBuffer buffer) throws SQLException {
        if (!buffer.hasArray()) {
            LocalizedErrorHandler.throwLocalizedException("PackedParameterSetBuffer.unableToConvertBufferToArray.txt", logger);
        }
    }

    public int getCapacity() {
        return this.packedByteBuffer.capacity();
    }

    public int getLimit() {
        return this.packedByteBuffer.limit();
    }

    private void setLimit(int newLimit) {
        this.packedByteBuffer.limit(newLimit);
    }

    public int getCurrentPosition() {
        return this.packedByteBuffer.position();
    }

    public void setCurrentPosition(int newPosition) {
        this.packedByteBuffer.position(newPosition);
    }

    public int getRemaining() {
        return this.packedByteBuffer.remaining();
    }

    public void cleanUpPackedBuffer() {
        if (this.packedByteBuffer != null) {
            this.packedByteBuffer.clear();
            this.setCurrentPosition(4);
        }
        this.offset = 4;
    }

    protected static byte[] removeTrailingZeros(byte[] original) {
        int i;
        byte[] bytes = null;
        int trailingZeros = 0;
        for (i = 0; i < original.length && original[i] == 0; ++i) {
            ++trailingZeros;
        }
        if (trailingZeros > 0) {
            bytes = new byte[original.length - trailingZeros];
            for (i = 0; i < bytes.length; ++i) {
                bytes[i] = original[trailingZeros++];
            }
            return bytes;
        }
        return original;
    }

    protected short resolveIndicatorSizeInBytes(long indicator) {
        int sizeInBytes = 0;
        sizeInBytes = indicator <= 127L ? 1 : (indicator <= 32767L ? 3 : (indicator <= Integer.MAX_VALUE ? 5 : 9));
        return (short)sizeInBytes;
    }

    protected int InsertNumericData(BigDecimal bigDecimal) {
        int NUMERIC_MAX_PRECISION = 38;
        MathContext MC_128 = new MathContext(38);
        BigDecimal rBigDecimal = bigDecimal;
        byte precision = (byte)bigDecimal.precision();
        if (precision > 38) {
            rBigDecimal = rBigDecimal.round(MC_128);
        }
        byte scale = (byte)rBigDecimal.scale();
        byte signum = (byte)rBigDecimal.signum();
        BigInteger unscaledBigInt = rBigDecimal.unscaledValue().abs();
        byte[] byteRepresentation = unscaledBigInt.toByteArray();
        byteRepresentation = PackedParameterSetBuffer.removeTrailingZeros(byteRepresentation);
        precision = (byte)unscaledBigInt.toString().length();
        int out = byteRepresentation.length + 3;
        this.packedByteBuffer.put((byte)out);
        this.packedByteBuffer.put(precision);
        this.packedByteBuffer.put(scale);
        this.packedByteBuffer.put(signum == -1 ? (byte)0 : 1);
        ++out;
        for (int pos = byteRepresentation.length - 1; pos >= 0; --pos) {
            this.packedByteBuffer.put(byteRepresentation[pos]);
        }
        return out;
    }

    protected void insertDateData(Date date) {
        calendar = PackedParameterSetBuffer.getCalendar();
        calendar.setTime(date);
        short year = (short)calendar.get(1);
        byte month = (byte)(calendar.get(2) + 1);
        byte day = (byte)calendar.get(5);
        this.packedByteBuffer.putShort(year);
        this.packedByteBuffer.put(month);
        this.packedByteBuffer.put(day);
    }

    protected void insertTimeData(Time time) {
        calendar = PackedParameterSetBuffer.getCalendar();
        calendar.setTimeInMillis(time.getTime());
        byte hour = (byte)calendar.get(11);
        byte minute = (byte)calendar.get(12);
        byte second = (byte)calendar.get(13);
        this.packedByteBuffer.put(hour);
        this.packedByteBuffer.put(minute);
        this.packedByteBuffer.put(second);
    }

    protected void insertTimestampData(Timestamp timeStamp) {
        calendar = PackedParameterSetBuffer.getCalendar();
        calendar.setTimeInMillis(timeStamp.getTime());
        short year = (short)calendar.get(1);
        byte month = (byte)(calendar.get(2) + 1);
        byte day = (byte)calendar.get(5);
        byte hour = (byte)calendar.get(11);
        byte minute = (byte)calendar.get(12);
        byte second = (byte)calendar.get(13);
        int fraction = timeStamp.getNanos();
        this.packedByteBuffer.putShort(year);
        this.packedByteBuffer.put(month);
        this.packedByteBuffer.put(day);
        this.packedByteBuffer.put(hour);
        this.packedByteBuffer.put(minute);
        this.packedByteBuffer.put(second);
        this.packedByteBuffer.putInt(fraction);
    }

    public static synchronized Calendar getCalendar() {
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        return calendar;
    }

    public abstract void addColumnNumbers(ParameterInfo[] var1);

    public abstract int packParameterValue(int var1, Object var2, Object var3);

    public byte[] buildPackedBuffer() throws SQLException {
        int bufferSize = this.calculateParamDataPackedBytesSize();
        this.addBufferSize(bufferSize);
        byte[] d = new byte[bufferSize];
        byte[] s = this.getParamSetByteArray();
        System.arraycopy(s, 0, d, 0, bufferSize);
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] buildCompressedBuffer(byte[] uncompressedData, boolean speed) throws SQLException {
        Deflater compresser = null;
        byte[] out = null;
        long startTime = System.nanoTime();
        int uncompressedDataLength = uncompressedData.length;
        try {
            compresser = speed ? new Deflater(1) : new Deflater(9);
            compresser.setInput(uncompressedData);
            compresser.finish();
            byte[] compressedData = new byte[uncompressedDataLength + 128];
            int compressedDataLength = compresser.deflate(compressedData);
            int bufferSize = compressedDataLength + 4;
            ByteBuffer pb = ByteBuffer.allocate(bufferSize);
            pb.order(ByteOrder.LITTLE_ENDIAN);
            pb.putInt(-bufferSize);
            pb.put(compressedData, 0, compressedDataLength);
            long delta = System.nanoTime() - startTime;
            if (AbstractLogger.isMeasurements) {
                LocalizedMessageHandler.logStatisticMessage("Compress.Deflater.txt", delta, logger);
            }
            out = pb.array();
        }
        catch (Exception e) {
            if (AbstractLogger.isError) {
                logger.error("buildCompressedBuffer: ");
                logger.error(e);
            }
        }
        finally {
            if (compresser != null) {
                compresser.end();
                compresser = null;
            }
        }
        return out;
    }

    public String toString() {
        String out = "";
        out = this.isCleanedUp ? out + "CleanUp:true" : out + "CleanUp:false";
        out = this.isPackType1 ? out + ";PackType:1" : out + ";PackType:0";
        if (this.packedByteBuffer != null) {
            int l;
            int capacity = this.packedByteBuffer.limit();
            byte[] a = this.packedByteBuffer.array();
            int p = this.packedByteBuffer.position();
            p = this.packedByteBuffer.position();
            int i = p - (l = 10);
            if (i < 0) {
                i = 0;
                l = p;
            }
            String b = UtilityFunctions.formatBytesHex(a, i, l);
            i = p;
            l = 10;
            if (i + l >= capacity) {
                l = capacity - p;
            }
            String c = UtilityFunctions.formatBytesHex(a, i, l);
            out = out + String.format("\nCapacity: %d Position: %d \nbefore  %s \ncurrent %s", capacity, p, b, c);
        } else {
            out = out + "\npackedByteBuffer is Null";
        }
        return out;
    }

    public static Object getParameterSetType(Object theValue, boolean isLong, boolean isVarying) {
        if (theValue == null) {
            return PARAMETER_TYPE_NULL;
        }
        if (theValue instanceof Number) {
            if (theValue instanceof Double) {
                return PARAMETER_TYPE_DOUBLE;
            }
            if (theValue instanceof Float) {
                return PARAMETER_TYPE_FLOAT;
            }
            if (theValue instanceof Byte) {
                return PARAMETER_TYPE_BYTE;
            }
            if (theValue instanceof Short) {
                return PARAMETER_TYPE_SHORT;
            }
            if (theValue instanceof Integer) {
                return PARAMETER_TYPE_INTEGER;
            }
            if (theValue instanceof Long) {
                return PARAMETER_TYPE_LONG;
            }
            if (theValue instanceof BigDecimal) {
                return PARAMETER_TYPE_BIG_DEC;
            }
        }
        if (theValue instanceof String) {
            if (isLong) {
                return PARAMETER_TYPE_STRING_L;
            }
            if (isVarying) {
                return PARAMETER_TYPE_STRING_V;
            }
            return PARAMETER_TYPE_STRING_F;
        }
        if (theValue instanceof byte[]) {
            if (isLong) {
                return PARAMETER_TYPE_ARRAY_L;
            }
            if (isVarying) {
                return PARAMETER_TYPE_ARRAY_V;
            }
            return PARAMETER_TYPE_ARRAY_F;
        }
        if (theValue instanceof TimeRepresentation) {
            Object dateTimeValue = ((TimeRepresentation)theValue).getRawDateTimeValue();
            if (dateTimeValue instanceof Date) {
                return PARAMETER_TYPE_DATE;
            }
            if (dateTimeValue instanceof Time) {
                return PARAMETER_TYPE_TIME;
            }
            if (dateTimeValue instanceof Timestamp) {
                return PARAMETER_TYPE_TIMESTAMP;
            }
        }
        return PARAMETER_TYPE_UNKNOWN;
    }

    public static class ParameterType {
        int index;
        String desc;

        public ParameterType(String s, int n) {
            String FMT = "%s(%d)";
            this.index = n;
            this.desc = String.format("%s(%d)", s, n);
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return this.desc;
        }
    }
}

