/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts;

import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.sql.LocalizedMessageHandler;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class FedSrvJDBC {
    protected static boolean debugConsole = false;
    private static long uniqueID;
    private static long debugCount;
    private static long debugUniqueID;
    protected static final String M_EXECUTE = "execute()";
    protected transient long myID = FedSrvJDBC.getNextID();

    public static boolean findStrings(String targetString, String[] searchStrings) {
        int numStrings = searchStrings.length;
        for (int si = 0; si < numStrings; ++si) {
            int index = targetString.indexOf(searchStrings[si]);
            if (index <= -1) continue;
            return true;
        }
        return false;
    }

    private static synchronized long getNextID() {
        long out;
        if (debugUniqueID == (out = ++uniqueID)) {
            ++debugCount;
        }
        return out;
    }

    protected static void staticThrowException(String ei, AbstractLogger logger) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException(ei, logger);
    }

    protected void throwException(String ei, AbstractLogger logger) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException(ei, logger);
    }

    protected void throwException(String ei, String[] args, AbstractLogger logger) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException(ei, args, logger);
    }

    protected void throwException(String messageKey, Exception theException, Object wrapperObject, AbstractLogger logger, Object ... args) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException(messageKey, args, theException, wrapperObject, logger);
    }

    public void throwException(String ei, AbstractLogger logger, String ... strings) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException(ei, strings, logger);
    }

    protected SQLWarning createAndLogWarning(String ei, String[] args, String sqlState, AbstractLogger logger) {
        String warningStr = LocalizedErrorHandler.getLocalizedError(ei, args);
        SQLWarning sw = new SQLWarning(warningStr, sqlState);
        if (logger != null && AbstractLogger.isWarn) {
            logger.warn(warningStr);
        }
        return sw;
    }

    protected String getLocalizedError(String messageKey, Object ... args) {
        String lem = LocalizedErrorHandler.getLocalizedError(messageKey, args);
        return lem;
    }

    protected void logInfoMessage(String method, String messageKey, AbstractLogger logger, Object ... args) {
        LocalizedMessageHandler.logInfoMessage(method, logger, messageKey, args);
    }

    public static void throwFunctionException(String m, Exception ex, Object wo, AbstractLogger l) throws SQLException {
        LocalizedErrorHandler.handleExceptionsInFunction(m, ex, wo, l);
    }

    public static SQLException createFunctionException(String m, Exception ex, Object wo, AbstractLogger l) throws SQLException {
        SQLException se = LocalizedErrorHandler.createExceptionsInFunction(m, ex, wo, l);
        return se;
    }

    protected static boolean isCharType(int sqlType) {
        boolean out = false;
        if (sqlType == 1 || sqlType == 12 || sqlType == -1) {
            out = true;
        }
        return out;
    }

    protected static boolean isNCharType(int sqlType) {
        boolean out = false;
        if (sqlType == -15 || sqlType == -9 || sqlType == -16) {
            out = true;
        }
        return out;
    }

    protected static boolean isBinaryType(int sqlType) {
        boolean out = false;
        if (sqlType == -2 || sqlType == -3 || sqlType == -4) {
            out = true;
        }
        return out;
    }

    protected static boolean isLongVar(int sqlType) {
        return sqlType == -1 || sqlType == -4;
    }

    protected boolean isVaryingLength(int sqlType) {
        boolean out = false;
        if (sqlType == 12 || sqlType == -3) {
            out = true;
        }
        return out;
    }

    protected static boolean isTimeout(Exception ex) {
        String tMsg = ex.getMessage();
        if (tMsg == null) {
            return false;
        }
        int index = tMsg.indexOf("Timeout expired");
        return index != -1;
    }

    public static void timeOutError(Exception ex, String messageFormat, Object ... args) {
        if (FedSrvJDBC.isTimeout(ex)) {
            String finalMessage = String.format(messageFormat, args);
            System.err.println(finalMessage);
            System.err.flush();
        }
    }

    protected FedSrvJDBC() {
    }

    public long getMyID() {
        return this.myID;
    }

    static {
        debugUniqueID = -1L;
    }
}

