/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.springframework.servlet;

import javax.servlet.ServletContextEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContextLoaderListener
extends org.springframework.web.context.ContextLoaderListener {
    private static final Logger LOGGER = LogManager.getLogger(ContextLoaderListener.class);
    public static final String CONTEXT_INITIALIZATION_ERRORS = "sas.svcs.contextInitializationErrors";
    public static final String CONTEXT_DESTRUCTION_ERRORS = "sas.svcs.contextDestructionErrors";

    public void contextDestroyed(ServletContextEvent event) {
        try {
            super.contextDestroyed(event);
        }
        catch (Throwable t) {
            LOGGER.warn("Caught an error during destruction. Information saved for future listeners.", t);
            if (null != event) {
                event.getServletContext().setAttribute(CONTEXT_DESTRUCTION_ERRORS, (Object)Boolean.TRUE);
            }
            this.handleThrowable(t);
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        try {
            super.contextInitialized(event);
        }
        catch (Throwable t) {
            LOGGER.warn("Caught an error during initialization. Information saved for future listeners.", t);
            if (null != event) {
                event.getServletContext().setAttribute(CONTEXT_INITIALIZATION_ERRORS, (Object)Boolean.TRUE);
            }
            this.handleThrowable(t);
        }
    }

    private void handleThrowable(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        LOGGER.error("Caught a non-runtime exception in listener startup. This shouldn't happen per the method contract.");
    }
}

