/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.springframework.context.event;

import com.sas.svcs.events.client.messages.InternalEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.AbstractApplicationEventMulticaster;
import org.springframework.core.ResolvableType;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;

public class ConfigurableApplicationEventMulticaster
extends AbstractApplicationEventMulticaster {
    private TaskExecutor synchronousExecutor = new SyncTaskExecutor();
    private TaskExecutor asynchronousExecutor = new SyncTaskExecutor();

    public void setSynchronousExecutor(TaskExecutor t) {
        this.synchronousExecutor = t;
    }

    public void setAsynchronousExecutor(TaskExecutor t) {
        this.asynchronousExecutor = t;
    }

    public void multicastEvent(ApplicationEvent event) {
        if (event instanceof InternalEvent && ((InternalEvent)event).requiresSynchronous()) {
            this.multicastSyncEvent(event);
        } else {
            this.multicastAsyncEvent(event);
        }
    }

    protected void multicastSyncEvent(ApplicationEvent event) {
        this.multicastEvent(event, this.synchronousExecutor);
    }

    protected void multicastAsyncEvent(ApplicationEvent event) {
        this.multicastEvent(event, this.asynchronousExecutor);
    }

    private void multicastEvent(final ApplicationEvent event, TaskExecutor executor) {
        for (final ApplicationListener listener : this.getApplicationListeners()) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.onApplicationEvent(event);
                }
            });
        }
    }

    public void multicastEvent(ApplicationEvent event, ResolvableType resolvableType) {
        if (event instanceof InternalEvent && ((InternalEvent)event).requiresSynchronous()) {
            this.multicastSyncEvent(event);
        } else {
            this.multicastAsyncEvent(event);
        }
    }
}

