/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.springframework.config.jmx;

import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.springframework.aop.support.AopUtils;
import org.springframework.jmx.export.annotation.AnnotationJmxAttributeSource;
import org.springframework.jmx.export.metadata.ManagedResource;
import org.springframework.jmx.export.naming.ObjectNamingStrategy;
import org.springframework.jmx.support.ObjectNameManager;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class NamingStrategy
implements ObjectNamingStrategy {
    public static final String DEFAULT_JMX_DOMAIN_NAME = "com.sas.svcs";
    public static final String SERVICE_KEY = "service";
    public static final String TYPE_KEY = "type";
    private final AnnotationJmxAttributeSource _attributeSource = new AnnotationJmxAttributeSource();

    public ObjectName getObjectName(Object managedBean, String beanKey) throws MalformedObjectNameException {
        Class managedClass = AopUtils.getTargetClass((Object)managedBean);
        ManagedResource mr = this._attributeSource.getManagedResource(managedClass);
        if (mr != null && StringUtils.hasText((String)mr.getObjectName())) {
            return ObjectNameManager.getInstance((String)mr.getObjectName());
        }
        try {
            return ObjectNameManager.getInstance((String)beanKey);
        }
        catch (MalformedObjectNameException ex) {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put(SERVICE_KEY, beanKey);
            properties.put(TYPE_KEY, ClassUtils.getShortName((Class)managedClass));
            return ObjectNameManager.getInstance((String)DEFAULT_JMX_DOMAIN_NAME, properties);
        }
    }
}

