/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.springframework.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class WebNamespaceHandler
extends NamespaceHandlerSupport {
    public void init() {
        this.registerBeanDefinitionParser("navigation-filter", (BeanDefinitionParser)new AbstractSimpleBeanDefinitionParser(){

            protected String getBeanClassName(Element element) {
                String value = element.getAttribute("use-referer-header");
                if (Boolean.parseBoolean(value)) {
                    return "com.sas.svcs.webapp.servlet.filters.ReferrerNavigationFilter";
                }
                return "com.sas.svcs.webapp.servlet.filters.NavigationFilter";
            }

            protected boolean isEligibleAttribute(String attributeName) {
                return super.isEligibleAttribute(attributeName) && !"use-referer-header".equals(attributeName);
            }
        });
        this.registerBeanDefinitionParser("security-filter", (BeanDefinitionParser)new SimpleBeanClassNameBeanDefinitionParser("com.sas.svcs.webapp.servlet.filters.SecurityFilter"));
        this.registerBeanDefinitionParser("platform-services-filter", (BeanDefinitionParser)new SimpleBeanClassNameBeanDefinitionParser("com.sas.svcs.webapp.servlet.filters.PlatformServicesFilter"));
        this.registerBeanDefinitionParser("authentication-filter", (BeanDefinitionParser)new SimpleBeanClassNameBeanDefinitionParser("com.sas.svcs.webapp.servlet.filters.AuthenticationFilter"));
        this.registerBeanDefinitionParser("theme-support-filter", (BeanDefinitionParser)new SimpleBeanClassNameBeanDefinitionParser("com.sas.svcs.webapp.servlet.filters.ThemeSupportFilter"));
        this.registerBeanDefinitionParser("locale-filter", (BeanDefinitionParser)new SimpleBeanClassNameBeanDefinitionParser("com.sas.svcs.webapp.servlet.filters.LocaleFilter"));
        this.registerBeanDefinitionParser("request-override-filter", (BeanDefinitionParser)new SimpleBeanClassNameBeanDefinitionParser("com.sas.svcs.webapp.servlet.filters.RequestOverrideFilter"));
        this.registerBeanDefinitionParser("local-platform-services-filter", (BeanDefinitionParser)new SimpleBeanClassNameBeanDefinitionParser("com.sas.svcs.webapp.servlet.filters.LocalPlatformServicesFilter"));
        this.registerBeanDefinitionParser("canonical-redirection-filter", (BeanDefinitionParser)new SimpleBeanClassNameBeanDefinitionParser("com.sas.svcs.webapp.servlet.filters.CanonicalRedirectionFilter"));
        this.registerBeanDefinitionParser("character-encoding-filter", (BeanDefinitionParser)new SimpleBeanClassNameBeanDefinitionParser("com.sas.framework.webapp.servlet.CharacterEncodingFilter"));
        this.registerBeanDefinitionParser("sanitizing-request-filter", (BeanDefinitionParser)new SimpleBeanClassNameBeanDefinitionParser("com.sas.framework.webapp.servlet.SanitizingRequestFilter"));
        this.registerBeanDefinitionParser("request-context-filter", (BeanDefinitionParser)new SimpleBeanClassNameBeanDefinitionParser("com.sas.framework.webapp.servlet.ContextFilter"));
        this.registerBeanDefinitionParser("director-servlet", (BeanDefinitionParser)new SimpleBeanClassNameBeanDefinitionParser("com.sas.svcs.webapp.servlet.http.DirectorServlet"));
        this.registerBeanDefinitionParser("return-servlet", (BeanDefinitionParser)new SimpleBeanClassNameBeanDefinitionParser("com.sas.svcs.webapp.servlet.http.ReturnServlet"));
        this.registerBeanDefinitionParser("logoff-servlet", (BeanDefinitionParser)new SimpleBeanClassNameBeanDefinitionParser("com.sas.svcs.webapp.servlet.http.LogoffServlet"));
        this.registerBeanDefinitionParser("preferences-servlet", (BeanDefinitionParser)new SimpleBeanClassNameBeanDefinitionParser("com.sas.svcs.webapp.servlet.http.PreferencesServlet"));
        this.registerBeanDefinitionParser("logging-change-servlet", (BeanDefinitionParser)new SimpleBeanClassNameBeanDefinitionParser("com.sas.svcs.webapp.servlet.http.LoggingAdminServlet"));
    }

    static class SimpleBeanClassNameBeanDefinitionParser
    extends AbstractSimpleBeanDefinitionParser {
        private final String klass;

        public SimpleBeanClassNameBeanDefinitionParser(String c) {
            this.klass = c;
        }

        protected String getBeanClassName(Element element) {
            return this.klass;
        }

        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            NamedNodeMap attributes = element.getAttributes();
            for (int x = 0; x < attributes.getLength(); ++x) {
                Attr attribute = (Attr)attributes.item(x);
                if (!this.isEligibleAttribute(attribute, parserContext)) continue;
                String attrName = attribute.getLocalName();
                boolean reference = false;
                if (attrName.endsWith("-ref")) {
                    attrName = attrName.substring(0, attrName.length() - 4);
                    reference = true;
                }
                String propertyName = this.extractPropertyName(attrName);
                Assert.state((boolean)StringUtils.hasText((String)propertyName), (String)"Illegal property name returned from 'extractPropertyName(String)': cannot be null or empty.");
                if (reference) {
                    builder.addPropertyReference(propertyName, attribute.getValue());
                    continue;
                }
                builder.addPropertyValue(propertyName, (Object)attribute.getValue());
            }
            this.postProcess(builder, element);
        }
    }
}

