/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.springframework.config;

import com.sas.svcs.cluster.httpinvoker.stateful.ServerRemoteInvocationStatefulServiceURIProcessor;
import com.sas.svcs.remoting.ServerRemoteInvocationApplicationProcessor;
import com.sas.svcs.remoting.ServerRemoteInvocationPublicUserProcessor;
import com.sas.svcs.remoting.ServerRemoteInvocationTargetApplicationProcessor;
import com.sas.svcs.remoting.ServerRemoteInvocationTenantProcessor;
import com.sas.svcs.remoting.arm.ServerRemoteInvocationArmProcessor;
import com.sas.svcs.remoting.aspects.ServerRemoteInvocationInterceptor;
import com.sas.svcs.remoting.security.ServerRemoteInvocationSASSecurityProcessor;
import com.sas.svcs.remoting.security.ServerRemoteInvocationSecurityProcessor;
import java.util.ArrayList;
import org.springframework.aop.config.AopNamespaceUtils;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ServerContextPropagationBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected Class<ServerRemoteInvocationInterceptor> getBeanClass(Element element) {
        return ServerRemoteInvocationInterceptor.class;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        AopNamespaceUtils.registerAspectJAnnotationAutoProxyCreatorIfNecessary((ParserContext)parserContext, (Element)element);
        boolean includeTarget = this.getBooleanAttribute(element, "include-target-processor");
        boolean includeArm = this.getBooleanAttribute(element, "include-arm-processor");
        String includeSecStr = element.getAttribute("include-security-processor");
        boolean includeSecurity = StringUtils.hasText((String)includeSecStr) ? Boolean.parseBoolean(includeSecStr) : true;
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(new ServerRemoteInvocationApplicationProcessor());
        l.add(new ServerRemoteInvocationStatefulServiceURIProcessor());
        l.add(new ServerRemoteInvocationTenantProcessor());
        l.add(new ServerRemoteInvocationPublicUserProcessor());
        if (includeSecurity) {
            l.add(new ServerRemoteInvocationSecurityProcessor());
            l.add(new ServerRemoteInvocationSASSecurityProcessor());
        }
        if (includeTarget) {
            l.add(new ServerRemoteInvocationTargetApplicationProcessor());
        }
        if (includeArm) {
            l.add(new ServerRemoteInvocationArmProcessor());
        }
        builder.addPropertyValue("preProcessors", l);
    }

    private boolean getBooleanAttribute(Element element, String name) {
        String string = element.getAttribute(name);
        return Boolean.parseBoolean(string);
    }
}

