/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.springframework.config;

import com.sas.svcs.springframework.config.PropertyAwareServletContextResource;
import java.util.Properties;
import org.springframework.core.io.Resource;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class PropertyAwareXmlWebApplicationContext
extends XmlWebApplicationContext {
    private static final String PROPERTIES_PARAMETER_NAME = "propertiesObjectName";
    private static final String DEFAULT_PROPERTIES_NAME = "environmentProperties";

    protected Resource getResourceByPath(String path) {
        String propertiesName = this.getServletContext().getInitParameter(PROPERTIES_PARAMETER_NAME);
        if (null == propertiesName || propertiesName.trim().length() == 0) {
            propertiesName = DEFAULT_PROPERTIES_NAME;
        }
        Properties properties = (Properties)this.getParent().getBean(propertiesName);
        return new PropertyAwareServletContextResource(this.getServletContext(), path, properties);
    }
}

