/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.springframework.config;

import com.sas.framework.commons.util.SystemProperty;
import com.sas.svcs.authentication.weblogic.ConnectionFactoryDecorator;
import com.sas.svcs.springframework.config.ApplicationServerIdentifier;
import com.sas.svcs.springframework.config.SasNamespaceUtils;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.jms.connection.UserCredentialsConnectionFactoryAdapter;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.springframework.jndi.JndiTemplate;
import org.w3c.dom.Element;

public class JmsConnectionFactoryBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final Logger LOGGER = LogManager.getLogger(JmsConnectionFactoryBeanDefinitionParser.class);
    private static final String JNDINAME_ATTRIBUTE = "jndiName";
    ApplicationServerIdentifier containerIdentifier = new ApplicationServerIdentifier();

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext context) {
        BeanDefinitionRegistry registry = context.getRegistry();
        return this.doParseInternal(element, registry);
    }

    protected AbstractBeanDefinition doParseInternal(Element element, BeanDefinitionRegistry registry) {
        String jndiName = element.getAttribute("jndi-name");
        boolean resourceRef = Boolean.parseBoolean(element.getAttribute("resource-ref"));
        String id = element.getAttribute("id");
        if (!SystemProperty.JMS_AUTHENTICATION_ENABLED.getBoolean() || this.containerIdentifier.isWebSphere()) {
            BeanDefinitionBuilder def = BeanDefinitionBuilder.rootBeanDefinition(JndiObjectFactoryBean.class);
            def.addPropertyValue("resourceRef", (Object)resourceRef);
            def.addPropertyValue(JNDINAME_ATTRIBUTE, (Object)jndiName);
            if (this.containerIdentifier.isWebSphere()) {
                def.addPropertyValue("proxyInterface", (Object)"javax.jms.ConnectionFactory");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Using basic definition... on WebSphere or jms authentication is not enabled.");
            }
            return def.getBeanDefinition();
        }
        SasNamespaceUtils.registerPasswordDecoderIfNecessary(registry);
        if (this.containerIdentifier.isJBoss()) {
            BeanDefinitionBuilder jndiDefinition = BeanDefinitionBuilder.rootBeanDefinition(JndiObjectFactoryBean.class);
            jndiDefinition.addPropertyValue("resourceRef", (Object)resourceRef);
            jndiDefinition.addPropertyValue(JNDINAME_ATTRIBUTE, (Object)jndiName);
            String jndiDefinitionId = "jboss.unsecureFactory." + id;
            registry.registerBeanDefinition(jndiDefinitionId, (BeanDefinition)jndiDefinition.getBeanDefinition());
            BeanDefinitionBuilder factoryDef = BeanDefinitionBuilder.rootBeanDefinition(UserCredentialsConnectionFactoryAdapter.class);
            factoryDef.addPropertyReference("targetConnectionFactory", jndiDefinitionId);
            factoryDef.addPropertyValue("username", (Object)"@{webappsrv.configure.jmssecurity.userid}");
            factoryDef.addPropertyValue("password", (Object)"@{webappsrv.configure.jmssecurity.passwd}");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Using jms authentication enabled jboss definition...");
            }
            return factoryDef.getBeanDefinition();
        }
        if (this.containerIdentifier.isVfabricTCSvr()) {
            BeanDefinitionBuilder jndiDefinition = BeanDefinitionBuilder.rootBeanDefinition(JndiObjectFactoryBean.class);
            jndiDefinition.addPropertyValue("resourceRef", (Object)resourceRef);
            jndiDefinition.addPropertyValue(JNDINAME_ATTRIBUTE, (Object)jndiName);
            String jndiDefinitionId = "vfabrictcsvr.unsecureFactory." + id;
            registry.registerBeanDefinition(jndiDefinitionId, (BeanDefinition)jndiDefinition.getBeanDefinition());
            BeanDefinitionBuilder factoryDef = BeanDefinitionBuilder.rootBeanDefinition(UserCredentialsConnectionFactoryAdapter.class);
            factoryDef.addPropertyReference("targetConnectionFactory", jndiDefinitionId);
            factoryDef.addPropertyValue("username", (Object)"@{webappsrv.configure.jmssecurity.userid}");
            factoryDef.addPropertyValue("password", (Object)"@{webappsrv.configure.jmssecurity.passwd}");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Using jms authentication enabled vfabrictcsvr definition...");
            }
            return factoryDef.getBeanDefinition();
        }
        if (this.containerIdentifier.isWebLogic()) {
            Properties props = new Properties();
            props.setProperty("java.naming.security.principal", "@{webappsrv.configure.jmssecurity.userid}");
            props.setProperty("java.naming.security.credentials", "@{webappsrv.configure.jmssecurity.passwd}");
            props.setProperty("java.naming.security.authentication", "simple");
            BeanDefinitionBuilder jndiTemplateDef = BeanDefinitionBuilder.rootBeanDefinition(JndiTemplate.class);
            jndiTemplateDef.addPropertyValue("environment", (Object)props);
            String jndiTemplateId = "weblogic.jndiTemplate." + id;
            registry.registerBeanDefinition(jndiTemplateId, (BeanDefinition)jndiTemplateDef.getBeanDefinition());
            BeanDefinitionBuilder decoratorDef = BeanDefinitionBuilder.rootBeanDefinition(ConnectionFactoryDecorator.class);
            decoratorDef.addPropertyReference("jndiTemplate", jndiTemplateId);
            decoratorDef.addPropertyValue(JNDINAME_ATTRIBUTE, (Object)(resourceRef ? "java:comp/env/" + jndiName : jndiName));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Using jms authentication enabled weblogic definition...");
            }
            return decoratorDef.getBeanDefinition();
        }
        return null;
    }
}

