/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.sql;

import MITI.messages.MIRModelBridge.BLIB;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqlFilterParser {
    String input = null;
    private List<FilterItem> filters = new ArrayList<FilterItem>();
    protected String delimiters = ",;";
    String regex = null;
    protected Pattern pattern = null;
    StringBuilder dbgTokens = null;

    public SqlFilterParser(String string) {
        this.input = string.trim();
        this.initRegex();
        this.filters = !this.input.equalsIgnoreCase("%") ? this.parse() : new ArrayList<FilterItem>();
    }

    private String getEscapeKey(String string) {
        String[] stringArray = new String[]{"~", "#", "@", ":", "_", "/", "`"};
        String string2 = null;
        for (int i = 1; i < stringArray.length; ++i) {
            for (int j = 1; j < stringArray.length; ++j) {
                String string3 = this.generateRandomString(stringArray, i);
                if (string.contains(string3)) continue;
                string2 = string3;
                break;
            }
            if (string2 != null) break;
        }
        if (string2 == null) {
            throw new IllegalStateException();
        }
        BLIB.DBG_DEBUG.log("Found unique key [" + string2 + "] for filter string '" + string + "'");
        return string2;
    }

    private String generateRandomString(String[] stringArray, int n) {
        if (n > stringArray.length) {
            throw new IllegalArgumentException();
        }
        int n2 = stringArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n3;
            do {
                n3 = 0;
                nArray[i] = (int)(Math.random() * (double)n2);
                if (nArray[i] > n2 - 1) {
                    nArray[i] = n2 - 1;
                }
                for (int j = 0; j <= i; ++j) {
                    if (nArray[j] != nArray[i]) continue;
                    ++n3;
                }
            } while (n3 > true);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int n4 : nArray) {
            stringBuilder.append(stringArray[n4]);
        }
        return stringBuilder.toString();
    }

    public SqlFilterParser(String string, boolean bl) {
        this.delimiters = string;
        this.initRegex();
    }

    protected void initRegex() {
        String string = this.delimiters.replaceFirst("\\.", "\\\\.");
        this.regex = String.format("('(?:[^']|'')+')|(?:([^\\s%s']+)\\.?)|([^\\s%s']+)\\s", string, string);
        this.pattern = Pattern.compile(this.regex, 2);
    }

    public List<String> splitFilterItems(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = this.pattern.matcher(string);
        while (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String string2 = matcher.group(i);
                if (string2 == null) continue;
                arrayList.add(string2);
            }
        }
        this.debugFilterParts(arrayList);
        return arrayList;
    }

    private void debugFilterParts(List<String> list) {
        this.dbgTokens = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i).trim();
            this.dbgTokens.append("[" + string + "]");
            if (i == list.size() - 1) continue;
            this.dbgTokens.append(", ");
        }
        if (this.dbgTokens.length() != 0) {
            BLIB.DBG_DEBUG.log("The Filter tokens: " + this.dbgTokens);
        }
    }

    public String getFilterPartsDebugText() {
        return this.dbgTokens == null ? "" : this.dbgTokens.toString();
    }

    protected List<FilterItem> parse() {
        ArrayList<FilterItem> arrayList = new ArrayList<FilterItem>();
        if (!this.input.isEmpty()) {
            List<String> list = this.splitFilterItems(this.input);
            BLIB.DBG_DEBUG.log("The Filter items:");
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                ArrayList<String> arrayList2 = new ArrayList<String>();
                String string = list.get(i);
                arrayList2.add(string);
                if ("NOT".equalsIgnoreCase(string)) {
                    if (i + 1 < list.size()) {
                        object = list.get(i + 1);
                        arrayList2.add((String)object);
                        if ("REGEXP_LIKE".equalsIgnoreCase((String)object) && ++i + 1 < list.size()) {
                            String string2 = list.get(i + 1);
                            arrayList2.add(string2);
                            ++i;
                        }
                    }
                } else if ("REGEXP_LIKE".equalsIgnoreCase(string) && i + 1 < list.size()) {
                    object = list.get(i + 1);
                    arrayList2.add((String)object);
                    ++i;
                }
                if ((object = this.createFilterItem(arrayList2)) != null) {
                    BLIB.DBG_DEBUG.log("\tOperator '" + (Object)((Object)((FilterItem)object).operator) + "' Condition [" + ((FilterItem)object).getCondition() + "] Items:" + arrayList2);
                    arrayList.add((FilterItem)object);
                    continue;
                }
                if (string.isEmpty()) continue;
                BLIB.DBG_DEBUG.log("\tCan't create a Filter from [" + string + "]");
            }
        }
        return arrayList;
    }

    protected boolean isQuoted(String string) {
        return string.startsWith("'") && string.endsWith("'");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected FilterItem createFilterItem(List<String> list) {
        FilterItem filterItem = null;
        int n = list.size();
        if (n <= 0) throw new IllegalArgumentException("Wrong filter structure [" + list + "]");
        if (n >= 4) throw new IllegalArgumentException("Wrong filter structure [" + list + "]");
        int n2 = n - 1;
        String string = list.get(n2);
        boolean bl = this.isQuoted(string);
        String string2 = this.replaceQuotes(string);
        if (n > 1 && ("REGEXP_LIKE".equalsIgnoreCase(list.get(0)) || "REGEXP_LIKE".equalsIgnoreCase(list.get(1)))) {
            return new FilterItem(n == 3 ? FilterOperatorType.NOT_REGEXP : FilterOperatorType.REGEXP, bl, string2);
        }
        boolean bl2 = false;
        String string3 = this.getEscapedPercentMarkPattern(string2);
        if (string3 != null) {
            if (string3.matches(".*[%].*")) {
                bl2 = true;
            }
            string2 = string2.replaceAll("%%", "%");
        } else if (string2.matches(".*[%].*")) {
            bl2 = true;
        }
        if (bl2) {
            if (list.size() <= 1) return new FilterItem(FilterOperatorType.LIKE, bl, string2);
            String string4 = list.get(0);
            if (!string4.equalsIgnoreCase("NOT")) throw new IllegalStateException("Wrong operator [" + string4 + "]");
            if (!list.get(1).equalsIgnoreCase(string)) throw new IllegalStateException("Wrong filter syntax [" + string4 + "]");
            return new FilterItem(FilterOperatorType.NOT_LIKE, bl, string2);
        }
        if (list.size() <= 2) return new FilterItem(list.size() > 1 ? FilterOperatorType.NOT_IN : FilterOperatorType.IN, bl, string2);
        throw new IllegalStateException("Wrong table or schema name structure [" + list + "]");
    }

    protected String replaceQuotes(String string) {
        return string.replaceFirst("^'", "").replaceFirst("'$", "");
    }

    private String getEscapedPercentMarkPattern(String string) {
        if (!string.matches(".*%%.*")) {
            return null;
        }
        String string2 = this.getEscapeKey(string);
        return string.replaceAll("%%", string2);
    }

    public List<FilterItem> getFilterNodes() {
        return this.filters;
    }

    public class FilterItem {
        private FilterOperatorType operator;
        private boolean quoted;
        private String condition;

        public FilterItem(FilterOperatorType filterOperatorType, boolean bl, String string) {
            this.operator = filterOperatorType;
            this.quoted = bl;
            this.condition = string;
        }

        public boolean equals(FilterOperatorType filterOperatorType) {
            return this.operator.equals((Object)filterOperatorType);
        }

        public String getCondition() {
            return this.condition;
        }

        public boolean isQuoted() {
            return this.quoted;
        }

        public FilterOperatorType getOperator() {
            return this.operator;
        }

        public String toString() {
            return String.format("%s:{%s}", new Object[]{this.operator, this.condition});
        }
    }

    public static enum FilterOperatorType {
        IN,
        NOT_IN,
        LIKE,
        NOT_LIKE,
        REGEXP,
        NOT_REGEXP;

    }
}

