/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.multithreading;

import MITI.MIRException;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.util.thread.SimpleTask;
import MITI.util.thread.SimpleThreadPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.RejectedExecutionException;
import java.util.stream.Collectors;

public abstract class TaskPlanner<T, U> {
    private boolean isDebug;
    private int submittedTaskCount;
    protected List<Task> taskContainer;
    private int numberThreads;
    private SimpleThreadPool threadPool;
    private ExecutorCompletionService<Boolean> taskService;
    protected int minProcessedTaskCount = 10;
    protected final Object syncObj = new Object();
    private boolean isInitialized = false;
    private int finishedTaskCount = 0;

    public TaskPlanner() {
        this(1);
    }

    public TaskPlanner(int n) {
        this(n, false);
    }

    public TaskPlanner(int n, boolean bl) {
        this.numberThreads = n;
        this.isDebug = bl;
    }

    public final synchronized void initialize() {
        if (!this.isInitialized) {
            if (this.numberThreads < 1) {
                this.numberThreads = Runtime.getRuntime().availableProcessors();
                BLIB.DBG_DEBUG.log("[INFO] The number of threads was set by default using method Runtime.availableProcessors(): " + this.numberThreads);
            }
            this.threadPool = new SimpleThreadPool("Task", this.numberThreads);
            this.taskService = new ExecutorCompletionService(this.threadPool);
            this.taskContainer = new LinkedList<Task>();
            this.isInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Collection<T> collection) throws MIRException, InterruptedException {
        if (collection == null || collection.isEmpty()) {
            throw new MIRException("Nothing to process.");
        }
        this.initialize();
        List<Task> list = this.syncObj;
        synchronized (list) {
            Collection<Task> collection2 = this.create(collection);
            for (Task task : collection2) {
                this.submit(task);
            }
        }
        list = null;
        while (this.taskContainer.size() > 0) {
            try {
                list = this.collect();
                if (list.isEmpty() || !this.canFinalize(Collections.unmodifiableList(list))) continue;
                this.finalize(list);
            }
            finally {
                if (list == null) continue;
                list.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Task> collect() throws MIRException, InterruptedException {
        ArrayList<Task> arrayList = this.syncObj;
        synchronized (arrayList) {
            if (this.taskContainer.isEmpty()) {
                throw new MIRException("Nothing to collect.");
            }
        }
        this.taskService.take();
        this.onWakeUp();
        arrayList = new ArrayList<Task>();
        Object object = this.syncObj;
        synchronized (object) {
            for (Task task : this.taskContainer) {
                if (!task.getStatus().equals((Object)Status.PROCESSED)) {
                    if (!this.isDebug) break;
                    BLIB.DBG_DEBUG.log("[DEBUG] " + task.toString() + " has blocked the collection of processed tasks. Index: " + this.taskContainer.indexOf(task));
                    break;
                }
                arrayList.add(task);
            }
        }
        return arrayList;
    }

    protected void onWakeUp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize(List<Task> list) throws MIRException {
        Object object = this.syncObj;
        synchronized (object) {
            for (Task task : list) {
                try {
                    task.finish();
                }
                finally {
                    task.changeStatus(Status.FINISHED);
                    ++this.finishedTaskCount;
                    this.taskContainer.remove(task);
                }
            }
            BLIB.DBG_DEBUG.log("[INFO]: Finished " + this.finishedTaskCount + "/" + this.submittedTaskCount);
        }
    }

    public void stop() {
        this.threadPool.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.taskContainer != null) {
                this.taskContainer.clear();
            }
            if (this.submittedTaskCount > 0) {
                this.submittedTaskCount = 0;
            }
            if (this.finishedTaskCount > 0) {
                this.finishedTaskCount = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T t) throws RejectedExecutionException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.taskContainer.isEmpty()) {
                throw new RejectedExecutionException("Task Planner has finished collecting tasks, you cannot add new tasks to the current work queue.");
            }
            Task task = this.create(t);
            if (task != null) {
                this.submit(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void submit(Task task) {
        Object object = this.syncObj;
        synchronized (object) {
            this.taskService.submit(task);
            this.taskContainer.add(task);
            ++this.submittedTaskCount;
            if (this.isDebug) {
                BLIB.DBG_DEBUG.log("[INFO]: " + task.toString() + " has been added to the task queue.");
            }
        }
    }

    protected void statusChanged(Task task) throws MIRException {
    }

    protected boolean canFinalize(List<Task> list) {
        int n = this.getTaskCount();
        return n > this.minProcessedTaskCount && list.size() > this.minProcessedTaskCount || n <= this.minProcessedTaskCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getTaskCount() {
        int n = 0;
        Object object = this.syncObj;
        synchronized (object) {
            n = this.taskContainer.size();
        }
        return n;
    }

    protected Collection<Task> create(Collection<T> collection) throws MIRException {
        return collection.stream().map(object -> this.create(object)).sorted().collect(Collectors.toList());
    }

    protected abstract Task create(T var1);

    public abstract class Task
    extends SimpleTask
    implements Comparable<Task> {
        private final String id;
        protected String name;
        private volatile Status status;
        private long changedStatusTime;
        protected final T input;
        protected U result;

        public Task(T t) {
            this(t, t.toString(), Integer.toHexString(t.hashCode()));
        }

        public Task(T t, String string, String string2) {
            this.id = string2;
            this.name = string;
            this.input = t;
            this.status = Status.WAITING;
            this.changedStatusTime = System.currentTimeMillis();
        }

        public final String getId() {
            return this.id;
        }

        public final Status getStatus() {
            return this.status;
        }

        public U getResult() {
            return this.result;
        }

        public T getInput() {
            return this.input;
        }

        protected long getChangedStatusTime() {
            return this.changedStatusTime;
        }

        @Override
        protected final Boolean internalCall() throws Exception {
            boolean bl = false;
            try {
                this.changeStatus(Status.PROCESSING);
                this.result = this.process();
                bl = true;
            }
            finally {
                this.changeStatus(Status.PROCESSED);
            }
            return bl;
        }

        private void changeStatus(Status status) throws MIRException {
            Status status2 = this.status;
            this.status = status;
            if (TaskPlanner.this.isDebug) {
                long l = System.currentTimeMillis();
                long l2 = (l - this.changedStatusTime) / 1000L;
                this.changedStatusTime = l;
                BLIB.DBG_DEBUG.log("[STATUS]: " + this.toString() + " status changed from " + (Object)((Object)status2) + " to " + (Object)((Object)this.status) + ". Time: " + l2 + " seconds.");
            }
            TaskPlanner.this.statusChanged(this);
        }

        protected abstract U process() throws MIRException;

        protected abstract void finish() throws MIRException;

        @Override
        public int compareTo(Task task) {
            return this.id.compareTo(task.id);
        }

        public String toString() {
            return "[Task (" + this.name + " : " + this.id + ")]";
        }
    }

    public static enum Status {
        WAITING,
        PROCESSING,
        PROCESSED,
        FINISHED;

    }
}

