/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.javabridgeinterface;

import MITI.util.text.BridgeEnumerationLiteral;
import MITI.util.text.BridgeOptionLiteral;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Parameter {
    private String name;
    private String displayName;
    private String description;
    private String defaultValue;
    private boolean mandatory;
    private boolean deprecated;
    private String[] fileExtensions;
    private OpenMode mode;
    private boolean transferable;
    private Type type;
    private Map<String, String> possibleValues;

    protected Parameter(BridgeOptionLiteral bridgeOptionLiteral, boolean bl, boolean bl2, String[] stringArray, OpenMode openMode, boolean bl3) {
        this.name = bridgeOptionLiteral.getParameterId();
        this.displayName = bridgeOptionLiteral.getText();
        this.description = bridgeOptionLiteral.getDescription();
        this.type = Type.valueOf(bridgeOptionLiteral.getType().name());
        this.defaultValue = bridgeOptionLiteral.getDefaultValue();
        if (this.type != Type.ENUMERATED && this.type != Type.BOOLEAN) {
            this.mandatory = bl;
        }
        this.deprecated = bl2;
        this.fileExtensions = stringArray;
        this.mode = openMode;
        this.transferable = bl3;
        if (bridgeOptionLiteral.getEnumeration() != null) {
            this.possibleValues = new LinkedHashMap<String, String>();
            for (BridgeEnumerationLiteral bridgeEnumerationLiteral : bridgeOptionLiteral.getEnumeration().getValues()) {
                this.possibleValues.put(bridgeEnumerationLiteral.getId(), bridgeEnumerationLiteral.getText());
            }
        }
    }

    public Parameter(String string, String string2, String string3, String string4, Type type, boolean bl, boolean bl2, String[] stringArray, OpenMode openMode, boolean bl3, Map<String, String> map) {
        this.name = string;
        this.displayName = string2;
        this.description = string3;
        this.defaultValue = string4;
        this.type = type;
        this.mandatory = bl;
        this.deprecated = bl2;
        this.fileExtensions = stringArray;
        this.mode = openMode;
        this.transferable = bl3;
        this.possibleValues = map;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Type getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isTransferable() {
        return this.transferable;
    }

    public OpenMode getOpenMode() {
        return this.mode;
    }

    public List<String> getFileExtensions() {
        if (this.fileExtensions != null) {
            return Arrays.asList(this.fileExtensions);
        }
        return Collections.emptyList();
    }

    public Map<String, String> getPossibleValues() {
        if (this.possibleValues != null) {
            return this.possibleValues;
        }
        return Collections.emptyMap();
    }

    public String getDisplayPossibleValue(String string) {
        if (this.possibleValues != null) {
            return this.possibleValues.getOrDefault(string, string);
        }
        return string;
    }

    public boolean isPossibleValue(String string) {
        if (string != null) {
            if (this.type == Type.ENUMERATED || this.type == Type.BOOLEAN) {
                if (this.possibleValues != null) {
                    return this.possibleValues.containsKey(string);
                }
                return false;
            }
            if (this.type == Type.FILE) {
                if (string.isEmpty()) {
                    return !this.mandatory;
                }
                List<String> list = this.getFileExtensions();
                if (!list.isEmpty()) {
                    for (String string2 : list) {
                        String string3 = "." + string2;
                        if (!string.toLowerCase().endsWith(string3.toLowerCase())) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }
            if (this.type == Type.DIRECTORY) {
                if (string.isEmpty()) {
                    return !this.mandatory;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public static enum OpenMode {
        DEFAULT,
        READ,
        WRITE,
        READWRITE;

    }

    public static enum Type {
        STRING,
        ENUMERATED,
        NUMERIC,
        BOOLEAN,
        PASSWORD,
        FILE,
        DIRECTORY,
        REPOSITORY_MODEL,
        REPOSITORY_SUBSET,
        DATE;

    }
}

