/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.javabridgeinterface;

import MITI.bridges.javabridgeinterface.MimbGenericOperationOptions;
import MITI.mimb.driver.operation.GenericOperationOption;
import MITI.util.Pair;
import MITI.util.StringUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MimbGenericKeyValueOptions
extends MimbGenericOperationOptions {
    private Map<String, String> values = new LinkedHashMap<String, String>();
    private String groupValueName;
    private List<Pair<String, String>> objIds = new LinkedList<Pair<String, String>>();
    private String name;

    public MimbGenericKeyValueOptions(String string) {
        this(string, "Values");
    }

    public MimbGenericKeyValueOptions(String string, String string2) {
        this.name = string;
        this.groupValueName = string2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addValue(String string, String string2) {
        if (string != null && string2 != null) {
            this.values.put(string, string2);
        }
    }

    public Map<String, String> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public String getGroupValueName() {
        return this.groupValueName;
    }

    public void addObjectId(String[] stringArray, String string) {
        this.objIds.add(new Pair<String, String>(StringUtil.join(stringArray, "\u2028"), string));
    }

    public List<Pair<String[], String>> getObjectIds() {
        return this.objIds.stream().map(pair -> new Pair((pair.obj1 != null ? ((String)pair.obj1).split("\u2028") : null), pair.obj2)).collect(Collectors.toList());
    }

    @Override
    public List<GenericOperationOption> getOptions() {
        LinkedList<GenericOperationOption> linkedList = new LinkedList<GenericOperationOption>();
        GenericOperationOption genericOperationOption = new GenericOperationOption(this.groupValueName);
        linkedList.add(genericOperationOption);
        for (Map.Entry<String, String> object : this.values.entrySet()) {
            genericOperationOption.addValue(object.getKey(), object.getValue());
        }
        for (Pair pair : this.objIds) {
            if (pair.obj1 == null && pair.obj2 == null) continue;
            genericOperationOption = new GenericOperationOption("Object");
            linkedList.add(genericOperationOption);
            if (pair.obj1 != null) {
                genericOperationOption.addValue("mimbObjectId", (String)pair.obj1);
            }
            if (pair.obj2 == null) continue;
            genericOperationOption.addValue("mmObjectId", (String)pair.obj2);
        }
        return linkedList;
    }

    @Override
    public void valueOf(List<GenericOperationOption> list) {
        for (GenericOperationOption genericOperationOption : list) {
            if ("Object".equals(genericOperationOption.getName())) {
                this.objIds.add(new Pair<String, String>(genericOperationOption.getValues().get("mimbObjectId"), genericOperationOption.getValues().get("mmObjectId")));
                continue;
            }
            this.groupValueName = genericOperationOption.getName();
            this.values.putAll(genericOperationOption.getValues());
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Name: ").append(this.name).append('\n');
        stringBuilder.append("Group name: ").append(this.groupValueName).append('\n');
        if (this.objIds != null) {
            stringBuilder.append("Objects (" + this.objIds.size() + "): ").append('\n');
            for (Pair object : this.objIds) {
                String[] stringArray = object.obj1 != null ? ((String)object.obj1).split("\u2028") : new String[]{};
                stringBuilder.append("     ").append("[" + StringUtil.join(stringArray, ",") + "]").append("(" + (String)object.obj2 + ")").append('\n');
            }
        }
        if (this.values != null) {
            stringBuilder.append("Values:").append('\n');
            for (Map.Entry<String, String> entry : this.values.entrySet()) {
                stringBuilder.append("     ").append(entry.getKey()).append(": ").append(entry.getValue()).append('\n');
            }
        }
        return stringBuilder.toString();
    }
}

