/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.javabridgeinterface;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.cache.MIMBCache;
import MITI.bridges.javabridge.JavaBridge;
import MITI.bridges.javabridgeinterface.BridgeEnvironment;
import MITI.bridges.javabridgeinterface.BridgeSpecification;
import MITI.bridges.javabridgeinterface.ClassPath;
import MITI.bridges.javabridgeinterface.MimbGenericOperationOptions;
import MITI.bridges.javabridgeinterface.MimbOption;
import MITI.bridges.javabridgeinterface.MimbOptions;
import MITI.bridges.javabridgeinterface.Parameter;
import MITI.bridges.mimb.MimbMessageLogOutputStream;
import MITI.bridges.mimb.MimbUtf8PrintStream;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.MIRModelBridge.JBDG;
import MITI.messages.MIRModelBridge.MBCM;
import MITI.mimb.message.XmlUtil;
import MITI.sdk.MIRMetadataOrigin;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.util.Encryption;
import MITI.util.Exec;
import MITI.util.MiscParams;
import MITI.util.ProcessBuilder;
import MITI.util.VersionNumber;
import MITI.util.config.MitiDebug;
import MITI.util.config.MitiLocale;
import MITI.util.file.FileUtil;
import MITI.util.file.PropertyFile;
import MITI.util.log.MIRLogger;
import MITI.util.os.MachineInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class JavaBridgeExec
extends Exec {
    public static final String JAVA_VERSION_7 = "1.7";
    public static final String JAVA_VERSION_8 = "1.8";
    private String bridgeClass;
    private Class<?> mainClass;
    private MIRLogger logger;
    private String javaExe;
    private String javaVersion;
    private ClassPath userClassPath;
    private String javaUserOptions = "";
    private List<String> javaProperties;
    private Map<String, String> userEnvironment;
    private static final String IMPORT_COMMAND = "Import";
    private static final String EXPORT_COMMAND = "Export";
    private static final String BROWSE_COMMAND = "Browse";
    private static final String TEST_COMMAND = "Test";
    public static final String IMPORT_GENERIC_OPERATION_COMMAND = "ImportGenericOperation";
    private BridgeEnvironment bridgeEnvironment;
    private String preScript = null;
    private String postScript = null;
    private static final String[] MIR_JARS = new String[]{"MIRUtil.jar", "MIR.jar", "MIRBridgeConstants.jar", "MIRExpressionLib.jar", "MIRModelBridge.jar", "MIRModelConverter.jar", "MIREtlBridgeLib.jar", "Mimb.jar", "MIRProfiler.jar", "MIRStatisticsUtil.jar", "Yaml/snakeyaml-2.0.jar"};
    private static final String[] MIR_OPTIONAL_JARS = new String[]{"Licensing.jar"};

    public JavaBridgeExec(MIRLogger mIRLogger, String string, ClassPath classPath, BridgeEnvironment bridgeEnvironment, String string2) throws MIRException {
        this.logger = mIRLogger;
        this.userClassPath = classPath;
        this.javaVersion = string2;
        this.bridgeClass = string;
        this.mainClass = JavaBridge.class;
        this.javaProperties = new ArrayList<String>();
        this.bridgeEnvironment = bridgeEnvironment;
    }

    public JavaBridgeExec(MIRLogger mIRLogger, String string, ClassPath classPath, BridgeEnvironment bridgeEnvironment) throws MIRException {
        this(mIRLogger, string, classPath, bridgeEnvironment, JAVA_VERSION_7);
    }

    public void javaImport(File file, MimbOptions mimbOptions, BridgeSpecification bridgeSpecification) throws MIRException {
        this.configureMiscellaneousOptions(mimbOptions);
        MIRMetadataOrigin mIRMetadataOrigin = this.generateMetadataOrigin(bridgeSpecification);
        this.execScript(this.preScript);
        this.exec(IMPORT_COMMAND, file, mimbOptions, this.bridgeEnvironment.getValidationLevel(), "", mIRMetadataOrigin, null);
        this.execScript(this.postScript);
    }

    public void javaExport(File file, MimbOptions mimbOptions) throws MIRException {
        this.configureMiscellaneousOptions(mimbOptions);
        this.execScript(this.preScript);
        this.exec(EXPORT_COMMAND, file, mimbOptions, MIRValidationLevel.NONE, "", null, null);
        this.execScript(this.postScript);
    }

    public void javaBrowse(File file, MimbOptions mimbOptions, BridgeSpecification bridgeSpecification, String string) throws MIRException {
        this.configureMiscellaneousOptions(mimbOptions);
        MIRMetadataOrigin mIRMetadataOrigin = this.generateMetadataOrigin(bridgeSpecification);
        this.exec(BROWSE_COMMAND, file, mimbOptions, MIRValidationLevel.BROWSE, string, mIRMetadataOrigin, null);
    }

    public void javaTest(MimbOptions mimbOptions) throws MIRException {
        this.configureMiscellaneousOptions(mimbOptions);
        this.exec(TEST_COMMAND, null, mimbOptions, MIRValidationLevel.NONE, "", null, null);
    }

    public void javaGenericOperation(MimbOptions mimbOptions, MimbGenericOperationOptions mimbGenericOperationOptions) throws MIRException {
        this.configureMiscellaneousOptions(mimbOptions);
        this.exec(IMPORT_GENERIC_OPERATION_COMMAND, null, mimbOptions, MIRValidationLevel.NONE, "", null, mimbGenericOperationOptions);
    }

    public void setJavaExe(String string) {
        this.javaExe = string;
    }

    public void setJavaUserOptions(String string) {
        this.javaUserOptions = string;
    }

    private void configureMiscellaneousOptions(MimbOptions mimbOptions) throws MIRException {
        String string = mimbOptions.getOptionValue("Miscellaneous", false);
        if (string != null) {
            this.configureMiscellaneousOptions(string);
        }
    }

    private void configureMiscellaneousOptions(String string) throws MIRException {
        String string2;
        String string3;
        String string4;
        MiscParams miscParams = MiscParams.parse(string);
        String string5 = miscParams.getValue("-java.memory");
        if (string5 != null && !string5.isEmpty()) {
            this.javaUserOptions = this.javaUserOptions + " -Xmx" + string5;
        }
        if ((string4 = miscParams.getValue("-java.parameters")) != null && !string4.isEmpty()) {
            this.javaUserOptions = this.javaUserOptions + " " + string4;
        }
        if ((string3 = miscParams.getValue("-prescript")) != null && !string3.isEmpty()) {
            this.preScript = string3;
        }
        if ((string2 = miscParams.getValue("-postscript")) != null && !string2.isEmpty()) {
            this.postScript = string2;
        }
        if (miscParams.contains("-java.executable")) {
            JBDG.DEPRECATED_MISC_PARAMETER.log("-java.executable");
        }
        if (miscParams.contains("-environment.variable")) {
            boolean bl = false;
            for (Map.Entry<String, String> entry : miscParams.getMappedValues("-environment.variable").entrySet()) {
                String string6 = entry.getKey().toUpperCase();
                if (string6.startsWith("INFA_") || string6.startsWith("MAPR_") || string6.equals("KRB5CCNAME")) {
                    this.setEnvironmentProperty(entry.getKey(), entry.getValue());
                    continue;
                }
                bl = true;
            }
            if (bl) {
                JBDG.DEPRECATED_MISC_PARAMETER.log("-environment.variable");
            }
        }
    }

    public void setEnvironmentProperty(String string, String string2) {
        if (this.userEnvironment == null) {
            this.userEnvironment = new HashMap<String, String>();
        }
        this.userEnvironment.put(string, string2);
    }

    public void addJavaProperty(String string, String string2) {
        this.addJavaProperty("-D" + string + "=" + string2);
    }

    private void addJavaProperty(String string) {
        this.javaProperties.add(string);
    }

    protected List<String> buildCommandLine(File file, File file2, MimbOptions mimbOptions, Map<String, String> map, boolean bl) throws MIRException {
        String string3;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = Exec.splitCommandLine(this.javaUserOptions + " " + this.bridgeEnvironment.getSetup().getJavaOptions());
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (string2.startsWith("-D")) {
                this.addJavaProperty(string2);
                continue;
            }
            if (string2.equals("--add-opens")) {
                Object object2 = object = iterator.hasNext() ? iterator.next() : "";
                if (!bl) continue;
                arrayList.add(string2);
                arrayList.add((String)object);
                continue;
            }
            arrayList.add(string2);
        }
        boolean bl2 = Exec.is64bits(new File(this.javaExe));
        JBDG.DETECTED_JVM_ARCHITECTURE.log(this.javaExe, bl2 ? "64" : "32");
        if (bl) {
            arrayList.add("-XX:+PrintClassHistogram");
            arrayList.add("-XX:OnOutOfMemoryError=" + (MachineInfo.isWindows() ? "JavaSignal.exe" : "kill -3") + " %p");
        }
        if (MitiDebug.getFlag(MitiDebug.Flag.JAVA_DEBUG_STOP)) {
            arrayList.add("-Xdebug");
            arrayList.add("-Xrunjdwp:transport=dt_socket,address=19988,server=y,suspend=y");
        }
        arrayList.add("-Dmimb.home=" + this.bridgeEnvironment.getHomeDirectory().getPath());
        arrayList.add("-Dmimb.data=" + this.bridgeEnvironment.getSetup().getDataDirectory().getPath());
        for (String string3 : this.javaProperties) {
            if (string3.equals("-Dnashorn.args=--no-deprecation-warning") && !bl) continue;
            arrayList.add(string3);
        }
        arrayList.add("-classpath");
        object = new ClassPath(this.bridgeEnvironment, this.logger, mimbOptions);
        ((ClassPath)object).addRelativePaths(this.bridgeEnvironment.getJavaDirectory(), MIR_JARS);
        if (!((ClassPath)object).isComplete()) {
            BLIB.SOME_JARS_NOT_FOUND.log(this.logger, new Object[0]);
        }
        ((ClassPath)object).addOptionalRelativePaths(this.bridgeEnvironment.getJavaDirectory(), MIR_OPTIONAL_JARS);
        ((ClassPath)object).appendClassPath(this.userClassPath);
        string3 = ((ClassPath)object).build();
        BLIB.DBG_DEBUG.log("Classpath: " + string3);
        arrayList.add(string3);
        String string4 = this.userClassPath.getLibraryPath();
        if (!string4.isEmpty()) {
            BLIB.DBG_DEBUG.log("Library path: " + string4);
            arrayList.add("-Djava.library.path=" + string4);
        }
        arrayList.add(this.mainClass.getName());
        arrayList.add("-r");
        arrayList.add(file.getPath());
        arrayList.add("-s");
        arrayList.add(file2.getPath());
        return arrayList;
    }

    protected File createXmlRequestFile(String string, File file, MimbOptions mimbOptions, MIRValidationLevel.Enum enum_, String string2, MIRMetadataOrigin mIRMetadataOrigin, MimbGenericOperationOptions mimbGenericOperationOptions) throws MIRException {
        Object object;
        Object object22;
        Element element = MITI.util.XmlUtil.parseString("<" + string + "/>");
        element.setAttribute("bridge", this.bridgeClass);
        if (mIRMetadataOrigin != null) {
            element.setAttribute("vendorName", mIRMetadataOrigin.getVendorName());
            element.setAttribute("toolName", mIRMetadataOrigin.getToolName());
            element.setAttribute("toolVersion", mIRMetadataOrigin.getToolVersion());
            element.setAttribute("formatVersion", mIRMetadataOrigin.getFormatVersion());
            element.setAttribute("bridgeName", mIRMetadataOrigin.getBridgeName());
            element.setAttribute("bridgeVersion", mIRMetadataOrigin.getBridgeVersion());
        }
        element.setAttribute("aliasId", this.bridgeClass);
        if (file != null) {
            element.setAttribute("file", file.getPath());
        }
        element.setAttribute("validationLevel", enum_.getName());
        if (string2 != null && !string2.isEmpty()) {
            element.setAttribute("browseParameter", string2);
        }
        String string3 = "0";
        if (MIMBCache.isResetXmiCache()) {
            string3 = MIMBCache.isResetNativeCache() ? "2" : "1";
        }
        element.setAttribute("resetCache", string3);
        element.setAttribute("javaVersion", this.javaVersion);
        for (Object object22 : mimbOptions) {
            Element element2 = MITI.util.XmlUtil.appendNewElement(element, "BridgeParameter");
            element2.setAttribute("name", ((MimbOption)object22).getName());
            if (((MimbOption)object22).getParameter().getType() == Parameter.Type.PASSWORD) {
                element2.setAttribute("encoded", "true");
                MITI.util.XmlUtil.setElementValue(element2, Encryption.encrypt(((MimbOption)object22).getValue()));
                continue;
            }
            MITI.util.XmlUtil.setElementValue(element2, ((MimbOption)object22).getValue());
        }
        if (mimbGenericOperationOptions != null) {
            object = MITI.util.XmlUtil.appendNewElement(element, "GenericOperation");
            object.setAttribute("name", mimbGenericOperationOptions.getName());
            object.setAttribute("path", mimbGenericOperationOptions.getOutputDir().getAbsolutePath());
            XmlUtil.addGenericOperationOptions((Element)object, mimbGenericOperationOptions.getOptions());
        }
        object = this.bridgeEnvironment.getSetup().getTempDirectory();
        object22 = MIRBridgeLib.makeTempFile((File)object, "MJBC", ".xml");
        FileUtil.writeContent((File)object22, MITI.util.XmlUtil.getString(element), FileUtil.UTF8);
        return object22;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exec(String string, File file, MimbOptions mimbOptions, MIRValidationLevel.Enum enum_, String string2, MIRMetadataOrigin mIRMetadataOrigin, MimbGenericOperationOptions mimbGenericOperationOptions) throws MIRException {
        File file2 = this.createXmlRequestFile(string, file, mimbOptions, enum_, string2, mIRMetadataOrigin, mimbGenericOperationOptions);
        try {
            Object object;
            Object object2;
            Object object3;
            File file3;
            MimbUtf8PrintStream mimbUtf8PrintStream = new MimbUtf8PrintStream(new MimbMessageLogOutputStream(this.logger));
            if (this.javaExe == null) {
                this.javaExe = this.bridgeEnvironment.getSetup().getJavaExecutable();
            }
            if (!(file3 = new File(this.javaExe)).exists()) {
                JBDG.WRN_FILE_NOT_FOUND.log(this.javaExe);
            }
            boolean bl = false;
            File file4 = new File(file3.getParentFile(), "../release");
            if (file4.exists()) {
                object3 = new PropertyFile(file4);
                object2 = ((PropertyFile)object3).getStringProperty("JAVA_VERSION").replace("\"", "");
                JBDG.DETECTED_JVM_VERSION.log(this.javaExe, object2);
                object = VersionNumber.parse((String)object2);
                bl = object != null ? ((VersionNumber)object).getMajor() >= 11 : ((String)object2).equals("11") || ((String)object2).startsWith("11.");
            }
            object3 = System.getenv();
            object2 = MIRBridgeLib.makeTempFile(this.bridgeEnvironment.getSetup().getTempDirectory(), "shutdown", ".pid");
            object = new ArrayList<String>();
            object.add(this.javaExe);
            object.addAll(this.buildCommandLine(file2, (File)object2, mimbOptions, (Map<String, String>)object3, bl));
            JBDG.JB_STARTING_JVM_PROCESS.log(this.logger, new Object[0]);
            File file5 = this.bridgeEnvironment.getSetup().getBinDirectory();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (bl) {
                hashMap.put("JDK_JAVA_OPTIONS", null);
            }
            hashMap.put("MIR_LOG_LEVEL", Integer.toString(this.logger.getLevel()));
            hashMap.put("MITI_OEM_CALLER_ID", this.bridgeEnvironment.getOemToken());
            hashMap.put("MIR_I18N_LANG", MitiLocale.getLang());
            MitiDebug.setFlags(hashMap);
            if (this.userEnvironment != null) {
                hashMap.putAll(this.userEnvironment);
            }
            int n = 0;
            try {
                ProcessBuilder processBuilder = new ProcessBuilder().setArguments(object.toArray(new String[object.size()])).setEnvironmentVariables(hashMap).setBaseDirectory(file5).setOutputStream(mimbUtf8PrintStream).redirectErrToOut(true).setCharset(FileUtil.UTF8).setShutdownFile((File)object2);
                n = processBuilder.exec();
            }
            catch (IOException iOException) {
                JBDG.JB_PLATFORM_ERROR.log(this.logger, iOException, "", iOException.getMessage());
                throw new MIRException(JBDG.JB_UNABLE_TO_START_JVM.getMessage(new Object[0]), iOException);
            }
            if (n == 143) {
                MBCM.ERR_MIMB_SIGTERM.log(this.logger, new Object[0]);
            } else if (n == 137) {
                MBCM.ERR_MIMB_OOM.log(this.logger, new Object[0]);
            } else if (n < -6 || n > 12) {
                MBCM.ERR_MIMB_EXE.log(this.logger, n);
            }
            if (n != 0) {
                throw new MIRException(JBDG.JB_IMPORT_BRIDGE_FAILED.getMessage(new Object[0]));
            }
        }
        finally {
            file2.delete();
        }
    }

    private File checkValidScript(File file, String string) {
        if (!FileUtil.isSubPath(file, string)) {
            MBCM.UNSUPPORTED_SCRIPT_PATH.log(this.logger, new Object[0]);
            return null;
        }
        File file2 = new File(file, string);
        if (!file2.exists()) {
            MBCM.SCRIPT_NOT_FOUND.log(this.logger, file2.getPath());
            return null;
        }
        if (string.toLowerCase().endsWith(".bat") || string.endsWith(".sh")) {
            return file2;
        }
        MBCM.UNSUPPORTED_SCRIPT_EXTENSION.log(this.logger, string);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execScript(String string) throws MIRException {
        if (string != null && !string.isEmpty()) {
            boolean bl;
            block15: {
                String string2;
                int n;
                File file = this.bridgeEnvironment.getSetup().getScriptDir();
                bl = true;
                File file2 = null;
                ProcessBuilder processBuilder = new ProcessBuilder();
                List<String> list = Exec.splitCommandLine(string);
                for (n = 0; n < list.size(); ++n) {
                    string2 = list.get(n);
                    if (n == 0) {
                        file2 = this.checkValidScript(file, string2);
                        if (file2 == null) {
                            bl = false;
                            break;
                        }
                        processBuilder.addArgument(file2.getPath());
                        continue;
                    }
                    processBuilder.addArgument(string2);
                }
                if (bl) {
                    MBCM.STARTING_SCRIPT.log(this.logger, file2.getPath());
                    try {
                        String[] stringArray;
                        n = processBuilder.exec();
                        string2 = processBuilder.getStdOut();
                        if (string2 != null) {
                            stringArray = string2.split("(\\\r)?\\\n");
                            int n2 = stringArray.length;
                            for (int i = 0; i < n2; ++i) {
                                String string3 = stringArray[i];
                                MBCM.SCRIPT_MESSAGE.log(this.logger, string3);
                            }
                        }
                        if ((stringArray = processBuilder.getStdErr()) != null && !stringArray.isEmpty()) {
                            for (String string4 : stringArray.split("(\\\r)?\\\n")) {
                                MBCM.SCRIPT_ERROR.log(this.logger, string4);
                            }
                        }
                        if (n == 0) {
                            bl = true;
                            break block15;
                        }
                        MBCM.SCRIPT_EXIT_CODE.log(this.logger, string, Integer.toString(n));
                        bl = false;
                    }
                    catch (IOException iOException) {
                        MBCM.SCRIPT_ERROR.log(this.logger, iOException, iOException.getMessage());
                        bl = false;
                    }
                }
            }
            if (!bl) {
                throw new MIRException(MBCM.SCRIPT_FAILED.getMessage(new Object[0]));
            }
        }
    }

    private MIRMetadataOrigin generateMetadataOrigin(BridgeSpecification bridgeSpecification) {
        MIRMetadataOrigin mIRMetadataOrigin = new MIRMetadataOrigin();
        mIRMetadataOrigin.setVendorName(bridgeSpecification.getProductCompany());
        mIRMetadataOrigin.setToolName(bridgeSpecification.getProductName());
        mIRMetadataOrigin.setToolVersion(bridgeSpecification.getProductVersion());
        mIRMetadataOrigin.setFormatVersion(bridgeSpecification.getProductVersion());
        mIRMetadataOrigin.setBridgeName(bridgeSpecification.getBridgeId());
        mIRMetadataOrigin.setBridgeVersion(bridgeSpecification.getBridgeVersion());
        return mIRMetadataOrigin;
    }
}

