/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.javabridgeinterface;

import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.bridgelib.SAXErrorHandler;
import MITI.bridges.javabridgeinterface.ClassPath;
import MITI.bridges.mimb.MIRSetup;
import MITI.util.XmlUtil;
import MITI.util.cmd.CommandLineOption;
import MITI.util.cmd.CommandLineParser;
import MITI.util.cmd.HelpOption;
import MITI.util.cmd.MandatoryOption;
import MITI.util.cmd.TypedOption;
import MITI.util.log.LogEvent;
import MITI.util.log.MIRLogger;
import MITI.util.log.XmlLogEventHandler;
import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EclipseLib {
    private static MIRLogger logger = MIRLogger.getLogger();
    private static HelpOption helpOption = new HelpOption();
    private static MandatoryOption requestXmlOption = new MandatoryOption(new String[]{"-r", "--requestXml"}, "", TypedOption.Type.FILE);
    private static CommandLineOption[] options = new CommandLineOption[]{helpOption, requestXmlOption};

    public boolean executeRequest(File file) {
        if (!file.exists() || file.isDirectory()) {
            throw new IllegalArgumentException("Request xml file is missing: " + file.getPath());
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new SAXErrorHandler(logger));
            Document document = documentBuilder.parse(file);
            Element element = document.getDocumentElement();
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = element.getAttribute("eclipsePlatformBasePath");
            boolean bl = element.getAttribute("usePlatformXml").equals("true");
            File file2 = new File(element.getAttribute("replyXmlFile"));
            ArrayList<Element> arrayList2 = XmlUtil.getChildElements(element, "Plugin");
            if (arrayList2 != null) {
                for (Element object2 : arrayList2) {
                    String bl2 = object2.getAttribute("id");
                    arrayList.add(bl2);
                }
            }
            MITI.bridges.eclipselib.EclipseLib eclipseLib = new MITI.bridges.eclipselib.EclipseLib();
            ClassPath classPath = new ClassPath(MIRSetup.getDefault(), logger);
            boolean bl2 = bl ? eclipseLib.computeEclipseClasspath(string, arrayList, classPath) : eclipseLib.computeEclipseClasspathFromPlugins(string, arrayList, classPath);
            String string2 = "<ClassPath success='" + (bl2 ? "true" : "false") + "'>" + classPath.toString() + "</ClassPath>";
            MIRBridgeLib.writeXmlFile(string2, file2);
            return bl2;
        }
        catch (Exception exception) {
            LogEvent logEvent = new LogEvent("Fatal error", 1, "");
            logEvent.setStackTrace(exception);
            logger.log(logEvent);
            return false;
        }
    }

    public static void main(String[] stringArray) {
        MIRLogger.init(new XmlLogEventHandler(System.err));
        try {
            CommandLineParser.process(stringArray, 0, options);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            System.exit(1);
        }
        EclipseLib eclipseLib = new EclipseLib();
        eclipseLib.executeRequest(requestXmlOption.getFileValue());
        System.exit(0);
    }
}

