/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.javabridgeinterface;

import MITI.bridges.javabridgeinterface.DataQualityObjectId;
import MITI.bridges.javabridgeinterface.MimbGenericOperationOptions;
import MITI.mimb.driver.operation.GenericOperationOption;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class DataQualityOptions
extends MimbGenericOperationOptions {
    public static final String NAME = "DataQuality";
    private static final String ATTR_ROW_LIMIT = "rowLimit";
    private static final String ATTR_ENABLED = "enabled";
    private static final String OPT_OPERATIONAL_METADATA = "OperationalMetadata";
    private static final String OPT_DATA_PROFILING = "DataProfiling";
    private static final String OPT_DATA_SAMPLING = "DataSampling";
    private static final String OPT_OBJECT = "Object";
    private boolean isDataSamplingEnabled;
    private long samplingRowLimit;
    private boolean isDataProfilingEnabled;
    private long profilingRowLimit;
    private boolean isOperationalMetadataEnabled;
    private List<DataQualityObjectId> objectIds = new ArrayList<DataQualityObjectId>();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void valueOf(List<GenericOperationOption> list) {
        for (GenericOperationOption genericOperationOption : list) {
            DataQualityObjectId dataQualityObjectId;
            if (OPT_DATA_PROFILING.equals(genericOperationOption.getName())) {
                this.isDataProfilingEnabled = DataQualityOptions.getBooleanValue(genericOperationOption.getValues().get(ATTR_ENABLED));
                this.profilingRowLimit = DataQualityOptions.getLongValue(genericOperationOption.getValues().get(ATTR_ROW_LIMIT));
                continue;
            }
            if (OPT_DATA_SAMPLING.equals(genericOperationOption.getName())) {
                this.isDataSamplingEnabled = DataQualityOptions.getBooleanValue(genericOperationOption.getValues().get(ATTR_ENABLED));
                this.samplingRowLimit = DataQualityOptions.getLongValue(genericOperationOption.getValues().get(ATTR_ROW_LIMIT));
                continue;
            }
            if (OPT_OPERATIONAL_METADATA.equals(genericOperationOption.getName())) {
                this.isOperationalMetadataEnabled = DataQualityOptions.getBooleanValue(genericOperationOption.getValues().get(ATTR_ENABLED));
                continue;
            }
            if (!OPT_OBJECT.equals(genericOperationOption.getName()) || (dataQualityObjectId = DataQualityObjectId.valueOf(genericOperationOption.getValues())) == null) continue;
            this.objectIds.add(dataQualityObjectId);
        }
    }

    @Override
    public List<GenericOperationOption> getOptions() {
        LinkedList<GenericOperationOption> linkedList = new LinkedList<GenericOperationOption>();
        GenericOperationOption genericOperationOption = new GenericOperationOption(OPT_DATA_SAMPLING);
        genericOperationOption.addValue(ATTR_ENABLED, DataQualityOptions.getStringValue(this.isDataSamplingEnabled));
        genericOperationOption.addValue(ATTR_ROW_LIMIT, Long.toString(this.samplingRowLimit));
        linkedList.add(genericOperationOption);
        genericOperationOption = new GenericOperationOption(OPT_DATA_PROFILING);
        genericOperationOption.addValue(ATTR_ENABLED, DataQualityOptions.getStringValue(this.isDataProfilingEnabled));
        genericOperationOption.addValue(ATTR_ROW_LIMIT, Long.toString(this.profilingRowLimit));
        linkedList.add(genericOperationOption);
        genericOperationOption = new GenericOperationOption(OPT_OPERATIONAL_METADATA);
        genericOperationOption.addValue(ATTR_ENABLED, DataQualityOptions.getStringValue(this.isOperationalMetadataEnabled));
        linkedList.add(genericOperationOption);
        for (DataQualityObjectId dataQualityObjectId : this.objectIds) {
            genericOperationOption = new GenericOperationOption(OPT_OBJECT);
            genericOperationOption.getValues().putAll(dataQualityObjectId.getOptionValues());
            linkedList.add(genericOperationOption);
        }
        return linkedList;
    }

    public boolean isDataProfilingEnabled() {
        return this.isDataProfilingEnabled;
    }

    public void setDataProfilingEnabled(boolean bl) {
        this.isDataProfilingEnabled = bl;
    }

    public long getProfilingRowLimit() {
        return this.profilingRowLimit;
    }

    public void setProfilingRowLimit(long l) {
        this.profilingRowLimit = l;
    }

    public boolean isDataSamplingEnabled() {
        return this.isDataSamplingEnabled;
    }

    public void setDataSamplingEnabled(boolean bl) {
        this.isDataSamplingEnabled = bl;
    }

    public long getSamplingRowLimit() {
        return this.samplingRowLimit;
    }

    public void setSamplingRowLimit(long l) {
        this.samplingRowLimit = l;
    }

    public boolean isOperationalMetadataEnabled() {
        return this.isOperationalMetadataEnabled;
    }

    public void setOperationalMetadataEnabled(boolean bl) {
        this.isOperationalMetadataEnabled = bl;
    }

    public List<DataQualityObjectId> getObjectIds() {
        return this.objectIds;
    }

    public void setObjectIds(List<DataQualityObjectId> list) {
        this.objectIds = list;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Operational metadata enabled: ").append(this.isOperationalMetadataEnabled).append('\n');
        stringBuilder.append("Data Sampling enabled: ").append(this.isDataSamplingEnabled).append('\n');
        if (this.isDataSamplingEnabled) {
            stringBuilder.append("Data Sampling rows: ").append(this.samplingRowLimit).append('\n');
        }
        stringBuilder.append("Data Profiling enabled: ").append(this.isDataProfilingEnabled).append('\n');
        if (this.isDataProfilingEnabled) {
            stringBuilder.append("Data Profiling rows: ").append(this.profilingRowLimit).append('\n');
        }
        stringBuilder.append("Data Profiling Objects (" + this.objectIds.size() + "): ").append('\n');
        for (DataQualityObjectId dataQualityObjectId : this.objectIds) {
            stringBuilder.append("     ").append(dataQualityObjectId.toString()).append('\n');
        }
        return stringBuilder.toString();
    }

    private static boolean getBooleanValue(String string) {
        return "true".equals(string);
    }

    private static long getLongValue(String string) {
        if (string != null && !string.isEmpty()) {
            try {
                return Long.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    private static String getStringValue(boolean bl) {
        return bl ? "true" : "false";
    }
}

