/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.glossary;

import MITI.MIRException;
import MITI.bridges.glossary.GlossaryConverterDefault;
import MITI.bridges.glossary.ICounter;
import MITI.bridges.glossary.IGlossaryConverter;
import MITI.bridges.glossary.SapEccGlossaryConverter;
import MITI.bridges.profiles.ProfileIds;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRGlossaryModel;
import MITI.sdk.MIRModel;
import java.util.Map;

public class GlossaryConverter
implements IGlossaryConverter {
    IGlossaryConverter _converter;
    ICounter counter;

    public void setCounter(ICounter iCounter) {
        this.counter = iCounter;
    }

    @Override
    public MIRGlossaryModel convert(MIRModel mIRModel) throws MIRException {
        if (mIRModel.getMetadataOrigin().getProfileId() == ProfileIds.SAP_ERP_CENTRAL_COMPONENT__SAP_ERP_CENTRAL_COMPONENT) {
            this._converter = new SapEccGlossaryConverter();
        } else {
            this._converter = new GlossaryConverterDefault();
            ((GlossaryConverterDefault)this._converter).setCounter(this.counter);
        }
        return this._converter.convert(mIRModel);
    }

    public Map<MIRElement, MIRElement> getCache() {
        if (this._converter instanceof GlossaryConverterDefault) {
            return ((GlossaryConverterDefault)this._converter).getObject2GlossaryMap();
        }
        return null;
    }

    public static class GlossaryDataTypeList {
        public static final String LOGICAL_BINARY = "Binary";
        public static final String LOGICAL_BOOLEAN = "Boolean";
        public static final String LOGICAL_DATE = "Date";
        public static final String LOGICAL_NUMBER = "Number";
        public static final String LOGICAL_STRING = "String";
    }
}

