/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.filefilter;

import MITI.bridges.filefilter.FilterPattern;
import java.util.LinkedList;

public class FileFilter {
    static final char FILTER_ESCAPE_SYMBOL = '\"';
    private static final char FILTER_SEPARATOR_SYMBOL = ' ';
    boolean negative;
    private FilterPattern[] patterns;

    private FileFilter(FilterPattern[] filterPatternArray, boolean bl) {
        this.patterns = filterPatternArray;
        this.negative = bl;
    }

    public boolean match(String string) {
        if (this.patterns == null || this.patterns.length == 0) {
            return true;
        }
        boolean bl = this.patterns[0].negation;
        for (FilterPattern filterPattern : this.patterns) {
            if (bl) {
                if (filterPattern.matches(string)) continue;
                return false;
            }
            if (!filterPattern.matches(string)) continue;
            return true;
        }
        return bl;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public static boolean isEmpty(FileFilter fileFilter) {
        return fileFilter == null || fileFilter.patterns == null;
    }

    public static FileFilter getInstance(String string) {
        String string2;
        if (string == null || string.isEmpty()) {
            return new FileFilter(null, false);
        }
        LinkedList<FilterPattern> linkedList = new LinkedList<FilterPattern>();
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                boolean bl2 = bl = !bl;
            }
            if (bl || c != ' ') continue;
            String object = string.substring(n, i).trim();
            if (!object.isEmpty() && !object.equals("-")) {
                linkedList.add(new FilterPattern(object));
            }
            n = i;
        }
        if (n < string.length() - 1 && !(string2 = string.substring(n, string.length()).trim()).isEmpty()) {
            linkedList.add(new FilterPattern(string2));
        }
        LinkedList<FilterPattern> linkedList2 = new LinkedList<FilterPattern>();
        for (FilterPattern filterPattern : linkedList) {
            if (!filterPattern.negation) continue;
            linkedList2.add(filterPattern);
        }
        if (linkedList2.size() > 0) {
            return new FileFilter(linkedList2.toArray(new FilterPattern[linkedList2.size()]), true);
        }
        return new FileFilter(linkedList.toArray(new FilterPattern[linkedList.size()]), false);
    }
}

