/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.filefilter;

import MITI.bridges.filefilter.FileFilter;
import java.io.File;
import java.util.ArrayList;

public abstract class DirectoryTraversal {
    private FileFilter directoryFilter;
    private FileFilter fileFilter;

    public DirectoryTraversal(FileFilter fileFilter, FileFilter fileFilter2) {
        if (fileFilter == null || fileFilter2 == null) {
            throw new IllegalArgumentException("Parameters directoryFilter and fileFilter cannot be set to null.");
        }
        this.directoryFilter = fileFilter;
        this.fileFilter = fileFilter2;
    }

    public void traverse(File file) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (file.listFiles() != null) {
            for (File file2 : file.listFiles()) {
                if (file2.isDirectory()) {
                    arrayList.add(file2);
                    continue;
                }
                if (!FileFilter.isEmpty(this.directoryFilter) && !this.directoryFilter.isNegative() || !this.fileFilter.match(file2.getName())) continue;
                this.processFile(file2);
            }
        }
        for (File file3 : arrayList) {
            int n = this.directoryFilter.match(file3.getName()) ? 1 : 0;
            if (n == 0 && this.directoryFilter.isNegative()) continue;
            this.traverseInternal(file3, "", n != 0);
        }
    }

    private void traverseInternal(File file, String string, boolean bl) {
        string = string.isEmpty() ? file.getName() : string + File.separator + file.getName();
        this.processDirectory(string);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (file.listFiles() != null) {
            for (File file2 : file.listFiles()) {
                if (file2.isDirectory()) {
                    arrayList.add(file2);
                    continue;
                }
                if (!bl || !this.fileFilter.match(file2.getName())) continue;
                this.processFile(file2);
            }
        }
        for (File file3 : arrayList) {
            int n = this.directoryFilter.match(file3.getName()) ? 1 : 0;
            if (n == 0 && this.directoryFilter.isNegative()) continue;
            this.traverseInternal(file3, string, bl || n != 0);
        }
    }

    protected abstract void processFile(File var1);

    protected abstract void processDirectory(String var1);
}

