/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.eclipselib;

import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.eclipselib.Plugin;
import MITI.bridges.eclipselib.PluginCollection;
import MITI.bridges.javabridgeinterface.ClassPath;
import MITI.messages.MIR.MIRSDK;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.MIRModelBridge.MBCM;
import MITI.util.XmlUtil;
import MITI.util.log.MIRLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class EclipseLib {
    private MIRLogger log = MIRLogger.getLogger();
    private List<String> requestedPlugins = new ArrayList<String>();
    private List<String> otherDependantPlugins = new ArrayList<String>();
    private PluginCollection availablePlugins = new PluginCollection();
    private Set<String> availablePluginFiles = new TreeSet<String>();
    private PluginCollection processedPlugins = new PluginCollection();
    private static final String MANIFEST_MF = "META-INF/MANIFEST.MF";
    private static final String PLUGIN_XML = "plugin.xml";
    private static final String BUNDLE_ID = "id";
    private static final String BUNDLE_RESOLUTION = "resolution";

    private Element parsePluginXml(InputStream inputStream, File file) {
        try {
            Document document = MIRBridgeLib.parseXmlStream(inputStream, this.log);
            Element element = document.getDocumentElement();
            if (element != null && element.getTagName().equals("plugin")) {
                return element;
            }
        }
        catch (IOException iOException) {
            BLIB.ERROR_PARSING_MANIFEST.log(this.log, iOException, PLUGIN_XML, file.getName());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            BLIB.ERROR_PARSING_MANIFEST.log(this.log, parserConfigurationException, PLUGIN_XML, file.getName());
        }
        catch (SAXException sAXException) {
            BLIB.ERROR_PARSING_MANIFEST.log(this.log, sAXException, PLUGIN_XML, file.getName());
        }
        return null;
    }

    private void analyzePluginXmlDependencies(Plugin plugin) {
        ArrayList<Element> arrayList;
        Element element;
        if (plugin.pluginXmlRoot != null && (element = XmlUtil.getFirstElement(plugin.pluginXmlRoot, "runtime")) != null && (arrayList = XmlUtil.getChildElements(element, "library")) != null) {
            for (Element element2 : arrayList) {
                String string = element2.getAttribute("name");
                if (string.isEmpty()) continue;
                plugin.jars.add(string);
            }
        }
    }

    private Plugin analyzePluginManifest(Manifest manifest, File file) {
        Object object;
        Attributes attributes = manifest.getMainAttributes();
        String string = this.getBundleSymbolicName(manifest);
        String string2 = this.getBundleVersion(manifest);
        Plugin plugin = null;
        if (EclipseLib.isEmpty(string)) {
            BLIB.MANIFEST_IS_MISSING_PROPERTY.log(this.log, MANIFEST_MF, file.getName(), "Bundle-SymbolicName");
            return null;
        }
        if (EclipseLib.isEmpty(string2)) {
            BLIB.MANIFEST_IS_MISSING_PROPERTY.log(this.log, MANIFEST_MF, file.getName(), "Bundle-Version");
            return null;
        }
        plugin = new Plugin(string, string2, file.isDirectory(), file.getPath());
        String string3 = attributes.getValue("Bundle-ClassPath");
        if (string3 != null) {
            for (Object object2 : object = string3.split(",")) {
                if (((String)object2).isEmpty()) continue;
                plugin.jars.add((String)object2);
            }
        }
        if ((object = attributes.getValue("Require-Bundle")) != null) {
            Object object2;
            int n = ((String)object).length();
            for (int i = 0; i < n; i += ((String)object2).length() + 1) {
                int n2 = this.findNextComma((String)object, i);
                object2 = n2 != -1 ? ((String)object).substring(i, n2) : ((String)object).substring(i);
                plugin.bundles.add((String)object2);
            }
        }
        return plugin;
    }

    private int findNextComma(String string, int n) {
        int n2 = 0;
        for (int i = n; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                ++n2;
                continue;
            }
            if (c != ',' || n2 % 2 != 0) continue;
            return i;
        }
        return -1;
    }

    private static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    private String getBundleSymbolicName(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        String string = attributes.getValue("Bundle-SymbolicName");
        if (string != null) {
            int n = string.indexOf(";");
            if (n != -1) {
                return string.substring(0, n);
            }
            return string;
        }
        return null;
    }

    private String getBundleVersion(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        String string = attributes.getValue("Bundle-Version");
        String string2 = attributes.getValue("Implementation-Version");
        if (!EclipseLib.isEmpty(string2) && !EclipseLib.isEmpty(string) && string2.startsWith(string)) {
            return string2;
        }
        if (!EclipseLib.isEmpty(string)) {
            return string;
        }
        return "0.0.0";
    }

    private Manifest getManifest(File file, JarFile jarFile) {
        Manifest manifest = null;
        if (file.isFile()) {
            if (jarFile != null) {
                try {
                    manifest = jarFile.getManifest();
                    if (manifest == null) {
                        BLIB.NO_MANIFEST.log(this.log, MANIFEST_MF, file.getName());
                    }
                }
                catch (IOException iOException) {
                    BLIB.NO_MANIFEST.log(this.log, iOException, MANIFEST_MF, file.getName());
                }
            }
        } else if (file.isDirectory()) {
            File file2 = new File(file, "META-INF");
            File file3 = new File(file2, "MANIFEST.MF");
            if (file3.exists()) {
                try {
                    manifest = new Manifest(new FileInputStream(file3));
                }
                catch (IOException iOException) {
                    BLIB.ERROR_PARSING_MANIFEST.log(this.log, iOException, MANIFEST_MF, file.getName());
                }
            } else {
                BLIB.NO_MANIFEST.log(this.log, MANIFEST_MF, file.getName());
            }
        }
        return manifest;
    }

    private InputStream getPluginXml(File file, JarFile jarFile, boolean bl) {
        InputStream inputStream = null;
        if (file.isFile()) {
            if (jarFile != null) {
                JarEntry jarEntry = jarFile.getJarEntry(PLUGIN_XML);
                if (jarEntry != null) {
                    try {
                        inputStream = jarFile.getInputStream(jarEntry);
                    }
                    catch (Exception exception) {
                        BLIB.ERROR_PARSING_MANIFEST.log(this.log, exception, PLUGIN_XML, file.getName());
                    }
                } else if (bl) {
                    BLIB.NO_MANIFEST.log(this.log, PLUGIN_XML, file.getName());
                }
            }
        } else if (file.isDirectory()) {
            File file2 = new File(file, PLUGIN_XML);
            if (file2.exists()) {
                try {
                    inputStream = new FileInputStream(file2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    BLIB.NO_MANIFEST.log(this.log, fileNotFoundException, PLUGIN_XML, file.getName());
                }
            } else if (bl) {
                BLIB.NO_MANIFEST.log(this.log, PLUGIN_XML, file.getName());
            }
        }
        return inputStream;
    }

    private Plugin analyzePlugin(File file) {
        Plugin plugin = null;
        if (file.isFile() || file.isDirectory()) {
            Manifest manifest;
            JarFile jarFile = null;
            if (file.isFile()) {
                try {
                    jarFile = new JarFile(file);
                }
                catch (IOException iOException) {
                    BLIB.DBG_DEBUG.log(this.log, iOException, "Error opening jar file " + file.getName());
                }
            }
            if ((manifest = this.getManifest(file, jarFile)) != null) {
                plugin = this.analyzePluginManifest(manifest, file);
            }
            Element element = null;
            boolean bl = plugin == null;
            InputStream inputStream = this.getPluginXml(file, jarFile, bl);
            if (inputStream != null) {
                element = this.parsePluginXml(inputStream, file);
            }
            if (plugin == null && element != null) {
                String string = element.getAttribute(BUNDLE_ID);
                String string2 = element.getAttribute("version");
                if (EclipseLib.isEmpty(string)) {
                    BLIB.MANIFEST_IS_MISSING_PROPERTY.log(this.log, PLUGIN_XML, file.getName(), BUNDLE_ID);
                } else if (EclipseLib.isEmpty(string2)) {
                    BLIB.MANIFEST_IS_MISSING_PROPERTY.log(this.log, PLUGIN_XML, file.getName(), "version");
                } else {
                    plugin = new Plugin(string, string2, file.isDirectory(), file.getPath());
                }
            }
            if (plugin != null) {
                plugin.pluginXmlRoot = element;
                this.analyzePluginXmlDependencies(plugin);
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {
                    BLIB.DBG_DEBUG.log(this.log, iOException, "Error closing jar file " + file.getName());
                }
            }
        } else {
            BLIB.DBG_DEBUG.log(this.log, "Not a valid file or directory: " + file.getName());
        }
        return plugin;
    }

    private void analyzeEclipseSite(Element element, String string) {
        String string2 = element.getAttribute("url");
        if (string2.startsWith("file:/") || string2.startsWith("file:\\")) {
            string2 = string2.substring(6);
        } else if (string2.startsWith("file:")) {
            string2 = string2.substring(5);
        } else if (string2 == "platform:/base/") {
            string2 = string;
        }
        File file = new File(string2);
        if (!file.isAbsolute()) {
            file = new File(string, string2);
        }
        File file2 = new File(file, "plugins");
        ArrayList<Element> arrayList = XmlUtil.getChildElements(element, "feature");
        if (arrayList != null) {
            for (Element element2 : arrayList) {
                String string3 = element2.getAttribute("url");
                File file3 = new File(file, string3);
                File file4 = new File(file3, "feature.xml");
                if (!file4.exists()) {
                    BLIB.WRN_FILE_NOT_FOUND.log(this.log, file3.getPath());
                    continue;
                }
                try {
                    ArrayList<Element> arrayList2;
                    Document document = MIRBridgeLib.parseXmlFile(file4, this.log);
                    Element element3 = document.getDocumentElement();
                    if (element3 == null || (arrayList2 = XmlUtil.getChildElements(element3, "plugin")) == null) continue;
                    for (Element element4 : arrayList2) {
                        boolean bl;
                        String string4;
                        String string5 = element4.getAttribute(BUNDLE_ID);
                        File file5 = this.getPluginFile(file2, string5, string4 = element4.getAttribute("version"), bl = !element4.getAttribute("unpack").equals("false"));
                        if (!file5.exists()) {
                            file5 = this.getPluginFile(file2, string5, string4, !bl);
                        }
                        if (file5.exists()) {
                            if (this.availablePluginFiles.contains(file5.getPath())) continue;
                            Plugin plugin = this.analyzePlugin(file5);
                            if (plugin != null) {
                                this.availablePlugins.addPlugin(plugin);
                            }
                            this.availablePluginFiles.add(file5.getPath());
                            continue;
                        }
                        BLIB.DBG_DEBUG.log(this.log, "Feature " + string3 + " refers to missing plugin " + file5.getName());
                    }
                }
                catch (IOException iOException) {
                    MBCM.ERR_CANNOT_READ_CONFIG_FILE.log(this.log, iOException, file4.getAbsolutePath(), iOException.getMessage());
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    MIRSDK.XML_PARSER_INIT.log(this.log, parserConfigurationException, parserConfigurationException.getMessage());
                }
                catch (SAXException sAXException) {
                    MBCM.ERR_CANNOT_PARSE_CONFIG_FILE.log(this.log, sAXException, file4.getAbsolutePath(), sAXException.getMessage());
                }
            }
        }
    }

    private File getPluginFile(File file, String string, String string2, boolean bl) {
        File file2 = bl ? (string2.isEmpty() ? new File(file, string) : new File(file, string + "_" + string2)) : (string2.isEmpty() ? new File(file, string + ".jar") : new File(file, string + "_" + string2 + ".jar"));
        return file2;
    }

    private void computeEclipsePluginClasspath(ClassPath classPath, Plugin plugin) {
        String string;
        if (!plugin.unpack) {
            classPath.addFiles(new File(plugin.path));
        } else {
            File file = new File(plugin.path);
            if (!file.exists()) {
                BLIB.WRN_FILE_NOT_FOUND.log(this.log, plugin.path);
                return;
            }
            for (int i = 0; i < plugin.jars.size(); ++i) {
                string = plugin.jars.get(i);
                classPath.addRelativePaths(file, string);
            }
        }
        for (int i = 0; i < plugin.bundles.size(); ++i) {
            String string2 = plugin.bundles.get(i);
            if (string2.isEmpty()) continue;
            string = this.getReferencedBundleProperty(string2, BUNDLE_ID);
            String string3 = this.getReferencedBundleProperty(string2, BUNDLE_RESOLUTION);
            if (string != null && string.equals("system.bundle") || string3 != null && string3.equals("optional")) continue;
            Plugin plugin2 = this.availablePlugins.findPlugin(string);
            if (plugin2 == null) {
                this.complainAboutDependantPlugin(string, plugin2);
                continue;
            }
            if (this.processedPlugins.findPlugin(string) != null || this.requestedPlugins.contains(string)) continue;
            this.complainAboutDependantPlugin(string, plugin2);
        }
    }

    private void complainAboutDependantPlugin(String string, Plugin plugin) {
        if (!this.otherDependantPlugins.contains(string)) {
            this.otherDependantPlugins.add(string);
            if (plugin == null) {
                BLIB.DBG_EXTRA_PLUGIN_NOT_FOUND.log(this.log, string);
            } else {
                BLIB.DBG_EXTRA_PLUGIN_MAYBE_NEEDED.log(this.log, string);
            }
        }
    }

    private String getReferencedBundleProperty(String string, String string2) {
        String string3 = "";
        String[] stringArray = string.split(";");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                if (string4 == null) continue;
                if (i == 0 && string2.equals(BUNDLE_ID)) {
                    string3 = string4;
                    break;
                }
                if (!string4.startsWith(string2 + ":=")) continue;
                string3 = string4.substring(string2.length() + 2);
                break;
            }
        }
        return string3;
    }

    private boolean computeClassPath(ClassPath classPath) {
        boolean bl = true;
        for (String string : this.requestedPlugins) {
            Plugin plugin = this.availablePlugins.findPlugin(string);
            if (plugin == null) {
                BLIB.MSG_PLUGIN_NOT_FOUND.log(this.log, string);
                bl = false;
                continue;
            }
            if (this.processedPlugins.findPlugin(string) != null) continue;
            BLIB.MSG_PLUGIN_FOUND.log(this.log, string);
            this.processedPlugins.addPlugin(plugin);
            this.computeEclipsePluginClasspath(classPath, plugin);
        }
        return bl;
    }

    public boolean computeEclipseClasspath(String string, List<String> list, ClassPath classPath) {
        File file = new File(string, "configuration/org.eclipse.update/platform.xml");
        if (!file.exists()) {
            BLIB.WRN_FILE_NOT_FOUND.log(this.log, file.getPath());
            return false;
        }
        this.requestedPlugins.addAll(list);
        boolean bl = false;
        try {
            Document document = MIRBridgeLib.parseXmlFile(file, this.log);
            Element element = document.getDocumentElement();
            if (element == null || !element.getTagName().equals("config")) {
                return false;
            }
            ArrayList<Element> arrayList = XmlUtil.getChildElements(element, "site");
            if (arrayList != null) {
                for (Element element2 : arrayList) {
                    boolean bl2 = !element2.getAttribute("enabled").equals("true");
                    String string2 = element2.getAttribute("policy");
                    if (bl2) continue;
                    if (string2.equals("USER-EXCLUDE")) {
                        this.analyzeEclipseSite(element2, string);
                        continue;
                    }
                    if (string2.equals("USER-INCLUDE")) {
                        this.analyzeEclipseSite(element2, string);
                        continue;
                    }
                    if (string2.equals("MANAGED-ONLY")) {
                        this.analyzeEclipseSite(element2, string);
                        continue;
                    }
                    this.analyzeEclipseSite(element2, string);
                }
            }
            bl = this.computeClassPath(classPath);
        }
        catch (IOException iOException) {
            MBCM.ERR_CANNOT_READ_CONFIG_FILE.log(this.log, iOException, file.getAbsolutePath(), iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            MIRSDK.XML_PARSER_INIT.log(this.log, parserConfigurationException, parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            MBCM.ERR_CANNOT_PARSE_CONFIG_FILE.log(this.log, sAXException, file.getAbsolutePath(), sAXException.getMessage());
        }
        return bl;
    }

    public boolean computeEclipseClasspathFromPlugins(String string, List<String> list, ClassPath classPath) {
        File[] fileArray;
        File file = new File(string);
        if (!file.exists()) {
            BLIB.WRN_FILE_NOT_FOUND.log(this.log, file.getPath());
            return false;
        }
        File file2 = new File(file, "plugins");
        if (!file2.exists()) {
            BLIB.WRN_FILE_NOT_FOUND.log(this.log, file2.getPath());
            return false;
        }
        BLIB.DBG_DEBUG.log(this.log, "Found plugins directory: " + file2.getPath());
        this.requestedPlugins.addAll(list);
        for (File file3 : fileArray = file2.listFiles()) {
            Plugin plugin = this.analyzePlugin(file3);
            if (plugin == null) continue;
            this.availablePlugins.addPlugin(plugin);
        }
        boolean bl = this.computeClassPath(classPath);
        return bl;
    }
}

