/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.dom;

import MITI.MIRException;
import MITI.bridges.bridgelib.SAXErrorHandler;
import MITI.bridges.dom.MIRDOMElement;
import MITI.messages.MIR.MIRSDK;
import MITI.util.log.MIRLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MIRDOM
extends DefaultHandler {
    private SAXParser saxParser = null;
    private MIRDOMElement root = null;
    private HashSet<String> ignoredTags = new HashSet(64);
    private Stack<MIRDOMElement> objectStack = new Stack();
    private int ignoreCounter = 0;
    private StringBuilder value = new StringBuilder();

    public MIRDOM(MIRLogger mIRLogger) throws MIRException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            this.saxParser = sAXParserFactory.newSAXParser();
            SAXErrorHandler sAXErrorHandler = new SAXErrorHandler(mIRLogger);
            this.saxParser.getXMLReader().setErrorHandler(sAXErrorHandler);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new MIRException(MIRSDK.XML_PARSER_INIT.getMessage(parserConfigurationException.getMessage()), parserConfigurationException);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() instanceof MIRException) {
                throw (MIRException)sAXException.getException();
            }
            throw new MIRException(sAXException);
        }
    }

    private void pushObject(MIRDOMElement mIRDOMElement) {
        this.objectStack.push(mIRDOMElement);
    }

    private MIRDOMElement getObject(int n) {
        if ((n += this.objectStack.size() - 1) < 0) {
            return null;
        }
        return (MIRDOMElement)this.objectStack.get(n);
    }

    private void popObject() {
        this.objectStack.pop();
    }

    public MIRDOMElement parseFile(File file) throws MIRException {
        try {
            this.saxParser.parse((InputStream)new FileInputStream(file), (DefaultHandler)this);
            this.clearInternalCollection();
            return this.root;
        }
        catch (SAXException sAXException) {
            throw new MIRException(sAXException.getMessage(), sAXException);
        }
        catch (IOException iOException) {
            throw new MIRException(iOException.getMessage(), iOException);
        }
    }

    public MIRDOMElement parseString(String string) throws MIRException {
        try {
            this.saxParser.parse(new InputSource(new StringReader(string)), (DefaultHandler)this);
            this.clearInternalCollection();
            return this.root;
        }
        catch (SAXException sAXException) {
            throw new MIRException(sAXException.getMessage(), sAXException);
        }
        catch (IOException iOException) {
            throw new MIRException(iOException.getMessage(), iOException);
        }
    }

    public MIRDOMElement parseStream(InputStream inputStream) throws MIRException {
        try {
            this.saxParser.parse(new InputSource(inputStream), (DefaultHandler)this);
            this.clearInternalCollection();
            return this.root;
        }
        catch (SAXException sAXException) {
            throw new MIRException(sAXException.getMessage(), sAXException);
        }
        catch (IOException iOException) {
            throw new MIRException(iOException.getMessage(), iOException);
        }
    }

    public void addIgnoredTag(String string) {
        this.ignoredTags.add(string);
    }

    public boolean isIgnoredTag(String string) {
        return this.ignoredTags.contains(string);
    }

    private void clearInternalCollection() {
        this.objectStack.clear();
    }

    private void setRoot(MIRDOMElement mIRDOMElement) {
        this.root = mIRDOMElement;
    }

    public MIRDOMElement getRoot() {
        return this.root;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.isIgnoredTag(string3)) {
            ++this.ignoreCounter;
        } else if (this.ignoreCounter == 0) {
            MIRDOMElement mIRDOMElement = this.getObject(0);
            MIRDOMElement mIRDOMElement2 = new MIRDOMElement(string3, mIRDOMElement);
            this.pushObject(mIRDOMElement2);
            if (mIRDOMElement == null) {
                this.setRoot(mIRDOMElement2);
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string4 = attributes.getQName(i);
                String string5 = attributes.getValue(i);
                mIRDOMElement2.setAttribute(string4, string5);
            }
            this.value.setLength(0);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.ignoreCounter == 0) {
            MIRDOMElement mIRDOMElement = this.getObject(0);
            String string = this.value.append(cArray, n, n2).toString();
            mIRDOMElement.setValue(mIRDOMElement.getValue().concat(string));
            this.value.setLength(0);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.isIgnoredTag(string3)) {
            --this.ignoreCounter;
        } else if (this.ignoreCounter == 0) {
            this.popObject();
            this.value.setLength(0);
        }
    }
}

