/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.dataquality;

import MITI.bridges.dataquality.DataQualityOptions;
import MITI.bridges.dataquality.MiscOptionHelper;
import MITI.bridges.sql.SqlFilterParser;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.util.MiscParams;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;

public class DataQualityBridgeOptions
extends DataQualityOptions {
    public SchemaFilter schemaFilter = new SchemaFilter();
    public DirectoryFilter dirFilter = new DirectoryFilter();
    private boolean isImportProfilngData;
    private boolean isImportRandomSamples;
    public static boolean isJUnitDebugMode = false;

    public boolean isProfileAllObjects() {
        return this.schemaFilter.isProfileAllObjects();
    }

    public void setMiscellaneous(String string) {
        String string2;
        MiscParams miscParams = MiscParams.parse(string);
        this.isImportProfilngData = DataQualityBridgeOptions.hasProfilingOptions(miscParams);
        if (!this.isImportProfilngData) {
            return;
        }
        String string3 = miscParams.getValue("-dpo");
        if (string3 != null) {
            if (string3.startsWith("\"") && string3.endsWith("\"")) {
                string3 = string3.replace("\"", "");
            }
            this.schemaFilter.parseDataQalityScope(string3);
            this.dirFilter.parseDataQalityScope(string3);
        } else {
            this.dirFilter.setProfileAllObjects();
            this.schemaFilter.setProfileAllObjects();
        }
        String string4 = miscParams.getValue("-dps");
        if (string4 == null) {
            BLIB.DBG_DEBUG.log("Profile records samples limit was not specified");
        } else if (string4.isEmpty()) {
            this.samplingRowCount = 10;
            BLIB.DBG_DEBUG.log(String.format("The '%s' was specified, but value is not provided. The value was set to default - %d.", "-dps", this.samplingRowCount));
        } else {
            this.samplingRowCount = MiscOptionHelper.getIntegerOptionValue(string4, "-dps");
        }
        String string5 = miscParams.getValue("-dp");
        if (string5 == null) {
            this.profilingRowCount = 1;
            this.profilingEnabled = string3 != null;
        } else {
            this.profilingEnabled = true;
            if (string5.isEmpty()) {
                BLIB.DBG_DEBUG.log(String.format("The '%s' was specified, but value is not provided. All tables and all rows will be profiled.", "-dp"));
            } else {
                this.profilingRowCount = MiscOptionHelper.getIntegerOptionValue(string5, "-dp");
            }
        }
        System.setProperty("miti.data.profiling", String.valueOf(this.profilingEnabled));
        if (this.samplingRowCount > this.profilingRowCount && this.profilingRowCount > 0) {
            BLIB.DBG_DEBUG.log(String.format("The profile records count was changed from %s to %d due to profiling samples records value.", this.profilingRowCount, this.samplingRowCount));
            this.profilingRowCount = this.samplingRowCount;
        }
        if ((string2 = miscParams.getValue("-dpv")) == null) {
            BLIB.DBG_DEBUG.log("Profile Volume limit was set to default");
            this.profilingVolumeLimit = 0;
        } else if (string2.isEmpty()) {
            BLIB.DBG_DEBUG.log(String.format("The '%s' was specified, but value is not provided. This option will be ignored.", "-dpv"));
        } else {
            this.profilingVolumeLimit = MiscOptionHelper.getIntegerOptionValue(string2, "-dpv");
        }
        String string6 = miscParams.getValue("-dpt");
        if (string6 == null) {
            BLIB.DBG_DEBUG.log("Profile time limit was set to default");
            this.profilingTimeLimit = 0;
        } else if (string6.isEmpty()) {
            BLIB.DBG_DEBUG.log(String.format("The '%s' was specified, but value is not provided. This option will be ignored.", "-dpt"));
        } else {
            this.profilingTimeLimit = MiscOptionHelper.getIntegerOptionValue(string6, "-dpt");
        }
        this.isImportRandomSamples = miscParams.contains("-samples.random");
    }

    public boolean isImportProfilngData() {
        return this.isImportProfilngData;
    }

    public static boolean hasProfilingOptions(String string) {
        MiscParams miscParams = MiscParams.parse(string);
        return DataQualityBridgeOptions.hasProfilingOptions(miscParams);
    }

    private static boolean hasProfilingOptions(MiscParams miscParams) {
        String string = miscParams.getValue("-dp");
        String string2 = miscParams.getValue("-dps");
        String string3 = miscParams.getValue("-dpo");
        return string3 != null && !string3.isEmpty() || string != null && !"0".equals(string) || string2 != null && !"0".equals(string2);
    }

    public String getProfileOptionsHash() {
        StringBuilder stringBuilder = new StringBuilder();
        Stream.concat(this.schemaFilter.schemes.stream(), this.dirFilter.schemes.stream()).forEach(schemaFilterData -> schemaFilterData.tables.forEach(table -> {
            stringBuilder.append(table.getTableName());
            table.getColumns().forEach(string -> stringBuilder.append((String)string));
        }));
        return String.format("%s:%d-%d", stringBuilder, this.profilingRowCount, this.samplingRowCount);
    }

    public String getProfiledTablesFilter() {
        StringBuilder stringBuilder = new StringBuilder();
        TreeSet treeSet = new TreeSet();
        Stream.concat(this.schemaFilter.schemes.stream(), this.dirFilter.schemes.stream()).forEach(schemaFilterData -> schemaFilterData.tables.forEach(table -> treeSet.add(this.quoteName(table.getTableName()) + ";")));
        treeSet.forEach(string -> stringBuilder.append((String)string));
        stringBuilder.setLength(stringBuilder.length() > 0 ? stringBuilder.length() - 1 : 0);
        return stringBuilder.toString();
    }

    public String getProfiledSchemasFilter() {
        StringBuilder stringBuilder = new StringBuilder();
        TreeSet treeSet = new TreeSet();
        Stream.concat(this.schemaFilter.schemes.stream(), this.dirFilter.schemes.stream()).forEach(schemaFilterData -> treeSet.add(this.quoteName(schemaFilterData.getName()) + ";"));
        treeSet.forEach(string -> stringBuilder.append((String)string));
        stringBuilder.setLength(stringBuilder.length() > 0 ? stringBuilder.length() - 1 : 0);
        return stringBuilder.toString();
    }

    String quoteName(String string) {
        String string2 = string.replace("'", "''");
        return "'" + string2 + "'";
    }

    public boolean isLoadRandomSamples() {
        return this.isImportRandomSamples;
    }

    public static class SchemaFilter {
        public final String ALL = "*";
        protected boolean isProfileAll = false;
        protected Set<SchemaFilterData> schemes = new LinkedHashSet<SchemaFilterData>();

        protected String getObjectsDelimiter() {
            return ".";
        }

        public void debug() {
            BLIB.DBG_DEBUG.log("-dpo filter settings:");
            for (SchemaFilterData schemaFilterData : this.schemes) {
                BLIB.DBG_DEBUG.log("Schema:" + schemaFilterData.getName());
                for (Table table : schemaFilterData.getTables()) {
                    BLIB.DBG_DEBUG.log("." + table.getTableName());
                    for (String string : table.getColumns()) {
                        BLIB.DBG_DEBUG.log(".." + string);
                    }
                }
                BLIB.DBG_DEBUG.log("------------------------");
            }
        }

        public boolean isFiltered(String string, String string2, String string3) {
            if (this.isProfileAll) {
                return false;
            }
            SchemaFilterData schemaFilterData = this.getSchemaByName(string);
            if (schemaFilterData == null) {
                return true;
            }
            Table table = schemaFilterData.getTableByName(string2);
            if (schemaFilterData.getTables().size() != 0 && table == null) {
                return true;
            }
            return string3 != null && table != null && table.getColumns().size() != 0 && !table.getColumns().contains(string3);
        }

        protected SchemaFilterData getSchemaFilter(Set<SchemaFilterData> set, String string) {
            SchemaFilterData schemaFilterData = this.getSchemaByName(string);
            if (schemaFilterData == null) {
                schemaFilterData = new SchemaFilterData(string);
                set.add(schemaFilterData);
            }
            return schemaFilterData;
        }

        protected SchemaFilterData getSchemaByName(String string) {
            SchemaFilterData schemaFilterData = null;
            for (SchemaFilterData schemaFilterData2 : this.schemes) {
                if (!schemaFilterData2.getName().equalsIgnoreCase(string)) continue;
                schemaFilterData = schemaFilterData2;
                break;
            }
            return schemaFilterData;
        }

        private void printDebugMessage(String string) {
            if (isJUnitDebugMode) {
                System.out.println(string);
            }
        }

        private void splitFullQualifiedNames(List<String> list, String string) {
            boolean bl;
            boolean bl2 = bl = string.startsWith("'") && string.endsWith("'");
            if (bl) {
                list.add(string);
            } else {
                String[] stringArray;
                for (String string2 : stringArray = string.replaceAll("^\\.|\\.$", "").split("\\.")) {
                    list.add(string2);
                }
            }
        }

        private List<List<String>> mergeIntoFullQuilifiedNamesParts(List<String> list) {
            if (isJUnitDebugMode) {
                System.out.println("Merging filer items into schemas/tables/features parts ...");
                list.forEach(string -> System.out.print("[" + string + "] "));
                System.out.println();
            }
            ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
            int n = list.size() - 1;
            for (int i = 0; i < list.size(); ++i) {
                ArrayList<String> arrayList2;
                List list2;
                String object = list.get(i);
                if (arrayList.size() == 0 && (".".equals(object) || object.startsWith("."))) {
                    throw new IllegalArgumentException("Profiling filter can't starts with '.'");
                }
                if (i == n && (".".equals(object) || object.endsWith("."))) {
                    throw new IllegalArgumentException("Profiling filter can't ends with '.'");
                }
                List list3 = list2 = arrayList.isEmpty() ? null : (List)arrayList.get(arrayList.size() - 1);
                if (".".equals(object)) {
                    list2.add(list.get(++i));
                    continue;
                }
                if (object.startsWith(".") && object.endsWith(".")) {
                    this.splitFullQualifiedNames(list2, object);
                    this.splitFullQualifiedNames(list2, list.get(++i));
                    continue;
                }
                if (object.startsWith(".")) {
                    this.splitFullQualifiedNames(list2, object);
                    continue;
                }
                if (object.endsWith(".")) {
                    arrayList2 = new ArrayList<String>();
                    this.splitFullQualifiedNames(arrayList2, object);
                    this.splitFullQualifiedNames(arrayList2, list.get(++i));
                    arrayList.add(arrayList2);
                    continue;
                }
                arrayList2 = new ArrayList();
                this.splitFullQualifiedNames(arrayList2, object);
                arrayList.add(arrayList2);
            }
            if (isJUnitDebugMode) {
                System.out.println("-------------------------------- full qulified names parts --------------------------------");
                for (List list4 : arrayList) {
                    list4.forEach(string -> System.out.print("[" + string + "] "));
                    System.out.println();
                }
                System.out.println("-------------------------------------------------------------------------------------------");
            }
            return arrayList;
        }

        protected boolean parseDataQalityScope(String string) {
            this.schemes = new LinkedHashSet<SchemaFilterData>();
            this.printDebugMessage("\nSplitting [" + string + "] ...");
            SqlFilterParser sqlFilterParser = new SqlFilterParser(",;", false);
            List<String> list = sqlFilterParser.splitFilterItems(string);
            List<List<String>> list2 = this.mergeIntoFullQuilifiedNamesParts(list);
            for (List<String> list3 : list2) {
                String string2 = null;
                SchemaFilterData schemaFilterData = null;
                if (list3.size() <= 0) continue;
                string2 = this.unquote(list3.get(0));
                schemaFilterData = this.getSchemaFilter(this.schemes, string2);
                Table table = null;
                if (schemaFilterData == null || list3.size() <= 1) continue;
                table = schemaFilterData.addTable(this.unquote(list3.get(1)));
                if (list3.size() <= 2) continue;
                String string3 = this.unquote(list3.get(2));
                table.addColumn(string3);
            }
            return true;
        }

        private String unquote(String string) {
            return string.trim().replaceFirst("^'", "").replaceFirst("'$", "").replace("''", "'");
        }

        public void setProfileAllObjects() {
            this.isProfileAll = true;
        }

        public boolean isProfileAllObjects() {
            return this.isProfileAll;
        }

        protected class SchemaFilterData {
            protected String name;
            private boolean isPartition = false;
            protected List<Table> tables = new ArrayList<Table>();

            public SchemaFilterData(String string) {
                this.name = string;
            }

            public String getName() {
                return this.name;
            }

            public List<Table> getTables() {
                return this.tables;
            }

            public Table addTable(String string) {
                Table table = this.getTableByName(string);
                if (table == null) {
                    table = new Table(string);
                    this.tables.add(table);
                }
                return table;
            }

            protected Table getTableByName(String string) {
                Table table = null;
                for (Table table2 : this.tables) {
                    if (!table2.getTableName().equalsIgnoreCase(string)) continue;
                    table = table2;
                    break;
                }
                return table;
            }

            public boolean isPartition() {
                return this.isPartition;
            }

            public void setIsPartition(boolean bl) {
                this.isPartition = bl;
            }
        }

        protected class Table {
            String tableName;
            Set<String> columns = new HashSet<String>();

            public Table(String string) {
                this.tableName = string;
            }

            public String getTableName() {
                return this.tableName;
            }

            public Set<String> getColumns() {
                return this.columns;
            }

            public void addColumn(String string) {
                this.columns.add(string);
            }
        }
    }

    public static class DirectoryFilter
    extends SchemaFilter {
        private String prepareDirName(String string) {
            string = string.replace("\\", "/").replace("file:/", "").trim();
            if ((string = string.replace("//", "/")).contains("/") && !string.endsWith("/")) {
                string = string + "/";
            }
            if (!string.contains(":") && !string.startsWith("/")) {
                string = "/" + string;
            }
            return string.toLowerCase();
        }

        @Override
        protected SchemaFilter.SchemaFilterData getSchemaFilter(Set<SchemaFilter.SchemaFilterData> set, String string) {
            SchemaFilter.SchemaFilterData schemaFilterData = this.getSchemaByName(this.prepareDirName(string));
            if (schemaFilterData == null) {
                schemaFilterData = new SchemaFilter.SchemaFilterData(this.prepareDirName(string));
                set.add(schemaFilterData);
            }
            return schemaFilterData;
        }

        protected SchemaFilter.SchemaFilterData getSchemaByNameStart(String string) {
            SchemaFilter.SchemaFilterData schemaFilterData = null;
            for (SchemaFilter.SchemaFilterData schemaFilterData2 : this.schemes) {
                if (!string.toLowerCase().startsWith(schemaFilterData2.getName().toLowerCase())) continue;
                schemaFilterData = schemaFilterData2;
                break;
            }
            return schemaFilterData;
        }

        protected SchemaFilter.SchemaFilterData getRelatedSchema(String string) {
            SchemaFilter.SchemaFilterData schemaFilterData = null;
            for (SchemaFilter.SchemaFilterData schemaFilterData2 : this.schemes) {
                if (!schemaFilterData2.getName().toLowerCase().startsWith(string.toLowerCase())) continue;
                schemaFilterData = schemaFilterData2;
                break;
            }
            return schemaFilterData;
        }

        public boolean isRelated(String string) {
            string = this.prepareDirName(string);
            if (this.isProfileAll) {
                return true;
            }
            SchemaFilter.SchemaFilterData schemaFilterData = this.getRelatedSchema(string);
            return schemaFilterData != null;
        }

        @Override
        public boolean isFiltered(String string, String string2, String string3) {
            string = this.prepareDirName(string);
            if (this.isProfileAll) {
                return false;
            }
            SchemaFilter.SchemaFilterData schemaFilterData = this.getSchemaByName(string);
            if (schemaFilterData == null && (schemaFilterData = this.getSchemaByNameStart(string)) == null) {
                return true;
            }
            if (schemaFilterData.isPartition) {
                return false;
            }
            SchemaFilter.Table table = schemaFilterData.getTableByName(string2);
            if (schemaFilterData.getTables().size() != 0 && table == null && string2 != null) {
                return true;
            }
            return string3 != null && table != null && table.getColumns().size() != 0 && !table.getColumns().contains(string3);
        }

        @Override
        protected boolean parseDataQalityScope(String string) {
            String[] stringArray = string.split("[,;]");
            int n = 0;
            for (String string2 : stringArray) {
                n = (string2 = string2.replace("\\", "/").replace("'", "").replace("\"", "").trim()).lastIndexOf("/");
                if (n <= 0) continue;
                String string3 = string2.substring(0, n);
                SchemaFilter.SchemaFilterData schemaFilterData = this.getSchemaFilter(this.schemes, string3);
                schemaFilterData.setIsPartition(string2.contains("PARTITONED_FILE_"));
                if (n >= string2.length() - 1) continue;
                String string4 = string2.substring(n + 1).trim();
                schemaFilterData.addTable(string4);
            }
            return true;
        }
    }
}

