/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib.session;

import MITI.bridges.bridgelib.session.Session;
import MITI.messages.MIRModelBridge.BLIB;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SessionPool<T extends Session> {
    private Set<T> allSessions = new HashSet<T>();
    private Set<T> freeSessions = new HashSet<T>();
    private Map<Thread, T> threadSessionMap = new HashMap<Thread, T>();

    public void addSession(T t) {
        this.allSessions.add(t);
        this.freeSessions.add(t);
    }

    public void CloseAll() {
        for (Session session : this.allSessions) {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getSession() {
        Thread thread = Thread.currentThread();
        Map<Thread, T> map = this.threadSessionMap;
        synchronized (map) {
            Session session = (Session)this.threadSessionMap.get(thread);
            if (session == null) {
                if (!this.freeSessions.isEmpty()) {
                    session = (Session)this.freeSessions.iterator().next();
                    this.freeSessions.remove(session);
                    this.threadSessionMap.put(thread, session);
                } else {
                    BLIB.DBG_DEBUG.log("We ran out of sessions!");
                }
            }
            return (T)session;
        }
    }

    public void unbindSessions() {
        this.freeSessions.addAll(this.allSessions);
        this.threadSessionMap.clear();
    }
}

