/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib.parsers;

import MITI.messages.MIRModelBridge.BLIB;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JDBCUrlParser {
    protected static final String AS400_JDBC_URL_PREFIX = "jdbc:as400";
    protected static final String AWSATHENA_JDBC_URL_PREFIX = "jdbc:awsathena";
    protected static final String BIGQUERY_JDBC_URL_PREFIX = "jdbc:bigquery";
    protected static final String CASSANDRA_JDBC_URL_PREFIX = "jdbc:cassandra";
    protected static final String DB2_JDBC_URL_PREFIX = "jdbc:db2";
    protected static final String DENODO_JDBC_URL_PREFIX = "jdbc:denodo";
    protected static final String DERBY_JDBC_URL_PREFIX = "jdbc:derby";
    protected static final String ES_JDBC_URL_PREFIX = "jdbc:es";
    protected static final String HIVE2_JDBC_URL_PREFIX = "jdbc:hive2";
    protected static final String IMPALA_JDBC_URL_PREFIX = "jdbc:impala";
    protected static final String INFORMIX_JDBC_URL_PREFIX = "jdbc:informix-sqli";
    protected static final String MARIADB_JDBC_URL_PREFIX = "jdbc:mariadb";
    protected static final String MYSQL_JDBC_URL_PREFIX = "jdbc:mysql";
    protected static final String NETEZZA_JDBC_URL_PREFIX = "jdbc:netezza";
    protected static final String ORACLE_OCI_JDBC_URL_PREFIX = "jdbc:oracle:oci:";
    protected static final String ORACLE_THIN_JDBC_URL_PREFIX = "jdbc:oracle:thin:";
    protected static final String GREENPLUM_JDBC_URL_PREFIX = "jdbc:pivotal:greenplum";
    protected static final String POSTGRESQL_JDBC_URL_PREFIX = "jdbc:postgresql";
    protected static final String PRESTO_JDBC_URL_PREFIX = "jdbc:presto";
    protected static final String REDSHIFT_JDBC_URL_PREFIX = "jdbc:redshift";
    protected static final String SAP_JDBC_URL_PREFIX = "jdbc:sap";
    protected static final String SNOWFLAKE_JDBC_URL_PREFIX = "jdbc:snowflake";
    protected static final String SPARK_JDBC_URL_PREFIX = "jdbc:spark";
    protected static final String SQLSERVER_JDBC_URL_PREFIX = "jdbc:sqlserver";
    protected static final String SQLSERVER_JTDS_JDBC_URL_PREFIX = "jdbc:jtds:sqlserver";
    protected static final String SQLSERVER_MICROSOFT_JDBC_URL_PREFIX = "jdbc:microsoft:sqlserver";
    protected static final String SYBASE_JTDS_JDBC_URL_PREFIX = "jdbc:jtds:sybase";
    protected static final String SYBASE_TDS_JDBC_URL_PREFIX = "jdbc:sybase:tds:";
    protected static final String TERADATA_JDBC_URL_PREFIX = "jdbc:teradata";
    protected static final String VDB_JDBC_URL_PREFIX = "jdbc:vdb";
    protected static final String VERTICA_JDBC_URL_PREFIX = "jdbc:vertica";
    private static final String JDBC_URL_START = "jdbc:";
    private static Pattern ORACLE_CONNECT_PATTERN = Pattern.compile("(?<username>.*)@(?<ldap>ldap:)?(//)?(?<host>[^:/]+)(?<port>:[0-9]+)?(?<service>[:/][^:/]+)?(?<server>:[^:/]+)?(?<instance>/[^:/]+)?");
    private String host = null;
    private Integer port = null;
    private String databaseName = null;
    private String dataStoreType = null;

    public JDBCUrlParser(String string) {
        this.parse(string);
    }

    private void parse(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        BLIB.DBG_DEBUG.log("Parse JDBC URL: " + string);
        string = string.replace("\\", "").replace("<", "").replace(">", "");
        String string2 = string.toLowerCase();
        if (string2.startsWith(AWSATHENA_JDBC_URL_PREFIX)) {
            String string3 = string.substring(AWSATHENA_JDBC_URL_PREFIX.length());
            Map<String, String> map = this.parseQueryParams(string3, ";");
            this.databaseName = map.get("s3outputlocation");
        } else if (string2.startsWith(BIGQUERY_JDBC_URL_PREFIX)) {
            if (string.contains("https://www.googleapis.com/bigquery/v2")) {
                String string4 = string.replace("https://www.googleapis.com/bigquery/v2", "tempHost");
                URI uRI = this.createURI(string4);
                if (uRI == null) {
                    return;
                }
                this.host = "https://www.googleapis.com/bigquery/v2";
                this.port = this.findPort(uRI, string2);
                this.databaseName = this.findDatabaseName(uRI, string2);
            }
        } else if (string2.startsWith(ORACLE_OCI_JDBC_URL_PREFIX) || string2.startsWith(ORACLE_THIN_JDBC_URL_PREFIX)) {
            String string5 = string2.startsWith(ORACLE_OCI_JDBC_URL_PREFIX) ? string.substring(ORACLE_OCI_JDBC_URL_PREFIX.length()) : string.substring(ORACLE_THIN_JDBC_URL_PREFIX.length());
            Matcher matcher = ORACLE_CONNECT_PATTERN.matcher(string5);
            if (matcher.matches()) {
                String string6;
                this.host = matcher.group("host");
                String string7 = matcher.group("port");
                if (string7 != null) {
                    try {
                        this.port = Integer.parseInt(string7.substring(1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((string6 = matcher.group("service")) != null) {
                    this.databaseName = string6.substring(1);
                }
            }
        } else {
            URI uRI = this.createURI(string);
            if (uRI == null) {
                return;
            }
            this.host = this.findHost(uRI);
            this.port = this.findPort(uRI, string2);
            this.databaseName = this.findDatabaseName(uRI, string2);
        }
        this.dataStoreType = this.findDataStoreType(string2);
    }

    private URI createURI(String string) {
        URI uRI = null;
        try {
            String string2;
            if (string.toLowerCase().startsWith(BIGQUERY_JDBC_URL_PREFIX)) {
                int n = string.indexOf(";");
                string2 = n != -1 ? string.replaceFirst(";", "/") : string;
                string2 = string2.substring(JDBC_URL_START.length());
            } else if (string.toLowerCase().startsWith(GREENPLUM_JDBC_URL_PREFIX)) {
                int n = string.indexOf(";");
                string2 = n != -1 ? string.replaceFirst(";", "/") : string;
                string2 = "greenplum" + string2.substring(GREENPLUM_JDBC_URL_PREFIX.length());
            } else if (string.toLowerCase().startsWith(SQLSERVER_JDBC_URL_PREFIX)) {
                int n = string.indexOf(";");
                string2 = n != -1 ? string.replaceFirst(";", "/") : string;
                string2 = string2.substring(JDBC_URL_START.length());
            } else if (string.toLowerCase().startsWith(SQLSERVER_MICROSOFT_JDBC_URL_PREFIX)) {
                int n = string.indexOf(";");
                string2 = n != -1 ? string.replaceFirst(";", "/") : string;
                string2 = "sqlserver" + string2.substring(SQLSERVER_MICROSOFT_JDBC_URL_PREFIX.length());
            } else {
                string2 = string.toLowerCase().startsWith(SQLSERVER_JTDS_JDBC_URL_PREFIX) ? "sqlserver" + string.substring(SQLSERVER_JTDS_JDBC_URL_PREFIX.length()) : (string.toLowerCase().startsWith(SYBASE_JTDS_JDBC_URL_PREFIX) ? "sybase" + string.substring(SYBASE_JTDS_JDBC_URL_PREFIX.length()) : (string.toLowerCase().startsWith(SYBASE_TDS_JDBC_URL_PREFIX) ? "sybase://" + string.substring(SYBASE_TDS_JDBC_URL_PREFIX.length()) : (string.length() > JDBC_URL_START.length() ? string.substring(JDBC_URL_START.length()) : string)));
            }
            uRI = new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            BLIB.DBG_DEBUG.log("Invalid JDBC URL: " + string, uRISyntaxException);
        }
        return uRI;
    }

    private String findHost(URI uRI) {
        return uRI.getHost();
    }

    private Integer findPort(URI uRI, String string) {
        Integer n = null;
        if (string.startsWith(TERADATA_JDBC_URL_PREFIX)) {
            String string2 = this.getSegment(uRI);
            if (string2 != null && !string2.isEmpty()) {
                string2 = string2.replace(",", "/");
                Map<String, String> map = this.parseQueryParams(string2, "/");
                try {
                    n = Integer.parseInt(map.get("dbs_port"));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            n = uRI.getPort() != -1 ? Integer.valueOf(uRI.getPort()) : null;
        }
        return n;
    }

    private String findDatabaseName(URI uRI, String string) {
        String string2 = null;
        String string3 = this.getSegment(uRI);
        if (string3 != null && !string3.isEmpty()) {
            if (string.startsWith(BIGQUERY_JDBC_URL_PREFIX)) {
                Map<String, String> map = this.parseQueryParams(string3, ";");
                string2 = map.get("projectid");
            } else if (string.startsWith(INFORMIX_JDBC_URL_PREFIX)) {
                int n = string3.indexOf(":");
                if (n != -1) {
                    string2 = string3.substring(0, n);
                }
            } else if (string.startsWith(GREENPLUM_JDBC_URL_PREFIX)) {
                Map<String, String> map = this.parseQueryParams(string3, ";");
                string2 = map.get("databasename");
            } else if (string.startsWith(SQLSERVER_JDBC_URL_PREFIX) || string.startsWith(SQLSERVER_MICROSOFT_JDBC_URL_PREFIX)) {
                Map<String, String> map = this.parseQueryParams(string3, ";");
                string2 = map.get("databasename");
                if (string2 == null) {
                    string2 = map.get("database");
                }
            } else if (string.startsWith(PRESTO_JDBC_URL_PREFIX)) {
                int n = string3.indexOf("/");
                string2 = n != -1 ? string3.substring(0, n) : string3;
            } else if (string.startsWith(SAP_JDBC_URL_PREFIX)) {
                Map<String, String> map = this.parseQueryParams(string3, "&");
                string2 = map.get("currentschema");
                if (string2 == null) {
                    string2 = map.get("databasename");
                }
            } else if (string.startsWith(SNOWFLAKE_JDBC_URL_PREFIX)) {
                Map<String, String> map = this.parseQueryParams(string3, "&");
                string2 = map.get("db");
            } else if (string.startsWith(TERADATA_JDBC_URL_PREFIX)) {
                string3 = string3.replace(",", "/");
                Map<String, String> map = this.parseQueryParams(string3, "/");
                string2 = map.get("database");
            } else {
                int n = string3.indexOf(";");
                string2 = n != -1 ? string3.substring(0, n) : string3;
            }
        }
        return string2;
    }

    private String findDataStoreType(String string) {
        String string2 = null;
        if (string.startsWith(AS400_JDBC_URL_PREFIX)) {
            string2 = "AS/400";
        } else if (string.startsWith(AWSATHENA_JDBC_URL_PREFIX)) {
            string2 = "AMAZONATHENA";
        } else if (string.startsWith(BIGQUERY_JDBC_URL_PREFIX)) {
            string2 = "GOOGLE BIGQUERY";
        } else if (string.startsWith(CASSANDRA_JDBC_URL_PREFIX)) {
            string2 = "APACHE CASSANDRA";
        } else if (string.startsWith(DB2_JDBC_URL_PREFIX)) {
            string2 = "DB2/UDB";
        } else if (string.startsWith(DENODO_JDBC_URL_PREFIX)) {
            string2 = "DENODO";
        } else if (string.startsWith(DERBY_JDBC_URL_PREFIX)) {
            string2 = "DERBY";
        } else if (string.startsWith(ES_JDBC_URL_PREFIX)) {
            string2 = "JDBC";
        } else if (string.startsWith(HIVE2_JDBC_URL_PREFIX)) {
            string2 = "HIVE";
        } else if (string.startsWith(IMPALA_JDBC_URL_PREFIX)) {
            string2 = "HIVE";
        } else if (string.startsWith(INFORMIX_JDBC_URL_PREFIX)) {
            string2 = "INFORMIX";
        } else if (string.startsWith(MARIADB_JDBC_URL_PREFIX)) {
            string2 = "MYSQL";
        } else if (string.startsWith(MYSQL_JDBC_URL_PREFIX)) {
            string2 = "MYSQL";
        } else if (string.startsWith(NETEZZA_JDBC_URL_PREFIX)) {
            string2 = "NETEZZA";
        } else if (string.startsWith(ORACLE_OCI_JDBC_URL_PREFIX) || string.startsWith(ORACLE_THIN_JDBC_URL_PREFIX)) {
            string2 = "ORACLE";
        } else if (string.startsWith(GREENPLUM_JDBC_URL_PREFIX)) {
            string2 = "TALEND.GREENPLUM";
        } else if (string.startsWith(POSTGRESQL_JDBC_URL_PREFIX)) {
            string2 = "POSTGRESQL";
        } else if (string.startsWith(PRESTO_JDBC_URL_PREFIX)) {
            string2 = "PRESTO";
        } else if (string.startsWith(REDSHIFT_JDBC_URL_PREFIX)) {
            string2 = "REDSHIFT";
        } else if (string.startsWith(SAP_JDBC_URL_PREFIX)) {
            string2 = "SAP HANA";
        } else if (string.startsWith(SNOWFLAKE_JDBC_URL_PREFIX)) {
            string2 = "SNOWFLAKE";
        } else if (string.startsWith(SPARK_JDBC_URL_PREFIX)) {
            string2 = "HIVE";
        } else if (string.startsWith(SQLSERVER_JDBC_URL_PREFIX) || string.startsWith(SQLSERVER_JTDS_JDBC_URL_PREFIX) || string.startsWith(SQLSERVER_MICROSOFT_JDBC_URL_PREFIX)) {
            string2 = "MICROSOFT SQL SERVER";
        } else if (string.startsWith(SYBASE_JTDS_JDBC_URL_PREFIX) || string.startsWith(SYBASE_TDS_JDBC_URL_PREFIX)) {
            string2 = "SYBASE AS ENTERPRISE";
        } else if (string.startsWith(TERADATA_JDBC_URL_PREFIX)) {
            string2 = "TERADATA";
        } else if (string.startsWith(VDB_JDBC_URL_PREFIX)) {
            string2 = "DENODO";
        } else if (string.startsWith(VERTICA_JDBC_URL_PREFIX)) {
            string2 = "HP VERTICA";
        }
        return string2;
    }

    private String getSegment(URI uRI) {
        String string = uRI.getPath();
        if (string != null && string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        if (string == null || string.isEmpty()) {
            string = uRI.getQuery();
        }
        if (string == null || string.isEmpty()) {
            string = uRI.getSchemeSpecificPart();
        }
        return string;
    }

    private Map<String, String> parseQueryParams(String string, String string2) {
        String[] stringArray;
        if (string == null || string.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (String string3 : stringArray = string.split(string2)) {
            try {
                String string4;
                int n = string3.indexOf("=");
                String string5 = string4 = n > 0 ? URLDecoder.decode(string3.substring(0, n), StandardCharsets.UTF_8.name()) : string3;
                if (linkedHashMap.containsKey(string4)) continue;
                String string6 = n > 0 && string3.length() > n + 1 ? URLDecoder.decode(string3.substring(n + 1), StandardCharsets.UTF_8.name()) : null;
                linkedHashMap.put(string4.toLowerCase(), string6);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return linkedHashMap;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDataStoreType() {
        return this.dataStoreType;
    }
}

