/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib.parsers;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.bridgelib.MIRTypeLib;
import MITI.bridges.bridgelib.parsers.DiParser;
import MITI.bridges.bridgelib.parsers.ParserBase;
import MITI.expression.MIRStatementNodeType;
import MITI.expression.analyzer.LookupOptions;
import MITI.expression.analyzer.MIRExpressionAnalyzerHelper;
import MITI.expression.analyzer.decoration.MIRDecorUtil;
import MITI.messages.MIRExpressionLib.EXPLIB;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.sdk.MIRAttribute;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRClassType;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRConnectionDataAttribute;
import MITI.sdk.MIRConnectionDataPackage;
import MITI.sdk.MIRConnectionDataSet;
import MITI.sdk.MIRConnectionNamespace;
import MITI.sdk.MIRConnectionPackage;
import MITI.sdk.MIRConstantNode;
import MITI.sdk.MIRDataAttribute;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDataSet;
import MITI.sdk.MIRDatabaseSchema;
import MITI.sdk.MIRDelimitedFileDescriptor;
import MITI.sdk.MIRDelimiterNode;
import MITI.sdk.MIRDiModel;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRFlatTextFile;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIROperation;
import MITI.sdk.MIROperationNode;
import MITI.sdk.MIROperatorNode;
import MITI.sdk.MIRQueryColumn;
import MITI.sdk.MIRQueryFilter;
import MITI.sdk.MIRQueryTable;
import MITI.sdk.MIRStatementNode;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRStoredProcedure;
import MITI.sdk.MIRStructuralFeature;
import MITI.sdk.MIRTransformation;
import MITI.sdk.MIRType;
import MITI.util.log.MIRLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DiOperationParser
extends DiParser {
    private static final String SP_RETURNVALUE = "ReturnValue";
    private static final String SP_PARAMETERS_SUFFIX = "_params";
    private static final String TEMPORARY = "Temporary";
    protected MIRClassifier paramsDataSet;
    protected MIRClassifier nestedParamsDataSet;
    private Collection<MIRClassifier> predefinedClassifiers = new HashSet<MIRClassifier>();
    private List<MIRQueryTable> fullyDefinedTables = new LinkedList<MIRQueryTable>();
    List<MIRNamespaceElement> namespaceElementsToRename = new ArrayList<MIRNamespaceElement>();
    private Map<String, MIRClassType> tableTypes = new HashMap<String, MIRClassType>();
    private static Map<String, MIRQueryTable> synonyms = new HashMap<String, MIRQueryTable>();
    private static final String OUTPUT = "Output_";

    public DiOperationParser(MIRDiModel mIRDiModel, MIRNamespaceElement mIRNamespaceElement, int n, int n2, MIRClassifier mIRClassifier, Set<MIRClassifier> set) {
        super(MIRLogger.getLogger(), mIRDiModel, mIRNamespaceElement, n, n2);
        this.paramsDataSet = mIRClassifier;
        this.setRecoverFromSyntaxErrors(true);
        if (set != null) {
            this.predefinedClassifiers = set;
        }
    }

    @Override
    public boolean startStatement(MIRStatementNode mIRStatementNode) {
        this.nestedParamsDataSet = null;
        if (mIRStatementNode.getStatementType() == 30 && this.getDatabaseType() == 11) {
            MIRDelimiterNode mIRDelimiterNode = (MIRDelimiterNode)mIRStatementNode.getExpressionNodeByPosition().get(0);
            MIRElementNode mIRElementNode = (MIRElementNode)mIRDelimiterNode.getExpressionNodeByPosition().get(0);
            MIRElementNamePart mIRElementNamePart = mIRElementNode.getElementNamePartByPosition().get(mIRElementNode.getElementNamePartCount() - 1);
            String string = mIRElementNamePart.getName();
            this.defaultSchema = this.getDataPackage(new ParserBase.QualifiedName(null, false, this.defaultCatalog != null ? this.defaultCatalog.getName() : "", false, string, mIRElementNamePart.getQuoted()), true);
        }
        return true;
    }

    @Override
    public void getSrcElements(MIRElementNode mIRElementNode, Collection<MIRClassifier> collection, Collection<MIRElement> collection2) {
        this.getSrcElements(new LookupOptions(mIRElementNode, false), collection, collection2);
    }

    private void renameTables(String string) {
        for (MIRNamespaceElement mIRNamespaceElement : this.namespaceElementsToRename) {
            mIRNamespaceElement.setName(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getSrcElements(LookupOptions lookupOptions, Collection<MIRClassifier> collection, Collection<MIRElement> collection2) {
        MIRElementNode mIRElementNode = lookupOptions.getNode();
        String string = MIRExpressionAnalyzerHelper.getCanonicalName(lookupOptions.getName(), lookupOptions.isQuoted(), this.getDatabaseType());
        if (mIRElementNode.getDestinationElementType() == 75) {
            MIRElement mIRElement;
            if (MIRExpressionAnalyzerHelper.isCreateSynonym(mIRElementNode)) {
                return;
            }
            MIRConnectionPackage mIRConnectionPackage = this.getConnectionPackage(mIRElementNode, true);
            if (MIRExpressionAnalyzerHelper.isRenameTable(mIRElementNode)) {
                if (mIRElementNode.getPosition() == 0) {
                    this.namespaceElementsToRename.clear();
                    this.namespaceElementsToRename = this.getItems(string, lookupOptions.isQuoted(), mIRConnectionPackage.getNamespaceElements());
                    this.namespaceElementsToRename.addAll(this.getItems(string, lookupOptions.isQuoted(), mIRConnectionPackage.getImportedNamespaceElements()));
                    this.namespaceElementsToRename.addAll(this.getItems(string, lookupOptions.isQuoted(), mIRConnectionPackage.getClassifiers()));
                } else if (mIRElementNode.getPosition() == 1) {
                    MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart(mIRElementNode);
                    String string2 = mIRElementNamePart.getName();
                    this.renameTables(string2);
                }
                mIRElement = null;
            } else {
                MIRClassifier cloneable2;
                mIRElement = null;
                if (!synonyms.isEmpty()) {
                    mIRElement = synonyms.get(string);
                }
                if (mIRElement == null) {
                    mIRElement = this.getClassifier(string, lookupOptions.isQuoted(), mIRConnectionPackage);
                }
                if (mIRElement == null && "%ROWTYPE".equalsIgnoreCase(mIRElementNode.getDataType())) {
                    mIRElement = this.getItem(mIRConnectionPackage, string, lookupOptions.isQuoted());
                }
                if (mIRElement == null && (cloneable2 = (MIRClassifier)this.getItem(string, lookupOptions.isQuoted(), this.fullyDefinedTables)) != null && (TEMPORARY.equals(cloneable2.getNativeType()) || cloneable2.getConnectionDataPackage() == mIRConnectionPackage)) {
                    mIRElement = cloneable2;
                }
                if (mIRElement == null) {
                    LinkedList<MIRClassifier> n = new LinkedList<MIRClassifier>();
                    LinkedHashSet<MIRDataPackage> linkedHashSet = new LinkedHashSet<MIRDataPackage>();
                    if (this.getItem(string, lookupOptions.isQuoted(), this.predefinedClassifiers) == null) {
                        linkedHashSet.addAll(Arrays.asList(this.getAlternativeDataPackages(mIRElementNode)));
                    }
                    if (mIRConnectionPackage != null) {
                        linkedHashSet.add(mIRConnectionPackage);
                    }
                    for (MIRDataPackage mIRDataPackage : linkedHashSet) {
                        MIRClassifier mIRClassifier = null;
                        MIRNamespaceElement mIRNamespaceElement = this.getItem(string, lookupOptions.isQuoted(), ((MIRConnectionPackage)mIRDataPackage).getNamespaceElements());
                        if (mIRNamespaceElement instanceof MIRClassifier) {
                            mIRClassifier = (MIRClassifier)mIRNamespaceElement;
                        } else {
                            mIRClassifier = new MIRConnectionDataSet();
                            mIRClassifier.setName(string);
                            if (this.getOptions().isReservedClassifierKeyword(string) || linkedHashSet.size() > 1) {
                                mIRClassifier.setLineageOption(1);
                            }
                            mIRDataPackage.addNamespaceElement(mIRClassifier);
                            this.setCollationLineageOption(mIRClassifier, lookupOptions.isQuoted());
                        }
                        MIRStoreConnection mIRStoreConnection = ((MIRConnectionPackage)mIRDataPackage).getStoreConnection();
                        if (mIRStoreConnection.getSourceOfMappingModel() == null) {
                            this.model.addSourceStoreConnection(mIRStoreConnection);
                        }
                        n.add(mIRClassifier);
                    }
                    if (!n.isEmpty()) {
                        collection2.addAll(n);
                        return;
                    }
                }
            }
            if (mIRElement != null) {
                collection2.add(mIRElement);
            }
        } else if (mIRElementNode.getDestinationElementType() == 24) {
            MIRFeature mIRFeature;
            MIRClassifier mIRClassifier;
            MIRClassifier mIRClassifier2 = mIRClassifier = this.nestedParamsDataSet != null ? this.nestedParamsDataSet : this.paramsDataSet;
            if (lookupOptions.isPositionBased()) {
                mIRFeature = this.getFeatureByPosition(mIRClassifier, lookupOptions.getPosition());
                if (mIRFeature == null) {
                    mIRFeature = this.createFeature(mIRClassifier);
                    mIRFeature.setPosition((short)lookupOptions.getPosition());
                    mIRFeature.setLineageOption(mIRClassifier.getLineageOptions());
                    mIRFeature.setLineageOption(512);
                    mIRFeature.setName(":" + String.valueOf(lookupOptions.getPosition()));
                    mIRClassifier.addFeature(mIRFeature);
                }
            } else {
                mIRFeature = mIRClassifier.getFeature(string);
                if (mIRFeature == null) {
                    mIRFeature = this.createFeature(mIRClassifier);
                    if (string.isEmpty()) {
                        int object2 = lookupOptions.getPosition();
                        string = "$" + object2;
                    }
                    mIRFeature.setName(string);
                    mIRClassifier.addFeature(mIRFeature);
                    mIRFeature.setPosition((short)mIRClassifier.getFeatureCount());
                    mIRFeature.setLineageOption(mIRClassifier.getLineageOptions());
                    this.setCollationLineageOption(mIRFeature, lookupOptions.isQuoted());
                }
            }
            collection2.add(mIRFeature);
        } else if (mIRElementNode.getDestinationElementType() == 77) {
            List<MIRElementNamePart> list;
            if (this.getOptions().supportPackages()) {
                list = mIRElementNode.getElementNamePartByPosition();
                Iterator<MIRClassifier> iterator = MIRDecorUtil.getClassifierPart(mIRElementNode);
                MIRElementNamePart string4 = MIRDecorUtil.getFeaturePart(mIRElementNode);
                if (list.size() >= 2 && iterator != null && string4 != null && !string4.getName().isEmpty() || list.size() == 1 && string4 != null && !string4.getName().isEmpty()) {
                    void var9_30;
                    Object object;
                    Object object2;
                    Object var9_27 = null;
                    boolean bl = false;
                    if (list.size() > 1) {
                        String string3 = ((MIRObject)((Object)iterator)).getName();
                        bl = ((MIRElementNamePart)((Object)iterator)).getQuoted();
                    } else {
                        object2 = this.model.getName();
                        object = ((String)object2).split("\\.");
                        if (((String[])object).length == 3) {
                            String string5 = object[1];
                            bl = false;
                        }
                    }
                    object2 = this.getItem((String)var9_30, bl, this.predefinedClassifiers);
                    object = null;
                    if (object2 instanceof MIRClass && "PACKAGE".equals(((MIRElement)object2).getNativeType())) {
                        object = (MIRClass)object2;
                    }
                    MIRFeature mIRFeature = null;
                    if (object != null) {
                        mIRFeature = this.getItem(string4.getName(), string4.getQuoted(), ((MIRClassifier)object).getFeatures());
                    }
                    if (object != null && mIRFeature != null) {
                        ParserBase.QualifiedName qualifiedName = this.getSchemaFullName(list, true);
                        MIRConnectionPackage mIRConnectionPackage = (MIRConnectionPackage)this.getDataPackage(qualifiedName, true);
                        MIRStoreConnection mIRStoreConnection = mIRConnectionPackage.getStoreConnection();
                        if (mIRStoreConnection.getSourceOfMappingModel() == null) {
                            mIRStoreConnection.addSourceOfMappingModel(this.model);
                        }
                        MIRClassifier mIRClassifier = null;
                        MIRElement mIRElement = this.getItem((String)var9_30, bl, mIRConnectionPackage.getNamespaceElements());
                        if (mIRElement instanceof MIRClassifier) {
                            mIRClassifier = (MIRClassifier)mIRElement;
                        } else {
                            mIRClassifier = new MIRConnectionDataSet();
                            mIRClassifier.setName((String)var9_30);
                            mIRConnectionPackage.addNamespaceElement(mIRClassifier);
                        }
                        collection.clear();
                        collection.add(mIRClassifier);
                    }
                }
            }
            list = new LinkedList<MIRElementNamePart>();
            if (lookupOptions.hasStar()) {
                block1: for (MIRClassifier mIRClassifier : collection) {
                    for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
                        if (!mIRFeature.hasLineageOption(256)) continue;
                        list.add((MIRElementNamePart)((Object)mIRFeature));
                        continue block1;
                    }
                }
            } else if (lookupOptions.isPositionBased()) {
                for (MIRClassifier mIRClassifier : collection) {
                    MIRFeature mIRFeature = this.getFeatureByPosition(mIRClassifier, lookupOptions.getPosition());
                    if (mIRFeature == null) continue;
                    list.add((MIRElementNamePart)((Object)mIRFeature));
                }
            } else {
                list.addAll(this.getFeatures(string, lookupOptions.isQuoted(), collection));
            }
            if (list.isEmpty()) {
                boolean bl = collection.size() > 1;
                for (MIRClassifier mIRClassifier : collection) {
                    MIRFeature mIRFeature;
                    if (bl && this.featureDoesNotExistInPredefinedClassifiers(string, mIRClassifier)) continue;
                    if (mIRClassifier instanceof MIRFlatTextFile) {
                        mIRFeature = new MIRAttribute();
                        mIRFeature.setLineageOption(512);
                        mIRFeature.addType(this.getType(lookupOptions));
                        mIRFeature.setPosition(this.getPosition(mIRClassifier, lookupOptions));
                        if (!string.isEmpty()) {
                            mIRFeature.setName(string);
                        } else {
                            mIRFeature.setName(":" + String.valueOf(mIRFeature.getPosition()));
                        }
                        mIRClassifier.addFeatureUniqueName(mIRFeature);
                    } else {
                        mIRFeature = this.createFeature(mIRClassifier);
                        if (lookupOptions.isPositionBased()) {
                            mIRFeature.setPosition((short)lookupOptions.getPosition());
                            mIRFeature.setLineageOption(512);
                            mIRFeature.setName(":" + String.valueOf(lookupOptions.getPosition()));
                        } else {
                            mIRFeature.setName(string);
                        }
                        mIRClassifier.addFeature(mIRFeature);
                    }
                    this.setCollationLineageOption(mIRFeature, lookupOptions.isQuoted());
                    if (bl || this.getOptions().isReservedFeatureKeyword(mIRFeature.getName())) {
                        mIRFeature.setLineageOption(1);
                    }
                    if (mIRClassifier.hasLineageOption(1024)) {
                        mIRFeature.setLineageOption(1024);
                    }
                    list.add((MIRElementNamePart)((Object)mIRFeature));
                }
            }
            collection2.addAll(list);
        } else if (mIRElementNode.getDestinationElementType() == 209) {
            String string6 = lookupOptions.getName();
            if (this.getDatabaseType() == 20 && mIRElementNode != null && mIRElementNode.getName() != null && mIRElementNode.getName().startsWith("@")) {
                String[] stringArray = this.getStageNameParts(mIRElementNode);
                String string7 = stringArray[0];
                String string8 = stringArray[1];
                String string9 = stringArray[2];
                MIRDataPackage mIRDataPackage = this.getDataPackage(new ParserBase.QualifiedName(null, false, string7, false, string8, false), true);
                MIRElement mIRElement = this.getClassifier(string9, lookupOptions.isQuoted(), mIRDataPackage);
                if (mIRDataPackage != null && mIRElement == null) {
                    if (mIRDataPackage instanceof MIRConnectionPackage) {
                        MIRConnectionDataSet mIRConnectionDataSet = new MIRConnectionDataSet();
                        mIRConnectionDataSet.setName(string9);
                        mIRDataPackage.addNamespaceElement(mIRConnectionDataSet);
                        this.setCollationLineageOption(mIRConnectionDataSet, lookupOptions.isQuoted());
                        mIRElement = mIRConnectionDataSet;
                    } else if (mIRDataPackage instanceof MIRDatabaseSchema && (string9.startsWith("@%") || string9.startsWith("%") || string9.startsWith("@~"))) {
                        MIRClass mIRClass = new MIRClass();
                        mIRClass.setName(string9);
                        if (string9.startsWith("@%") || string9.startsWith("%")) {
                            mIRClass.setNativeType("TABLE STAGE");
                        } else if (string9.startsWith("@~")) {
                            mIRClass.setNativeType("USER STAGE");
                        }
                        mIRDataPackage.addNamespaceElement(mIRClass);
                        this.setCollationLineageOption(mIRClass, lookupOptions.isQuoted());
                        mIRElement = mIRClass;
                    }
                }
                if (mIRElement != null) {
                    collection2.add(mIRElement);
                }
            } else {
                if (string6.endsWith("/")) {
                    string6 = string6.substring(0, string6.length() - 1);
                }
                StringBuilder stringBuilder = new StringBuilder();
                MIRConnectionNamespace mIRConnectionNamespace = MIRBridgeLib.getConnectionNamespace(this.model, string6, stringBuilder);
                string6 = stringBuilder.toString();
                MIRStoreConnection mIRStoreConnection2 = MIRBridgeLib.getStoreConnection(mIRConnectionNamespace);
                mIRStoreConnection2 = this.getFileConnection(mIRStoreConnection2.getName());
                MIRNamespaceElement mIRNamespaceElement = mIRConnectionNamespace.getNamespaceElement(string6);
                if (mIRNamespaceElement == null) {
                    MIRFlatTextFile mIRFlatTextFile = new MIRFlatTextFile();
                    mIRFlatTextFile.setName(string6);
                    this.setFlatFileDescriptor(mIRFlatTextFile);
                    mIRConnectionNamespace.addNamespaceElement(mIRFlatTextFile);
                    mIRNamespaceElement = mIRFlatTextFile;
                }
                collection2.add(mIRNamespaceElement);
            }
        }
    }

    private boolean featureDoesNotExistInPredefinedClassifiers(String string, MIRClassifier mIRClassifier) {
        List<MIRClassifier> list = this.getItems(mIRClassifier.getName(), false, this.predefinedClassifiers);
        for (MIRClassifier mIRClassifier2 : list) {
            String string2;
            String string3 = mIRClassifier2.getNamespace().getName();
            if (!string3.equals(string2 = mIRClassifier.getNamespace().getName())) continue;
            MIRFeature mIRFeature = mIRClassifier2.getFeature(string);
            return mIRFeature == null;
        }
        return !list.isEmpty();
    }

    private MIRFeature createFeature(MIRClassifier mIRClassifier) {
        MIRStructuralFeature mIRStructuralFeature = null;
        if (mIRClassifier instanceof MIRDataSet) {
            mIRStructuralFeature = new MIRDataAttribute();
            mIRStructuralFeature.addType(MIRTypeLib.getUndefinedBaseType(this.model));
        } else if (mIRClassifier instanceof MIRQueryTable) {
            mIRStructuralFeature = new MIRQueryColumn();
        } else if (mIRClassifier instanceof MIRFlatTextFile) {
            mIRStructuralFeature = new MIRAttribute();
            mIRStructuralFeature.addType(MIRTypeLib.getUndefinedBaseType(this.model));
        } else if (mIRClassifier instanceof MIRClass) {
            mIRStructuralFeature = new MIRAttribute();
            mIRStructuralFeature.addType(MIRTypeLib.getUndefinedBaseType(this.model));
        } else {
            mIRStructuralFeature = new MIRConnectionDataAttribute();
        }
        return mIRStructuralFeature;
    }

    @Override
    public void getSrcElements(MIROperationNode mIROperationNode, Collection<MIRElement> collection) {
        MIRNamespaceElement mIRNamespaceElement;
        MIRClass mIRClass;
        MIROperation mIROperation;
        Object object;
        MIRElement mIRElement;
        Object object2;
        Object object3;
        MIRElement mIRElement2;
        List<MIRElementNamePart> list = mIROperationNode.getElementNamePartByPosition();
        MIRElementNamePart mIRElementNamePart = list.get(list.size() - 1);
        boolean bl = mIRElementNamePart.getQuoted();
        String string = MIRExpressionAnalyzerHelper.getCanonicalName(mIRElementNamePart.getName(), bl, this.getDatabaseType());
        MIROperatorNode mIROperatorNode = mIROperationNode.getRightOfOperatorNode();
        if (mIROperatorNode != null && ".".equals(mIROperatorNode.getName())) {
            return;
        }
        MIRStatementNode mIRStatementNode = mIROperationNode.getStatementNode();
        if (mIRStatementNode != null && string.toUpperCase().equals("EXECUTE") && mIRStatementNode.getStatementType() == 11 && mIROperationNode.getExpressionNodeCount() != 0 && (mIRElement2 = mIROperationNode.getExpressionNodeByPosition().get(0)) instanceof MIRConstantNode) {
            MIRConstantNode mIRConstantNode = (MIRConstantNode)mIRElement2;
            String string2 = mIRConstantNode.getName();
            MIRClassifierMap mIRClassifierMap = new MIRClassifierMap();
            mIRClassifierMap.setOperation(string2);
            MIRTransformation mIRTransformation = this.model.getTransformation(MIRStatementNodeType.getName(36));
            MIRClassifier mIRClassifier = mIRTransformation.getOutputTransformationDataSets().first();
            this.model.addClassifierMap(mIRClassifierMap);
            mIRClassifierMap.addDestinationClassifier(mIRClassifier);
            try {
                BLIB.DBG_DEBUG.log("Parsing the statement EXECUTE IMMEDIATE '" + string2 + "'.");
                DiOperationParser diOperationParser = new DiOperationParser(this.model, this.defaultSchema, this.getParserType(), this.getDatabaseType(), this.paramsDataSet, (Set)this.predefinedClassifiers);
                diOperationParser.parse(mIRClassifierMap);
            }
            catch (MIRException mIRException) {
                BLIB.DBG_DEBUG.log("The statement EXECUTE IMMEDIATE '" + string2 + "' is not parsed.");
            }
            return;
        }
        mIRElement2 = this.getItem(string, bl, this.predefinedClassifiers);
        if (mIRElement2 != null && "TYPE".equals(mIRElement2.getNativeType())) {
            return;
        }
        MIRConnectionPackage mIRConnectionPackage = this.getConnectionPackage(mIROperationNode, true);
        String string3 = this.getPackageName(mIROperationNode);
        String string4 = (string3 != null ? string3 + "." : "") + string;
        MIRNamespaceElement mIRNamespaceElement2 = mIRConnectionPackage.getNamespaceElement(string4);
        MIRClass mIRClass2 = null;
        if (mIRNamespaceElement2 == null && this.getOptions().supportPackages() && ((String[])(object3 = ((String)(object2 = this.model.getName())).split("\\."))).length == 3 && (mIRElement = (MIRElement)this.getItem((String)(object = object3[1]), false, this.predefinedClassifiers)) instanceof MIRClass && "PACKAGE".equals(mIRElement.getNativeType()) && (mIROperation = this.getItem(string, bl, (mIRClass = (MIRClass)mIRElement).getOperations())) != null && (mIRNamespaceElement = mIRConnectionPackage.getNamespaceElement((String)object)) instanceof MIRClass) {
            mIRClass2 = (MIRClass)mIRNamespaceElement;
            mIRNamespaceElement2 = mIRClass2.getOperation(string4);
        }
        object2 = null;
        if (mIRNamespaceElement2 != null) {
            if (mIRNamespaceElement2 instanceof MIRStoredProcedure) {
                object2 = (MIRStoredProcedure)mIRNamespaceElement2;
            }
        } else {
            object2 = new MIRStoredProcedure();
            ((MIRObject)object2).setName(string4);
            object3 = new MIRDataSet();
            ((MIRObject)object3).setName(string + SP_PARAMETERS_SUFFIX);
            ((MIRStoredProcedure)object2).addParametersDataSet((MIRDataSet)object3);
            object = new MIRDataSet();
            ((MIRObject)object).setName(string);
            if (!MIRExpressionAnalyzerHelper.isInClassifierContext(mIROperationNode)) {
                mIRElement = this.createFeature((MIRClassifier)object);
                ((MIRFeature)mIRElement).setPosition((short)1);
                mIRElement.setName(SP_RETURNVALUE);
                ((MIRFeature)mIRElement).setLineageOption(512);
                ((MIRFeature)mIRElement).setLineageOption(1);
                ((MIRClassifier)object).addFeature((MIRFeature)mIRElement);
            }
            ((MIRStoredProcedure)object2).addResultDataSet((MIRDataSet)object);
            if (mIRClass2 == null) {
                mIRConnectionPackage.addNamespaceElement((MIRNamespaceElement)object2);
            } else {
                mIRClass2.addOperation((MIROperation)object2);
            }
        }
        if (object2 != null) {
            collection.add((MIRElement)object2);
        } else {
            EXPLIB.DBG_CANNOT_FIND_SRC_OPERATION.log(this.getLog(), mIROperationNode.getName());
        }
    }

    @Override
    public MIRClassifierMap getOutput(MIRElementNode mIRElementNode, Collection<MIRClassifier> collection, byte by) {
        MIRClassifierMap mIRClassifierMap;
        MIRClassifier mIRClassifier;
        MIRClassifierMap mIRClassifierMap2 = super.getOutput(mIRElementNode, collection, by);
        if (mIRElementNode.getDestinationElementType() == 66) {
            return null;
        }
        if (mIRElementNode.getDestinationElementType() == 49) {
            MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart(mIRElementNode);
            String string = MIRExpressionAnalyzerHelper.getSynonymReferencedTable(mIRElementNode);
            List<MIRQueryTable> list = this.getItems(string, mIRElementNamePart.getQuoted(), this.fullyDefinedTables);
            MIRQueryTable mIRQueryTable = null;
            if (list != null) {
                Iterator<MIRQueryTable> iterator = list.iterator();
                while (iterator.hasNext()) {
                    MIRQueryTable mIRQueryTable2;
                    mIRQueryTable = mIRQueryTable2 = iterator.next();
                }
            }
            if (mIRQueryTable != null) {
                synonyms.put(mIRElementNode.getName(), mIRQueryTable);
            }
        } else if (mIRElementNode.getDestinationElementType() == 23 && mIRClassifierMap2.getDestinationClassifier().getSourceOfClassifierMapCount() > 0 && (mIRClassifier = (mIRClassifierMap = mIRClassifierMap2.getDestinationClassifier().getSourceOfClassifierMaps().first()).getDestinationClassifier()) instanceof MIRDataSet && ((MIRDataSet)mIRClassifier).getResultOfStoredProcedure() != null) {
            if (mIRClassifierMap != this.cm) {
                mIRClassifierMap.delete();
            }
            mIRClassifierMap2.removeDestinationClassifier();
            mIRClassifierMap2.addDestinationClassifier(mIRClassifier);
        }
        return mIRClassifierMap2;
    }

    @Override
    public MIRType getDataType(String string) {
        return this.tableTypes.get(string);
    }

    MIRType getType(LookupOptions lookupOptions) {
        return MIRTypeLib.getUndefinedBaseType(this.model);
    }

    void setFlatFileDescriptor(MIRFlatTextFile mIRFlatTextFile) {
        mIRFlatTextFile.addFlatFileDescriptor(new MIRDelimitedFileDescriptor());
    }

    void setFlatFileDescriptor(MIRQueryTable mIRQueryTable) {
        mIRQueryTable.addFlatFileDescriptor(new MIRDelimitedFileDescriptor());
    }

    short getPosition(MIRClassifier mIRClassifier, LookupOptions lookupOptions) {
        return (short)lookupOptions.getPosition();
    }

    private MIRStoreConnection getFileConnection(String string) {
        MIRStoreConnection mIRStoreConnection = this.model.getStoreConnection(string);
        if (mIRStoreConnection == null) {
            mIRStoreConnection = new MIRStoreConnection();
            mIRStoreConnection.setName(string);
            this.model.addStoreConnection(mIRStoreConnection);
        }
        mIRStoreConnection.setStoreType((byte)2);
        mIRStoreConnection.setSystemType("Flat file");
        if (mIRStoreConnection.getSourceOfMappingModel() == null) {
            this.model.addSourceStoreConnection(mIRStoreConnection);
        }
        return mIRStoreConnection;
    }

    private MIRFeature getFeatureByPosition(MIRClassifier mIRClassifier, int n) {
        for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
            if (mIRFeature.getPosition() != n) continue;
            return mIRFeature;
        }
        return null;
    }

    @Override
    public MIRFeature getDstFeature(MIRClassifier mIRClassifier, LookupOptions lookupOptions) {
        String string;
        MIRFeature mIRFeature = null;
        short s = 0;
        if (lookupOptions.hasStar()) {
            string = lookupOptions.getName() != null && !lookupOptions.getName().isEmpty() ? lookupOptions.getName() : "*";
            for (MIRFeature mIRFeature2 : mIRClassifier.getFeatures()) {
                if (mIRFeature2.getPosition() != s || !mIRFeature2.hasLineageOption(256)) continue;
                mIRFeature = mIRFeature2;
                break;
            }
            if (mIRFeature == null) {
                mIRFeature = this.createFeature(mIRClassifier);
                mIRFeature.setName(string);
                mIRFeature.setLineageOption(256);
                mIRClassifier.addFeatureUniqueName(mIRFeature);
            }
        } else if (lookupOptions.isPositionBased()) {
            s = (short)lookupOptions.getPosition();
            string = ":" + String.valueOf(s);
            mIRFeature = this.getFeatureByPosition(mIRClassifier, s);
        } else {
            string = MIRExpressionAnalyzerHelper.getCanonicalName(lookupOptions.getName(), lookupOptions.isQuoted(), this.getDatabaseType());
            mIRFeature = this.getItem(string, lookupOptions.isQuoted(), mIRClassifier.getFeatures());
        }
        if (mIRFeature == null && lookupOptions.getNode() != null && lookupOptions.getNode().getDestinationElementType() == 24) {
            mIRFeature = this.getItem(string, lookupOptions.isQuoted(), this.paramsDataSet.getFeatures());
        }
        if (mIRFeature == null) {
            mIRFeature = this.createFeature(mIRClassifier);
            if (lookupOptions.isPositionBased()) {
                mIRFeature.setPosition(s);
                mIRFeature.setLineageOption(512);
            }
            if (string.isEmpty()) {
                mIRFeature.setName(OUTPUT + s);
                mIRClassifier.addFeatureUniqueName(mIRFeature);
            } else {
                mIRFeature.setName(string);
                mIRClassifier.addFeatureUniqueName(mIRFeature);
                this.setCollationLineageOption(mIRFeature, lookupOptions.isQuoted());
            }
            if (this.fullyDefinedTables.contains(mIRClassifier) || this.getClassifierMap().getDestinationClassifier() == mIRClassifier) {
                mIRFeature.setPosition((short)lookupOptions.getPosition());
            }
        }
        if (mIRClassifier.hasLineageOption(1024)) {
            mIRFeature.setLineageOption(1024);
        }
        return mIRFeature;
    }

    @Override
    public MIRFeature getDstCondition(MIRClassifier mIRClassifier) {
        MIRFeature mIRFeature = mIRClassifier.getFeature("SQL CONDITION");
        if (mIRFeature == null || !mIRFeature.isInstanceOf((short)333)) {
            MIRQueryFilter mIRQueryFilter = new MIRQueryFilter();
            mIRQueryFilter.setName("SQL CONDITION");
            mIRClassifier.addFeatureUniqueName(mIRQueryFilter, '_');
            mIRQueryFilter.setPosition((short)Short.MAX_VALUE);
            mIRQueryFilter.setLineageOption(128);
            mIRFeature = mIRQueryFilter;
        }
        return mIRFeature;
    }

    private String removeAt(String string) {
        if (string.startsWith("@")) {
            return string.substring(1);
        }
        return string;
    }

    private String getCatalogName() {
        String string = this.defaultCatalog.getName();
        int n = string.indexOf(".");
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    private String[] getStageNameParts(MIRElementNode mIRElementNode) {
        List<MIRElementNamePart> list = mIRElementNode.getElementNamePartByPosition();
        MIRElementNamePart mIRElementNamePart = list.get(list.size() - 1);
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (mIRElementNamePart.getName().startsWith("/")) {
            if (list.size() == 2) {
                string = this.getCatalogName();
                string2 = this.defaultSchema.getName();
                string3 = list.get(0).getName();
            } else if (list.size() == 3) {
                string = this.getCatalogName();
                string2 = this.removeAt(list.get(0).getName());
                string3 = "@" + list.get(1).getName();
            } else if (list.size() == 4) {
                string = this.removeAt(list.get(0).getName());
                string2 = list.get(1).getName();
                string3 = "@" + list.get(2).getName();
            }
            string4 = mIRElementNamePart.getName();
        } else if (list.size() == 1) {
            string = this.getCatalogName();
            string2 = this.defaultSchema.getName();
            string3 = list.get(0).getName();
        } else if (list.size() == 2) {
            string = this.getCatalogName();
            string2 = this.removeAt(list.get(0).getName());
            string3 = "@" + list.get(1).getName();
        } else if (list.size() == 3) {
            string = this.removeAt(list.get(0).getName());
            string2 = list.get(1).getName();
            string3 = "@" + list.get(2).getName();
        }
        String[] stringArray = new String[]{string, string2, string3, string4};
        return stringArray;
    }

    @Override
    protected MIRClassifier getDstClassifier(MIRElementNode mIRElementNode) {
        MIRElement mIRElement = new MIRQueryTable();
        List<MIRElementNamePart> list = mIRElementNode.getElementNamePartByPosition();
        MIRElementNamePart mIRElementNamePart = list.get(list.size() - 1);
        if (mIRElementNode.getDestinationElementType() == 209) {
            String string = mIRElementNode.getName();
            if (string.startsWith("@") && this.getDatabaseType() == 20) {
                String[] stringArray = this.getStageNameParts(mIRElementNode);
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                String string4 = stringArray[2];
                MIRDataPackage mIRDataPackage = this.getDataPackage(new ParserBase.QualifiedName(null, false, string2, false, string3, false), true);
                if (mIRDataPackage != null && mIRDataPackage instanceof MIRConnectionPackage) {
                    mIRElement.setName(string4);
                    this.setCollationLineageOption(mIRElement, mIRElementNamePart.getQuoted());
                    ((MIRConnectionPackage)mIRDataPackage).addClassifier((MIRClassifier)mIRElement);
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                if (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                }
                MIRConnectionNamespace mIRConnectionNamespace = MIRBridgeLib.getConnectionNamespace(this.model, string, stringBuilder);
                MIRStoreConnection mIRStoreConnection = MIRBridgeLib.getStoreConnection(mIRConnectionNamespace);
                mIRStoreConnection = this.getFileConnection(mIRStoreConnection.getName());
                mIRElement.setName(stringBuilder.toString());
                this.setFlatFileDescriptor((MIRQueryTable)mIRElement);
                mIRConnectionNamespace.addClassifier((MIRClassifier)mIRElement);
            }
        } else if (mIRElementNode.getDestinationElementType() == 66) {
            MIRConnectionPackage mIRConnectionPackage = this.getConnectionPackage(mIRElementNode, false);
            mIRElement.setNativeType("TYPE");
            String string = mIRElementNamePart.getName();
            mIRElement.setName(string);
            mIRConnectionPackage.addClassifier((MIRClassifier)mIRElement);
            MIRClass mIRClass = new MIRClass();
            mIRClass.setNativeType("TYPE");
            mIRClass.setName(string);
            MIRClassType mIRClassType = new MIRClassType();
            mIRClassType.setName(string);
            mIRClassType.addAssociatedClass(mIRClass);
            this.tableTypes.put(string, mIRClassType);
        } else {
            Object object;
            Object object2;
            MIRConnectionPackage mIRConnectionPackage = this.getConnectionPackage(mIRElementNode, false);
            mIRElement.setName(MIRExpressionAnalyzerHelper.getCanonicalName(mIRElementNamePart.getName(), mIRElementNamePart.getQuoted(), this.getDatabaseType()));
            List<MIRQueryTable> list2 = this.getItems(mIRElement.getName(), mIRElementNamePart.getQuoted(), this.fullyDefinedTables);
            MIRElement mIRElement2 = null;
            if (list2 != null) {
                object2 = list2.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (!TEMPORARY.equals(((MIRElement)object).getNativeType()) && ((MIRClassifier)object).getConnectionDataPackage() != mIRConnectionPackage) continue;
                    mIRElement2 = object;
                    break;
                }
            }
            if (mIRElement2 != null) {
                if (TEMPORARY.equals(mIRElement2.getNativeType())) {
                    mIRConnectionPackage = null;
                    mIRElement = mIRElement2;
                } else {
                    ((MIRClassifier)mIRElement).setLineageOptions(((MIRClassifier)mIRElement2).getLineageOptions());
                    this.copyFeatures((MIRClassifier)mIRElement2, (MIRClassifier)mIRElement);
                }
            }
            if (MIRExpressionAnalyzerHelper.isCreateOperation(mIRElementNode)) {
                MIRClass mIRClass;
                object2 = mIRElementNode.getElementNamePartByPosition().get(mIRElementNode.getElementNamePartCount() - 1);
                boolean bl = ((MIRElementNamePart)object2).getQuoted();
                String string = MIRExpressionAnalyzerHelper.getCanonicalName(((MIRObject)object2).getName(), bl, this.getDatabaseType());
                MIRStoredProcedure mIRStoredProcedure = ((MIRDataSet)this.paramsDataSet).getParametersOfStoredProcedure();
                MIRClass mIRClass2 = mIRClass = mIRStoredProcedure.getAssociatedClass() != null ? mIRStoredProcedure.getAssociatedClass() : null;
                if (mIRClass != null && this.getItems(string, bl, mIRClass.getOperations()).isEmpty() || mIRClass == null && this.getItems(string, bl, this.defaultSchema.getNamespaceElements()).isEmpty()) {
                    MIRStoredProcedure mIRStoredProcedure2 = new MIRStoredProcedure();
                    mIRStoredProcedure2.setName(string);
                    mIRStoredProcedure2.setSemantics(this.getStatementMetaInfo(mIRElementNode).getText());
                    if (mIRClass != null) {
                        mIRClass.addOperation(mIRStoredProcedure2);
                    } else {
                        this.defaultSchema.addNamespaceElement(mIRStoredProcedure2);
                    }
                    MIRDataSet mIRDataSet = new MIRDataSet();
                    mIRDataSet.setName(mIRStoredProcedure2.getName());
                    mIRDataSet.setLineageOption(1024);
                    mIRStoredProcedure2.addResultDataSet(mIRDataSet);
                    MIRClassifierMap mIRClassifierMap = new MIRClassifierMap();
                    mIRDataSet.addClassifierMap(mIRClassifierMap);
                    mIRClassifierMap.addDestinationClassifier(mIRDataSet);
                    mIRClassifierMap.addSourceClassifier((MIRClassifier)mIRElement);
                    MIRDataSet mIRDataSet2 = new MIRDataSet();
                    mIRDataSet2.setName(mIRStoredProcedure2.getName() + SP_PARAMETERS_SUFFIX);
                    mIRDataSet2.setLineageOption(1024);
                    mIRStoredProcedure2.addParametersDataSet(mIRDataSet2);
                    this.nestedParamsDataSet = mIRDataSet2;
                    this.setTemporary((MIRClassifier)mIRElement);
                } else if (MIRExpressionAnalyzerHelper.match(string, bl, mIRStoredProcedure, this.getCollationMode())) {
                    this.cm.addSourceClassifier((MIRClassifier)mIRElement);
                }
            } else if (MIRExpressionAnalyzerHelper.isCreateTable(mIRElementNode)) {
                if (MIRExpressionAnalyzerHelper.isCreateTmpTable(mIRElementNode, this.getDatabaseType())) {
                    mIRConnectionPackage = null;
                    this.setTemporary((MIRClassifier)mIRElement);
                }
                this.fullyDefinedTables.add((MIRQueryTable)mIRElement);
            } else if (MIRExpressionAnalyzerHelper.isDropTable(mIRElementNode)) {
                if (mIRConnectionPackage != null) {
                    if (mIRElement2 != null) {
                        object2 = this.getItems(mIRElement.getName(), mIRElementNamePart.getQuoted(), mIRConnectionPackage.getClassifiers());
                        object = object2.iterator();
                        while (object.hasNext()) {
                            MIRClassifier mIRClassifier = (MIRClassifier)object.next();
                            this.setTemporary(mIRClassifier);
                        }
                    }
                    if ((object2 = mIRConnectionPackage.getNamespaceElement(mIRElement.getName())) instanceof MIRConnectionDataSet) {
                        this.setTemporary((MIRConnectionDataSet)object2);
                    }
                }
                this.setTemporary((MIRClassifier)mIRElement);
            }
            object2 = null;
            if (mIRElementNode.getDestinationElementType() == 23 && this.paramsDataSet instanceof MIRDataSet) {
                object2 = ((MIRDataSet)this.paramsDataSet).getParametersOfStoredProcedure();
            }
            if (mIRConnectionPackage != null && (object2 == null || ((MIROperation)object2).getAssociatedClass() == null)) {
                mIRConnectionPackage.addClassifier((MIRClassifier)mIRElement);
            }
            this.setCollationLineageOption(mIRElement, mIRElementNamePart.getQuoted());
        }
        return mIRElement;
    }

    private void setTemporary(MIRClassifier mIRClassifier) {
        mIRClassifier.setLineageOption(1024);
        mIRClassifier.setNativeType(TEMPORARY);
        for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
            mIRFeature.setLineageOption(1024);
        }
    }

    private MIRNamespaceElement getItem(MIRConnectionPackage mIRConnectionPackage, String string, boolean bl) {
        MIRNamespaceElement mIRNamespaceElement = this.getItem(string, bl, mIRConnectionPackage.getNamespaceElements());
        if (mIRNamespaceElement == null) {
            mIRNamespaceElement = this.getItem(string, bl, mIRConnectionPackage.getImportedNamespaceElements());
        }
        if (mIRNamespaceElement == null) {
            mIRNamespaceElement = this.getItem(string, bl, mIRConnectionPackage.getClassifiers());
        }
        return mIRNamespaceElement;
    }

    private void copyFeatures(MIRClassifier mIRClassifier, MIRClassifier mIRClassifier2) {
        for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
            MIRQueryColumn mIRQueryColumn = new MIRQueryColumn((MIRQueryColumn)mIRFeature);
            mIRQueryColumn.setLineageOption(512);
            mIRQueryColumn.setLineageOption(1024);
            mIRClassifier2.addFeatureUniqueName(mIRQueryColumn);
        }
    }

    @Override
    public boolean isClassifierDefined(MIRClassifier mIRClassifier) {
        if (mIRClassifier == null) {
            return false;
        }
        if (this.fullyDefinedTables.contains(mIRClassifier)) {
            return true;
        }
        MIRClassifier mIRClassifier2 = this.getItem(MIRBridgeLib.getPhysicalName(mIRClassifier), mIRClassifier.hasLineageOption(4096), this.predefinedClassifiers);
        if (mIRClassifier2 != null && mIRClassifier2.getFeatureCount() > 0) {
            for (MIRFeature mIRFeature : mIRClassifier2.getFeatureByPosition()) {
                String string = MIRBridgeLib.getPhysicalName(mIRFeature);
                MIRFeature mIRFeature2 = this.getItem(MIRBridgeLib.getPhysicalName(mIRFeature), mIRFeature.hasLineageOption(4096), mIRClassifier.getFeatures());
                if (mIRFeature2 == null && mIRFeature.getPosition() > 0) {
                    mIRFeature2 = this.getFeatureByPosition(mIRClassifier, mIRFeature.getPosition());
                }
                if (mIRFeature2 != null) continue;
                mIRFeature2 = this.createFeature(mIRClassifier);
                mIRFeature2.setPosition(mIRFeature.getPosition());
                mIRFeature2.setName(string);
                mIRClassifier.addFeature(mIRFeature2);
            }
            return true;
        }
        for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
            if (!mIRFeature.hasLineageOption(512) && !mIRFeature.hasLineageOption(256)) continue;
            return true;
        }
        MIRFeature mIRFeature = this.createFeature(mIRClassifier);
        mIRFeature.setName("*");
        mIRFeature.setLineageOption(256);
        mIRClassifier.addFeature(mIRFeature);
        return true;
    }

    @Override
    public boolean isStarCandidate(MIRFeature mIRFeature, boolean bl) {
        return bl && (mIRFeature.getPosition() > 0 || mIRFeature.hasLineageOption(256));
    }

    @Override
    public boolean captureConstantExpressions() {
        return true;
    }

    @Override
    public boolean supportFunctionCalls() {
        return true;
    }

    @Override
    public void move(MIRClassifier mIRClassifier, MIRClassifier mIRClassifier2) {
        List<Object> list;
        if (mIRClassifier2 != null && mIRClassifier2.getFeatureCount() == 0) {
            Object object;
            list = new LinkedList();
            MIRConnectionDataPackage mIRConnectionDataPackage = (MIRConnectionDataPackage)mIRClassifier.getNamespace();
            List<MIRClassifier> list2 = this.getItems(mIRClassifier.getName(), mIRClassifier.hasLineageOption(4096), mIRConnectionDataPackage.getClassifiers());
            for (MIRClassifier mIRModelObject : list2) {
                for (MIRFeature mIRFeature : mIRModelObject.getFeatures()) {
                    if (mIRFeature.getPosition() <= 0) continue;
                    list.add(mIRFeature);
                }
                if (list.isEmpty()) continue;
                break;
            }
            if (list.isEmpty()) {
                for (MIRFeature mIRFeature : mIRClassifier.getFeatureByPosition()) {
                    if (!mIRFeature.hasLineageOption(256)) continue;
                    list.add(mIRFeature);
                    break;
                }
                if (list.isEmpty()) {
                    MIRFeature mIRFeature = this.createFeature(mIRClassifier);
                    mIRFeature.setName("*");
                    mIRFeature.setLineageOption(256);
                    mIRClassifier.addFeature(mIRFeature);
                    list.add(mIRFeature);
                }
            } else {
                for (MIRFeature mIRFeature : list) {
                    object = null;
                    object = mIRFeature.getPosition() > 0 ? this.getFeatureByPosition(mIRClassifier, mIRFeature.getPosition()) : this.getItem(mIRFeature.getName(), mIRFeature.hasLineageOption(4096), mIRClassifier.getFeatures());
                    if (object != null) continue;
                    object = this.createFeature(mIRClassifier);
                    ((MIRObject)object).setName(mIRFeature.getName());
                    ((MIRFeature)object).setLineageOptions(mIRFeature.getLineageOptions());
                    ((MIRFeature)object).setPosition(mIRFeature.getPosition());
                    if (mIRFeature.getPosition() > 0) {
                        mIRClassifier.addFeatureUniqueName((MIRFeature)object);
                        continue;
                    }
                    mIRClassifier.addFeature((MIRFeature)object);
                }
            }
            for (MIRFeature mIRFeature : mIRClassifier.getFeatureByPosition()) {
                object = new MIRQueryColumn();
                ((MIRObject)object).setName(mIRFeature.getName());
                ((MIRFeature)object).setLineageOptions(mIRFeature.getLineageOptions());
                ((MIRFeature)object).setPosition(mIRFeature.getPosition());
                mIRClassifier2.addFeature((MIRFeature)object);
                MIRFeatureMap mIRFeatureMap = MIRBridgeLib.getDestinationOfFeatureMap((MIRFeature)object, true);
                if (mIRFeature.hasLineageOption(256)) {
                    mIRFeatureMap.setBulk(true);
                }
                MIRBridgeLib.addSourceFeature(mIRFeatureMap, mIRFeature);
            }
        }
        if ((list = this.getItems(mIRClassifier.getName(), mIRClassifier.hasLineageOption(4096), this.fullyDefinedTables)) != null && !list.isEmpty()) {
            this.setTemporary(mIRClassifier);
        }
    }
}

