/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib;

import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.bridgelib.MIRTypeLib;
import MITI.bridges.bridgelib.MIRUdpLib;
import MITI.literals.BridgeLibLiterals;
import MITI.sdk.MIRAssociation;
import MITI.sdk.MIRAssociationRole;
import MITI.sdk.MIRAssociationRoleNameMap;
import MITI.sdk.MIRAttribute;
import MITI.sdk.MIRBaseType;
import MITI.sdk.MIRCandidateKey;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRClassType;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDerivedType;
import MITI.sdk.MIRDesignPackage;
import MITI.sdk.MIRDiagram;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRFlatTextFile;
import MITI.sdk.MIRForeignKey;
import MITI.sdk.MIRIndex;
import MITI.sdk.MIRIndexMember;
import MITI.sdk.MIRKey;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRModelElement;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRPresentationElement;
import MITI.sdk.MIRPropertyType;
import MITI.sdk.MIRPropertyValue;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIRStructuralFeature;
import MITI.sdk.MIRType;
import MITI.sdk.MIR_Object;
import MITI.sdk.util.ObjectCollector;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class MIRRelationalLib {
    public static void createARNM(MIRAttribute mIRAttribute, MIRAttribute mIRAttribute2, MIRForeignKey mIRForeignKey, boolean bl) {
        if (mIRAttribute.getName().equals(mIRAttribute2.getName()) && !bl) {
            return;
        }
        MIRAssociationRoleNameMap mIRAssociationRoleNameMap = null;
        for (MIRAssociationRoleNameMap mIRAssociationRoleNameMap2 : mIRForeignKey.getAssociationRoleNameMaps()) {
            if (mIRAssociationRoleNameMap2.getDestinationAttribute() != mIRAttribute2 || mIRAssociationRoleNameMap2.getSourceAttribute() != mIRAttribute) continue;
            mIRAssociationRoleNameMap = mIRAssociationRoleNameMap2;
            break;
        }
        if (mIRAssociationRoleNameMap == null) {
            mIRAssociationRoleNameMap = new MIRAssociationRoleNameMap();
            mIRAssociationRoleNameMap.addForeignKey(mIRForeignKey);
            mIRAssociationRoleNameMap.addDestinationAttribute(mIRAttribute2);
            mIRAssociationRoleNameMap.addSourceAttribute(mIRAttribute);
        }
    }

    public static void getSubjectAreaObjects(MIRDesignPackage mIRDesignPackage, HashSet<MIRNamespaceElement> hashSet) {
        Object object;
        Object object2;
        Iterator<MIRNamespaceElement> iterator = mIRDesignPackage.getNamespaceElementIterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            hashSet.add((MIRNamespaceElement)object2);
        }
        object2 = mIRDesignPackage.getImportedNamespaceElementIterator();
        while (object2.hasNext()) {
            object = (MIRNamespaceElement)object2.next();
            hashSet.add((MIRNamespaceElement)object);
        }
        object = mIRDesignPackage.getDiagramIterator();
        while (object.hasNext()) {
            Object object3;
            MIRDiagram mIRDiagram = (MIRDiagram)object.next();
            if (mIRDiagram.getElementType() != 11) continue;
            Iterator<MIRModelElement> iterator2 = mIRDiagram.getModelElementIterator();
            while (iterator2.hasNext()) {
                object3 = iterator2.next();
                if (!((MIR_Object)object3).isInstanceOf((short)211)) continue;
                hashSet.add((MIRNamespaceElement)object3);
            }
            object3 = mIRDiagram.getPresentationElementIterator();
            while (object3.hasNext()) {
                MIRPresentationElement mIRPresentationElement = (MIRPresentationElement)object3.next();
                MIRModelObject mIRModelObject = mIRPresentationElement.getSubjectModelObject();
                if (mIRModelObject == null || !mIRModelObject.isInstanceOf((short)211)) continue;
                hashSet.add((MIRNamespaceElement)mIRModelObject);
            }
        }
    }

    public static boolean isAk(MIRFeature mIRFeature) {
        if (mIRFeature.getElementType() == 14) {
            MIRAttribute mIRAttribute = (MIRAttribute)mIRFeature;
            for (MIRKey mIRKey : mIRAttribute.getKeys()) {
                if (mIRKey.getElementType() != 21 || ((MIRCandidateKey)mIRKey).getPrimaryOfClass() != null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isFk(MIRFeature mIRFeature) {
        if (mIRFeature.getElementType() == 14) {
            MIRAttribute mIRAttribute = (MIRAttribute)mIRFeature;
            for (MIRKey mIRKey : mIRAttribute.getKeys()) {
                if (mIRKey.getElementType() != 22) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPk(MIRFeature mIRFeature) {
        if (mIRFeature.getElementType() == 14) {
            MIRAttribute mIRAttribute = (MIRAttribute)mIRFeature;
            for (MIRKey mIRKey : mIRAttribute.getKeys()) {
                if (mIRKey.getElementType() != 21 || ((MIRCandidateKey)mIRKey).getPrimaryOfClass() == null) continue;
                return true;
            }
        }
        return false;
    }

    public static String getOptional(MIRFeature mIRFeature) {
        if (mIRFeature.isInstanceOf((short)99) && !((MIRStructuralFeature)mIRFeature).getOptional()) {
            return "NOT NULL";
        }
        return "NULL";
    }

    public static ClassifierParsedName splitClassifierQualifiedName(String string) {
        ClassifierParsedName classifierParsedName = new ClassifierParsedName();
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 1) {
            classifierParsedName.classifierName = MIRBridgeLib.removeQuotes(stringArray[0]);
        } else if (stringArray.length == 2) {
            classifierParsedName.schemaName = MIRBridgeLib.removeQuotes(stringArray[0]);
            classifierParsedName.classifierName = MIRBridgeLib.removeQuotes(stringArray[1]);
        } else if (stringArray.length >= 3) {
            classifierParsedName.databaseName = MIRBridgeLib.removeQuotes(stringArray[stringArray.length - 3]);
            classifierParsedName.schemaName = MIRBridgeLib.removeQuotes(stringArray[stringArray.length - 2]);
            classifierParsedName.classifierName = MIRBridgeLib.removeQuotes(stringArray[stringArray.length - 1]);
        }
        return classifierParsedName;
    }

    private static boolean isAlreadyMigrated(MIRAttribute mIRAttribute, MIRForeignKey mIRForeignKey) {
        Iterator<MIRAssociationRoleNameMap> iterator = mIRForeignKey.getAssociationRoleNameMapIterator();
        while (iterator.hasNext()) {
            if (iterator.next().getSourceAttribute() != mIRAttribute) continue;
            return true;
        }
        MIRAttribute mIRAttribute2 = (MIRAttribute)mIRForeignKey.getAssociatedClass().getFeature(mIRAttribute.getName());
        if (mIRAttribute2 == null || !mIRForeignKey.containsAttribute(mIRAttribute2)) {
            return false;
        }
        iterator = mIRForeignKey.getAssociationRoleNameMapIterator();
        while (iterator.hasNext()) {
            if (iterator.next().getDestinationAttribute() != mIRAttribute2) continue;
            return false;
        }
        return true;
    }

    private static boolean attributeHasSameOriginatingPK(MIRCandidateKey mIRCandidateKey, MIRAttribute mIRAttribute) {
        Iterator<MIRKey> iterator = mIRAttribute.getKeyIterator();
        while (iterator.hasNext()) {
            MIRKey mIRKey = iterator.next();
            if (mIRKey.getElementType() != 22 || ((MIRForeignKey)mIRKey).getCandidateKey() != mIRCandidateKey) continue;
            return true;
        }
        return false;
    }

    private static void keyAddAttribute(boolean bl, MIRKey mIRKey, MIRAttribute mIRAttribute, int n, int n2) {
        Object object;
        MIRIndex mIRIndex = mIRKey.getIndex();
        if (n != 0 && mIRIndex != null) {
            object = mIRIndex.getIndexMemberIterator();
            while (object.hasNext()) {
                MIRIndexMember mIRIndexMember = object.next();
                if (mIRIndexMember.getPosition() < n - 1 + n2) continue;
                mIRIndexMember.setPosition((short)(mIRIndexMember.getPosition() + 1));
            }
        }
        if (!mIRKey.containsAttribute(mIRAttribute)) {
            mIRKey.addAttribute(mIRAttribute);
            if (mIRIndex != null) {
                object = new MIRIndexMember();
                ((MIRIndexMember)object).addIndex(mIRIndex);
                ((MIRIndexMember)object).addAttribute(mIRAttribute);
                if (n != 0) {
                    ((MIRIndexMember)object).setPosition((short)(n - 1 + n2));
                } else {
                    ((MIRIndexMember)object).setPosition((short)(mIRIndex.getIndexMemberCount() - 1));
                }
            }
        }
    }

    private static int getAttributeIndex(MIRClass mIRClass, String string) {
        int n = 0;
        Iterator<MIRFeature> iterator = mIRClass.getFeatureIterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().getName();
            if (!string2.startsWith(string) || string2.length() <= string.length() || string2.charAt(string.length()) != '/') continue;
            int n2 = 0;
            try {
                n2 = Integer.parseInt(string2.substring(string.length() + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private static void migrateAttributes(MIRCandidateKey mIRCandidateKey, MIRClass mIRClass, MIRForeignKey mIRForeignKey, MIRCandidateKey mIRCandidateKey2, int n, boolean bl) {
        boolean bl2;
        Iterator<MIRModelObject> iterator;
        int n2 = 0;
        TreeSet<MIRAttribute> treeSet = new TreeSet<MIRAttribute>(new Comparator<MIRAttribute>(){

            @Override
            public int compare(MIRAttribute mIRAttribute, MIRAttribute mIRAttribute2) {
                return mIRAttribute.getPosition() - mIRAttribute2.getPosition();
            }
        });
        if (mIRCandidateKey.getIndex() != null) {
            iterator = mIRCandidateKey.getIndex().getIndexMemberByPosition().iterator();
            while (iterator.hasNext()) {
                treeSet.add(((MIRIndexMember)iterator.next()).getAttribute());
            }
        } else {
            iterator = mIRCandidateKey.getAttributeIterator();
            while (iterator.hasNext()) {
                treeSet.add((MIRAttribute)iterator.next());
            }
        }
        MIRAssociationRole mIRAssociationRole = mIRForeignKey.getAssociationRole();
        if (mIRCandidateKey2 != null || mIRAssociationRole == null) {
            bl2 = false;
        } else {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(2);
            MIRBridgeLib.decodeMultiplicity(MIRBridgeLib.findReverseRole(mIRAssociationRole).getMultiplicity(), hashMap);
            bl2 = hashMap.get("min") == MIRBridgeLib.CARD_UNKNOWN || hashMap.get("min") == MIRBridgeLib.CARD_UNSPECIFIED || hashMap.get("min") == 0;
        }
        int n3 = 0;
        for (MIRAttribute mIRAttribute : treeSet) {
            if (MIRRelationalLib.isAlreadyMigrated(mIRAttribute, mIRForeignKey)) continue;
            MIRAttribute mIRAttribute2 = (MIRAttribute)mIRClass.getFeature(mIRAttribute.getName());
            if (mIRAttribute2 == null || bl) {
                mIRAttribute2 = new MIRAttribute(mIRAttribute);
                mIRAttribute2.setPosition((short)0);
                mIRAttribute2.setNativeId("");
                MIRUdpLib.copyPropertyValues(mIRAttribute, mIRAttribute2);
                mIRAttribute2.setOptional(bl2);
                MIRRelationalLib.migrateAttribute(mIRAttribute, mIRClass, mIRAttribute2, mIRCandidateKey2, n, n2++, mIRForeignKey);
            } else {
                String string;
                Object object;
                int n4;
                int n5 = 1;
                do {
                    n4 = 0;
                    boolean bl3 = false;
                    object = mIRAttribute2.getKeyIterator();
                    while (object.hasNext()) {
                        MIRKey mIRKey = object.next();
                        if (mIRKey.getElementType() == 21 && ((MIRCandidateKey)mIRKey).getPrimaryOfClass() != null) {
                            n4 = 1;
                        }
                        if (mIRKey.getElementType() != 22) continue;
                        bl3 = true;
                    }
                    if (!bl3) {
                        string = mIRAttribute.getName() + "/" + n5;
                        mIRAttribute2 = (MIRAttribute)mIRClass.getFeature(string);
                        ++n5;
                        continue;
                    }
                    if (mIRCandidateKey2 != null && n4 != 0 || mIRCandidateKey2 == null && n4 == 0) break;
                    string = mIRAttribute.getName() + "/" + n5;
                    mIRAttribute2 = (MIRAttribute)mIRClass.getFeature(string);
                    ++n5;
                } while (mIRAttribute2 != null);
                if (mIRAttribute2 == null || mIRClass == mIRAttribute.getClassifier() || MIRRelationalLib.attributeHasSameOriginatingPK(mIRCandidateKey, mIRAttribute2)) {
                    mIRAttribute2 = new MIRAttribute(mIRAttribute);
                    mIRAttribute2.setPosition((short)0);
                    mIRAttribute2.setNativeId("");
                    MIRUdpLib.copyPropertyValues(mIRAttribute, mIRAttribute2);
                    string = mIRAttribute.getName();
                    n4 = MIRRelationalLib.getAttributeIndex(mIRClass, string);
                    String string2 = string + "/" + ++n4;
                    mIRAttribute2.setName(string2);
                    object = MIRBridgeLib.getPhysicalName(mIRAttribute) + "_" + n4;
                    mIRAttribute2.setPhysicalName((String)object);
                    MIRRelationalLib.migrateAttribute(mIRAttribute, mIRClass, mIRAttribute2, mIRCandidateKey2, n, n2++, mIRForeignKey);
                }
                if (!mIRAttribute2.getName().equals(mIRAttribute.getName())) {
                    MIRRelationalLib.createARNM(mIRAttribute, mIRAttribute2, mIRForeignKey, false);
                }
            }
            MIRRelationalLib.keyAddAttribute(false, mIRForeignKey, mIRAttribute2, n, n3);
            if (mIRCandidateKey2 != null && mIRClass != mIRAttribute.getClassifier()) {
                MIRRelationalLib.keyAddAttribute(true, mIRCandidateKey2, mIRAttribute2, n, n3);
            }
            mIRAttribute2.setOptional(bl2);
            ++n3;
        }
    }

    private static void migrateAttribute(MIRAttribute mIRAttribute, MIRClass mIRClass, MIRAttribute mIRAttribute2, MIRCandidateKey mIRCandidateKey, int n, int n2, MIRForeignKey mIRForeignKey) {
        Object object;
        MIRModelObject mIRModelObject;
        Object object2;
        MIRType mIRType = mIRAttribute.getType();
        if (mIRType.getDataType().equals("AUTOINCREMENT")) {
            object2 = mIRType.getModel().getTypeIterator();
            while (object2.hasNext()) {
                mIRModelObject = (MIRType)object2.next();
                if (((MIRType)mIRModelObject).getElementType() != 4 || !((MIRType)mIRModelObject).getDataType().equals("undefined")) continue;
                mIRAttribute2.addType((MIRType)mIRModelObject);
                break;
            }
        } else {
            mIRAttribute2.addType(mIRType);
        }
        object2 = mIRClass.getFeatureByPosition();
        if (object2.size() > 0) {
            mIRModelObject = (MIRAttribute)object2.get(object2.size() - 1);
            mIRAttribute2.setPosition((short)(((MIRFeature)mIRModelObject).getPosition() + 1));
        } else {
            mIRAttribute2.setPosition((short)0);
        }
        if (mIRCandidateKey != null) {
            MIRModelObject mIRModelObject2;
            if (n != 0 && mIRCandidateKey.getIndex() != null) {
                Object object4;
                mIRModelObject = mIRCandidateKey.getIndex();
                object = ((MIRIndex)mIRModelObject).getIndexMemberByPosition().iterator();
                int n3 = 0;
                while (object.hasNext() && ((MIRIndexMember)(object4 = (MIRIndexMember)object.next())).getPosition() < n - 1 + n2) {
                    n3 = ((MIRIndexMember)object4).getAttribute().getPosition() + 1;
                }
                for (MIRAttribute object32 : mIRClass.getFeatureByPosition()) {
                    if (object32.getPosition() < n3) continue;
                    object32.setPosition((short)(object32.getPosition() + 1));
                }
                Iterator<MIRAssociationRole> iterator = mIRClass.getAssociationRoleIterator();
                while (iterator.hasNext()) {
                    mIRModelObject2 = iterator.next();
                    if (!((MIRAssociationRole)mIRModelObject2).getSource()) continue;
                    ((MIRAssociationRole)mIRModelObject2).setPosition((short)(((MIRAssociationRole)mIRModelObject2).getPosition() + 1));
                }
                mIRAttribute2.setPosition((short)n3);
            } else {
                Object object5;
                short s = 0;
                object = mIRClass.getFeatureIterator();
                while (object.hasNext()) {
                    object5 = (MIRAttribute)((Object)object.next());
                    boolean bl = false;
                    Iterator<MIRKey> iterator = ((MIRAttribute)object5).getKeyIterator();
                    while (iterator.hasNext()) {
                        mIRModelObject2 = iterator.next();
                        if (((MIRKey)mIRModelObject2).getElementType() != 21 || ((MIRCandidateKey)mIRModelObject2).getPrimaryOfClass() == null) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    s = ((MIRFeature)object5).getPosition();
                    break;
                }
                object = mIRClass.getFeatureIterator();
                while (object.hasNext()) {
                    object5 = (MIRAttribute)object.next();
                    if (((MIRFeature)object5).getPosition() < s) continue;
                    ((MIRFeature)object5).setPosition((short)(((MIRFeature)object5).getPosition() + 1));
                }
                object5 = mIRClass.getAssociationRoleIterator();
                while (object5.hasNext()) {
                    MIRAssociationRole mIRAssociationRole = (MIRAssociationRole)object5.next();
                    if (!mIRAssociationRole.getSource()) continue;
                    mIRAssociationRole.setPosition((short)(mIRAssociationRole.getPosition() + 1));
                }
                mIRAttribute2.setPosition(s);
            }
        }
        Iterator<MIRFeature> iterator = mIRClass.getFeatureIterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (((MIRModelObject)object).getPhysicalName().isEmpty() || !((MIRModelObject)object).getPhysicalName().equals(mIRAttribute2.getPhysicalName())) continue;
            mIRAttribute2.setPhysicalName("");
            break;
        }
        mIRClass.addFeatureUniqueName(mIRAttribute2, '/');
        if (!mIRAttribute.getName().equals(mIRAttribute2.getName())) {
            mIRAttribute2.setPhysicalName("");
            MIRRelationalLib.createARNM(mIRAttribute, mIRAttribute2, mIRForeignKey, false);
        }
    }

    private static String getQuotedString(String string, String string2, String string3) {
        if (string.indexOf(32) != -1) {
            String string4 = string2 + string + string3;
            return string4;
        }
        return string;
    }

    public static String getQualifiedPhysicalName(MIRModelObject mIRModelObject) {
        MIRNamespaceElement mIRNamespaceElement;
        MIRDataPackage mIRDataPackage;
        if (mIRModelObject == null) {
            return "";
        }
        String string = "\"";
        String string2 = "\"";
        MIRModel mIRModel = mIRModelObject.getRootModel();
        if (mIRModel.getSystemType().equalsIgnoreCase("MICROSOFT SQL SERVER") || mIRModel.getSystemType().equalsIgnoreCase("MICROSOFT SQL AZURE")) {
            string = "[";
            string2 = "]";
        }
        String string3 = MIRBridgeLib.getPhysicalName(mIRModelObject);
        String string4 = "";
        if (mIRModelObject.isInstanceOf((short)211) && (mIRDataPackage = (mIRNamespaceElement = (MIRNamespaceElement)mIRModelObject).getDataPackage()) != null && mIRDataPackage.getElementType() == 72) {
            string4 = MIRBridgeLib.getPhysicalName(mIRDataPackage);
        }
        if (!string4.isEmpty() && !string3.isEmpty()) {
            return MIRRelationalLib.getQuotedString(string4, string, string2) + "." + MIRRelationalLib.getQuotedString(string3, string, string2);
        }
        if (!string3.isEmpty()) {
            return MIRRelationalLib.getQuotedString(string3, string, string2);
        }
        return "";
    }

    private static void createForeignKeyOnMiddleClass(MIRClass mIRClass, MIRCandidateKey mIRCandidateKey, MIRAssociationRole mIRAssociationRole) {
        MIRForeignKey mIRForeignKey = new MIRForeignKey();
        mIRAssociationRole.addForeignKey(mIRForeignKey);
        mIRCandidateKey.addForeignKey(mIRForeignKey);
        mIRForeignKey.addAssociatedClass(mIRClass);
        MIRRelationalLib.migrateAttributes(mIRCandidateKey, mIRClass, mIRForeignKey, null, 0, false);
    }

    private static void processUMLAssociationClass(MIRAssociation mIRAssociation) {
        MIRModelObject mIRModelObject;
        MIRClass mIRClass = mIRAssociation.getAssociatedClass();
        MIRAssociationRole mIRAssociationRole = null;
        MIRAssociationRole mIRAssociationRole2 = null;
        Iterator<MIRAssociationRole> iterator = mIRAssociation.getAssociationRoleIterator();
        while (iterator.hasNext()) {
            mIRModelObject = iterator.next();
            if (((MIRAssociationRole)mIRModelObject).getSource()) {
                if (mIRAssociationRole == null) {
                    mIRAssociationRole = mIRModelObject;
                    continue;
                }
                mIRAssociationRole2 = mIRModelObject;
                continue;
            }
            if (mIRAssociationRole2 == null) {
                mIRAssociationRole2 = mIRModelObject;
                continue;
            }
            mIRAssociationRole = mIRModelObject;
        }
        if (mIRAssociationRole == null || mIRAssociationRole2 == null) {
            return;
        }
        mIRModelObject = mIRAssociationRole.getAssociatedClass();
        MIRClass mIRClass2 = mIRAssociationRole2.getAssociatedClass();
        if (mIRModelObject == null || mIRClass2 == null) {
            return;
        }
        MIRAssociation mIRAssociation2 = new MIRAssociation(mIRAssociation);
        mIRAssociation2.setDesignLevel(mIRAssociation.getDesignLevel());
        mIRAssociation2.setAggregation(true);
        mIRClass2.getNamespace().addNamespaceElementUniqueName(mIRAssociation2);
        MIRAssociationRole mIRAssociationRole3 = new MIRAssociationRole();
        MIRAssociationRole mIRAssociationRole4 = new MIRAssociationRole(mIRAssociationRole2);
        mIRAssociationRole3.setSource(true);
        mIRAssociationRole4.setSource(false);
        mIRAssociationRole3.setMultiplicity("1");
        Iterator<MIRDiagram> iterator2 = mIRAssociation.getDiagramIterator();
        while (iterator2.hasNext()) {
            mIRAssociation2.addDiagram(iterator2.next());
        }
        mIRAssociationRole3.addAssociatedClass((MIRClass)mIRModelObject);
        mIRAssociationRole4.addAssociatedClass(mIRClass);
        mIRAssociation2.addAssociationRole(mIRAssociationRole3);
        mIRAssociation2.addAssociationRole(mIRAssociationRole4);
        MIRAssociation mIRAssociation3 = new MIRAssociation(mIRAssociation);
        mIRAssociation3.setDesignLevel(mIRAssociation.getDesignLevel());
        mIRAssociation3.setAggregation(true);
        mIRClass2.getNamespace().addNamespaceElementUniqueName(mIRAssociation3);
        MIRAssociationRole mIRAssociationRole5 = new MIRAssociationRole();
        MIRAssociationRole mIRAssociationRole6 = new MIRAssociationRole(mIRAssociationRole);
        mIRAssociationRole5.setSource(true);
        mIRAssociationRole6.setSource(false);
        mIRAssociationRole5.setMultiplicity("1");
        iterator2 = mIRAssociation.getDiagramIterator();
        while (iterator2.hasNext()) {
            mIRAssociation3.addDiagram(iterator2.next());
        }
        mIRAssociationRole5.addAssociatedClass(mIRClass2);
        mIRAssociationRole6.addAssociatedClass(mIRClass);
        mIRAssociation3.addAssociationRole(mIRAssociationRole5);
        mIRAssociation3.addAssociationRole(mIRAssociationRole6);
        MIRCandidateKey mIRCandidateKey = ((MIRClass)mIRModelObject).getPrimaryCandidateKey();
        if (mIRCandidateKey != null) {
            MIRRelationalLib.createForeignKeyOnMiddleClass(mIRClass, mIRCandidateKey, mIRAssociationRole4);
        }
        if ((mIRCandidateKey = mIRClass2.getPrimaryCandidateKey()) != null) {
            MIRRelationalLib.createForeignKeyOnMiddleClass(mIRClass, mIRCandidateKey, mIRAssociationRole6);
        }
        mIRAssociationRole.delete();
        mIRAssociationRole2.delete();
        mIRAssociation.delete();
    }

    public static void processUMLAssociationClasses(MIRStoreModel mIRStoreModel) {
        ObjectCollector objectCollector = new ObjectCollector(new short[]{13});
        Set set = objectCollector.collect(mIRStoreModel);
        for (MIRClass mIRClass : set) {
            MIRAssociation mIRAssociation = mIRClass.getAssociation();
            if (mIRAssociation == null) continue;
            MIRRelationalLib.processUMLAssociationClass(mIRAssociation);
        }
    }

    public static void processUMLClassTypes(MIRStoreModel mIRStoreModel, boolean bl) {
        MIRModelObject mIRModelObject2;
        HashMap<String, MIRClass> hashMap = new HashMap<String, MIRClass>();
        ObjectCollector objectCollector = new ObjectCollector(new short[]{13});
        Set set = objectCollector.collect(mIRStoreModel);
        for (MIRModelObject mIRModelObject2 : set) {
            if (mIRModelObject2.getNativeId().isEmpty()) continue;
            hashMap.put(mIRModelObject2.getNativeId(), (MIRClass)mIRModelObject2);
        }
        MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRStoreModel, (short)14, "db-ref", (byte)0, "JsonDb", "", "SQL_VARCHAR", false, "");
        mIRModelObject2 = MIRUdpLib.fetchPropertyType(mIRStoreModel, (short)14, "schema-ref", (byte)0, "JsonDb", "", "SQL_VARCHAR", false, "");
        ObjectCollector objectCollector2 = new ObjectCollector(new short[]{14});
        Set set2 = objectCollector2.collect(mIRStoreModel);
        for (MIRAttribute mIRAttribute : set2) {
            MIRClass mIRClass;
            Object object;
            Object object2;
            MIRObject mIRObject;
            MIRObject mIRObject2;
            MIRType mIRType = mIRAttribute.getType();
            if (mIRType.getElementType() == 66) {
                mIRObject2 = ((MIRClassType)mIRType).getAssociatedClass();
                MIRRelationalLib.createAssociation(mIRStoreModel, mIRAttribute, (MIRClass)mIRObject2, bl, "0..1");
            } else if (mIRType.getElementType() == 5 && mIRType.getDataType().equals("SQL_ARRAY") && (mIRObject = MIRRelationalLib.getArrayTypeElement((MIRDerivedType)(mIRObject2 = (MIRDerivedType)mIRType))) != null && ((MIRType)mIRObject).getElementType() == 66) {
                object2 = ((MIRClassType)mIRObject).getAssociatedClass();
                MIRRelationalLib.createAssociation(mIRStoreModel, mIRAttribute, (MIRClass)object2, bl, "0..*");
            }
            if (mIRPropertyType == null || mIRModelObject2 == null) continue;
            mIRObject2 = MIRUdpLib.getPropertyValue(mIRPropertyType, mIRAttribute);
            mIRObject = MIRUdpLib.getPropertyValue((MIRPropertyType)mIRModelObject2, mIRAttribute);
            object2 = "";
            String string = "";
            if (mIRObject == null) continue;
            object2 = ((MIRPropertyValue)mIRObject).getValue();
            if (mIRObject2 != null) {
                string = ((MIRPropertyValue)mIRObject2).getValue();
            } else {
                object = mIRAttribute.getClassifier().getNamespace();
                while (((MIRNamespaceElement)object).getNamespace() != null) {
                    object = ((MIRNamespaceElement)object).getNamespace();
                }
                string = ((MIRObject)object).getName();
            }
            if ((mIRClass = (MIRClass)hashMap.get(object = string + "/" + (String)object2)) == null) continue;
            MIRRelationalLib.createAssociation(mIRStoreModel, mIRAttribute, mIRClass, bl, "0..*");
        }
    }

    public static MIRType getArrayTypeElement(MIRDerivedType mIRDerivedType) {
        MIRType mIRType = mIRDerivedType.getArrayOfType();
        if (mIRType != null && mIRType.getElementType() == 5 && mIRType.getDataType().equals("SQL_ARRAY") && mIRType != mIRDerivedType) {
            mIRType = MIRRelationalLib.getArrayTypeElement((MIRDerivedType)mIRType);
        }
        return mIRType;
    }

    private static void createAssociation(MIRStoreModel mIRStoreModel, MIRAttribute mIRAttribute, MIRClass mIRClass, boolean bl, String string) {
        MIRClass mIRClass2 = (MIRClass)mIRAttribute.getClassifier();
        MIRAssociation mIRAssociation = new MIRAssociation();
        mIRAssociation.setName(mIRAttribute.getName());
        mIRAssociation.setAggregation(false);
        mIRClass.getNamespace().addNamespaceElementUniqueName(mIRAssociation);
        MIRAssociationRole mIRAssociationRole = new MIRAssociationRole();
        MIRAssociationRole mIRAssociationRole2 = new MIRAssociationRole();
        mIRAssociationRole.setSource(true);
        mIRAssociationRole2.setSource(false);
        mIRAssociationRole.setMultiplicity("0..1");
        mIRAssociationRole2.setMultiplicity(string);
        mIRAssociationRole.addAssociatedClass(mIRClass);
        mIRAssociationRole2.addAssociatedClass(mIRClass2);
        mIRAssociation.addAssociationRole(mIRAssociationRole);
        mIRAssociation.addAssociationRole(mIRAssociationRole2);
        MIRBaseType mIRBaseType = MIRTypeLib.getBaseType(mIRStoreModel, "undefined");
        MIRCandidateKey mIRCandidateKey = mIRClass.getPrimaryCandidateKey();
        MIRAttribute mIRAttribute2 = null;
        if (mIRCandidateKey == null) {
            mIRCandidateKey = new MIRCandidateKey();
            mIRCandidateKey.setUniqueKey(true);
            mIRClass.addKey(mIRCandidateKey);
            mIRClass.addPrimaryCandidateKey(mIRCandidateKey);
            mIRAttribute2 = new MIRAttribute();
            mIRAttribute2.setName("fake_id");
            mIRAttribute2.setDescription(BridgeLibLiterals.FAKE_ID_DESCRIPTION.getText());
            if (bl) {
                mIRAttribute2.setDesignLevel((byte)2);
            }
            mIRClass.addFeatureUniqueName(mIRAttribute2);
            mIRCandidateKey.addAttribute(mIRAttribute2);
            mIRAttribute2.addType(mIRBaseType);
        } else {
            mIRAttribute2 = mIRCandidateKey.getAttributes().first();
        }
        MIRForeignKey mIRForeignKey = new MIRForeignKey();
        mIRForeignKey.addAssociatedClass(mIRClass2);
        mIRForeignKey.addAttribute(mIRAttribute);
        mIRForeignKey.addCandidateKey(mIRCandidateKey);
        mIRForeignKey.addAssociationRole(mIRAssociationRole2);
        MIRRelationalLib.createARNM(mIRAttribute2, mIRAttribute, mIRForeignKey, false);
        MIRType mIRType = mIRAttribute.getType();
        if (mIRType instanceof MIRClassType) {
            mIRAttribute.removeType();
            mIRAttribute.addType(mIRAttribute2.getType());
        } else if (mIRType instanceof MIRDerivedType && mIRType.getDataType().equals("SQL_ARRAY")) {
            mIRAttribute.removeType();
            mIRAttribute.addType(mIRAttribute2.getType());
        }
    }

    public static void propagateExternalTableColumnsToFile(MIRClass mIRClass, MIRFlatTextFile mIRFlatTextFile) {
        MIRRelationalLib.propagateExternalTableColumnsToFile(mIRClass, mIRFlatTextFile, false);
    }

    public static void propagateExternalTableColumnsToFile(MIRClass mIRClass, MIRFlatTextFile mIRFlatTextFile, boolean bl) {
        if (mIRClass == null || mIRFlatTextFile == null) {
            return;
        }
        boolean bl2 = mIRFlatTextFile.getFlatFileDescriptor() != null && mIRFlatTextFile.getFlatFileDescriptor().isInstanceOf((short)326);
        short s = 1;
        for (MIRFeature mIRFeature : mIRClass.getFeatureByPosition()) {
            Object object;
            MIRFeature mIRFeature2 = null;
            String string = MIRBridgeLib.getPhysicalName(mIRFeature);
            mIRFeature2 = bl2 && !bl ? MIRBridgeLib.getFeatureByPosition(mIRFlatTextFile, bl2 ? mIRFeature.getPosition() : s) : mIRFlatTextFile.getFeature(string);
            if (mIRFeature2 == null) {
                if (!bl2 && MIRRelationalLib.getHierarchicalType(mIRFeature.getType()) != null) {
                    object = MIRRelationalLib.expandHierarchicalColumn(mIRFeature);
                    for (Map.Entry entry : object.entrySet()) {
                        String string2 = (String)entry.getKey();
                        MIRFeature mIRFeature3 = (MIRFeature)entry.getValue();
                        if (MIRRelationalLib.getHierarchicalType(mIRFeature3.getType()) != null) continue;
                        mIRFeature2 = mIRFlatTextFile.getFeature(string2);
                        if (mIRFeature2 == null) {
                            mIRFeature2 = new MIRAttribute();
                            mIRFeature2.setName(string2);
                            mIRFlatTextFile.addFeature(mIRFeature2);
                            mIRFeature2.addType(mIRFeature3.getType());
                            if (mIRClass.getFeatureCount() == 1 && !(mIRClass.getFeatureByPosition().get(0).getType() instanceof MIRClassType)) {
                                mIRFeature2.setLineageOption(256);
                            } else if (bl) {
                                mIRFeature2.setLineageOption(8192);
                            } else {
                                short s2 = s;
                                s = (short)(s + 1);
                                mIRFeature2.setPosition(s2);
                            }
                        }
                        MIRFeatureMap mIRFeatureMap = MIRBridgeLib.getDestinationOfFeatureMap(mIRFeature3, true);
                        MIRBridgeLib.addSourceFeature(mIRFeatureMap, mIRFeature2);
                        mIRFeatureMap = MIRBridgeLib.getDestinationOfFeatureMap(mIRFeature2, true);
                        MIRBridgeLib.addSourceFeature(mIRFeatureMap, mIRFeature3);
                    }
                    continue;
                }
                mIRFeature2 = (MIRFeature)mIRFeature.clone();
                mIRFeature2.setNativeId("");
                if (mIRClass.getFeatureCount() == 1 && !(mIRClass.getFeatureByPosition().get(0).getType() instanceof MIRClassType)) {
                    mIRFeature2.setLineageOption(256);
                } else if (bl) {
                    mIRFeature2.setLineageOption(8192);
                    mIRFeature2.setPosition((short)0);
                } else {
                    short s3;
                    if (bl2) {
                        s3 = mIRFeature.getPosition();
                    } else {
                        s3 = s;
                        s = (short)(s + 1);
                    }
                    mIRFeature2.setPosition(s3);
                }
                mIRFeature2.addType(mIRFeature.getType());
                mIRFeature2.setName(string);
                mIRFlatTextFile.addFeatureUniqueName(mIRFeature2, '_');
                object = MIRBridgeLib.getDestinationOfFeatureMap(mIRFeature, true);
                MIRBridgeLib.addSourceFeature((MIRFeatureMap)object, mIRFeature2);
                object = MIRBridgeLib.getDestinationOfFeatureMap(mIRFeature2, true);
                MIRBridgeLib.addSourceFeature((MIRFeatureMap)object, mIRFeature);
                continue;
            }
            s = (short)(s + 1);
            object = MIRBridgeLib.getDestinationOfFeatureMap(mIRFeature, true);
            MIRBridgeLib.addSourceFeature((MIRFeatureMap)object, mIRFeature2);
            object = MIRBridgeLib.getDestinationOfFeatureMap(mIRFeature2, true);
            MIRBridgeLib.addSourceFeature((MIRFeatureMap)object, mIRFeature);
        }
    }

    public static MIRAttribute getParentAttribute(MIRAttribute mIRAttribute, MIRForeignKey mIRForeignKey) {
        Object object;
        if (mIRAttribute == null || mIRForeignKey == null) {
            return null;
        }
        MIRCandidateKey mIRCandidateKey = mIRForeignKey.getCandidateKey();
        assert (mIRCandidateKey != null);
        if (mIRCandidateKey == null) {
            return null;
        }
        assert (mIRForeignKey.containsAttribute(mIRAttribute));
        if (!mIRForeignKey.containsAttribute(mIRAttribute)) {
            return null;
        }
        MIRAttribute mIRAttribute2 = null;
        Iterator<MIRAssociationRoleNameMap> iterator = mIRAttribute.getDestinationOfAssociationRoleNameMapIterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (((MIRAssociationRoleNameMap)object).getForeignKey() != mIRForeignKey) continue;
            mIRAttribute2 = ((MIRAssociationRoleNameMap)object).getSourceAttribute();
            break;
        }
        if (mIRAttribute2 != null) {
            if (!mIRCandidateKey.containsAttribute(mIRAttribute2)) {
                return null;
            }
        } else {
            object = mIRCandidateKey.getAttributeIterator();
            while (object.hasNext()) {
                MIRAttribute mIRAttribute3 = (MIRAttribute)object.next();
                if (!mIRAttribute3.getName().equals(mIRAttribute.getName())) continue;
                mIRAttribute2 = mIRAttribute3;
                break;
            }
        }
        return mIRAttribute2;
    }

    public static void reverseRolenamesAssociations(MIRStoreModel mIRStoreModel) {
        ObjectCollector objectCollector = new ObjectCollector(new short[]{17});
        Set set = objectCollector.collect(mIRStoreModel);
        for (MIRAssociation mIRAssociation : set) {
            MIRAssociationRole mIRAssociationRole = MIRBridgeLib.findSourceRole(mIRAssociation);
            MIRAssociationRole mIRAssociationRole2 = MIRBridgeLib.findReverseRole(mIRAssociationRole);
            if (mIRAssociationRole == null || mIRAssociationRole2 == null) continue;
            String string = mIRAssociationRole.getName();
            mIRAssociationRole.setName(mIRAssociationRole2.getName());
            mIRAssociationRole2.setName(string);
        }
    }

    private static MIRClassType getHierarchicalType(MIRType mIRType) {
        if (mIRType instanceof MIRDerivedType) {
            mIRType = ((MIRDerivedType)mIRType).getArrayOfType();
        }
        if (mIRType instanceof MIRClassType) {
            return (MIRClassType)mIRType;
        }
        return null;
    }

    private static Map<String, MIRFeature> expandHierarchicalColumn(MIRFeature mIRFeature) {
        LinkedHashMap<String, MIRFeature> linkedHashMap = new LinkedHashMap<String, MIRFeature>();
        linkedHashMap.put(mIRFeature.getName(), mIRFeature);
        MIRClassType mIRClassType = MIRRelationalLib.getHierarchicalType(mIRFeature.getType());
        if (mIRClassType != null) {
            MIRClass mIRClass = mIRClassType.getAssociatedClass();
            for (MIRFeature mIRFeature2 : mIRClass.getFeatures()) {
                Map<String, MIRFeature> map = MIRRelationalLib.expandHierarchicalColumn(mIRFeature2);
                for (Map.Entry<String, MIRFeature> entry : map.entrySet()) {
                    String string = entry.getKey();
                    if (mIRFeature.getType() instanceof MIRDerivedType) {
                        linkedHashMap.put(mIRFeature.getName() + "." + "$nameless_array_item" + "." + string, entry.getValue());
                        continue;
                    }
                    linkedHashMap.put(mIRFeature.getName() + "." + string, entry.getValue());
                }
            }
        }
        return linkedHashMap;
    }

    public static class ClassifierParsedName {
        public String databaseName = "";
        public String schemaName = "";
        public String classifierName = "";
    }
}

