/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib;

import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.bridgelib.Point2D;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.sdk.MIRAssociation;
import MITI.sdk.MIRAssociationRole;
import MITI.sdk.MIRAttribute;
import MITI.sdk.MIRCandidateKey;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRClassDiagram;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRDiagram;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRGeneralization;
import MITI.sdk.MIRGeneralizationRole;
import MITI.sdk.MIRJoin;
import MITI.sdk.MIRJoinRole;
import MITI.sdk.MIRKey;
import MITI.sdk.MIRModelElement;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRPresentationElement;
import MITI.sdk.MIRProjection;
import MITI.sdk.MIRRelationshipProjection;
import MITI.sdk.MIRSQLViewAssociation;
import MITI.sdk.MIRShape;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.util.ObjectCollector;
import java.awt.Canvas;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.TextAttribute;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class MIRGraphicsLib {
    public static final int FLASH_DPI = 72;
    public static final int JAVA_DPI = 72;
    public static final int MIR_DPI = 96;
    private static final String DIAGRAM_NAME_SUFFIX_LOGICAL = " Logical";
    private static final String DIAGRAM_NAME_SUFFIX_PHYSICAL = " Physical";
    private static boolean warnFirst = true;

    public static String getDiagramName(MIRClassDiagram mIRClassDiagram) {
        String string = mIRClassDiagram.getName();
        if (mIRClassDiagram.getDesignLevel() == 1 && string.endsWith(DIAGRAM_NAME_SUFFIX_LOGICAL)) {
            string = string.substring(0, string.length() - DIAGRAM_NAME_SUFFIX_LOGICAL.length());
        } else if (mIRClassDiagram.getDesignLevel() == 2 && string.endsWith(DIAGRAM_NAME_SUFFIX_PHYSICAL)) {
            string = string.substring(0, string.length() - DIAGRAM_NAME_SUFFIX_PHYSICAL.length());
        }
        return string;
    }

    public static int getLinePointCount(MIRShape mIRShape) {
        if (mIRShape == null || mIRShape.getLinePoints().isEmpty()) {
            return 0;
        }
        int n = 0;
        String string = mIRShape.getLinePoints();
        int n2 = string.indexOf(40);
        int n3 = string.indexOf(41);
        while (n2 != -1 && n3 != -1) {
            String string2 = string.substring(n2, n3 + 1);
            if (string2.indexOf(44) >= 0) {
                ++n;
            }
            string = string.substring(n3 + 1, string.length());
            n2 = string.indexOf(40);
            n3 = string.indexOf(41);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static void processPresentationElements(MIRClassDiagram mIRClassDiagram, boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (MIRPresentationElement mIRPresentationElement : mIRClassDiagram.getPresentationElements()) {
            void object;
            n2 = mIRPresentationElement.getX();
            n = mIRPresentationElement.getY();
            int n5 = mIRPresentationElement.getWidth();
            int n6 = mIRPresentationElement.getHeight();
            if (bl) {
                n = -n;
            }
            if (n2 != 0 && n != 0) {
                if (n2 - n5 < n3) {
                    n3 = n2 - n5;
                }
                if (n - n6 < n4) {
                    n4 = n - n6;
                }
            }
            Object var11_14 = null;
            if (mIRPresentationElement.getElementType() == 63) {
                ArrayList<Point2D> arrayList = Point2D.decodeLinePoints(((MIRRelationshipProjection)mIRPresentationElement).getLinePoints());
            } else if (mIRPresentationElement.getElementType() == 151) {
                ArrayList<Point2D> arrayList = Point2D.decodeLinePoints(((MIRShape)mIRPresentationElement).getLinePoints());
            }
            if (object == null) continue;
            for (Point2D point2D : object) {
                n2 = point2D.getX();
                n = point2D.getY();
                if (bl) {
                    n = -n;
                }
                if (n2 < n3) {
                    n3 = n2;
                }
                if (n >= n4) continue;
                n4 = n;
            }
        }
        for (MIRPresentationElement mIRPresentationElement : mIRClassDiagram.getPresentationElements()) {
            n2 = mIRPresentationElement.getX();
            n = mIRPresentationElement.getY();
            if (bl) {
                n = -n;
            }
            if (n2 != 0 || n != 0) {
                mIRPresentationElement.setX(n2 - n3);
                mIRPresentationElement.setY(n - n4);
            }
            ArrayList<Point2D> arrayList = null;
            if (mIRPresentationElement.getElementType() == 63) {
                arrayList = Point2D.decodeLinePoints(((MIRRelationshipProjection)mIRPresentationElement).getLinePoints());
            } else if (mIRPresentationElement.getElementType() == 151) {
                arrayList = Point2D.decodeLinePoints(((MIRShape)mIRPresentationElement).getLinePoints());
            }
            if (arrayList != null) {
                for (Point2D point2D : arrayList) {
                    n2 = point2D.getX();
                    n = point2D.getY();
                    if (bl) {
                        n = -n;
                    }
                    point2D.setX(n2 - n3);
                    point2D.setY(n - n4);
                }
                if (mIRPresentationElement.getElementType() == 63) {
                    ((MIRRelationshipProjection)mIRPresentationElement).setLinePoints(Point2D.encodeLinePoints(arrayList));
                } else if (mIRPresentationElement.getElementType() == 151) {
                    ((MIRShape)mIRPresentationElement).setLinePoints(Point2D.encodeLinePoints(arrayList));
                }
            }
            MIRModelObject mIRModelObject = mIRPresentationElement.getSubjectModelObject();
            if (!bl2 || mIRModelObject == null) continue;
            switch (mIRModelObject.getElementType()) {
                case 13: {
                    if (MIRGraphicsLib.isDependentEntity((MIRClass)mIRModelObject)) {
                        mIRPresentationElement.setShapeType((byte)1);
                        break;
                    }
                    mIRPresentationElement.setShapeType((byte)0);
                    break;
                }
                case 17: 
                case 18: 
                case 27: 
                case 155: {
                    if (mIRPresentationElement.getShapeType() == 4 || mIRPresentationElement.getShapeType() == 5) break;
                    mIRPresentationElement.setShapeType((byte)4);
                    break;
                }
                case 25: {
                    mIRPresentationElement.setShapeType((byte)1);
                }
            }
        }
    }

    private static boolean isDependentEntity(MIRClass mIRClass) {
        for (MIRGeneralizationRole mIRModelObject : mIRClass.getGeneralizationRoles()) {
            if (mIRModelObject.getSubtypeOfGeneralization() == null) continue;
            return true;
        }
        for (MIRAssociationRole mIRAssociationRole : mIRClass.getAssociationRoles()) {
            MIRAssociation mIRAssociation = mIRAssociationRole.getAssociation();
            if (mIRAssociation == null || !mIRAssociation.getAggregation() || mIRAssociationRole.getSource()) continue;
            return true;
        }
        return false;
    }

    public static int getTextWidth(String string, MIRPresentationElement mIRPresentationElement, boolean bl, int n) {
        FontMetrics fontMetrics = MIRGraphicsLib.getFontMetrics(mIRPresentationElement.getFontName(), mIRPresentationElement.getFontSize(), mIRPresentationElement.getBold(), mIRPresentationElement.getItalic(), mIRPresentationElement.getUnderline(), mIRPresentationElement.getStrike(), n);
        if (fontMetrics != null) {
            return fontMetrics.stringWidth(string);
        }
        return 0;
    }

    public static int getFontHeightPixel(MIRPresentationElement mIRPresentationElement, int n) {
        FontMetrics fontMetrics = MIRGraphicsLib.getFontMetrics(mIRPresentationElement.getFontName(), mIRPresentationElement.getFontSize(), mIRPresentationElement.getBold(), mIRPresentationElement.getItalic(), mIRPresentationElement.getUnderline(), mIRPresentationElement.getStrike(), n);
        if (fontMetrics != null) {
            return fontMetrics.getHeight();
        }
        return 0;
    }

    private static int adjustFontSize(int n, int n2) {
        return (int)Math.floor(n * n2 / 72);
    }

    private static FontMetrics getFontMetrics(String string, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2) {
        int n3 = 0;
        if (bl) {
            n3 |= 1;
        }
        if (bl2) {
            n3 |= 2;
        }
        Font font = new Font(string, n3, MIRGraphicsLib.adjustFontSize(n, n2));
        HashMap<TextAttribute, Constable> hashMap = new HashMap<TextAttribute, Constable>();
        if (bl3) {
            hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (bl4) {
            hashMap.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        if (!hashMap.isEmpty()) {
            font = font.deriveFont(hashMap);
        }
        try {
            Canvas canvas = new Canvas();
            return canvas.getFontMetrics(font);
        }
        catch (Throwable throwable) {
            if (warnFirst) {
                BLIB.WRN_MISSING_FONTS.log(new Object[0]);
                warnFirst = false;
            }
            return null;
        }
    }

    public static String getFkIndicator(MIRProjection mIRProjection, MIRFeature mIRFeature) {
        boolean bl;
        boolean bl2 = bl = !mIRProjection.hasDisplayOption(8192);
        if (mIRFeature.getElementType() == 14) {
            MIRAttribute mIRAttribute = (MIRAttribute)mIRFeature;
            for (MIRKey mIRKey : mIRAttribute.getKeys()) {
                if (mIRKey.getElementType() != 22 || !bl && (mIRKey.getIndex() == null || !mIRKey.getIndex().getGenerate())) continue;
                return "(FK)";
            }
        }
        return "";
    }

    public static String getAkIndicator(MIRProjection mIRProjection, MIRFeature mIRFeature, String string) {
        boolean bl;
        String string2 = "";
        boolean bl2 = bl = !mIRProjection.hasDisplayOption(8192);
        if (mIRFeature.getElementType() == 14) {
            MIRAttribute mIRAttribute = (MIRAttribute)mIRFeature;
            for (MIRKey mIRKey : mIRAttribute.getKeys()) {
                MIRCandidateKey mIRCandidateKey;
                if (mIRKey.getElementType() != 21 || (mIRCandidateKey = (MIRCandidateKey)mIRKey).getPrimaryOfClass() != null || !bl && (mIRKey.getIndex() == null || !mIRKey.getIndex().getGenerate())) continue;
                string2 = string2.isEmpty() ? string2 + "(" : string2 + string;
                int n = 1;
                MIRClassifier mIRClassifier = mIRAttribute.getClassifier();
                if (mIRClassifier != null && mIRClassifier.getElementType() == 13) {
                    MIRClass mIRClass = (MIRClass)mIRClassifier;
                    for (MIRKey mIRKey2 : mIRClass.getKeys()) {
                        if (mIRKey2.getElementType() != 21 || ((MIRCandidateKey)mIRKey2).getUniqueKey() != mIRCandidateKey.getUniqueKey() || mIRClass.getPrimaryCandidateKey() == mIRKey2) continue;
                        if (mIRKey2 == mIRCandidateKey) break;
                        ++n;
                    }
                }
                string2 = string2 + (mIRCandidateKey.getUniqueKey() ? "AK" : "IE") + n + ".1";
            }
            if (!string2.isEmpty()) {
                string2 = string2 + ")";
            }
        }
        return string2;
    }

    public static String getPkIndicator(MIRProjection mIRProjection, MIRFeature mIRFeature) {
        boolean bl;
        boolean bl2 = bl = !mIRProjection.hasDisplayOption(8192);
        if (mIRFeature.getElementType() == 14) {
            MIRAttribute mIRAttribute = (MIRAttribute)mIRFeature;
            for (MIRKey mIRKey : mIRAttribute.getKeys()) {
                MIRCandidateKey mIRCandidateKey;
                if (mIRKey.getElementType() != 21 || (mIRCandidateKey = (MIRCandidateKey)mIRKey).getPrimaryOfClass() == null || !bl && (mIRKey.getIndex() == null || !mIRKey.getIndex().getGenerate())) continue;
                return "(PK)";
            }
        }
        return "";
    }

    public static int getRedRGB(int n) {
        return n & 0xFF;
    }

    public static int getGreenRGB(int n) {
        return (n & 0xFF00) >> 8;
    }

    public static int getBlueRGB(int n) {
        return (n & 0xFF0000) >> 16;
    }

    public static int getDarkestColor(int n, int n2) {
        int n3;
        int n4 = MIRGraphicsLib.getRedRGB(n) + MIRGraphicsLib.getGreenRGB(n) + MIRGraphicsLib.getBlueRGB(n);
        return n4 < (n3 = MIRGraphicsLib.getRedRGB(n2) + MIRGraphicsLib.getGreenRGB(n2) + MIRGraphicsLib.getBlueRGB(n2)) ? n : n2;
    }

    public static void verifyDiagram(MIRClassDiagram mIRClassDiagram) {
        Object object;
        ArrayList<MIRModelElement> arrayList = new ArrayList<MIRModelElement>();
        block5: for (MIRModelElement object22 : mIRClassDiagram.getModelElements()) {
            boolean bl;
            if (object22.getElementType() == 17) {
                MIRAssociation mIRAssociation = (MIRAssociation)object22;
                if (mIRAssociation.getAssociationRoleCount() < 2) {
                    arrayList.add(mIRAssociation);
                    continue;
                }
                for (MIRAssociationRole mIRAssociationRole : mIRAssociation.getAssociationRoles()) {
                    MIRClass mIRClass = mIRAssociationRole.getAssociatedClass();
                    if (mIRClass != null && mIRClassDiagram.containsModelElement(mIRClass)) continue;
                    arrayList.add(mIRAssociation);
                    continue block5;
                }
                continue;
            }
            if (object22.getElementType() == 16) {
                MIRClass mIRClass;
                MIRGeneralization mIRGeneralization = (MIRGeneralization)object22;
                object = true;
                for (MIRGeneralizationRole mIRGeneralizationRole : mIRGeneralization.getSupertypeGeneralizationRoles()) {
                    mIRClass = mIRGeneralizationRole.getAssociatedClass();
                    if (mIRClass == null || !mIRClassDiagram.containsModelElement(mIRClass)) continue;
                    object = false;
                    break;
                }
                if (!((Boolean)object).booleanValue()) {
                    object = true;
                    for (MIRGeneralizationRole mIRGeneralizationRole : mIRGeneralization.getSubtypeGeneralizationRoles()) {
                        mIRClass = mIRGeneralizationRole.getAssociatedClass();
                        if (mIRClass == null || !mIRClassDiagram.containsModelElement(mIRClass)) continue;
                        object = false;
                        break;
                    }
                }
                if (!((Boolean)object).booleanValue()) continue;
                arrayList.add(mIRGeneralization);
                continue;
            }
            if (object22.getElementType() == 27) {
                MIRSQLViewAssociation mIRSQLViewAssociation = (MIRSQLViewAssociation)object22;
                object = mIRSQLViewAssociation.getDestinationSQLViewEntity();
                MIRClassifier mIRClassifier = mIRSQLViewAssociation.getSourceClassifier();
                boolean bl2 = false;
                if (object == null || !mIRClassDiagram.containsModelElement((MIRModelElement)object)) {
                    bl2 = true;
                }
                if (mIRClassifier == null || !mIRClassDiagram.containsModelElement(mIRClassifier)) {
                    bl2 = true;
                }
                if (!bl2) continue;
                arrayList.add(mIRSQLViewAssociation);
                continue;
            }
            if (object22.getElementType() != 92) continue;
            boolean bl3 = false;
            for (MIRJoinRole mIRJoinRole : ((MIRJoin)object22).getJoinRoles()) {
                MIRClassifier mIRClassifier = mIRJoinRole.getClassifier();
                if (mIRClassifier != null && mIRClassDiagram.containsModelElement(mIRClassifier)) continue;
                bl = true;
            }
            if (!bl) continue;
            arrayList.add(object22);
        }
        for (MIRModelElement mIRModelElement : arrayList) {
            mIRClassDiagram.removeModelElement(mIRModelElement);
        }
        ArrayList arrayList2 = new ArrayList();
        for (MIRPresentationElement mIRPresentationElement : mIRClassDiagram.getPresentationElements()) {
            object = mIRPresentationElement.getSubjectModelObject();
            if (object == null) continue;
            boolean bl = false;
            switch (((MIRModelObject)object).getElementType()) {
                case 18: {
                    MIRModelObject mIRModelObject = ((MIRAssociationRole)object).getAssociation();
                    if (mIRClassDiagram.containsModelElement((MIRModelElement)mIRModelObject)) break;
                    bl = true;
                    break;
                }
                case 155: {
                    MIRGeneralization mIRGeneralization;
                    MIRModelObject mIRModelObject = (MIRGeneralizationRole)object;
                    boolean bl4 = true;
                    if (((MIRGeneralizationRole)mIRModelObject).getSupertypeOfGeneralization() != null) {
                        mIRGeneralization = ((MIRGeneralizationRole)mIRModelObject).getSupertypeOfGeneralization();
                        if (mIRClassDiagram.containsModelElement(mIRGeneralization)) {
                            bl4 = false;
                        }
                    } else if (((MIRGeneralizationRole)mIRModelObject).getSubtypeOfGeneralization() != null && mIRClassDiagram.containsModelElement(mIRGeneralization = ((MIRGeneralizationRole)mIRModelObject).getSubtypeOfGeneralization())) {
                        bl4 = false;
                    }
                    if (!bl4 || mIRClassDiagram.getDesignLevel() == 2) break;
                    bl = true;
                    break;
                }
                case 13: 
                case 16: 
                case 17: 
                case 25: 
                case 27: 
                case 85: 
                case 87: {
                    if (mIRClassDiagram.containsModelElement((MIRModelElement)object)) break;
                    bl = true;
                    break;
                }
            }
            if (!bl) continue;
            arrayList2.add(mIRPresentationElement);
        }
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            MIRPresentationElement mIRPresentationElement = (MIRPresentationElement)iterator.next();
            mIRPresentationElement.delete();
        }
    }

    public static void completeDiagramPresentationElements(MIRClassDiagram mIRClassDiagram) {
        Iterator<MIRModelElement> iterator = mIRClassDiagram.getModelElementIterator();
        while (iterator.hasNext()) {
            MIRModelElement mIRModelElement = iterator.next();
            MIRPresentationElement mIRPresentationElement = MIRBridgeLib.getPresentationElement(mIRModelElement, mIRClassDiagram);
            if (mIRPresentationElement != null) continue;
            if (mIRModelElement.isInstanceOf((short)75) || mIRModelElement.isInstanceOf((short)16)) {
                mIRPresentationElement = new MIRProjection();
                mIRPresentationElement.addDiagram(mIRClassDiagram);
                mIRPresentationElement.addSubjectModelObject(mIRModelElement);
                continue;
            }
            if (!mIRModelElement.isInstanceOf((short)15)) continue;
            mIRPresentationElement = new MIRRelationshipProjection();
            mIRPresentationElement.addDiagram(mIRClassDiagram);
            mIRPresentationElement.addSubjectModelObject(mIRModelElement);
        }
    }

    public static int getCommonDisplayPropertyClassifiers(MIRDiagram mIRDiagram, short s, byte by) {
        int n = 0;
        if (s != 13 && s != 25 && s != 75) {
            return n;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        Iterator<MIRPresentationElement> iterator = mIRDiagram.getPresentationElementIterator();
        while (iterator.hasNext()) {
            MIRModelObject mIRModelObject;
            MIRPresentationElement mIRPresentationElement = iterator.next();
            if (mIRPresentationElement.getElementType() != 62 || (mIRModelObject = mIRPresentationElement.getSubjectModelObject()) == null || !mIRModelObject.isInstanceOf(s) || mIRModelObject.getDesignLevel() != by && mIRModelObject.getDesignLevel() != 0) continue;
            if (mIRPresentationElement.hasDisplayOption(2)) {
                ++n3;
            }
            if (mIRPresentationElement.hasDisplayOption(4)) {
                ++n4;
            }
            if (mIRPresentationElement.hasDisplayOption(8)) {
                ++n5;
            }
            if (mIRPresentationElement.hasDisplayOption(16)) {
                ++n6;
            }
            if (mIRPresentationElement.hasDisplayOption(32)) {
                ++n7;
            }
            if (mIRPresentationElement.hasDisplayOption(1024)) {
                ++n8;
            }
            if (mIRPresentationElement.hasDisplayOption(2048)) {
                ++n9;
            }
            if (mIRPresentationElement.hasDisplayOption(4096)) {
                ++n10;
            }
            if (mIRPresentationElement.hasDisplayOption(8192)) {
                ++n11;
            }
            if (mIRPresentationElement.hasDisplayOption(0x100000)) {
                ++n12;
            }
            if (mIRPresentationElement.hasDisplayOption(0x200000)) {
                ++n13;
            }
            if (mIRPresentationElement.hasDisplayOption(0x400000)) {
                ++n14;
            }
            if (mIRPresentationElement.hasDisplayOption(0x800000)) {
                ++n15;
            }
            if (mIRPresentationElement.hasDisplayOption(0x1000000)) {
                ++n16;
            }
            if (mIRPresentationElement.hasDisplayOption(0x2000000)) {
                ++n17;
            }
            if (mIRPresentationElement.hasDisplayOption(16384)) {
                ++n18;
            }
            if (n2 == 0) {
                n19 = mIRPresentationElement.getDisplayOptions();
            }
            ++n2;
        }
        if (n2 == 1) {
            n = n19;
        } else if (n2 > 1) {
            if (n2 / 2 <= n3) {
                n |= 2;
            }
            if (n2 / 2 <= n4) {
                n |= 4;
            }
            if (n2 / 2 <= n5) {
                n |= 8;
            }
            if (n2 / 2 <= n6) {
                n |= 0x10;
            }
            if (n2 / 2 <= n7) {
                n |= 0x20;
            }
            if (n2 / 2 <= n8) {
                n |= 0x400;
            }
            if (n2 / 2 <= n9) {
                n |= 0x800;
            }
            if (n2 / 2 <= n10) {
                n |= 0x1000;
            }
            if (n2 / 2 <= n11) {
                n |= 0x2000;
            }
            if (n2 / 2 <= n12) {
                n |= 0x100000;
            }
            if (n2 / 2 <= n13) {
                n |= 0x200000;
            }
            if (n2 / 2 <= n14) {
                n |= 0x400000;
            }
            if (n2 / 2 <= n15) {
                n |= 0x800000;
            }
            if (n2 / 2 <= n16) {
                n |= 0x1000000;
            }
            if (n2 / 2 <= n17) {
                n |= 0x2000000;
            }
            if (n2 / 2 <= n18) {
                n |= 0x4000;
            }
        }
        return n;
    }

    public static int getCommonDisplayPropertyRelationships(MIRDiagram mIRDiagram, short s, byte by, boolean bl) {
        int n = 0;
        if (s != 17 && s != 27 && s != 155 && s != 15) {
            return n;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        Iterator<MIRPresentationElement> iterator = mIRDiagram.getPresentationElementIterator();
        while (iterator.hasNext()) {
            MIRModelObject mIRModelObject;
            MIRPresentationElement mIRPresentationElement = iterator.next();
            if (mIRPresentationElement.getElementType() != 63 || (mIRModelObject = mIRPresentationElement.getSubjectModelObject()) == null || mIRModelObject.getElementType() == 155 && (bl && ((MIRGeneralizationRole)mIRModelObject).getSubtypeOfGeneralization() != null || !bl && ((MIRGeneralizationRole)mIRModelObject).getSupertypeOfGeneralization() != null) || !mIRModelObject.isInstanceOf(s) || mIRModelObject.getDesignLevel() != by && mIRModelObject.getDesignLevel() != 0) continue;
            if (mIRPresentationElement.hasDisplayOption(2)) {
                ++n3;
            }
            if (mIRPresentationElement.hasDisplayOption(4)) {
                ++n4;
            }
            if (mIRPresentationElement.hasDisplayOption(8)) {
                ++n5;
            }
            if (mIRPresentationElement.hasDisplayOption(16)) {
                ++n6;
            }
            if (mIRPresentationElement.hasDisplayOption(32)) {
                ++n7;
            }
            if (mIRPresentationElement.hasDisplayOption(64)) {
                ++n8;
            }
            if (mIRPresentationElement.hasDisplayOption(1024)) {
                ++n9;
            }
            if (n2 == 0) {
                n10 = mIRPresentationElement.getDisplayOptions();
            }
            ++n2;
        }
        if (n2 == 1) {
            n = n10;
        } else if (n2 > 1) {
            if (n2 / 2 <= n3) {
                n |= 2;
            }
            if (n2 / 2 <= n4) {
                n |= 4;
            }
            if (n2 / 2 <= n5) {
                n |= 8;
            }
            if (n2 / 2 <= n6) {
                n |= 0x10;
            }
            if (n2 / 2 <= n7) {
                n |= 0x20;
            }
            if (n2 / 2 <= n8) {
                n |= 0x40;
            }
            if (n2 / 2 <= n9) {
                n |= 0x400;
            }
        }
        return n;
    }

    public static byte getCommonNotation(MIRStoreModel mIRStoreModel, byte by) {
        ObjectCollector objectCollector = new ObjectCollector(new short[]{11});
        Set set = objectCollector.collect(mIRStoreModel);
        for (MIRClassDiagram mIRClassDiagram : set) {
            if (mIRClassDiagram.getDesignLevel() != by) continue;
            return mIRClassDiagram.getNotation();
        }
        if (by != 0) {
            return MIRGraphicsLib.getCommonNotation(mIRStoreModel, (byte)0);
        }
        return 0;
    }
}

