/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.bridgelib.MIRConnectionManager;
import MITI.bridges.bridgelib.MIRTypeLib;
import MITI.bridges.datatypelib.MIRDataStoreVersion;
import MITI.bridges.datatypelib.MIRDataTypeConverter;
import MITI.bridges.datatypelib.MIRDataTypeLib;
import MITI.bridges.profiles.ProfileIds;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.sdk.MIRAllClasses;
import MITI.sdk.MIRAttribute;
import MITI.sdk.MIRBaseTypeList;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRClassType;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRConcreteType;
import MITI.sdk.MIRConnectedTransformation;
import MITI.sdk.MIRConnection;
import MITI.sdk.MIRConnectionDataAttribute;
import MITI.sdk.MIRConnectionDataPackage;
import MITI.sdk.MIRConnectionDataSet;
import MITI.sdk.MIRConnectionNamespace;
import MITI.sdk.MIRConnectionPackage;
import MITI.sdk.MIRContent;
import MITI.sdk.MIRDataAttribute;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDataSet;
import MITI.sdk.MIRDatabaseSchema;
import MITI.sdk.MIRDelimitedFileDescriptor;
import MITI.sdk.MIRDerivedType;
import MITI.sdk.MIRDesignPackage;
import MITI.sdk.MIRDiModel;
import MITI.sdk.MIRDirectoryStructureModel;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementType;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFileDirectory;
import MITI.sdk.MIRFixedWidthFileDescriptor;
import MITI.sdk.MIRFlatFileDescriptor;
import MITI.sdk.MIRFlatTextFile;
import MITI.sdk.MIRMetadataOrigin;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIROlapSchema;
import MITI.sdk.MIRPackage;
import MITI.sdk.MIRQueryTable;
import MITI.sdk.MIRSQLViewAttribute;
import MITI.sdk.MIRSQLViewEntity;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRStoreContent;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIRStoredProcedure;
import MITI.sdk.MIRStructuralFeature;
import MITI.sdk.MIRSystemPackage;
import MITI.sdk.MIRType;
import MITI.sdk.mix.MIRMixManager;
import MITI.sdk.validation.MIRValidation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class MIRConnectionSummarizer {
    public static final String VSAM_STORE = "VSAM";
    public static final String NATIVE_TYPE_STORED_PROCEDURE = "Stored Procedure";
    public static final String NATIVE_TYPE_VIEW = "View";
    public static boolean convertPartionFolderClasses = false;

    public static void summarizeConnections(MIRModel mIRModel) throws MIRException {
        MIRConnectionSummarizer.summarizeConnections(mIRModel, true);
    }

    private static boolean defaultFilter(MIRStoreConnection mIRStoreConnection) {
        MIRConnection mIRConnection = mIRStoreConnection.getRootModel().getContent().getClientOfConnection(MIRBridgeLib.getPhysicalName(mIRStoreConnection));
        return mIRConnection != null && mIRConnection.getSupplierStoreContent() != null && mIRConnection.getSupplierStoreContent().getConnectionOfDirectoryStructureModel() != null;
    }

    public static void summarizeConnections(MIRModel mIRModel, boolean bl) throws MIRException {
        MIRConnectionSummarizer.summarizeConnections(mIRModel, MIRConnectionSummarizer::defaultFilter, bl);
    }

    public static void summarizeConnections(MIRModel mIRModel, Predicate<MIRStoreConnection> predicate, boolean bl) throws MIRException {
        MIRContent mIRContent = mIRModel.getContent();
        MIRDirectoryStructureModel mIRDirectoryStructureModel = (MIRDirectoryStructureModel)mIRContent.getRootModel();
        LinkedHashSet<MIRStoreConnection> linkedHashSet = new LinkedHashSet<MIRStoreConnection>();
        mIRContent.getClientOfConnections().forEach(mIRConnection -> linkedHashSet.add(mIRModel.getStoreConnection(mIRConnection.getName())));
        linkedHashSet.addAll(mIRModel.getStoreConnections());
        for (MIRStoreConnection mIRStoreConnection : linkedHashSet) {
            MIRElement mIRElement;
            MIRElement mIRElement2;
            if (mIRStoreConnection == null || predicate != null && !predicate.test(mIRStoreConnection)) continue;
            String string = MIRBridgeLib.getPhysicalName(mIRStoreConnection);
            MIRConnection mIRConnection2 = mIRContent.getClientOfConnection(string);
            if (mIRConnection2 == null) {
                mIRConnection2 = new MIRConnection();
                mIRConnection2.setName(string);
                mIRConnection2.addClientContent(mIRContent);
                byte by = mIRStoreConnection.getSourceOfMappingModel() == null && mIRStoreConnection.getDestinationOfMappingModel() == null ? (mIRStoreConnection.getStoreType() == 2 ? (byte)2 : 0) : (mIRStoreConnection.getSourceOfMappingModel() != null && mIRStoreConnection.getDestinationOfMappingModel() != null ? (byte)2 : (mIRStoreConnection.getDestinationOfMappingModel() != null ? (byte)1 : 0));
                mIRConnection2.setUsage(by);
                mIRConnection2.setMatchingRule(mIRStoreConnection.getMatchingRule());
            }
            String string2 = MIRConnectionManager.getStoreContentName(mIRStoreConnection);
            MIRElement mIRElement3 = mIRConnection2.getSupplierStoreContent();
            if (mIRElement3 != null && !mIRElement3.getName().equals(string2) && ((MIRStoreModel)((MIRContent)mIRElement3).getModel()).getStoreType() == 0) {
                mIRConnection2.removeSupplierStoreContent();
                mIRElement2 = mIRDirectoryStructureModel.getConnectionStoreContent(string2);
                if (null == mIRElement2) {
                    mIRElement2 = new MIRStoreContent((MIRStoreContent)mIRElement3);
                    mIRElement2.setName(string2);
                    mIRElement2.setNativeId("");
                    mIRElement = new MIRStoreModel((MIRStoreModel)((MIRContent)mIRElement3).getModel());
                    mIRElement.setName(string2);
                    if (!((MIRModelObject)mIRElement).getPhysicalName().isEmpty()) {
                        ((MIRModelObject)mIRElement).setPhysicalName(string2);
                    }
                    ((MIRModel)mIRElement).addMetadataOrigin(new MIRMetadataOrigin(((MIRContent)mIRElement3).getModel().getMetadataOrigin()));
                    ((MIRContent)mIRElement2).addModel((MIRModel)mIRElement);
                    mIRDirectoryStructureModel.addConnectionStoreContent((MIRStoreContent)mIRElement2);
                }
                mIRElement3 = mIRElement2;
            } else if (mIRElement3 == null) {
                mIRElement3 = mIRDirectoryStructureModel.getConnectionStoreContent(string2);
            }
            if (mIRElement3 == null) {
                mIRElement3 = new MIRStoreContent();
                mIRElement3.setName(string2);
                mIRDirectoryStructureModel.addConnectionStoreContent((MIRStoreContent)mIRElement3);
            }
            if (mIRConnection2.getSupplierStoreContent() == null) {
                mIRConnection2.addSupplierStoreContent((MIRStoreContent)mIRElement3);
            }
            if (((MIRContent)mIRElement3).getModel() == null) {
                mIRElement2 = new MIRStoreModel();
                ((MIRStoreModel)mIRElement2).setStoreType(mIRStoreConnection.getStoreType());
                ((MIRSystemPackage)mIRElement2).setSystemType(mIRStoreConnection.getSystemType());
                mIRElement2.setName(mIRElement3.getName());
                if (MIRConnectionManager.getInstance().isCaseSensitive(mIRElement2.getName())) {
                    ((MIRSystemPackage)mIRElement2).setSystemCase((byte)1);
                } else if (MIRConnectionManager.getInstance().isCaseInsensitive(mIRElement2.getName())) {
                    ((MIRSystemPackage)mIRElement2).setSystemCase((byte)2);
                }
                mIRElement = new MIRMetadataOrigin(mIRModel.getMetadataOrigin());
                ((MIRMetadataOrigin)mIRElement).setProfileId(ProfileIds.META_INTEGRATION_ETL_SUMMARY__DATA_STORE);
                ((MIRMetadataOrigin)mIRElement).setSource("");
                ((MIRMetadataOrigin)mIRElement).setEncoding("UTF-8");
                ((MIRModel)mIRElement2).addMetadataOrigin((MIRMetadataOrigin)mIRElement);
                ((MIRContent)mIRElement3).addModel((MIRModel)mIRElement2);
            }
            MIRConnectionSummarizer.updateConnectedStore(mIRStoreConnection, (MIRStoreModel)((MIRContent)mIRElement3).getModel(), bl);
        }
    }

    public static void saveConnectionModels(MIRDirectoryStructureModel mIRDirectoryStructureModel, MIRMixManager mIRMixManager) throws MIRException {
        MIRConnectionSummarizer.saveConnectionModels(mIRDirectoryStructureModel.getConnectionStoreContents(), mIRMixManager);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveConnectionModels(Collection<MIRStoreContent> collection, MIRMixManager mIRMixManager) throws MIRException {
        ArrayList<MIRStoreContent> arrayList = new ArrayList<MIRStoreContent>();
        for (MIRStoreContent mIRStoreContent : collection) {
            if (mIRStoreContent.getSupplierOfConnectionCount() != 0) {
                MIRConnection[] mIRConnectionArray = (MIRConnection[])mIRMixManager.loadModel(mIRStoreContent);
                MIRConnectionSummarizer.cleanStoreModel((MIRStoreModel)mIRConnectionArray);
                if (mIRConnectionArray.getDataPackageCount() != 0 || mIRConnectionArray.getDesignPackageCount() != 0) {
                    MIRTypeLib.factorizeTypes((MIRModel)mIRConnectionArray);
                    MIRMetadataOrigin mIRMetadataOrigin = mIRConnectionArray.getMetadataOrigin();
                    if (mIRMetadataOrigin != null && mIRMetadataOrigin.getProfileId() <= 0) {
                        mIRMetadataOrigin.setProfileId(ProfileIds.META_INTEGRATION_ETL_SUMMARY__DATA_STORE);
                    }
                    if (mIRConnectionArray.getStoreType() == 2 && MIRObjectCollections.__getSdkCaseSensitive()) {
                        mIRConnectionArray.setSystemCase((byte)1);
                    }
                    if (mIRConnectionArray.getSystemType().isEmpty()) {
                        BLIB.WRN_SYSTEM_TYPE.log(MIRValidation.buildValidationName((MIRObject)mIRConnectionArray), "ODBC");
                        mIRConnectionArray.setSystemType("ODBC");
                    }
                    try {
                        mIRMixManager.saveModel(mIRStoreContent);
                    }
                    catch (Exception exception) {
                        BLIB.ERR_OPERATION_FAILED.log(exception, "while saving store content " + mIRStoreContent.getPath());
                    }
                    if (!MIRConnectionManager.getInstance().isMergeQuestion()) {
                        // empty if block
                    }
                } else {
                    arrayList.add(mIRStoreContent);
                }
                mIRConnectionArray.delete();
                continue;
            }
            if (mIRStoreContent.getFolder() != null) continue;
            arrayList.add(mIRStoreContent);
        }
        Iterator<MIRStoreContent> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            MIRStoreContent mIRStoreContent;
            mIRStoreContent = iterator.next();
            for (MIRConnection mIRConnection : mIRStoreContent.getSupplierOfConnections().toArray(new MIRConnection[mIRStoreContent.getSupplierOfConnectionCount()])) {
                mIRConnection.delete();
            }
            mIRStoreContent.delete();
        }
        return;
    }

    private static void cleanStoreModel(MIRStoreModel mIRStoreModel) throws MIRException {
        ArrayList<MIRDataPackage> arrayList = new ArrayList<MIRDataPackage>();
        for (MIRDataPackage mIRDataPackage : mIRStoreModel.getDataPackages()) {
            for (Object object : mIRDataPackage.getNamespaceElements().toArray()) {
                if (!MIRConnectionSummarizer.isNamespaceElementEmpty((MIRNamespaceElement)object)) continue;
                mIRDataPackage.removeNamespaceElement((MIRNamespaceElement)object);
            }
            for (Object object : mIRDataPackage.getNamespaceElements().toArray()) {
                if (!MIRConnectionSummarizer.isNamespaceElementEmpty((MIRNamespaceElement)object)) continue;
                mIRDataPackage.removeImportedNamespaceElement((MIRNamespaceElement)object);
            }
        }
        for (MIRDataPackage mIRDataPackage : mIRStoreModel.getDataPackages()) {
            if (mIRDataPackage.getNamespaceElementCount() != 0 || mIRDataPackage.getImportedNamespaceElementCount() != 0) continue;
            arrayList.add(mIRDataPackage);
        }
        for (MIRDataPackage mIRDataPackage : arrayList) {
            mIRStoreModel.removeDataPackage(mIRDataPackage);
            mIRDataPackage.delete();
        }
    }

    private static boolean isNamespaceElementEmpty(MIRNamespaceElement mIRNamespaceElement) {
        boolean bl = true;
        if (mIRNamespaceElement.isInstanceOf((short)207)) {
            MIRNamespaceElement mIRNamespaceElement2;
            Iterator iterator = ((MIRFileDirectory)mIRNamespaceElement).getNamespaceElements().iterator();
            while (iterator.hasNext() && (bl = MIRConnectionSummarizer.isNamespaceElementEmpty(mIRNamespaceElement2 = (MIRNamespaceElement)iterator.next()))) {
            }
        } else {
            bl = mIRNamespaceElement.isInstanceOf((short)75) ? ((MIRClassifier)mIRNamespaceElement).getFeatureCount() == 0 : !mIRNamespaceElement.isInstanceOf((short)67);
        }
        return bl;
    }

    public static void updateConnectedStore(MIRStoreConnection mIRStoreConnection, MIRStoreModel mIRStoreModel, boolean bl) throws MIRException {
        Object object;
        Object object2;
        Object object3;
        MIRConnectionManager.copyConnectionProperties(mIRStoreConnection, mIRStoreModel.getContent());
        if (mIRStoreModel.getStoreType() != mIRStoreConnection.getStoreType()) {
            if (mIRStoreModel.getDataPackageCount() == 0) {
                mIRStoreModel.setStoreType(mIRStoreConnection.getStoreType());
                BLIB.WRN_STORE_TYPE.log(MIRValidation.buildValidationName(mIRStoreConnection), MIRValidation.buildValidationName(mIRStoreModel));
            } else {
                BLIB.ERR_STORE_TYPE.log(MIRValidation.buildValidationName(mIRStoreConnection), MIRValidation.buildValidationName(mIRStoreModel));
                return;
            }
        }
        if (mIRStoreModel.getSystemType().isEmpty()) {
            mIRStoreModel.setSystemType(mIRStoreConnection.getSystemType());
            mIRStoreModel.setSystemMajorVersion(mIRStoreConnection.getSystemMajorVersion());
            mIRStoreModel.setSystemMinorVersion(mIRStoreConnection.getSystemMinorVersion());
            mIRStoreModel.setSystemReleaseVersion(mIRStoreConnection.getSystemReleaseVersion());
        }
        MIRContent mIRContent = mIRStoreConnection.getRootModel().getContent();
        MIRStoreContent mIRStoreContent = (MIRStoreContent)mIRStoreModel.getContent();
        String string = MIRBridgeLib.getPhysicalName(mIRStoreConnection);
        if (mIRContent.getClientOfConnection(string) == null) {
            object3 = new MIRConnection();
            ((MIRObject)object3).setName(string);
            ((MIRConnection)object3).addClientContent(mIRContent);
            ((MIRConnection)object3).addSupplierStoreContent(mIRStoreContent);
        }
        object3 = null;
        if (bl) {
            MIRDataStoreVersion mIRDataStoreVersion = MIRDataTypeLib.getDataStore(mIRStoreModel);
            object3 = MIRConnectionSummarizer.getDataTypeConverter(mIRDataStoreVersion);
        }
        boolean bl2 = mIRStoreConnection.getStoreType() == 2;
        boolean bl3 = mIRStoreConnection.getStoreType() == 5;
        for (MIRConnectionNamespace mIRConnectionDataPackage : mIRStoreConnection.getConnectionNamespaces()) {
            object2 = MIRBridgeLib.getPhysicalName(mIRConnectionDataPackage);
            if (bl3) {
                object = mIRStoreModel.getDesignPackage((String)object2);
                if (object == null) {
                    object = new MIRDesignPackage();
                    ((MIRObject)object).setName((String)object2);
                    ((MIRElement)object).setNativeId(mIRConnectionDataPackage.getNativeId());
                    mIRStoreModel.addDesignPackage((MIRDesignPackage)object);
                }
                MIRConnectionSummarizer.updateConnectedNamespace(mIRConnectionDataPackage, (MIRPackage)object, mIRStoreModel, MIRDesignPackage::new, (MIRDataTypeConverter)object3);
                continue;
            }
            object = mIRStoreModel.getDataPackage((String)object2);
            if (object == null) {
                object = new MIRFileDirectory();
                ((MIRObject)object).setName((String)object2);
                if (bl2 && ((MIRObject)object).getName().equals("Fake Root") && mIRConnectionDataPackage.getNativeType().equals("Fake Root")) {
                    ((MIRElement)object).setNativeType("Fake Root");
                }
                mIRStoreModel.addDataPackage((MIRDataPackage)object);
            }
            MIRConnectionSummarizer.updateConnectedNamespace(mIRConnectionDataPackage, (MIRPackage)object, mIRStoreModel, MIRFileDirectory::new, (MIRDataTypeConverter)object3);
        }
        for (MIRConnectionPackage mIRConnectionPackage : mIRStoreConnection.getConnectionPackages()) {
            object2 = MIRConnectionSummarizer.getDataPackage(mIRStoreModel, mIRConnectionPackage.getNamespaceName(mIRConnectionPackage));
            object = mIRConnectionPackage.getAllNamespaceElementIterator();
            while (object.hasNext()) {
                MIRNamespaceElement mIRNamespaceElement = (MIRNamespaceElement)object.next();
                if (mIRNamespaceElement.isInstanceOf((short)75)) {
                    MIRConnectionSummarizer.updateConnectedClass((MIRPackage)object2, (MIRDataTypeConverter)object3, (MIRClassifier)mIRNamespaceElement, bl2);
                    continue;
                }
                if (!mIRNamespaceElement.isInstanceOf((short)67)) continue;
                MIRConnectionSummarizer.updateStoredProcedure(mIRStoreModel, (MIRDataPackage)object2, (MIRDataTypeConverter)object3, (MIRStoredProcedure)mIRNamespaceElement);
            }
            for (MIRClassifier mIRClassifier : mIRConnectionPackage.getClassifiers()) {
                MIRConnectionSummarizer.updateConnectedClass((MIRPackage)object2, (MIRDataTypeConverter)object3, mIRClassifier, bl2);
            }
        }
    }

    public static MIRDataTypeConverter getDataTypeConverter(MIRDataStoreVersion mIRDataStoreVersion) throws MIRException {
        MIRDataTypeConverter mIRDataTypeConverter = null;
        try {
            mIRDataTypeConverter = new MIRDataTypeConverter(mIRDataStoreVersion, "");
        }
        catch (MIRException mIRException) {
            BLIB.WRN_UNSUPPORTED_DB_TYPE_DEFAULT_APPLY.log(mIRDataStoreVersion.getDataStoreType());
            mIRDataTypeConverter = new MIRDataTypeConverter(new MIRDataStoreVersion("ODBC", 1, 0, 0), "");
        }
        return mIRDataTypeConverter;
    }

    public static void updateConnectedNamespace(MIRConnectionNamespace mIRConnectionNamespace, MIRPackage mIRPackage, MIRStoreModel mIRStoreModel, Supplier<MIRPackage> supplier, MIRDataTypeConverter mIRDataTypeConverter) throws MIRException {
        ArrayList<MIRNamespaceElement> arrayList = new ArrayList<MIRNamespaceElement>();
        arrayList.addAll(mIRConnectionNamespace.getNamespaceElements());
        arrayList.addAll(mIRConnectionNamespace.getImportedNamespaceElements());
        boolean bl = mIRPackage instanceof MIRFileDirectory;
        for (MIRObject mIRObject : arrayList) {
            MIRClassifier mIRClassifier;
            MIRNamespaceElement mIRNamespaceElement;
            if (mIRObject.isInstanceOf((short)75)) {
                MIRConnectionSummarizer.updateConnectedClass(mIRPackage, mIRDataTypeConverter, (MIRClassifier)mIRObject, bl);
                continue;
            }
            if (!mIRObject.isInstanceOf((short)321)) continue;
            String string = MIRBridgeLib.getPhysicalName(mIRObject);
            MIRNamespaceElement mIRNamespaceElement2 = mIRNamespaceElement = mIRPackage != null ? mIRPackage.getNamespaceElement(string) : mIRStoreModel.getDataPackage(string);
            if (mIRNamespaceElement == null) {
                mIRNamespaceElement = supplier.get();
                mIRNamespaceElement.setName(string);
                if (mIRPackage != null) {
                    mIRPackage.addNamespaceElement(mIRNamespaceElement);
                } else {
                    mIRStoreModel.addDataPackage((MIRDataPackage)mIRNamespaceElement);
                }
            } else {
                if (mIRNamespaceElement.isInstanceOf((short)75)) {
                    MIRConnectionSummarizer.mergeConnectedClassifiers((MIRClassifier)mIRNamespaceElement, (MIRConnectionNamespace)mIRObject, mIRDataTypeConverter);
                    continue;
                }
                if (!mIRNamespaceElement.isInstanceOf((short)144)) {
                    BLIB.ERR_FILE_DIRECTORY_COLLISION.log(mIRPackage.getPath(), MIRElementType.getName(mIRNamespaceElement.getElementType()), mIRObject.getPath());
                    continue;
                }
            }
            if (convertPartionFolderClasses && (mIRClassifier = MIRConnectionSummarizer.getPartionFolderClass(mIRStoreModel, (MIRConnectionNamespace)mIRObject, bl)) != null) {
                MIRConnectionSummarizer.createPartionFolderClassifier(mIRPackage, (MIRDataPackage)mIRNamespaceElement, mIRClassifier, (MIRConnectionNamespace)mIRObject, mIRDataTypeConverter);
                continue;
            }
            MIRConnectionSummarizer.updateConnectedNamespace((MIRConnectionNamespace)mIRObject, (MIRPackage)mIRNamespaceElement, mIRStoreModel, supplier, mIRDataTypeConverter);
        }
        for (MIRClassifier mIRClassifier : mIRConnectionNamespace.getClassifiers()) {
            MIRConnectionSummarizer.updateConnectedClass(mIRPackage, mIRDataTypeConverter, mIRClassifier, bl);
        }
    }

    private static MIRClassifier getPartionFolderClass(MIRStoreModel mIRStoreModel, MIRDataPackage mIRDataPackage, boolean bl) {
        String string;
        MIRClassifier mIRClassifier = null;
        String string2 = string = mIRStoreModel != null ? mIRStoreModel.getName() : "";
        if (bl && string != null && !string.equals("Working directory") && !string.equals("/")) {
            ArrayList<MIRNamespaceElement> arrayList = new ArrayList<MIRNamespaceElement>();
            arrayList.addAll(mIRDataPackage.getNamespaceElements());
            arrayList.addAll(mIRDataPackage.getImportedNamespaceElements());
            if (mIRDataPackage.isInstanceOf((short)356)) {
                arrayList.addAll(((MIRConnectionDataPackage)mIRDataPackage).getClassifiers());
            }
            for (MIRObject mIRObject : arrayList) {
                if (!mIRObject.isInstanceOf((short)75) || !mIRObject.getName().contains("*") && !mIRObject.getName().contains("?")) continue;
                mIRClassifier = (MIRClassifier)mIRObject;
                break;
            }
        }
        return mIRClassifier;
    }

    private static MIRClassifier createPartionFolderClassifier(MIRPackage mIRPackage, MIRDataPackage mIRDataPackage, MIRClassifier mIRClassifier, MIRDataPackage mIRDataPackage2, MIRDataTypeConverter mIRDataTypeConverter) {
        MIRClassifier mIRClassifier2 = null;
        if (convertPartionFolderClasses) {
            mIRClassifier2 = MIRConnectionSummarizer.getClassifier(mIRDataPackage, mIRDataTypeConverter, mIRClassifier, true);
            BLIB.WRN_PARTITIONCREATED.log(MIRBridgeLib.getFilePath(mIRDataPackage));
            mIRPackage.removeNamespaceElement(mIRDataPackage);
            mIRPackage.removeImportedNamespaceElement(mIRDataPackage);
            mIRDataPackage.removeNamespaceElement(mIRClassifier2);
            mIRClassifier2.setName(mIRDataPackage.getName());
            mIRClassifier2.setPhysicalName(mIRDataPackage.getPhysicalName());
            mIRPackage.addNamespaceElement(mIRClassifier2);
            MIRConnectionSummarizer.mergeConnectedClassifiers(mIRClassifier2, mIRDataPackage, mIRDataTypeConverter);
            MIRConnectionSummarizer.mergeConnectedClassifiers(mIRClassifier2, mIRDataPackage2, mIRDataTypeConverter);
            mIRDataPackage.delete();
        }
        return mIRClassifier2;
    }

    public static void mergeConnectedClass(MIRClassifier mIRClassifier, MIRClassifier mIRClassifier2, MIRDataTypeConverter mIRDataTypeConverter) {
        MIRStoreModel mIRStoreModel = (MIRStoreModel)mIRClassifier2.getRootModel();
        mIRClassifier2.setLineageOption(mIRClassifier.getLineageOptions());
        MIRFlatFileDescriptor mIRFlatFileDescriptor = null;
        MIRFlatFileDescriptor mIRFlatFileDescriptor2 = null;
        if (mIRClassifier2.isInstanceOf((short)209)) {
            if (!(mIRClassifier2.getNativeType().contains(mIRClassifier.getNativeType()) || mIRClassifier2.hasLineageOption(16384) || mIRClassifier2.getNativeType().isEmpty() || mIRClassifier.getNativeType().isEmpty())) {
                if (mIRClassifier.getNativeType().compareTo(mIRClassifier2.getNativeType()) < 0) {
                    mIRClassifier2.setNativeType(mIRClassifier.getNativeType() + " " + mIRClassifier2.getNativeType());
                } else {
                    mIRClassifier2.setNativeType(mIRClassifier2.getNativeType() + " " + mIRClassifier.getNativeType());
                }
            }
            mIRFlatFileDescriptor = ((MIRFlatTextFile)mIRClassifier2).getFlatFileDescriptor();
            if (mIRClassifier.isInstanceOf((short)254)) {
                MIRConnectedTransformation mIRConnectedTransformation = ((MIRConnectionDataSet)mIRClassifier).getConnectedTransformation();
                if (mIRConnectedTransformation != null) {
                    mIRFlatFileDescriptor2 = mIRConnectedTransformation.getFlatFileDescriptor();
                }
            } else if (mIRClassifier.isInstanceOf((short)209)) {
                mIRFlatFileDescriptor2 = ((MIRFlatTextFile)mIRClassifier).getFlatFileDescriptor();
            } else if (mIRClassifier.isInstanceOf((short)243)) {
                mIRFlatFileDescriptor2 = ((MIRQueryTable)mIRClassifier).getFlatFileDescriptor();
            }
            if (mIRFlatFileDescriptor == null) {
                if (mIRFlatFileDescriptor2 != null) {
                    mIRFlatFileDescriptor = mIRFlatFileDescriptor2.isInstanceOf((short)325) ? new MIRDelimitedFileDescriptor() : new MIRFixedWidthFileDescriptor();
                    mIRFlatFileDescriptor.setFrom(mIRFlatFileDescriptor2);
                    ((MIRFlatTextFile)mIRClassifier2).addFlatFileDescriptor(mIRFlatFileDescriptor);
                }
            } else if (mIRFlatFileDescriptor2 != null && mIRFlatFileDescriptor.isInstanceOf((short)325) && mIRFlatFileDescriptor2.isInstanceOf((short)326)) {
                ((MIRFlatTextFile)mIRClassifier2).removeFlatFileDescriptor();
                mIRFlatFileDescriptor = new MIRFixedWidthFileDescriptor();
                mIRFlatFileDescriptor.setFrom(mIRFlatFileDescriptor2);
                ((MIRFlatTextFile)mIRClassifier2).addFlatFileDescriptor(mIRFlatFileDescriptor);
            }
        }
        boolean bl = false;
        if (mIRFlatFileDescriptor != null && mIRFlatFileDescriptor2 != null) {
            bl = mIRClassifier.getFeatureCount() == 1 && mIRClassifier2.getFeatureCount() == 1 && mIRFlatFileDescriptor.getElementType() != mIRFlatFileDescriptor2.getElementType();
        } else {
            boolean bl2;
            boolean bl3 = bl2 = mIRFlatFileDescriptor != null && mIRStoreModel.getSystemType().equals(VSAM_STORE);
            if (bl2) {
                return;
            }
        }
        block7: for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
            MIRModelObject mIRModelObject;
            MIRType mIRType;
            if (MIRConnectionSummarizer.isCondition(mIRFeature)) continue;
            MIRFeature mIRFeature2 = null;
            String string = MIRBridgeLib.getPhysicalName(mIRFeature);
            if (mIRFlatFileDescriptor != null) {
                if (mIRFlatFileDescriptor.getNativeType().equals(VSAM_STORE)) {
                    mIRFeature2 = MIRBridgeLib.getFeatureByPosition(mIRClassifier2, mIRFeature.getPosition());
                } else {
                    if (mIRFeature.hasLineageOption(512) && mIRFeature.getPosition() < 0) {
                        BLIB.WRN_NO_POSITION.log(mIRFeature.getPath());
                    }
                    if (mIRFeature.hasLineageOption(512) && mIRFeature.hasLineageOption(8192)) {
                        BLIB.WRN_BY_NAME_AND_POSITION.log(mIRFeature.getPath());
                    }
                    HowToStitch howToStitch = HowToStitch.Unknown;
                    howToStitch = mIRFeature.getPosition() < 0 ? (mIRFeature.hasLineageOption(512) ? HowToStitch.stitchSkip : HowToStitch.stitchByName) : ((mIRFeature.hasLineageOption(8192) || MIRConnectionSummarizer.isStarFeature(mIRFeature)) && !mIRFeature.hasLineageOption(512) ? HowToStitch.stitchByName : HowToStitch.stitchByPos);
                    switch (howToStitch) {
                        case stitchSkip: 
                        case Unknown: {
                            continue block7;
                        }
                        case stitchByName: {
                            mIRFeature2 = mIRClassifier2.getFeature(string);
                            if (mIRFeature2 == null) break;
                            mIRFeature2.setLineageOption(mIRFeature.getLineageOptions());
                            mIRFeature2.setPosition((short)0);
                            break;
                        }
                        case stitchByPos: {
                            mIRFeature2 = MIRBridgeLib.getFeatureByPosition(mIRClassifier2, mIRFeature.getPosition());
                            if (mIRFeature2 == null || mIRFeature2.getName().compareTo(mIRFeature.getName()) >= 0) break;
                            mIRFeature2.setUniqueName(mIRFeature.getName(), '_');
                        }
                    }
                }
            } else {
                mIRFeature2 = mIRClassifier2.getFeature(string);
                if (mIRFeature2 != null) {
                    MIRFeature mIRFeature3;
                    if (!mIRFeature.hasLineageOption(1) && mIRFeature2.hasLineageOption(1)) {
                        mIRFeature2.unsetLineageOption(1);
                    }
                    mIRFeature2.setLineageOption(mIRFeature.getLineageOptions());
                    if (mIRFeature2.getPosition() == 0) {
                        mIRFeature2.setPosition(mIRFeature.getPosition());
                    }
                    if (mIRFeature.getType() == null && (mIRFeature3 = MIRConnectionSummarizer.getPropgatedTypeFeature(mIRFeature)) != null && mIRFeature3.getType() != null) {
                        mIRFeature.addType(mIRFeature3.getType());
                    }
                }
            }
            if (mIRFeature2 != null || bl) continue;
            mIRFeature2 = mIRClassifier2.isInstanceOf((short)106) ? new MIRDataAttribute() : (mIRClassifier2.isInstanceOf((short)25) ? new MIRSQLViewAttribute() : new MIRAttribute());
            mIRFeature2.setFrom(mIRFeature);
            mIRFeature2.setName(string);
            mIRFeature2.setPhysicalName("");
            if (mIRFeature.hasLineageOption(8192)) {
                mIRFeature2.setPosition((short)0);
            }
            mIRClassifier2.addFeatureUniqueName(mIRFeature2);
            if (mIRFlatFileDescriptor == null) {
                if (!mIRFeature2.getName().equals(mIRFeature.getName())) {
                    mIRFeature2.setPhysicalName(MIRBridgeLib.getPhysicalName(mIRFeature));
                }
            } else if (!mIRFeature.hasLineageOption(8192)) {
                mIRFeature2.setPhysicalName("");
            }
            boolean bl4 = true;
            if (mIRFeature.isInstanceOf((short)99)) {
                bl4 = ((MIRStructuralFeature)mIRFeature).getOptional();
            }
            if ((mIRType = mIRFeature.getType()) == null && (mIRModelObject = MIRConnectionSummarizer.getPropgatedTypeFeature(mIRFeature)) != null) {
                mIRType = ((MIRFeature)mIRModelObject).getType();
                if (mIRModelObject.isInstanceOf((short)99)) {
                    bl4 = ((MIRStructuralFeature)mIRModelObject).getOptional();
                }
            }
            if (mIRFeature2.isInstanceOf((short)14)) {
                ((MIRAttribute)mIRFeature2).setOptional(bl4);
            }
            mIRModelObject = null;
            if (mIRType != null) {
                if (mIRType.isInstanceOf((short)66)) {
                    MIRType mIRType2 = MIRConnectionSummarizer.getType(mIRFeature2, mIRType);
                    MIRClass mIRClass = ((MIRClassType)mIRType).getAssociatedClass();
                    if (mIRClass == null) continue;
                    MIRPackage mIRPackage = MIRConnectionSummarizer.getPackage(mIRClass, mIRStoreModel);
                    MIRClass mIRClass2 = (MIRClass)MIRConnectionSummarizer.getClassifier(mIRPackage, mIRDataTypeConverter, mIRClass, false);
                    MIRConnectionSummarizer.mergeConnectedClass(mIRClass, mIRClass2, mIRDataTypeConverter);
                    ((MIRClassType)mIRType2).addAssociatedClass(mIRClass2);
                    continue;
                }
                if (mIRDataTypeConverter == null) {
                    if (mIRType.isInstanceOf((short)4)) {
                        mIRModelObject = mIRStoreModel.getType(mIRType.getName());
                    }
                    if (mIRModelObject == null) {
                        mIRModelObject = MIRConnectionSummarizer.copyType(mIRType, mIRFeature2);
                    }
                } else {
                    mIRModelObject = new MIRDerivedType();
                    try {
                        mIRModelObject.setName(mIRDataTypeConverter.getExportTypeName(mIRType.getDataType()));
                    }
                    catch (MIRException mIRException) {
                        mIRModelObject.setName(mIRType.getDataType());
                    }
                    ((MIRConcreteType)mIRModelObject).setDataType(mIRType.getDataType());
                    ((MIRConcreteType)mIRModelObject).setLength(mIRType.getLength());
                    ((MIRConcreteType)mIRModelObject).setScale(mIRType.getScale());
                    ((MIRConcreteType)mIRModelObject).setNativeDataType(mIRType.getNativeDataType());
                    if (mIRFeature.getType() == null) {
                        mIRFeature.addType(mIRType);
                    }
                    ((MIRDerivedType)mIRModelObject).addDerivedFromConcreteType(MIRTypeLib.getBaseType(mIRStoreModel, MIRBaseTypeList.getLogicalName(((MIRType)mIRModelObject).getDataType())));
                }
            }
            if (mIRFeature2.getType() == null) {
                mIRFeature2.addType((MIRType)(mIRModelObject == null ? MIRTypeLib.getUndefinedBaseType(mIRStoreModel) : mIRModelObject));
            }
            if (mIRModelObject == null || null != ((MIRType)mIRModelObject).getModel()) continue;
            mIRStoreModel.addType((MIRType)mIRModelObject);
        }
    }

    private static boolean isStarFeature(MIRFeature mIRFeature) {
        return mIRFeature != null && mIRFeature.getName().equals("*") && mIRFeature.hasLineageOption(256);
    }

    public static MIRClassifier getClassifier(MIRPackage mIRPackage, MIRDataTypeConverter mIRDataTypeConverter, MIRClassifier mIRClassifier, boolean bl) {
        MIRModelObject mIRModelObject;
        MIRClassifier mIRClassifier2 = null;
        boolean bl2 = mIRClassifier.isInstanceOf((short)243);
        String string = bl2 ? mIRClassifier.getName() : MIRBridgeLib.getPhysicalName(mIRClassifier);
        String string2 = MIRBridgeLib.getPhysicalName(mIRClassifier);
        MIRNamespaceElement mIRNamespaceElement = mIRPackage.getNamespaceElement(string);
        if (mIRNamespaceElement == null && !string2.isEmpty()) {
            mIRNamespaceElement = mIRPackage.getNamespaceElement(string2);
        }
        if (mIRNamespaceElement == null) {
            mIRNamespaceElement = mIRPackage.getImportedNamespaceElement(string2);
        }
        if (mIRNamespaceElement != null) {
            if (mIRNamespaceElement.isInstanceOf((short)75)) {
                mIRClassifier2 = (MIRClassifier)mIRNamespaceElement;
            } else if (mIRNamespaceElement.isInstanceOf((short)67)) {
                mIRModelObject = (MIRStoredProcedure)mIRNamespaceElement;
                mIRClassifier2 = ((MIRStoredProcedure)mIRModelObject).getResultDataSet();
            } else if (bl) {
                if (mIRNamespaceElement.isInstanceOf((short)207)) {
                    mIRClassifier2 = MIRConnectionSummarizer.convertToPartionFolderClassifier((MIRDataPackage)mIRPackage, (MIRFileDirectory)mIRNamespaceElement, mIRDataTypeConverter, mIRClassifier);
                    return mIRClassifier2;
                }
                BLIB.ERR_FILE_DIRECTORY_COLLISION.log(mIRPackage.getPath(), MIRElementType.getName(mIRNamespaceElement.getElementType()), mIRClassifier.getPath());
                return null;
            }
        }
        if (!bl && mIRClassifier.getFeatureCount() == 0 && mIRClassifier.isInstanceOf((short)254) && mIRClassifier.getDestinationOfClassifierMap() != null) {
            mIRModelObject = new MIRConnectionDataAttribute();
            mIRModelObject.setName("*");
            ((MIRFeature)mIRModelObject).setLineageOption(256);
            mIRClassifier.addFeature((MIRFeature)mIRModelObject);
        }
        if (mIRClassifier2 == null) {
            if (bl) {
                mIRClassifier2 = new MIRFlatTextFile();
                mIRClassifier2.setFrom(mIRClassifier);
                mIRPackage.addNamespaceElement(mIRClassifier2);
            } else if (mIRClassifier.getNativeType().contains(NATIVE_TYPE_STORED_PROCEDURE)) {
                mIRModelObject = new MIRStoredProcedure();
                mIRModelObject.setName(mIRClassifier.getName());
                MIRDataSet mIRDataSet = new MIRDataSet();
                ((MIRStoredProcedure)mIRModelObject).addResultDataSet(mIRDataSet);
                mIRPackage.addNamespaceElementUniqueName((MIRNamespaceElement)mIRModelObject);
                mIRClassifier2 = mIRDataSet;
                mIRClassifier2.setFrom(mIRClassifier);
            } else {
                mIRClassifier2 = mIRClassifier.getNativeType().contains(NATIVE_TYPE_VIEW) ? new MIRSQLViewEntity() : new MIRClass();
                mIRClassifier2.setFrom(mIRClassifier);
                mIRPackage.addNamespaceElement(mIRClassifier2);
                if (mIRClassifier.getRootModel() instanceof MIRDiModel && mIRClassifier2 instanceof MIRClass) {
                    ((MIRClass)mIRClassifier2).setCppPersistent(true);
                }
            }
            if (bl2) {
                mIRClassifier2.setName(string2);
                mIRClassifier2.setPhysicalName(mIRClassifier.getPhysicalName());
            }
        }
        return mIRClassifier2;
    }

    public static MIRClassifier updateConnectedClass(MIRPackage mIRPackage, MIRDataTypeConverter mIRDataTypeConverter, MIRClassifier mIRClassifier, boolean bl) {
        MIRClassifier mIRClassifier2 = MIRConnectionSummarizer.getClassifier(mIRPackage, mIRDataTypeConverter, mIRClassifier, bl);
        MIRConnectionSummarizer.mergeConnectedClass(mIRClassifier, mIRClassifier2, mIRDataTypeConverter);
        return mIRClassifier2;
    }

    private static MIRFeature getPropgatedTypeFeature(MIRFeature mIRFeature) {
        MIRFeature mIRFeature2;
        MIRFeature mIRFeature3 = null;
        if (mIRFeature3 == null && mIRFeature.getDestinationOfFeatureMap() != null && mIRFeature.getDestinationOfFeatureMap().getSourceFeatureCount() != 0) {
            mIRFeature3 = mIRFeature.getDestinationOfFeatureMap().getSourceFeatures().first();
        }
        if ((mIRFeature3 == null || mIRFeature3.getType() == null) && mIRFeature.getSourceOfFeatureMapCount() != 0 && (mIRFeature2 = mIRFeature.getSourceOfFeatureMaps().first().getDestinationFeature()) != null) {
            mIRFeature3 = mIRFeature2;
        }
        return mIRFeature3;
    }

    private static void updateStoredProcedure(MIRStoreModel mIRStoreModel, MIRDataPackage mIRDataPackage, MIRDataTypeConverter mIRDataTypeConverter, MIRStoredProcedure mIRStoredProcedure) {
        MIRStoredProcedure mIRStoredProcedure2 = null;
        MIRNamespaceElement mIRNamespaceElement = mIRDataPackage.getNamespaceElement(MIRBridgeLib.getPhysicalName(mIRStoredProcedure));
        if (mIRNamespaceElement == null) {
            mIRStoredProcedure2 = new MIRStoredProcedure(mIRStoredProcedure);
            mIRDataPackage.addNamespaceElement(mIRStoredProcedure2);
        } else if (mIRNamespaceElement.isInstanceOf((short)67)) {
            mIRStoredProcedure2 = (MIRStoredProcedure)mIRNamespaceElement;
        }
        if (mIRStoredProcedure2 != null) {
            MIRDataSet mIRDataSet;
            MIRDataSet mIRDataSet2 = mIRStoredProcedure.getResultDataSet();
            if (mIRDataSet2 != null) {
                mIRDataSet = mIRStoredProcedure2.getResultDataSet();
                if (mIRDataSet == null) {
                    mIRDataSet = new MIRDataSet(mIRDataSet2);
                    mIRStoredProcedure2.addResultDataSet(mIRDataSet);
                }
                MIRConnectionSummarizer.mergeConnectedClass(mIRDataSet2, mIRDataSet, mIRDataTypeConverter);
            }
            if ((mIRDataSet = mIRStoredProcedure.getParametersDataSet()) != null) {
                MIRDataSet mIRDataSet3 = mIRStoredProcedure2.getParametersDataSet();
                if (mIRDataSet3 == null) {
                    mIRDataSet3 = new MIRDataSet(mIRDataSet);
                    mIRStoredProcedure2.addParametersDataSet(mIRDataSet3);
                }
                MIRConnectionSummarizer.mergeConnectedClass(mIRDataSet, mIRDataSet3, mIRDataTypeConverter);
            }
        }
    }

    private static MIRClassifier convertToPartionFolderClassifier(MIRDataPackage mIRDataPackage, MIRDataPackage mIRDataPackage2, MIRDataTypeConverter mIRDataTypeConverter, MIRClassifier mIRClassifier) {
        BLIB.WRN_PARTITIONCREATED.log(MIRBridgeLib.getFilePath(mIRDataPackage2));
        mIRDataPackage.removeImportedNamespaceElement(mIRDataPackage2);
        mIRDataPackage.removeNamespaceElement(mIRDataPackage2);
        MIRClassifier mIRClassifier2 = MIRConnectionSummarizer.updateConnectedClass(mIRDataPackage, mIRDataTypeConverter, mIRClassifier, true);
        MIRConnectionSummarizer.mergeConnectedClassifiers(mIRClassifier2, mIRDataPackage2, mIRDataTypeConverter);
        mIRDataPackage2.delete();
        return mIRClassifier2;
    }

    public static void mergeConnectedClassifiers(MIRClassifier mIRClassifier, MIRDataPackage mIRDataPackage, MIRDataTypeConverter mIRDataTypeConverter) {
        mIRClassifier.setLineageOption(16384);
        ArrayList<MIRNamespaceElement> arrayList = new ArrayList<MIRNamespaceElement>();
        arrayList.addAll(mIRDataPackage.getNamespaceElements());
        arrayList.addAll(mIRDataPackage.getImportedNamespaceElements());
        if (mIRDataPackage.isInstanceOf((short)356)) {
            arrayList.addAll(((MIRConnectionDataPackage)mIRDataPackage).getClassifiers());
        }
        for (MIRNamespaceElement mIRNamespaceElement : arrayList) {
            if (mIRNamespaceElement.isInstanceOf((short)75)) {
                BLIB.WRN_FILEMERGED.log(MIRBridgeLib.getFilePath(mIRNamespaceElement), MIRBridgeLib.getFilePath(mIRClassifier));
                MIRConnectionSummarizer.mergeConnectedClass((MIRClassifier)mIRNamespaceElement, mIRClassifier, mIRDataTypeConverter);
                continue;
            }
            if (!mIRNamespaceElement.isInstanceOf((short)141)) continue;
            MIRConnectionSummarizer.mergeConnectedClassifiers(mIRClassifier, (MIRDataPackage)mIRNamespaceElement, mIRDataTypeConverter);
        }
        mIRClassifier.setNativeType("Partitioned");
    }

    public static MIRPackage getPackage(MIRClassifier mIRClassifier, MIRStoreModel mIRStoreModel) {
        MIRPackage mIRPackage = null;
        Stack<MIRPackage> stack = new Stack<MIRPackage>();
        for (MIRObject mIRObject = mIRClassifier.getParent(); mIRObject != null; mIRObject = mIRObject.getParent()) {
            if (!mIRObject.isInstanceOf((short)144)) {
                if (mIRObject.isInstanceOf((short)218) || mIRObject.isInstanceOf((short)216)) break;
                stack.clear();
                break;
            }
            stack.push((MIRPackage)mIRObject);
        }
        while (!stack.isEmpty()) {
            MIRPackage mIRPackage2 = (MIRPackage)stack.pop();
            if (mIRPackage == null) {
                mIRPackage = MIRConnectionSummarizer.getPackage(mIRStoreModel, mIRPackage2);
                continue;
            }
            mIRPackage = MIRConnectionSummarizer.getPackage(mIRPackage, mIRPackage2);
        }
        return mIRPackage;
    }

    private static MIRDataPackage getDataPackage(MIRStoreModel mIRStoreModel, String string) {
        MIRDataPackage mIRDataPackage = mIRStoreModel.getDataPackage(string);
        if (mIRDataPackage == null) {
            switch (mIRStoreModel.getStoreType()) {
                case 2: {
                    mIRDataPackage = new MIRFileDirectory();
                    break;
                }
                case 1: {
                    mIRDataPackage = new MIROlapSchema();
                    break;
                }
                default: {
                    mIRDataPackage = new MIRDatabaseSchema();
                }
            }
            mIRDataPackage.setName(string);
            mIRStoreModel.addDataPackage(mIRDataPackage);
        }
        return mIRDataPackage;
    }

    private static MIRDesignPackage getDesignPackage(MIRStoreModel mIRStoreModel, String string) {
        MIRDesignPackage mIRDesignPackage = mIRStoreModel.getDesignPackage(string);
        if (mIRDesignPackage == null) {
            mIRDesignPackage = new MIRDesignPackage();
            mIRDesignPackage.setName(string);
            mIRStoreModel.addDesignPackage(mIRDesignPackage);
        }
        return mIRDesignPackage;
    }

    private static MIRPackage getPackage(MIRStoreModel mIRStoreModel, MIRPackage mIRPackage) {
        String string = mIRPackage.getNamespaceName(mIRPackage);
        MIRPackage mIRPackage2 = null;
        switch (mIRPackage.getElementType()) {
            case 9: {
                mIRPackage2 = MIRConnectionSummarizer.getDesignPackage(mIRStoreModel, string);
                break;
            }
            case 141: {
                mIRPackage2 = MIRConnectionSummarizer.getDataPackage(mIRStoreModel, string);
            }
        }
        return mIRPackage2;
    }

    private static MIRPackage getPackage(MIRPackage mIRPackage, MIRPackage mIRPackage2) {
        String string = mIRPackage2.getNamespaceName(mIRPackage2);
        MIRPackage mIRPackage3 = (MIRPackage)mIRPackage.getNamespaceElement(string);
        if (mIRPackage3 == null) {
            mIRPackage3 = (MIRPackage)MIRAllClasses.createMIRObject(mIRPackage.getElementType());
            mIRPackage3.setName(string);
            mIRPackage.addNamespaceElement(mIRPackage3);
        }
        return mIRPackage3;
    }

    public static MIRNamespaceElement getNamespaceElement(MIRElement mIRElement, MIRNamespaceElement mIRNamespaceElement) {
        MIRNamespaceElement mIRNamespaceElement2 = null;
        short s = mIRNamespaceElement.getElementType();
        switch (mIRElement.getElementType()) {
            case 2: {
                if (s == 9) {
                    mIRNamespaceElement2 = ((MIRStoreModel)mIRElement).getDesignPackage(mIRNamespaceElement.getName());
                    break;
                }
                if (s != 141) break;
                mIRNamespaceElement2 = ((MIRStoreModel)mIRElement).getDataPackage(mIRNamespaceElement.getName());
                break;
            }
            case 144: {
                if (s != 144) break;
                mIRNamespaceElement2 = ((MIRPackage)mIRElement).getNamespaceElement(mIRNamespaceElement.getName());
            }
        }
        return mIRNamespaceElement2;
    }

    private static MIRType getType(MIRFeature mIRFeature, MIRType mIRType) {
        MIRType mIRType2 = mIRFeature.getType();
        if (mIRType2 == null) {
            if (mIRType.isInstanceOf((short)4)) {
                mIRType2 = MIRTypeLib.getBaseType(mIRFeature.getRootModel(), MIRBaseTypeList.getLogicalName(mIRType.getDataType()));
            } else {
                mIRType2 = (MIRType)MIRAllClasses.createMIRObject(mIRType.getElementType());
                mIRType2.setFrom(mIRType);
                mIRFeature.getRootModel().addType(mIRType2);
            }
            mIRFeature.addType(mIRType2);
        }
        return mIRType2;
    }

    private static MIRType copyType(MIRType mIRType, MIRFeature mIRFeature) {
        MIRType mIRType2 = (MIRType)MIRAllClasses.createMIRObject(mIRType.getElementType());
        mIRType2.setFrom(mIRType);
        mIRFeature.addType(mIRType2);
        mIRFeature.getRootModel().addType(mIRType2);
        if (mIRType.getElementType() == 5 && mIRType2.getElementType() == 5) {
            MIRConnectionSummarizer.mergeDerivedTypes((MIRDerivedType)mIRType2, (MIRDerivedType)mIRType);
        }
        return mIRType2;
    }

    private static void mergeDerivedTypes(MIRDerivedType mIRDerivedType, MIRDerivedType mIRDerivedType2) {
        MIRConcreteType mIRConcreteType = mIRDerivedType2.getDerivedFromConcreteType();
        MIRConcreteType mIRConcreteType2 = mIRDerivedType.getDerivedFromConcreteType();
        if (mIRConcreteType2 == null) {
            mIRConcreteType2 = (MIRConcreteType)MIRAllClasses.createMIRObject(mIRConcreteType.getElementType());
            mIRConcreteType2.setFrom(mIRConcreteType);
            mIRDerivedType.addDerivedFromConcreteType(mIRConcreteType2);
            mIRDerivedType.getRootModel().addType(mIRConcreteType2);
        }
        if (mIRConcreteType.getElementType() == 5 && mIRConcreteType2.getElementType() == 5) {
            MIRConnectionSummarizer.mergeDerivedTypes((MIRDerivedType)mIRConcreteType2, (MIRDerivedType)mIRConcreteType);
        }
    }

    private static boolean isCondition(MIRFeature mIRFeature) {
        return mIRFeature.isInstanceOf((short)84) | mIRFeature.isInstanceOf((short)333) | mIRFeature.isInstanceOf((short)334) | mIRFeature.isInstanceOf((short)335);
    }

    static enum HowToStitch {
        Unknown,
        stitchByPos,
        stitchByName,
        stitchSkip;

    }
}

