/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib;

import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.bridgelib.MIRStoreConnectionSummarizer;
import MITI.bridges.bridgelib.MIRUdpLib;
import MITI.expression.analyzer.MIRExpressionAnalyzer;
import MITI.expression.analyzer.MIRExpressionAnalyzerHelper;
import MITI.expression.analyzer.engine.CollationMode;
import MITI.expression.analyzer.engine.MIRParserOptions;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRConnectionDataPackage;
import MITI.sdk.MIRConnectionNamespace;
import MITI.sdk.MIRConnectionPackage;
import MITI.sdk.MIRContent;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRMappingModel;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRPropertyType;
import MITI.sdk.MIRPropertyValue;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRSystemPackage;
import MITI.util.MiscParams;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class MIRConnectionManager {
    private GuiderConnectionMerge guiderConnectionMerge;
    private GuiderConnectionSplit guiderConnectionSplit;
    private GuiderFileConnectionSplit guiderFileConnectionSplit;
    private GuiderConnectionCast guiderConnectionCast;
    private GuiderConnectionCollation guiderConnectionCollation;
    private boolean isPurview;
    private boolean isLegacyMode;
    protected String miscString;
    protected ConnectionLevel connectionLevel;

    private MIRConnectionManager() {
        this._init("");
    }

    public static MIRConnectionManager getInstance() {
        return MIRConnectionManagerHolder.SINGLE_INSTANCE;
    }

    public static void init(String string) {
        MIRConnectionManager mIRConnectionManager = MIRConnectionManagerHolder.SINGLE_INSTANCE;
        mIRConnectionManager._init(string);
    }

    public void setServerName(MIRSystemPackage mIRSystemPackage, String string) {
        if (string == null || string.isEmpty()) {
            string = this.guiderConnectionMerge.imvDefaultServer;
        }
        if (string != null && !string.isEmpty() && !MIRConnectionManager.getInstance().isLegacyMode) {
            MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRSystemPackage.getRootModel(), mIRSystemPackage.getElementType(), "Server", (byte)0, "Connection", "", "SQL_VARCHAR", true, "");
            MIRUdpLib.setPropertyValue(mIRPropertyType, string, mIRSystemPackage);
        }
    }

    public static String getServerName(MIRSystemPackage mIRSystemPackage) {
        String string = null;
        if (mIRSystemPackage == null) {
            return string;
        }
        MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRSystemPackage.getRootModel(), mIRSystemPackage.getElementType(), "Server", (byte)0, "Connection", "", "SQL_VARCHAR", false, "");
        if (mIRPropertyType != null) {
            string = MIRUdpLib.getPropertyValueValue(mIRPropertyType, mIRSystemPackage);
        }
        if (string != null && !MIRConnectionManager.getInstance().isPurview) {
            string = string.toUpperCase();
        }
        return string;
    }

    public void setDatabaseName(MIRSystemPackage mIRSystemPackage, String string) {
        if (string == null || string.isEmpty()) {
            string = this.guiderConnectionMerge.imvDefaultDatabase;
        }
        if (string != null && !string.isEmpty() && !MIRConnectionManager.getInstance().isLegacyMode) {
            MIRConnectionManager.removePropertyValue("Catalog", mIRSystemPackage);
            MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRSystemPackage.getRootModel(), mIRSystemPackage.getElementType(), "Database", (byte)0, "Connection", "", "SQL_VARCHAR", true, "");
            MIRUdpLib.setPropertyValue(mIRPropertyType, string, mIRSystemPackage);
        } else if (string == null) {
            MIRConnectionManager.removePropertyValue("Database", mIRSystemPackage);
        }
    }

    public static String getDatabaseName(MIRSystemPackage mIRSystemPackage) {
        String string = null;
        if (mIRSystemPackage == null) {
            return string;
        }
        MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRSystemPackage.getRootModel(), mIRSystemPackage.getElementType(), "Database", (byte)0, "Connection", "", "SQL_VARCHAR", false, "");
        if (mIRPropertyType != null) {
            string = MIRUdpLib.getPropertyValueValue(mIRPropertyType, mIRSystemPackage);
        }
        return string;
    }

    public static void setCatalogName(MIRSystemPackage mIRSystemPackage, String string) {
        if (string != null && !string.isEmpty() && !MIRConnectionManager.getInstance().isLegacyMode) {
            MIRConnectionManager.removePropertyValue("Database", mIRSystemPackage);
            MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRSystemPackage.getRootModel(), mIRSystemPackage.getElementType(), "Catalog", (byte)0, "Connection", "", "SQL_VARCHAR", true, "");
            MIRUdpLib.setPropertyValue(mIRPropertyType, string, mIRSystemPackage);
        } else if (string == null) {
            MIRConnectionManager.removePropertyValue("Database", mIRSystemPackage);
        }
    }

    public static String getCatalogName(MIRSystemPackage mIRSystemPackage) {
        String string = null;
        if (mIRSystemPackage == null) {
            return string;
        }
        MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRSystemPackage.getRootModel(), mIRSystemPackage.getElementType(), "Catalog", (byte)0, "Connection", "", "SQL_VARCHAR", false, "");
        if (mIRPropertyType != null) {
            string = MIRUdpLib.getPropertyValueValue(mIRPropertyType, mIRSystemPackage);
        }
        return string;
    }

    public static void setSchemaName(MIRSystemPackage mIRSystemPackage, String string) {
        if (string != null && !string.isEmpty() && !MIRConnectionManager.getInstance().isLegacyMode) {
            MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRSystemPackage.getRootModel(), mIRSystemPackage.getElementType(), "Schema", (byte)0, "Connection", "", "SQL_VARCHAR", true, "");
            MIRUdpLib.setPropertyValue(mIRPropertyType, string, mIRSystemPackage);
        } else if (string == null) {
            MIRConnectionManager.removePropertyValue("Schema", mIRSystemPackage);
        }
    }

    public static String getSchemaName(MIRSystemPackage mIRSystemPackage) {
        String string = null;
        if (mIRSystemPackage == null) {
            return string;
        }
        MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRSystemPackage.getRootModel(), mIRSystemPackage.getElementType(), "Schema", (byte)0, "Connection", "", "SQL_VARCHAR", false, "");
        if (mIRPropertyType != null) {
            string = MIRUdpLib.getPropertyValueValue(mIRPropertyType, mIRSystemPackage);
        }
        return string;
    }

    public static void setConnectionName(MIRSystemPackage mIRSystemPackage, String string) {
        if (string != null && !string.isEmpty() && !MIRConnectionManager.getInstance().isLegacyMode) {
            MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRSystemPackage.getRootModel(), mIRSystemPackage.getElementType(), "Connection", (byte)0, "Connection", "", "SQL_VARCHAR", true, "");
            MIRUdpLib.setPropertyValue(mIRPropertyType, string, mIRSystemPackage);
        }
    }

    public static String getConnectionName(MIRSystemPackage mIRSystemPackage) {
        String string = null;
        if (mIRSystemPackage == null) {
            return string;
        }
        MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRSystemPackage.getRootModel(), mIRSystemPackage.getElementType(), "Connection", (byte)0, "Connection", "", "SQL_VARCHAR", false, "");
        if (mIRPropertyType != null) {
            string = MIRUdpLib.getPropertyValueValue(mIRPropertyType, mIRSystemPackage);
        }
        return string;
    }

    public static String getStoreContentName(MIRStoreConnection mIRStoreConnection) {
        String string = MIRBridgeLib.getPhysicalName(mIRStoreConnection);
        if (mIRStoreConnection.getStoreType() != 0 || MIRConnectionManager.getInstance().guiderConnectionMerge.imvMrgCnnct.containsValue(string)) {
            return string;
        }
        String string2 = null;
        ConnectionLevel connectionLevel = MIRConnectionManager.getInstance().getConnectionLevel();
        String string3 = connectionLevel == ConnectionLevel.SCHEMA ? MIRConnectionManager.getSchemaName(mIRStoreConnection) : null;
        String string4 = "";
        if ((connectionLevel == ConnectionLevel.SCHEMA || connectionLevel == ConnectionLevel.DATABASE || connectionLevel == ConnectionLevel.CATALOG) && (string4 = MIRConnectionManager.getCatalogName(mIRStoreConnection)) == null) {
            string4 = MIRConnectionManager.getDatabaseName(mIRStoreConnection);
        }
        boolean bl = MIRConnectionManager.isCaseInsensitive(mIRStoreConnection);
        String string5 = MIRConnectionManager.getConnectionName(mIRStoreConnection);
        if (null == string5 || string5.isEmpty()) {
            string5 = MIRConnectionManager.getServerName(mIRStoreConnection);
        }
        if (null == string5 || string5.isEmpty()) {
            if ((string4 == null || string4.isEmpty()) && (string3 == null || string3.isEmpty())) {
                return string;
            }
            if (string.equals(MIRConnectionManager.getInstance().getFormattedConnectionName(string4, string3, string5, bl))) {
                return string;
            }
            if (connectionLevel == ConnectionLevel.SCHEMA) {
                string5 = string;
            }
        }
        string2 = MIRConnectionManager.getInstance().getFormattedConnectionName(string4, string3, string5, bl);
        return string2;
    }

    private void _init(String string) {
        if (string == null) {
            string = "";
        }
        if (string.equals(this.miscString) && this.guiderConnectionCast != null) {
            return;
        }
        this.miscString = string;
        MiscParams miscParams = MiscParams.parse(string);
        this.connectionLevel = ConnectionLevel.getByName(miscParams.getValue("-connection.level"));
        this.isPurview = miscParams.contains("-purview") || miscParams.contains("-ms");
        this.isLegacyMode = miscParams.contains("-Informatica");
        this.guiderConnectionCast = new GuiderConnectionCast(miscParams);
        this.guiderConnectionMerge = new GuiderConnectionMerge(miscParams);
        this.guiderConnectionSplit = new GuiderConnectionSplit(miscParams);
        this.guiderFileConnectionSplit = new GuiderFileConnectionSplit(miscParams);
        this.guiderConnectionCollation = new GuiderConnectionCollation(miscParams);
    }

    public String mapPath(String string, boolean bl) {
        return this.guiderFileConnectionSplit.mapPath(string, bl);
    }

    public String getMergeName(String string) {
        return this.guiderConnectionMerge.getMrgName(string);
    }

    public boolean isMergeQuestion() {
        return this.guiderConnectionMerge.imvIsQuestion;
    }

    public ConnectionLevel getConnectionLevel() {
        return this.connectionLevel;
    }

    public String getFormattedConnectionName(String string, String string2) {
        return this.guiderConnectionMerge.getConnectionName(string, string2, false);
    }

    public String getFormattedConnectionName(String string, String string2, String string3) {
        return this.guiderConnectionMerge.getConnectionName(string, string2, false, string3);
    }

    public String getFormattedConnectionName(String string, String string2, String string3, boolean bl) {
        return this.guiderConnectionMerge.getConnectionName(string, string2, string3, bl);
    }

    public String getConnectionName(String string, String string2) {
        return this.guiderConnectionSplit.getGrnConnectionName(string, string2);
    }

    public String getType(String string, String string2) {
        return this.guiderConnectionCast.getType(string, string2);
    }

    public boolean getIsLegacyMode() {
        return this.isLegacyMode;
    }

    private static void removePropertyValue(String string, MIRElement mIRElement) {
        MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRElement.getRootModel(), mIRElement.getElementType(), string, (byte)0, "Connection", "", "SQL_VARCHAR", false, "");
        MIRPropertyValue mIRPropertyValue = MIRUdpLib.getPropertyValue(mIRPropertyType, mIRElement);
        mIRElement.removePropertyValue(mIRPropertyValue);
    }

    public void addCaseInsensitiveConnections(List<String> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        if (this.guiderConnectionCollation.caseInsensitiveConnections == null) {
            this.guiderConnectionCollation.caseInsensitiveConnections = new HashSet();
        }
        for (String string : list) {
            this.guiderConnectionCollation.caseInsensitiveConnections.add(string);
        }
    }

    public boolean isCaseInsensitive(String string) {
        if (string == null || string.isEmpty() || this.guiderConnectionCollation.caseInsensitiveConnections == null) {
            return false;
        }
        if (this.guiderConnectionCollation.caseInsensitiveConnections.isEmpty() || this.guiderConnectionCollation.caseInsensitiveConnections.contains(string)) {
            return true;
        }
        int n = string.indexOf(46);
        String string2 = n != -1 ? string.substring(0, n) : string;
        return this.guiderConnectionCollation.caseInsensitiveConnections.contains(string2 + ".*");
    }

    public boolean isCaseSensitive(String string) {
        if (string == null || string.isEmpty() || this.guiderConnectionCollation.caseSensitiveConnections == null) {
            return false;
        }
        if (this.guiderConnectionCollation.caseSensitiveConnections.isEmpty() || this.guiderConnectionCollation.caseSensitiveConnections.contains(string)) {
            return true;
        }
        int n = string.indexOf(46);
        String string2 = n != -1 ? string.substring(0, n) : string;
        return this.guiderConnectionCollation.caseSensitiveConnections.contains(string2 + ".*");
    }

    public void processConnections(MIRModel mIRModel) {
        String string;
        BLIB.DBG_START_PROCESSING_CONNECTIONS.log(new Object[0]);
        LinkedList<MIRStoreConnection> linkedList = new LinkedList<MIRStoreConnection>(mIRModel.getStoreConnections());
        if (!this.isLegacyMode) {
            for (MIRStoreConnection mIRStoreConnection : linkedList) {
                this.splitConnection(mIRStoreConnection);
            }
        }
        linkedList = new LinkedList<MIRStoreConnection>(mIRModel.getStoreConnections());
        for (MIRStoreConnection mIRStoreConnection : linkedList) {
            string = MIRConnectionManager.getConnectionName(mIRStoreConnection);
            if (string == null || string.isEmpty()) {
                string = MIRConnectionManager.getServerName(mIRStoreConnection);
            }
            String string2 = MIRConnectionManager.getSchemaName(mIRStoreConnection);
            String string3 = MIRConnectionManager.getCatalogName(mIRStoreConnection);
            int n = MIRExpressionAnalyzer.getExpressionDatabaseType(mIRStoreConnection.getSystemType());
            CollationMode collationMode = MIRParserOptions.getCollationMode(n, 0);
            boolean bl = MIRConnectionManager.isCaseInsensitive(mIRStoreConnection);
            string = string2 != null && !string2.isEmpty() || string3 != null && !string3.isEmpty() ? this.guiderConnectionMerge.getConnectionName(string3, string2, string, bl) : (mIRStoreConnection.getName() != null && (mIRStoreConnection.getName().equals(string) || bl && mIRStoreConnection.getName().equalsIgnoreCase(string)) ? mIRStoreConnection.getName() : this.guiderConnectionMerge.getConnectionName(mIRStoreConnection.getName(), string, bl));
            string = this.getMergeName(string);
            if (mIRStoreConnection.getName().equals(string)) continue;
            MIRStoreConnection mIRStoreConnection2 = mIRModel.getStoreConnection(string);
            if (mIRStoreConnection2 == null) {
                mIRStoreConnection.setName(string);
                continue;
            }
            boolean bl2 = MIRStoreConnectionSummarizer.mergeStoreConnections(mIRStoreConnection, mIRStoreConnection2, collationMode);
            if (!bl2 || !(mIRModel instanceof MIRMappingModel)) continue;
            MIRMappingModel mIRMappingModel = (MIRMappingModel)mIRModel;
            if (mIRStoreConnection.getSourceOfMappingModel() != null && mIRStoreConnection2.getSourceOfMappingModel() == null) {
                mIRStoreConnection2.addSourceOfMappingModel(mIRMappingModel);
            }
            if (mIRStoreConnection.getDestinationOfMappingModel() == null || mIRStoreConnection2.getDestinationOfMappingModel() != null) continue;
            mIRStoreConnection2.addDestinationOfMappingModel(mIRMappingModel);
        }
        for (MIRStoreConnection mIRStoreConnection : linkedList) {
            string = this.getType(mIRStoreConnection.getName(), null);
            if (string == null) continue;
            mIRStoreConnection.setSystemType(string);
        }
        BLIB.DBG_STOP_PROCESSING_CONNECTIONS.log(new Object[0]);
    }

    private static boolean isCaseInsensitive(MIRStoreConnection mIRStoreConnection) {
        int n = MIRExpressionAnalyzer.getExpressionDatabaseType(mIRStoreConnection.getSystemType());
        CollationMode collationMode = MIRParserOptions.getCollationMode(n, 0);
        return mIRStoreConnection.getStoreType() == 0 ? collationMode == CollationMode.CaseInsensitive || collationMode == CollationMode.QuotedCaseSensitive : false;
    }

    public static void copyConnectionProperties(MIRSystemPackage mIRSystemPackage, MIRElement mIRElement) {
        LinkedList<MIRElement> linkedList = new LinkedList<MIRElement>();
        linkedList.add(mIRElement);
        if (mIRElement.isInstanceOf((short)159)) {
            linkedList.add(((MIRContent)mIRElement).getModel());
            ConnectionLevel connectionLevel = MIRConnectionManager.getInstance().getConnectionLevel();
            switch (connectionLevel) {
                case CONNECTION: {
                    for (MIRElement mIRElement2 : linkedList) {
                        MIRConnectionManager.removePropertyValue("Database", mIRElement2);
                        MIRConnectionManager.removePropertyValue("Catalog", mIRElement2);
                    }
                    break;
                }
                case DATABASE: 
                case CATALOG: {
                    for (MIRElement mIRElement2 : linkedList) {
                        MIRConnectionManager.removePropertyValue("Schema", mIRElement2);
                    }
                    break;
                }
            }
        }
        block10: for (MIRPropertyValue mIRPropertyValue : mIRSystemPackage.getPropertyValues()) {
            MIRElement mIRElement2;
            mIRElement2 = mIRPropertyValue.getPropertyType();
            if (mIRPropertyValue.getValue() == null || mIRPropertyValue.getValue().isEmpty()) continue;
            if (mIRElement.isInstanceOf((short)159)) {
                ConnectionLevel connectionLevel = MIRConnectionManager.getInstance().getConnectionLevel();
                String string = mIRElement2.getName();
                switch (connectionLevel) {
                    case CONNECTION: {
                        if (!string.equals("Schema") && !string.equals("Database") && !string.equals("Catalog")) break;
                        continue block10;
                    }
                    case DATABASE: 
                    case CATALOG: {
                        if (!string.equals("Schema")) break;
                        continue block10;
                    }
                }
            }
            for (MIRElement mIRElement3 : linkedList) {
                MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRElement3.getRootModel(), mIRElement3.getElementType(), mIRElement2.getName(), ((MIRModelObject)mIRElement2).getDesignLevel(), ((MIRPropertyType)mIRElement2).getUsage(), ((MIRPropertyType)mIRElement2).getGroup(), ((MIRPropertyType)mIRElement2).getDataType(), true, ((MIRPropertyType)mIRElement2).getInitialValue());
                MIRUdpLib.setPropertyValue(mIRPropertyType, mIRPropertyValue.getValue(), mIRElement3);
            }
        }
    }

    private void splitConnection(MIRStoreConnection mIRStoreConnection) {
        MIRModel mIRModel = mIRStoreConnection.getRootModel();
        if (mIRStoreConnection.getStoreType() == 2 || mIRStoreConnection.getStoreType() == 5) {
            Collection<MIRClassifier> collection = this.getClassifiers(mIRStoreConnection);
            for (MIRClassifier mIRClassifier : collection) {
                MIRConnectionNamespace mIRConnectionNamespace;
                String string;
                String string2 = MIRBridgeLib.getFilePath(mIRClassifier);
                if (string2.equals(string = this.guiderFileConnectionSplit.mapPath(string2, true)) || (mIRConnectionNamespace = MIRBridgeLib.getConnectionNamespace(mIRModel, string, null)) == null) continue;
                MIRConnectionDataPackage mIRConnectionDataPackage = mIRClassifier.getConnectionDataPackage();
                mIRClassifier.removeConnectionDataPackage();
                mIRConnectionNamespace.addClassifier(mIRClassifier);
                while (mIRConnectionNamespace.getParent() instanceof MIRConnectionNamespace) {
                    mIRConnectionNamespace = (MIRConnectionNamespace)mIRConnectionNamespace.getParent();
                }
                MIRStoreConnection mIRStoreConnection2 = mIRConnectionNamespace.getParent() instanceof MIRStoreConnection ? (MIRStoreConnection)mIRConnectionNamespace.getParent() : null;
                mIRStoreConnection2.setNativeType(mIRStoreConnection.getNativeType());
                if (mIRModel instanceof MIRMappingModel) {
                    if (mIRClassifier.getSourceOfClassifierMapCount() > 0 && mIRStoreConnection2.getSourceOfMappingModel() == null) {
                        ((MIRMappingModel)mIRModel).addSourceStoreConnection(mIRStoreConnection2);
                    }
                    if (mIRClassifier.getDestinationOfClassifierMapCount() > 0 && mIRStoreConnection2.getDestinationOfMappingModel() == null) {
                        ((MIRMappingModel)mIRModel).addDestinationStoreConnection(mIRStoreConnection2);
                    }
                }
                MIRConnectionManager.copyConnectionProperties(mIRStoreConnection, mIRStoreConnection2);
                this.cleanup(mIRConnectionDataPackage);
            }
        } else if (mIRStoreConnection.getStoreType() == 0) {
            String string = MIRConnectionManager.getSchemaName(mIRStoreConnection);
            if (string != null && !string.isEmpty() && mIRStoreConnection.getConnectionPackageCount() < 2) {
                return;
            }
            LinkedList<MIRConnectionPackage> linkedList = new LinkedList<MIRConnectionPackage>(mIRStoreConnection.getConnectionPackages());
            String string3 = MIRConnectionManager.getCatalogName(mIRStoreConnection);
            String string4 = MIRConnectionManager.getConnectionName(mIRStoreConnection);
            if (string4 == null || string4.isEmpty()) {
                string4 = MIRConnectionManager.getServerName(mIRStoreConnection);
            }
            int n = MIRExpressionAnalyzer.getExpressionDatabaseType(mIRStoreConnection.getSystemType());
            CollationMode collationMode = MIRParserOptions.getCollationMode(n, 0);
            boolean bl = MIRConnectionManager.isCaseInsensitive(mIRStoreConnection);
            for (MIRConnectionPackage mIRConnectionPackage : linkedList) {
                MIRModelObject mIRModelObject;
                String string5 = string != null && !string.isEmpty() ? string : mIRConnectionPackage.getName();
                String string6 = this.getFormattedConnectionName(string3, string5, string4, bl);
                String string7 = string6 = string6 != null && !string6.isEmpty() ? this.guiderConnectionSplit.getGrnConnectionName(string6, null) : this.guiderConnectionSplit.getGrnConnectionName(mIRStoreConnection.getName(), mIRConnectionPackage.getName());
                if (linkedList.size() == 1 && mIRStoreConnection.getName().equals(mIRConnectionPackage.getName()) || mIRStoreConnection.getName().equals(string6)) continue;
                MIRStoreConnection mIRStoreConnection3 = MIRExpressionAnalyzerHelper.getItem(string6, false, mIRModel.getStoreConnections(), collationMode);
                if (mIRStoreConnection3 != null) {
                    mIRStoreConnection3.setName(string6);
                } else {
                    mIRStoreConnection3 = new MIRStoreConnection(mIRStoreConnection);
                    mIRStoreConnection3.setName(string6);
                    mIRStoreConnection3.setNativeType(mIRStoreConnection.getNativeType());
                    mIRModel.addStoreConnection(mIRStoreConnection3);
                    if (mIRModel instanceof MIRMappingModel) {
                        mIRModelObject = (MIRMappingModel)mIRModel;
                        if (mIRStoreConnection.getSourceOfMappingModel() != null) {
                            mIRStoreConnection3.addSourceOfMappingModel((MIRMappingModel)mIRModelObject);
                        }
                        if (mIRStoreConnection.getDestinationOfMappingModel() != null) {
                            mIRStoreConnection3.addDestinationOfMappingModel((MIRMappingModel)mIRModelObject);
                        }
                    }
                    MIRConnectionManager.copyConnectionProperties(mIRStoreConnection, mIRStoreConnection3);
                    MIRConnectionManager.setSchemaName(mIRStoreConnection3, mIRConnectionPackage.getName());
                }
                mIRModelObject = mIRStoreConnection3.getConnectionPackage(MIRBridgeLib.getPhysicalName(mIRConnectionPackage));
                if (mIRModelObject == null) {
                    mIRConnectionPackage.removeStoreConnection();
                    mIRStoreConnection3.addConnectionPackage(mIRConnectionPackage);
                    continue;
                }
                if (mIRStoreConnection == mIRStoreConnection3) continue;
                MIRStoreConnectionSummarizer.mergeConnectionDataPackage(mIRConnectionPackage, mIRModelObject, collationMode);
                mIRConnectionPackage.removeStoreConnection();
                mIRConnectionPackage.delete();
            }
            if (mIRStoreConnection.getConnectionPackageCount() == 0 && mIRStoreConnection.getConnectionClassifierCount() == 0) {
                mIRStoreConnection.delete();
            }
        }
    }

    private Collection<MIRClassifier> getClassifiers(MIRStoreConnection mIRStoreConnection) {
        LinkedHashSet<MIRClassifier> linkedHashSet = new LinkedHashSet<MIRClassifier>();
        LinkedList<MIRConnectionNamespace> linkedList = new LinkedList<MIRConnectionNamespace>(mIRStoreConnection.getConnectionNamespaces());
        while (!linkedList.isEmpty()) {
            MIRConnectionNamespace mIRConnectionNamespace = (MIRConnectionNamespace)linkedList.remove(0);
            for (MIRClassifier mIRClassifier : mIRConnectionNamespace.getClassifiers()) {
                linkedHashSet.add(mIRClassifier);
            }
            for (MIRNamespaceElement mIRNamespaceElement : mIRConnectionNamespace.getNamespaceElements()) {
                if (!(mIRNamespaceElement instanceof MIRConnectionNamespace)) continue;
                linkedList.add((MIRConnectionNamespace)mIRNamespaceElement);
            }
        }
        return linkedHashSet;
    }

    private void cleanup(MIRConnectionDataPackage mIRConnectionDataPackage) {
        MIRConnectionDataPackage mIRConnectionDataPackage2 = mIRConnectionDataPackage;
        while (mIRConnectionDataPackage2 != null && mIRConnectionDataPackage2.getClassifierCount() == 0 && mIRConnectionDataPackage2.getNamespaceElementCount() == 0 && mIRConnectionDataPackage2.getImportedNamespaceElementCount() == 0) {
            MIRObject mIRObject = mIRConnectionDataPackage2.getParent();
            mIRConnectionDataPackage2.delete();
            if (mIRObject instanceof MIRConnectionDataPackage) {
                mIRConnectionDataPackage2 = (MIRConnectionDataPackage)mIRObject;
                continue;
            }
            mIRConnectionDataPackage2 = null;
            if (!(mIRObject instanceof MIRStoreConnection) || ((MIRStoreConnection)mIRObject).getConnectionNamespaceCount() != 0) continue;
            mIRObject.delete();
        }
    }

    private static class GuiderConnectionCollation {
        private Set<String> caseSensitiveConnections;
        private Set<String> caseInsensitiveConnections;

        GuiderConnectionCollation(MiscParams miscParams) {
            Map<String, String> map;
            Map<String, String> map2 = miscParams.getMappedValues("-connection.casesensitive");
            if (map2 != null) {
                this.caseSensitiveConnections = new HashSet<String>();
                if (MIRConnectionManager.getInstance().getConnectionLevel() == ConnectionLevel.CATALOG) {
                    this.caseSensitiveConnections.addAll(map2.keySet().stream().map(string -> string.contains(".") ? string : string + ".*").collect(Collectors.toList()));
                } else {
                    this.caseSensitiveConnections.addAll(map2.keySet());
                }
            }
            if ((map = miscParams.getMappedValues("-connection.caseinsensitive")) != null) {
                this.caseInsensitiveConnections = new HashSet<String>();
                if (MIRConnectionManager.getInstance().getConnectionLevel() == ConnectionLevel.CATALOG) {
                    this.caseInsensitiveConnections.addAll(map.keySet().stream().map(string -> string.contains(".") ? string : string + ".*").collect(Collectors.toList()));
                } else {
                    this.caseInsensitiveConnections.addAll(map.keySet());
                }
            }
        }
    }

    private static class GuiderFileConnectionSplit {
        protected ArrayList<Map.Entry<String, String>> imvCdParamVals = new ArrayList();

        public GuiderFileConnectionSplit(MiscParams miscParams) {
            if (miscParams != null) {
                Map<String, String> map = miscParams.getMappedValues("-connection.map");
                if (map == null) {
                    map = miscParams.getMappedValues("-cd");
                }
                if (map != null) {
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        if (null == entry.getValue()) continue;
                        this.imvCdParamVals.add(new AbstractMap.SimpleEntry<String, String>(entry.getKey(), entry.getValue()));
                    }
                    if (this.imvCdParamVals.size() > 0) {
                        BLIB.DBG_DEBUG.log("Split file connections entries:");
                        for (Map.Entry<String, String> entry : map.entrySet()) {
                            BLIB.DBG_DEBUG.log(String.format("%s => %s", entry.getKey(), entry.getValue()));
                        }
                    }
                }
            }
        }

        protected int splitPathElement(String string, int n, String string2, ArrayList<cPathElement> arrayList) {
            int n2 = string.indexOf(string2, n);
            if (n2 != -1) {
                if (n < n2) {
                    arrayList.add(new cPathElementSeparator(string.substring(n, n2)));
                }
                arrayList.add(new cPathElementName(string2));
                n2 += string2.length();
            }
            return n2;
        }

        public ArrayList<cPathElement> splitPath(String string) {
            String[] stringArray;
            ArrayList<cPathElement> arrayList = new ArrayList<cPathElement>();
            MIRBridgeLib.FileConnectionOptions fileConnectionOptions = new MIRBridgeLib.FileConnectionOptions();
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            String string2 = MIRBridgeLib.getFileConnectionName(string, stringBuilder, stringBuilder2, fileConnectionOptions);
            String string3 = stringBuilder.toString();
            String string4 = stringBuilder2.toString();
            int n = 0;
            if (n >= 0 && string2 != null && !string2.isEmpty()) {
                if (string2.length() == 3 && string2.endsWith("\\") && string2.charAt(1) == ':') {
                    string2 = string2.substring(0, 2);
                }
                n = this.splitPathElement(string, n, string2, arrayList);
            }
            for (String string5 : stringArray = string3.toString().split("[/\\\\]")) {
                if (n < 0 || string5.isEmpty()) continue;
                n = this.splitPathElement(string, n, string5, arrayList);
            }
            if (n >= 0 && !string4.isEmpty()) {
                n = this.splitPathElement(string, n, string4, arrayList);
            }
            if (n >= 0 && n < string.length()) {
                arrayList.add(new cPathElementSeparator(string.substring(n, string.length())));
                n = string.length();
            }
            return n == string.length() ? arrayList : null;
        }

        private String mapPath(String string, String string2, String string3, boolean bl) {
            String string4 = string;
            ArrayList<cPathElement> arrayList = this.splitPath(string);
            ArrayList<cPathElement> arrayList2 = this.splitPath(string2);
            ArrayList<cPathElement> arrayList3 = this.splitPath(string3);
            if (arrayList != null && arrayList2 != null && arrayList3 != null) {
                int n;
                boolean bl2 = true;
                for (n = 0; n < arrayList2.size(); ++n) {
                    if (n < arrayList.size()) {
                        cPathElement cPathElement2 = arrayList.get(n);
                        cPathElement cPathElement3 = arrayList2.get(n);
                        if (!(cPathElement2 instanceof cPathElementName) || !(cPathElement3 instanceof cPathElementName)) continue;
                        if (bl) {
                            if (cPathElement2.imvValue.equals(cPathElement3.imvValue)) continue;
                            bl2 = false;
                            break;
                        }
                        if (cPathElement2.imvValue.equalsIgnoreCase(cPathElement3.imvValue)) continue;
                        bl2 = false;
                        break;
                    }
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    int n2;
                    n = arrayList2.size();
                    if (arrayList2.size() < arrayList.size() && arrayList.get(arrayList2.size()) instanceof cPathElementSeparator && arrayList3.get(arrayList3.size() - 1) instanceof cPathElementSeparator) {
                        ++n;
                    }
                    string4 = "";
                    for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                        string4 = string4 + arrayList3.get((int)n2).imvValue;
                    }
                    for (n2 = n; n2 < arrayList.size(); ++n2) {
                        string4 = string4 + arrayList.get((int)n2).imvValue;
                    }
                    BLIB.DBG_DEBUG.log("Mapped connection path: '" + string + "' to:'" + string4);
                }
            } else {
                BLIB.DBG_DEBUG.log("Can not map the connection path: '" + string + "'");
            }
            return string4;
        }

        public String mapPath(String string, boolean bl) {
            if (this.imvCdParamVals.size() > 0) {
                for (Map.Entry<String, String> entry : this.imvCdParamVals) {
                    string = this.mapPath(string, entry.getKey(), entry.getValue(), bl);
                }
            }
            return string;
        }

        protected class cPathElementSeparator
        extends cPathElement {
            public cPathElementSeparator(String string) {
                super(string);
            }
        }

        protected class cPathElementName
        extends cPathElement {
            public cPathElementName(String string) {
                super(string);
            }
        }

        protected abstract class cPathElement {
            public String imvValue;

            public cPathElement(String string) {
                this.imvValue = string;
            }
        }
    }

    private static class GuiderConnectionSplit {
        protected TreeMap<String, TreeMap<String, String>> splitMap = new TreeMap();

        public GuiderConnectionSplit(MiscParams miscParams) {
            TreeMap<String, String> treeMap;
            Map<String, String> map = miscParams.getMappedValues("-connection.split");
            if (map == null) {
                map = miscParams.getMappedValues("-cs");
            }
            if (map != null) {
                if (map.size() == 1 && map.containsKey("*")) {
                    if (this.splitMap.get("*") == null) {
                        this.splitMap.put("*", null);
                    }
                } else {
                    for (Map.Entry<String, String> object : map.entrySet()) {
                        TreeMap<String, String> treeMap2;
                        treeMap = object.getValue();
                        Object object2 = object.getKey();
                        if (object2 == null || ((String)object2).isEmpty()) continue;
                        if (null == treeMap) {
                            this.splitMap.put((String)object2, null);
                            continue;
                        }
                        String string2 = "";
                        int n = ((String)object2).lastIndexOf(".");
                        if (n > 0) {
                            string2 = ((String)object2).substring(n + 1);
                            object2 = ((String)object2).substring(0, n);
                        }
                        if ((treeMap2 = this.splitMap.get(object2)) == null) {
                            treeMap2 = new TreeMap();
                            this.splitMap.put((String)object2, treeMap2);
                        }
                        treeMap2.put(string2, (String)((Object)treeMap));
                    }
                }
            }
            if (this.splitMap.size() > 0) {
                BLIB.DBG_DEBUG.log("Split connections entries:");
                for (String string : this.splitMap.keySet()) {
                    treeMap = this.splitMap.get(string);
                    if (treeMap == null) {
                        BLIB.DBG_DEBUG.log("''='" + string + "'.''");
                        continue;
                    }
                    for (String string2 : treeMap.keySet()) {
                        BLIB.DBG_DEBUG.log("'" + (String)treeMap.get(string2) + "'='" + string + "'.'" + string2 + "'");
                    }
                }
            }
        }

        public String getGrnConnectionName(String string, String string2) {
            String string3;
            String string4 = string3 = string2 != null && !string2.isEmpty() ? "." + string2 : "";
            if (this.splitMap.keySet().contains("*")) {
                return string + string3;
            }
            if (this.splitMap.containsKey(string)) {
                String string5;
                TreeMap<String, String> treeMap = this.splitMap.get(string);
                if (treeMap != null && string2 != null && (string5 = treeMap.get(string2)) != null && !string5.isEmpty()) {
                    return string5;
                }
                return string + string3;
            }
            return string;
        }
    }

    private static class GuiderConnectionCast {
        protected TreeMap<String, String> imvMap = new TreeMap();

        public GuiderConnectionCast(MiscParams miscParams) {
            Map<String, String> map;
            if (miscParams != null && (map = miscParams.getMappedValues("-connection.cast")) != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    this.imvMap.put(entry.getKey(), entry.getValue());
                }
            }
        }

        public String getType(String string, String string2) {
            String string3 = this.imvMap.get(string);
            return string3 == null || string3.isEmpty() ? string2 : string3;
        }
    }

    private static class GuiderConnectionMerge {
        protected TreeMap<String, String> imvMrgCnnct = new TreeMap();
        protected boolean imvIsQuestion = false;
        protected String imvDefaultServer;
        protected String imvDefaultDatabase;

        public GuiderConnectionMerge(MiscParams miscParams) {
            Object object;
            Map<String, String> map = miscParams.getMappedValues("-connection.merge");
            if (miscParams.contains("-connection.rename")) {
                if (map != null) {
                    map.putAll(miscParams.getMappedValues("-connection.rename"));
                } else {
                    map = miscParams.getMappedValues("-connection.rename");
                }
            }
            this.imvDefaultServer = miscParams.getValue("-default.server");
            this.imvDefaultDatabase = miscParams.getValue("-default.database");
            if (map == null) {
                map = miscParams.getMappedValues("-cm");
            }
            if (map != null) {
                for (Map.Entry<String, String> object2 : map.entrySet()) {
                    this.imvIsQuestion = object2.getKey().trim().equals("?");
                    if (object2.getValue() == null) continue;
                    for (String string : object = object2.getValue().split(",")) {
                        this.imvMrgCnnct.put(object2.getKey(), string);
                    }
                }
            }
            if (this.imvMrgCnnct.size() > 0) {
                BLIB.DBG_DEBUG.log("Merge connections entries. Question mark = " + this.imvIsQuestion + ":");
                for (String string : this.imvMrgCnnct.keySet()) {
                    object = this.imvMrgCnnct.get(string);
                    BLIB.DBG_DEBUG.log(string + " = " + (String)object);
                }
            }
        }

        private String getConnectionName(String string, String string2, boolean bl) {
            return this.getConnectionName(string, string2, bl, ".");
        }

        private String getConnectionName(String string, String string2, boolean bl, String string3) {
            if (string != null && !MIRConnectionManager.getInstance().isLegacyMode && bl) {
                string = string.toUpperCase();
            }
            if (string2 != null && !string2.isEmpty() && string != null && !string.isEmpty()) {
                if (!MIRConnectionManager.getInstance().isLegacyMode && bl) {
                    string2 = string2.toUpperCase();
                }
                return string2 + string3 + string;
            }
            return string2 != null && !string2.isEmpty() ? string2 : string;
        }

        private String getConnectionName(String string, String string2, String string3, boolean bl) {
            String string4 = (string == null || string.isEmpty()) && (string2 == null || string2.isEmpty()) ? "" : (string == null || string.isEmpty() ? (string3 == null || string3.isEmpty() || !MIRConnectionManager.getInstance().isLegacyMode ? string2 : "") : string + (!MIRConnectionManager.getInstance().isLegacyMode && string2 != null && !string2.isEmpty() ? "." + string2 : ""));
            return this.getConnectionName(string4, string3, bl);
        }

        public String getMrgName(String string) {
            String string2 = this.imvMrgCnnct.get(string);
            return this.imvIsQuestion ? string : (string2 == null ? string : string2);
        }
    }

    public static enum ConnectionLevel {
        CONNECTION,
        SERVER,
        DATABASE,
        CATALOG,
        SCHEMA;


        public static ConnectionLevel getByName(String string) {
            for (ConnectionLevel connectionLevel : ConnectionLevel.values()) {
                if (!connectionLevel.name().equalsIgnoreCase(string)) continue;
                return connectionLevel;
            }
            return SCHEMA;
        }
    }

    private static class MIRConnectionManagerHolder {
        static final MIRConnectionManager SINGLE_INSTANCE = new MIRConnectionManager();

        private MIRConnectionManagerHolder() {
        }
    }
}

