/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.util;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.MdAuthorizationUtil;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdPermissionInfo;
import com.sas.metadata.remote.MdPermissionInfoImpl;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASPassword;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Tree;
import com.sas.util.BASE64;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;

public class GlobalConfiguration {
    public static final String DEPLOYMENT_AGENT_KEY_STORE_NAME = "Deployment Agent Key Store";
    public static final String DEPLOYMENT_AGENT_KEY_STORE_PASSWORD = "Deployment Agent Key Store Password";
    public static final String DEPLOYMENT_AGENT_TRUST_STORE_NAME = "Deployment Agent Trust Store";
    public static final String DEPLOYMENT_AGENT_TRUST_STORE_PASSWORD = "Deployment Agent Trust Store Password";
    public static final String DEPLOYMENT_AGENT_CLIENT_KEY_STORE_NAME = "Deployment Agent Client Key Store";
    public static final String DEPLOYMENT_AGENT_CLIENT_KEY_STORE_PASSWORD = "Deployment Agent Client Key Store Password";
    public static final String DEPLOYMENT_AGENT_CLIENT_TRUST_STORE_NAME = "Deployment Agent Client Trust Store";
    public static final String DEPLOYMENT_AGENT_CLIENT_TRUST_STORE_PASSWORD = "Deployment Agent Client Trust Store Password";
    private static final String RESTRICTED_ADMIN_DATA_TREE_NAME = "Restricted Adminstration Data";
    private static final String RESTRICTED_ADMIN_DATA_TREE_TYPE = "RestrictedAdminData";
    private static final String CERTIFICATE_STORE_TEXT_ROLE = "CertficateStore";
    private static final String CERTIFICATE_STORE_TEXT_TYPE = "BASE64";
    private static final String BINARY_PREFIX = "{BASE64}";
    private SoftwareComponent component = null;
    private Tree adminData = null;

    private GlobalConfiguration(SoftwareComponent component) {
        this.component = component;
    }

    public static GlobalConfiguration getGlobalConfiguration(MdObjectStore store) throws MdException {
        try {
            MdFactory factory = store.getFactory();
            String reposID = factory.getOMIUtil().getFoundationReposID();
            String options = "<Templates><SoftwareComponent><SoftwareTrees/></SoftwareComponent><Tree><Members/><Notes/></Tree></Templates><XMLSelect search=\"*[@ClassIdentifier='globalroot']\"/>";
            int flags = 396;
            List objectsList = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, reposID, "SoftwareComponent", flags, options);
            if (objectsList.isEmpty()) {
                LogManager.getLogger(GlobalConfiguration.class).error("No GLOBALROOT SoftwareComponent found.");
                return null;
            }
            if (objectsList.size() > 1) {
                LogManager.getLogger(GlobalConfiguration.class).error("Multiple GLOBALROOT SoftwareComponents found.");
            }
            return new GlobalConfiguration((SoftwareComponent)objectsList.get(0));
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public SoftwareComponent getSoftwareComponent() {
        return this.component;
    }

    public String getPassword(String name) throws MdException {
        if (this.adminData == null) {
            this.initRestrictedAdminData(false);
        }
        if (this.adminData == null) {
            return null;
        }
        try {
            AssociationList members = this.adminData.getMembers();
            for (Root member : members) {
                if (!(member instanceof SASPassword) || !member.getName().equalsIgnoreCase(name)) continue;
                SASPassword password = (SASPassword)member;
                return password.getPassword();
            }
            return null;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPassword(String name, String password) throws MdException {
        if (this.adminData == null) {
            this.initRestrictedAdminData(true);
        }
        try {
            AssociationList members = this.adminData.getMembers();
            for (Root member : members) {
                if (!(member instanceof SASPassword) || !member.getName().equalsIgnoreCase(name)) continue;
                SASPassword pwd = (SASPassword)member;
                if (password != null) {
                    pwd.setPassword(password);
                } else {
                    pwd.delete();
                }
                return;
            }
            if (password == null) {
                return;
            }
            MdObjectStore store = (MdObjectStore)this.adminData.getObjectStore();
            MdFactory factory = store.getFactory();
            String reposID = this.adminData.getRepositoryID();
            SASPassword pwd = (SASPassword)factory.createComplexMetadataObject(store, name, "SASPassword", reposID);
            pwd.setPassword(password);
            this.adminData.getMembers().add((Object)pwd);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void setCertificateStore(String name, byte[] certStore) throws MdException {
        if (this.adminData == null) {
            this.initRestrictedAdminData(true);
        }
        try {
            String base64;
            TextStore note = this.findCertificateTextStore(name);
            if (certStore == null) {
                if (note != null) {
                    note.delete();
                }
                return;
            }
            if (note == null) {
                MdObjectStore store = (MdObjectStore)this.adminData.getObjectStore();
                MdFactory factory = store.getFactory();
                String reposID = this.adminData.getRepositoryID();
                note = (TextStore)factory.createComplexMetadataObject(store, name, "TextStore", reposID);
                note.setTextRole(CERTIFICATE_STORE_TEXT_ROLE);
                note.setTextType(CERTIFICATE_STORE_TEXT_TYPE);
                this.adminData.getNotes().add((Object)note);
            }
            if ((base64 = BASE64.encode((byte[])certStore)) == null) {
                base64 = "";
            }
            note.setStoredText(BINARY_PREFIX + base64);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getCertificateStore(String name) throws MdException {
        if (this.adminData == null) {
            this.initRestrictedAdminData(false);
        }
        if (this.adminData == null) {
            return null;
        }
        try {
            TextStore note = this.findCertificateTextStore(name);
            if (note == null) {
                return null;
            }
            String text = note.getStoredText();
            if (text.startsWith(BINARY_PREFIX)) {
                return BASE64.decode((String)text.substring(BINARY_PREFIX.length()));
            }
            try {
                return text.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private TextStore findCertificateTextStore(String name) throws MdException {
        try {
            AssociationList notes = this.adminData.getNotes();
            for (TextStore note : notes) {
                if (!note.getName().equalsIgnoreCase(name) || !note.getTextRole().equals(CERTIFICATE_STORE_TEXT_ROLE)) continue;
                return note;
            }
            return null;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteRestrictedAdminData() throws MdException {
        if (this.adminData == null) {
            this.initRestrictedAdminData(false);
        }
        if (this.adminData == null) {
            return;
        }
        try {
            AssociationList notes = this.adminData.getNotes();
            for (int i = notes.size() - 1; i >= 0; --i) {
                ((TextStore)notes.get(i)).delete();
            }
            AssociationList members = this.adminData.getMembers();
            for (int i = members.size() - 1; i >= 0; --i) {
                Root member = (Root)members.get(i);
                if (!(member instanceof SASPassword)) continue;
                member.delete();
            }
            this.adminData.delete();
            this.adminData = null;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private void initRestrictedAdminData(boolean create) throws MdException {
        if (this.adminData != null) {
            return;
        }
        try {
            AssociationList trees = this.component.getSoftwareTrees();
            for (Tree tree : trees) {
                if (!tree.getTreeType().equals(RESTRICTED_ADMIN_DATA_TREE_TYPE)) continue;
                this.adminData = tree;
                return;
            }
            if (!create) {
                return;
            }
            MdObjectStore store = (MdObjectStore)this.component.getObjectStore();
            MdFactory factory = store.getFactory();
            String reposID = this.component.getRepositoryID();
            this.adminData = (Tree)factory.createComplexMetadataObject(store, RESTRICTED_ADMIN_DATA_TREE_NAME, "Tree", reposID);
            this.adminData.setTreeType(RESTRICTED_ADMIN_DATA_TREE_TYPE);
            this.component.getSoftwareTrees().add((Object)this.adminData);
            this.lockRestrictedAdminData();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private void lockRestrictedAdminData() throws MdException {
        try {
            MdAuthorizationUtil auth = this.adminData.getAuthorizationUtil();
            ArrayList<MdPermissionInfoImpl> perms = new ArrayList<MdPermissionInfoImpl>(3);
            perms.add(new MdPermissionInfoImpl(MdPermissionInfo.PermissionType.DENY, "ReadMetadata"));
            perms.add(new MdPermissionInfoImpl(MdPermissionInfo.PermissionType.DENY, "WriteMetadata"));
            perms.add(new MdPermissionInfoImpl(MdPermissionInfo.PermissionType.DENY, "CheckinMetadata"));
            MdStore store = this.component.getObjectStore();
            MdFactory factory = store.getFactory();
            String reposID = factory.getOMIUtil().getFoundationReposID();
            String options = "<XMLSelect search=\"*[@Name='PUBLIC' and @PublicType='UserGroup']\"/>";
            int flags = 392;
            List objectsList = factory.getOMIUtil().getMetadataObjectsSubset(store, reposID, "IdentityGroup", flags, options);
            if (objectsList == null || objectsList.isEmpty()) {
                return;
            }
            auth.setAuthorizations((Identity)objectsList.get(0), perms);
            auth.setCommitOnUpdate(true);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }
}

