/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.util;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.util.ConfigurablePropertiesUtil;
import com.sas.metadata.util.ConfigurationDirectory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Properties;

public class DeploymentAgentUtil {
    private static final String AGENT_CONFIG_PROPERTY = "sas.deployment.agent.client.config";
    private static final String AGENT_PORT_PROPERTY = "solstice.agent.jmx.port";
    private static final String AGENT_SECURITY_PROPERTY = "solstice.security.enabled";

    private DeploymentAgentUtil() {
    }

    public static Properties getLocalDeploymentAgentProperties() {
        try {
            return DeploymentAgentUtil.getDeploymentAgentProperties(null, null);
        }
        catch (MdException e) {
            throw new RuntimeException(e);
        }
    }

    public static Properties getDeploymentAgentProperties(MdFactory factory, String machine) throws MdException {
        String propFilePath = System.getProperty(AGENT_CONFIG_PROPERTY);
        if (propFilePath == null) {
            throw new IllegalStateException("sas.deployment.agent.client.config property is not defined.");
        }
        Properties agentProps = new Properties();
        try {
            FileInputStream input = new FileInputStream(new File(propFilePath));
            agentProps.load(input);
            ((InputStream)input).close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read deployment agent properties from " + propFilePath, e);
        }
        if (factory != null) {
            try {
                MdObjectStore store = factory.createObjectStore();
                SoftwareComponent cfgdir = ConfigurationDirectory.getConfigurationDirectory(store, machine, null);
                if (cfgdir != null) {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    ConfigurablePropertiesUtil.getObjectProperties(cfgdir, properties, null);
                    if (properties.containsKey(AGENT_PORT_PROPERTY)) {
                        agentProps.setProperty(AGENT_PORT_PROPERTY, (String)properties.get(AGENT_PORT_PROPERTY));
                    }
                    if (properties.containsKey(AGENT_SECURITY_PROPERTY)) {
                        agentProps.setProperty(AGENT_SECURITY_PROPERTY, (String)properties.get(AGENT_SECURITY_PROPERTY));
                    }
                }
                store.dispose();
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
        return agentProps;
    }
}

