/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.util;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.util.RB;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.text.Message;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class ConfigurablePropertiesUtil {
    private static final String PROPERTY_NAME_PUBLIC = "Public Configuration Properties";
    private static final String PROPERTY_NAME_PRIVATE = "Private Configuration Properties";
    private static final int PROPERTY_TYPE_PUBLIC = 0;
    private static final int PROPERTY_TYPE_PRIVATE = 1;

    public static void getObjectProperties(MdObjectStore store, String id, Map<String, String> publicProperties, Map<String, String> privateProperties) throws MdException, RemoteException {
        SoftwareComponent sc = ConfigurablePropertiesUtil.getRootObject(store, id);
        ConfigurablePropertiesUtil.getObjectProperties(sc, publicProperties, privateProperties);
    }

    public static void getObjectProperties(SoftwareComponent comp, Map<String, String> publicProperties, Map<String, String> privateProperties) throws MdException, RemoteException {
        if (comp != null) {
            Map<String, String> tempPrivateProps;
            TextStore privateTextStore;
            Map<String, String> tempPublicProps;
            TextStore publicTextStore = ConfigurablePropertiesUtil.getTextStore(comp, 0);
            if (publicTextStore != null && (tempPublicProps = ConfigurablePropertiesUtil.retrieveProperties(publicTextStore)) != null && publicProperties != null) {
                publicProperties.putAll(tempPublicProps);
            }
            if ((privateTextStore = ConfigurablePropertiesUtil.getTextStore(comp, 1)) != null && (tempPrivateProps = ConfigurablePropertiesUtil.retrieveProperties(privateTextStore)) != null && privateProperties != null) {
                privateProperties.putAll(tempPrivateProps);
            }
        }
    }

    public static void setObjectProperties(MdObjectStore store, String id, Map<String, String> publicProperties, Map<String, String> privateProperties) throws MdException, RemoteException {
        SoftwareComponent sc = ConfigurablePropertiesUtil.getRootObject(store, id);
        ConfigurablePropertiesUtil.setObjectProperties(sc, publicProperties, privateProperties);
    }

    public static void setObjectProperties(SoftwareComponent comp, Map<String, String> publicProperties, Map<String, String> privateProperties) throws MdException, RemoteException {
        if (comp != null) {
            String publicPropertiesString = ConfigurablePropertiesUtil.convertPropertiesToString(publicProperties);
            String privatePropertiesString = ConfigurablePropertiesUtil.convertPropertiesToString(privateProperties);
            ConfigurablePropertiesUtil.persistProperties(comp, publicPropertiesString, privatePropertiesString);
        }
    }

    public static void removeObjectProperties(MdObjectStore store, String id) throws MdException, RemoteException {
        SoftwareComponent sc = ConfigurablePropertiesUtil.getRootObject(store, id);
        ConfigurablePropertiesUtil.removeObjectProperties(sc);
    }

    public static void removeObjectProperties(SoftwareComponent comp) throws MdException, RemoteException {
        if (comp != null) {
            ArrayList<TextStore> notesToDelete = new ArrayList<TextStore>(2);
            AssociationList notes = comp.getNotes();
            for (TextStore note : notes) {
                String name = note.getName();
                if (!PROPERTY_NAME_PUBLIC.equalsIgnoreCase(name) && !PROPERTY_NAME_PRIVATE.equalsIgnoreCase(name)) continue;
                notesToDelete.add(note);
            }
            MdFactory factory = comp.getObjectStore().getFactory();
            factory.deleteMetadataObjects(notesToDelete);
        }
    }

    private static String convertPropertiesToString(Map<String, String> properties) throws MdException {
        String propString = null;
        if (properties != null && properties.size() > 0) {
            PropertyList propertyList = new PropertyList();
            for (String key : properties.keySet()) {
                String value = properties.get(key);
                propertyList.addProperty(key, value);
            }
            StringWriter writer = new StringWriter();
            try {
                propertyList.save((Writer)writer);
                String storedText = writer.toString();
                propString = storedText.replaceAll("\\r", "");
            }
            catch (IOException e) {
                throw new MdException((Throwable)e);
            }
        }
        return propString;
    }

    private static void persistProperties(SoftwareComponent comp, String publicProperties, String privateProperties) throws MdException, RemoteException {
        TextStore textStore;
        AssociationList notes = comp.getNotes();
        Object[] noteArray = notes.toArray();
        for (int i = 0; i < noteArray.length; ++i) {
            TextStore note;
            String name;
            if (!(noteArray[i] instanceof TextStore) || !PROPERTY_NAME_PUBLIC.equalsIgnoreCase(name = (note = (TextStore)noteArray[i]).getName()) && !PROPERTY_NAME_PRIVATE.equalsIgnoreCase(name)) continue;
            note.delete();
        }
        boolean updated = false;
        MdObjectStore store = (MdObjectStore)comp.getObjectStore();
        MdFactory factory = store.getFactory();
        String reposID = comp.getRepositoryID();
        if (publicProperties != null) {
            textStore = (TextStore)factory.createComplexMetadataObject(store, PROPERTY_NAME_PUBLIC, "TextStore", reposID);
            textStore.setStoredText(publicProperties);
            comp.getNotes().add((Object)textStore);
            updated = true;
        }
        if (privateProperties != null) {
            textStore = (TextStore)factory.createComplexMetadataObject(store, PROPERTY_NAME_PRIVATE, "TextStore", reposID);
            textStore.setStoredText(privateProperties);
            comp.getNotes().add((Object)textStore);
            updated = true;
        }
        if (updated) {
            store.updatedMetadataAll();
        }
    }

    private static TextStore getTextStore(SoftwareComponent comp, int propertyType) throws MdException, RemoteException {
        AssociationList notes = comp.getNotes();
        for (Object meta : notes) {
            if (!(meta instanceof TextStore)) continue;
            TextStore note = (TextStore)meta;
            String name = note.getName();
            if (propertyType == 0 && PROPERTY_NAME_PUBLIC.equalsIgnoreCase(name)) {
                return note;
            }
            if (propertyType != 1 || !PROPERTY_NAME_PRIVATE.equalsIgnoreCase(name)) continue;
            return note;
        }
        return null;
    }

    private static SoftwareComponent getRootObject(MdObjectStore store, String id) throws MdException, RemoteException {
        SoftwareComponent sc = null;
        if (store != null && id != null) {
            MdFactory factory = store.getFactory();
            String reposID = "A0000001." + id.substring(0, 8);
            String options = "<SoftwareComponent><Notes/></SoftwareComponent><XMLSelect search=\"*[@Id='" + id + "']\"/>";
            int flags = 412;
            List objectsList = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, reposID, "SoftwareComponent", flags, options);
            if (objectsList != null && objectsList.size() > 0) {
                sc = (SoftwareComponent)objectsList.get(0);
            }
        }
        if (sc == null) {
            throw new MdException(Message.format((ResourceBundle)RB.getResources(), (String)"ConfigurablePropertiesUtil.MissingConfigObject.fmt.txt", (Object)id));
        }
        return sc;
    }

    private static Map<String, String> retrieveProperties(TextStore textStore) throws MdException, RemoteException {
        HashMap<String, String> props = new HashMap<String, String>();
        String storedTextAttribute = textStore.getStoredText();
        StringReader reader = new StringReader(storedTextAttribute);
        PropertyMap myProperties = new PropertyMap();
        try {
            myProperties.load((Reader)reader);
            String propName = null;
            String propValue = null;
            Iterator iter = myProperties.getPropertyIterator();
            while (iter.hasNext()) {
                propName = (String)iter.next();
                propValue = myProperties.getProperty(propName);
                props.put(propName, propValue);
            }
            return props;
        }
        catch (IOException e) {
            throw new MdException((Throwable)e);
        }
    }
}

