/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.om.Item;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.ObjectValue;

public class SQLExecute
extends ExtensionInstruction {
    Expression connection;
    Expression statement;

    public void prepareAttributes() throws XPathException {
        String statementAtt = this.getAttributeValue("", "statement");
        if (statementAtt == null) {
            this.reportAbsence("statement");
        }
        this.statement = this.makeAttributeValueTemplate(statementAtt);
        String connectAtt = this.getAttributeValue("", "connection");
        if (connectAtt == null) {
            this.reportAbsence("connection");
        } else {
            this.connection = this.makeExpression(connectAtt);
        }
    }

    public void validate(Declaration decl) throws XPathException {
        super.validate(decl);
        this.statement = this.typeCheck("column", this.statement);
        this.connection = this.typeCheck("connection", this.connection);
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        return new SqlStatementInstruction(this.connection, this.statement);
    }

    private static class SqlStatementInstruction
    extends SimpleExpression {
        public static final int CONNECTION = 0;
        public static final int STATEMENT = 1;

        public SqlStatementInstruction(Expression connection, Expression statement) {
            Expression[] sub = new Expression[]{connection, statement};
            this.setArguments(sub);
        }

        public int getImplementationMethod() {
            return 4;
        }

        public String getExpressionType() {
            return "sql:statement";
        }

        public void process(XPathContext context) throws XPathException {
            Item conn = this.arguments[0].evaluateItem(context);
            if (!(conn instanceof ObjectValue) || !(((ObjectValue)conn).getObject() instanceof Connection)) {
                XPathException de = new XPathException("Value of connection expression is not a JDBC Connection");
                de.setXPathContext(context);
                throw de;
            }
            Connection connection = (Connection)((ObjectValue)conn).getObject();
            String statementText = ((Object)this.arguments[1].evaluateAsString(context)).toString();
            try {
                if ("COMMIT WORK".equals(statementText)) {
                    connection.commit();
                } else if ("ROLLBACK WORK".equals(statementText)) {
                    connection.rollback();
                } else {
                    Statement s = connection.createStatement();
                    s.execute(statementText);
                }
            }
            catch (SQLException ex) {
                XPathException de = new XPathException("(SQL) " + ex.getMessage());
                de.setXPathContext(context);
                throw de;
            }
        }
    }
}

