/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.sql;

import java.io.Serializable;
import net.sf.saxon.TypeCheckerEnvironment;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.option.sql.SQLConnect;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class SQLColumn
extends StyleElement {
    private String name;
    private Expression select;

    public boolean isInstruction() {
        return false;
    }

    public boolean mayContainSequenceConstructor() {
        return false;
    }

    protected boolean mayContainFallback() {
        return false;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String selectAtt = null;
        String nameAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String localName = atts.getLocalName(a);
            if (localName.equals("name")) {
                nameAtt = Whitespace.trim((CharSequence)atts.getValue(a));
                continue;
            }
            if (localName.equals("select")) {
                selectAtt = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNameCode(a));
        }
        if (nameAtt == null) {
            this.reportAbsence("name");
            this.name = "saxon-dummy-column";
        } else {
            this.name = SQLConnect.quoteSqlName(nameAtt);
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        }
    }

    public void validate(Declaration decl) throws XPathException {
        this.select = this.typeCheck("select", this.select);
        try {
            RoleLocator role = new RoleLocator(4, (Serializable)((Object)"sql:column/select"), 0);
            this.select = TypeChecker.staticTypeCheck((Expression)this.select, (SequenceType)SequenceType.SINGLE_ATOMIC, (boolean)false, (RoleLocator)role, (TypeCheckerEnvironment)this.makeExpressionVisitor());
        }
        catch (XPathException err) {
            this.compileError(err);
        }
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        return this.select;
    }

    public String getColumnName() {
        return Navigator.getAttributeValue((NodeInfo)this, (String)"", (String)"name");
    }
}

