/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.sql;

import java.sql.Connection;
import java.sql.SQLException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.om.Item;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.ObjectValue;

public class SQLClose
extends ExtensionInstruction {
    Expression connection = null;

    public void prepareAttributes() throws XPathException {
        String connectAtt = this.getAttributeList().getValue("", "connection");
        if (connectAtt == null) {
            this.reportAbsence("connection");
        } else {
            this.connection = this.makeExpression(connectAtt);
        }
    }

    public void validate(Declaration decl) throws XPathException {
        super.validate(decl);
        this.connection = this.typeCheck("connection", this.connection);
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        return new CloseInstruction(this.connection);
    }

    private static class CloseInstruction
    extends SimpleExpression {
        public static final int CONNECTION = 0;

        public CloseInstruction(Expression connect) {
            Expression[] sub = new Expression[]{connect};
            this.setArguments(sub);
        }

        public int getImplementationMethod() {
            return 1;
        }

        public String getExpressionType() {
            return "sql:close";
        }

        public int computeCardinality() {
            return 24576;
        }

        public Item evaluateItem(XPathContext context) throws XPathException {
            Item conn = this.arguments[0].evaluateItem(context);
            if (!(conn instanceof ObjectValue) || !(((ObjectValue)conn).getObject() instanceof Connection)) {
                this.dynamicError("Value of connection expression is not a JDBC Connection", "SXSQ0001", context);
            }
            Connection connection = (Connection)((ObjectValue)conn).getObject();
            try {
                connection.close();
            }
            catch (SQLException ex) {
                this.dynamicError("(SQL) Failed to close connection: " + ex.getMessage(), "SXSQ0002", context);
            }
            return null;
        }
    }
}

