/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sg.datamodel.impl;

import com.sas.sg.datamodel.DataModel;
import com.sas.sg.datamodel.PermutationPolicy;
import com.sas.sg.datamodel.impl.SgDataModel;
import com.sas.sg.datamodel.impl.SgFract;
import com.sas.sg.datamodel.impl.SgObsBooleanProp;
import com.sas.sg.datamodel.impl.SgObsSortContext;
import com.sas.sg.datamodel.impl.SgObsSortPolicy;

abstract class SgVariable {
    protected SgDataModel m_dataModel;
    protected int m_varIndex;
    protected String m_valueType;
    protected String m_name = new String();
    protected String m_label = new String();
    protected Object m_format = new String();
    protected Object m_informat = new String();
    protected int[] m_fractValues = null;
    protected boolean m_isFractOn = false;
    protected double m_fractMargin = 9.313225746154785E-10;
    protected double m_fractScale;
    protected PermutationPolicy m_fractPolicy;
    protected int m_oldGroupIndex;
    protected int m_numOldGroups;

    public SgVariable(SgDataModel dataModel, int varIndex, int numObs) {
        if (dataModel == null) {
            throw new IllegalArgumentException("null Data Model");
        }
        this.m_dataModel = dataModel;
        this.m_varIndex = varIndex;
        this.m_oldGroupIndex = -1;
        this.m_numOldGroups = 0;
    }

    public final String getValueType() {
        return this.m_valueType;
    }

    public abstract boolean isNumeric();

    public abstract void setNominal(boolean var1);

    public abstract boolean isNominal();

    public abstract void changeCapacity(int var1);

    protected abstract int getCapacity();

    public void setFractOn(boolean on) {
        if (this.m_isFractOn == on) {
            return;
        }
        this.m_isFractOn = on;
        if (on) {
            if (this.m_fractValues == null || this.m_fractValues.length < this.getCapacity()) {
                this.m_fractValues = new int[this.getCapacity()];
            }
            this.calcFracts(-1);
        }
    }

    public boolean isFractOn() {
        return this.m_isFractOn;
    }

    public void setFractPolicy(PermutationPolicy policy) {
        if (this.m_fractPolicy == policy || this.m_fractPolicy != null && this.m_fractPolicy.equals(policy)) {
            return;
        }
        this.m_fractPolicy = policy;
        if (this.isFractOn()) {
            this.calcFracts(-1);
        }
    }

    public PermutationPolicy getFractPolicy() {
        return this.m_fractPolicy;
    }

    public void calcFracts(int obsOrdinal) {
        this.calcNominalFracts(obsOrdinal);
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    public final String getName() {
        return this.m_name;
    }

    public final void setLabel(String label) {
        this.m_label = label;
    }

    public final String getLabel() {
        return this.m_label;
    }

    public final void setFormat(Object format) {
        this.m_format = format;
    }

    public final Object getFormat() {
        return this.m_format;
    }

    public final void setInformat(Object informat) {
        this.m_informat = informat;
    }

    public final Object getInformat() {
        return this.m_informat;
    }

    public abstract boolean setValue(int var1, Object var2);

    public boolean setValue(int obsHandle, double value) {
        return this.setValue(obsHandle, new Double(value).toString());
    }

    public abstract Object getValue(int var1);

    public double getDoubleValue(int obsHandle) {
        return Double.parseDouble(this.getValue(obsHandle).toString());
    }

    public String getStringValue(int obsHandle) {
        return this.getValue(obsHandle).toString();
    }

    public abstract void copyValue(int var1, int var2);

    protected void toDeleteValues(int fromIndex, int toIndex) {
    }

    public double getMinValue() {
        return Double.NaN;
    }

    public double getMaxValue() {
        return Double.NaN;
    }

    public abstract void setDefaultMissingValue(Object var1);

    public abstract Object getDefaultMissingValue();

    protected abstract void setMissingValues(int var1, int var2);

    public abstract boolean isValueMissing(int var1);

    public final int getFractValue(int obsHandle) {
        return this.m_fractValues[obsHandle];
    }

    public final double getNormalizedValue(int obsHandle) {
        return SgFract.fractToDouble(this.m_fractValues[obsHandle]);
    }

    public void setFractMargin(double margin) {
        if (this.m_fractMargin == margin) {
            return;
        }
        this.m_fractMargin = margin;
        if (this.isFractOn()) {
            this.calcFracts(-1);
        }
    }

    public double getFractMargin() {
        return this.m_fractMargin;
    }

    protected void calcNominalFracts(int obsOrdinal) {
        int i;
        int lastObs;
        int firstObs;
        int group;
        SgObsSortContext pm;
        if (!this.isNominal()) {
            throw new UnsupportedOperationException("only nominal variable supports this operation");
        }
        if (!this.isFractOn()) {
            return;
        }
        PermutationPolicy policy = this.getFractPolicy();
        if (policy == null) {
            pm = new SgObsSortContext();
            pm.init(this.m_dataModel, new SgObsSortPolicy((DataModel)this.m_dataModel, this.m_varIndex, true, "internal use"));
            pm.doPermutation();
        } else {
            pm = this.m_dataModel.getObsPermutation(policy);
        }
        int numGroups = pm.getNumGroups();
        SgObsBooleanProp obsGraphed = (SgObsBooleanProp)this.m_dataModel.getObsPropertyModel("Obs Graphed");
        int numGraphedGroups = 0;
        if (obsGraphed != null) {
            for (group = 0; group < numGroups; ++group) {
                firstObs = pm.getFirstInGroup(group);
                lastObs = pm.getLastInGroup(group);
                boolean found = false;
                for (i = firstObs; !found && i <= lastObs; ++i) {
                    found = obsGraphed.get(pm.findIndex(i));
                }
                if (!found) continue;
                ++numGraphedGroups;
            }
        } else {
            numGraphedGroups = numGroups;
        }
        double offset = 1.0 / (double)(2 * numGraphedGroups);
        this.m_fractScale = 1.0 / (double)numGraphedGroups;
        int newGroupIndex = pm.findGroup(pm.findOrdinal(obsOrdinal));
        if (obsOrdinal >= 0 && numGraphedGroups == this.m_numOldGroups && pm.getLastInGroup(newGroupIndex) - pm.getFirstInGroup(newGroupIndex) > 0) {
            for (group = 0; group < numGroups; ++group) {
                firstObs = pm.getFirstInGroup(group);
                lastObs = pm.getLastInGroup(group);
                for (i = firstObs; i <= lastObs; ++i) {
                    if (obsOrdinal != pm.findIndex(i)) continue;
                    int fractValue = obsGraphed == null || obsGraphed.get(obsOrdinal) ? SgFract.doubleToFract(2.0 * (offset + (double)group * this.m_fractScale) - 1.0) : SgFract.doubleToFract(0.0);
                    this.m_fractValues[this.m_dataModel.m_obsHandles[obsOrdinal]] = fractValue;
                    return;
                }
            }
        } else {
            for (group = 0; group < numGroups; ++group) {
                firstObs = pm.getFirstInGroup(group);
                lastObs = pm.getLastInGroup(group);
                int fractValue = SgFract.doubleToFract(2.0 * (offset + (double)group * this.m_fractScale) - 1.0);
                for (i = firstObs; i <= lastObs; ++i) {
                    this.m_fractValues[this.m_dataModel.m_obsHandles[pm.findIndex((int)i)]] = fractValue;
                }
            }
        }
        this.m_numOldGroups = numGraphedGroups;
    }
}

