/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sg.datamodel.impl;

import com.sas.sg.datamodel.DataModel;
import com.sas.sg.datamodel.DataReaderModel;
import com.sas.sg.datamodel.DataWriterModel;
import com.sas.sg.datamodel.ObsDataEvent;
import com.sas.sg.datamodel.ObsPermutationModel;
import com.sas.sg.datamodel.ObsPropertyModel;
import com.sas.sg.datamodel.PermutationPolicy;
import com.sas.sg.datamodel.ValueDataEvent;
import com.sas.sg.datamodel.VarDataEvent;
import com.sas.sg.datamodel.impl.SgAbstractDataModel;
import com.sas.sg.datamodel.impl.SgCharacterVar;
import com.sas.sg.datamodel.impl.SgGenericVar;
import com.sas.sg.datamodel.impl.SgNumericVar;
import com.sas.sg.datamodel.impl.SgObsManager;
import com.sas.sg.datamodel.impl.SgVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class SgDataModel
extends SgAbstractDataModel {
    protected SgObsManager m_obsManager = new SgObsManager(this);
    protected int m_numObs;
    protected int[] m_obsHandles;
    protected int[] m_obsOrdinals;
    protected int m_numVars;
    protected SgVariable[] m_vars;

    public SgDataModel() {
    }

    public SgDataModel(DataReaderModel reader, DataWriterModel writer) {
        this.setDataReader(reader);
        this.setDataWriter(writer);
    }

    public SgDataModel(int numVars, int numObs) {
        int i;
        if (numVars < 0 || numObs < 0) {
            throw new IllegalArgumentException();
        }
        if (numObs > 0) {
            this.m_obsHandles = new int[numObs];
            this.m_obsOrdinals = new int[numObs];
            for (i = 0; i < numObs; ++i) {
                this.m_obsOrdinals[i] = i;
                this.m_obsHandles[i] = i;
            }
        }
        this.m_numObs = numObs;
        this.m_numVars = numVars;
        if (numVars > 0) {
            this.m_vars = new SgVariable[numVars];
            for (i = 0; i < numVars; ++i) {
                this.m_vars[i] = new SgNumericVar(this, i, numObs);
            }
        }
    }

    public int getNumVars() {
        return this.m_numVars;
    }

    public void addVars(int varIndex, int numVars, String varType) {
        int i;
        if (varIndex > this.m_numVars || varIndex < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (numVars <= 0) {
            return;
        }
        int obsCapacity = this.m_obsHandles != null ? this.m_obsHandles.length : 1;
        ArrayList<SgVariable> list = this.m_vars != null ? new ArrayList<SgVariable>(Arrays.asList(this.m_vars)) : new ArrayList();
        for (i = 0; i < numVars; ++i) {
            if (varType.equals("Numeric Variable")) {
                list.add(varIndex, new SgNumericVar(this, 0, obsCapacity));
                continue;
            }
            if (varType.equals("Charater Variable")) {
                list.add(varIndex, new SgCharacterVar(this, 0, obsCapacity));
                continue;
            }
            if (varType.equals("Generic Object Variable")) {
                list.add(varIndex, new SgGenericVar(this, 0, obsCapacity));
                continue;
            }
            throw new IllegalArgumentException("wrong variable type");
        }
        this.m_numVars += numVars;
        this.m_vars = new SgVariable[this.m_numVars];
        for (i = 0; i < this.m_numVars; ++i) {
            this.m_vars[i] = list.get(i);
        }
        for (i = 0; i < this.m_numVars; ++i) {
            this.m_vars[i].m_varIndex = i;
        }
        this.fireVarChange(new VarDataEvent((DataModel)this, 1, -1, varIndex, numVars));
    }

    public void deleteVars(int startIndex, int endIndex) {
        int i;
        if (startIndex < 0 || startIndex >= this.m_numVars || endIndex < 0 || endIndex >= this.m_numVars) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (startIndex > endIndex) {
            throw new IllegalArgumentException("startIndex > endIndex");
        }
        ArrayList<SgVariable> list = new ArrayList<SgVariable>(Arrays.asList(this.m_vars));
        for (i = endIndex; i >= startIndex; --i) {
            list.remove(i);
        }
        this.m_numVars -= endIndex - startIndex + 1;
        this.m_vars = new SgVariable[this.m_numVars];
        for (i = 0; i < this.m_numVars; ++i) {
            this.m_vars[i] = list.get(i);
        }
        for (i = 0; i < this.m_numVars; ++i) {
            this.m_vars[i].m_varIndex = i;
        }
        this.fireVarChange(new VarDataEvent((DataModel)this, 2, startIndex, -1, endIndex - startIndex + 1));
    }

    public void moveVars(int fromIndex, int toIndex, int numVars) {
        int i;
        int endIndex = fromIndex + numVars;
        if (fromIndex < 0 || fromIndex >= this.m_numVars || toIndex < 0 || toIndex >= numVars || numVars <= 0 || endIndex >= this.m_numVars) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (fromIndex <= toIndex && toIndex <= endIndex) {
            return;
        }
        ArrayList<SgVariable> list = new ArrayList<SgVariable>(Arrays.asList(this.m_vars));
        boolean shift = toIndex < fromIndex;
        for (i = fromIndex; i <= endIndex; ++i) {
            list.add(toIndex, list.remove(i));
            if (!shift) continue;
            ++toIndex;
        }
        this.m_vars = new SgVariable[this.m_numVars];
        for (i = 0; i < this.m_numVars; ++i) {
            this.m_vars[i] = list.get(i);
        }
        for (i = 0; i < this.m_numVars; ++i) {
            this.m_vars[i].m_varIndex = i;
        }
        this.fireVarChange(new VarDataEvent((DataModel)this, 3, fromIndex, toIndex, numVars));
    }

    public int findVarIndex(String varName) {
        for (int varIndex = 0; varIndex < this.m_numVars; ++varIndex) {
            if (!this.m_vars[varIndex].getName().equalsIgnoreCase(varName)) continue;
            return varIndex;
        }
        return -1;
    }

    public void setVarName(int varIndex, String varName) {
        if (this.getVarName(varIndex).equals(varName)) {
            return;
        }
        this.m_vars[varIndex].setName(varName);
        this.fireVarChange(new VarDataEvent((DataModel)this, 4, varIndex));
    }

    public String getVarName(int varIndex) {
        return this.m_vars[varIndex].getName();
    }

    public void setVarType(int varIndex, String typeName) {
        throw new UnsupportedOperationException("this method yet to support");
    }

    public String getVarType(int varIndex) {
        return this.m_vars[varIndex].getValueType();
    }

    public boolean isVarNumeric(int varIndex) {
        return this.m_vars[varIndex].getValueType().equals("Numeric Variable");
    }

    public boolean isVarCharacter(int varIndex) {
        return this.m_vars[varIndex].getValueType().equals("Charater Variable");
    }

    public boolean isVarGeneric(int varIndex) {
        return this.m_vars[varIndex].getValueType().equals("Generic Object Variable");
    }

    public void setVarLabel(int varIndex, String varLabel) {
        if (this.getVarLabel(varIndex).equals(varLabel)) {
            return;
        }
        this.m_vars[varIndex].setLabel(varLabel);
        this.fireVarChange(new VarDataEvent((DataModel)this, 5, varIndex));
    }

    public String getVarLabel(int varIndex) {
        return this.m_vars[varIndex].getLabel();
    }

    public void setVarFormat(int varIndex, Object varFormat) {
        if (this.getVarFormat(varIndex) != null && this.getVarFormat(varIndex).equals(varFormat)) {
            return;
        }
        this.m_vars[varIndex].setFormat(varFormat);
        this.fireVarChange(new VarDataEvent((DataModel)this, 7, varIndex));
    }

    public Object getVarFormat(int varIndex) {
        return this.m_vars[varIndex].getFormat();
    }

    public void setVarInformat(int varIndex, Object varInformat) {
        if (this.getVarInformat(varIndex) != null && this.getVarInformat(varIndex).equals(varInformat)) {
            return;
        }
        this.m_vars[varIndex].setInformat(varInformat);
        this.fireVarChange(new VarDataEvent((DataModel)this, 8, varIndex));
    }

    public Object getVarInformat(int varIndex) {
        return this.m_vars[varIndex].getInformat();
    }

    public void setVarMissingValue(int varIndex, Object missingValue) {
        if (this.getVarMissingValue(varIndex) != null && this.getVarMissingValue(varIndex).equals(missingValue)) {
            return;
        }
        this.m_vars[varIndex].setDefaultMissingValue(missingValue);
        this.fireVarChange(new VarDataEvent((DataModel)this, 10, varIndex));
    }

    public Object getVarMissingValue(int varIndex) {
        return this.m_vars[varIndex].getDefaultMissingValue();
    }

    public void setVarNominal(int varIndex, boolean isNominal) {
        if (this.isVarNominal(varIndex) == isNominal) {
            return;
        }
        this.m_vars[varIndex].setNominal(isNominal);
        this.fireVarChange(new VarDataEvent((DataModel)this, 9, varIndex));
    }

    public boolean isVarNominal(int varIndex) {
        return this.m_vars[varIndex].isNominal();
    }

    protected void setVarFractPolicy(int varIndex, PermutationPolicy policy) {
        if (this.getVarFractPolicy(varIndex) == policy) {
            return;
        }
        this.m_vars[varIndex].setFractPolicy(policy);
    }

    protected PermutationPolicy getVarFractPolicy(int varIndex) {
        return this.m_vars[varIndex].getFractPolicy();
    }

    public int getNumObs() {
        return this.m_numObs;
    }

    public void addObs(int obsIndex, int numObs) {
        if (numObs <= 0) {
            return;
        }
        this.m_obsManager.addObs(obsIndex, numObs);
        for (int obsIdx = obsIndex; obsIdx < obsIndex + numObs; ++obsIdx) {
            int obsHandle = this.m_obsHandles[obsIdx];
            for (int varIdx = 0; varIdx < this.getNumVars(); ++varIdx) {
                this.m_vars[varIdx].setMissingValues(obsHandle, obsHandle);
            }
        }
        Iterator iterator = this.m_obsPropModels.values().iterator();
        while (iterator.hasNext()) {
            ((ObsPropertyModel)iterator.next()).obsAdded(obsIndex, numObs);
        }
        iterator = this.m_obsPermutations.values().iterator();
        while (iterator.hasNext()) {
            ((ObsPermutationModel)iterator.next()).obsAdded(obsIndex, numObs);
        }
        this.fireObsChange(new ObsDataEvent((DataModel)this, 1, -1, obsIndex, numObs));
    }

    public void deleteObs(int startIndex, int endIndex) {
        this.m_obsManager.deleteObs(startIndex, endIndex);
        Iterator iterator = this.m_obsPropModels.values().iterator();
        while (iterator.hasNext()) {
            ((ObsPropertyModel)iterator.next()).obsDeleted(startIndex, endIndex);
        }
        iterator = this.m_obsPermutations.values().iterator();
        while (iterator.hasNext()) {
            ((ObsPermutationModel)iterator.next()).obsDeleted(startIndex, endIndex);
        }
        this.fireObsChange(new ObsDataEvent((DataModel)this, 2, startIndex, -1, endIndex - startIndex + 1));
    }

    public void deleteObs(ObsPropertyModel obsProperty, Object propValue) {
        int i;
        if (obsProperty.isComparable()) {
            throw new IllegalArgumentException("this observation property is not comparable");
        }
        int numDeletedObs = obsProperty.getNumObsWith(propValue);
        if (numDeletedObs == 0) {
            return;
        }
        if (this.m_obsList == null || this.m_obsList.length < numDeletedObs) {
            this.m_obsList = new int[numDeletedObs];
        }
        int j = 0;
        for (i = 0; i < this.m_numObs; ++i) {
            if (!obsProperty.getValue(i).equals(propValue)) continue;
            this.m_obsList[j++] = i;
        }
        for (i = numDeletedObs - 1; i >= 0; --i) {
            this.m_obsManager.deleteObs(this.m_obsList[i], this.m_obsList[i]);
        }
        Iterator iterator = this.m_obsPropModels.values().iterator();
        while (iterator.hasNext()) {
            ((ObsPropertyModel)iterator.next()).obsDeleted(this.m_obsList, numDeletedObs);
        }
        iterator = this.m_obsPermutations.values().iterator();
        while (iterator.hasNext()) {
            ((ObsPermutationModel)iterator.next()).obsDeleted(this.m_obsList, numDeletedObs);
        }
        this.fireObsChange(new ObsDataEvent((DataModel)this, 5, this.m_obsList, -1, -1, numDeletedObs));
    }

    public void moveObs(int fromIndex, int toIndex, int numObs) {
        if (numObs <= 0) {
            return;
        }
        this.m_obsManager.moveObs(fromIndex, toIndex, numObs);
        Iterator iterator = this.m_obsPropModels.values().iterator();
        while (iterator.hasNext()) {
            ((ObsPropertyModel)iterator.next()).obsMoved(fromIndex, toIndex, numObs);
        }
        iterator = this.m_obsPermutations.values().iterator();
        while (iterator.hasNext()) {
            ((ObsPermutationModel)iterator.next()).obsMoved(fromIndex, toIndex, numObs);
        }
        this.fireObsChange(new ObsDataEvent((DataModel)this, 3, fromIndex, toIndex, numObs));
    }

    public void moveObs(ObsPropertyModel obsProperty, Object propValue, int toIndex) {
        if (obsProperty.isComparable()) {
            throw new IllegalArgumentException("this observation property is not comparable");
        }
        int numMovedObs = obsProperty.getNumObsWith(propValue);
        if (numMovedObs == 0) {
            return;
        }
        if (this.m_obsList == null || this.m_obsList.length < numMovedObs) {
            this.m_obsList = new int[numMovedObs];
        }
        int a = -1;
        int j = 0;
        for (int i = 0; i < this.m_numObs; ++i) {
            if (!obsProperty.getValue(i).equals(propValue)) continue;
            this.m_obsList[j] = i;
            if (i <= toIndex) {
                a = j;
            }
            ++j;
        }
        if (a == numMovedObs - 1 && this.m_obsList[a] < toIndex) {
            ++a;
        }
        this.m_obsManager.moveObs(this.m_obsList, numMovedObs, toIndex, a);
        Iterator iterator = this.m_obsPropModels.values().iterator();
        while (iterator.hasNext()) {
            ((ObsPropertyModel)iterator.next()).obsMoved(this.m_obsList, numMovedObs, toIndex);
        }
        iterator = this.m_obsPermutations.values().iterator();
        while (iterator.hasNext()) {
            ((ObsPermutationModel)iterator.next()).obsMoved(this.m_obsList, numMovedObs, toIndex);
        }
        this.fireObsChange(new ObsDataEvent((DataModel)this, 6, this.m_obsList, -1, toIndex, numMovedObs));
    }

    public void permuteObs(ObsPermutationModel permutation) {
        if (this.m_obsList == null || this.m_obsList.length < this.m_numObs) {
            this.m_obsList = new int[this.m_numObs];
        }
        for (int i = 0; i < this.m_numObs; ++i) {
            int oldOrdinal = permutation.findIndex(i);
            int oldHandle = this.m_obsHandles[oldOrdinal];
            this.m_obsOrdinals[oldHandle] = i;
            this.m_obsHandles[oldOrdinal] = this.m_obsOrdinals[i];
            this.m_obsHandles[i] = oldHandle;
            this.m_obsList[i] = oldOrdinal;
        }
        this.fireObsChange(new ObsDataEvent((DataModel)this, 4, this.m_obsList, this.m_numObs));
    }

    public void permuteObs(int[] permutation) {
        if (permutation.length != this.m_numObs) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = 0; i < this.m_numObs; ++i) {
            int oldOrdinal = permutation[i];
            int oldHandle = this.m_obsHandles[oldOrdinal];
            this.m_obsOrdinals[oldHandle] = i;
            this.m_obsHandles[oldOrdinal] = this.m_obsOrdinals[i];
            this.m_obsHandles[i] = oldHandle;
        }
        this.fireObsChange(new ObsDataEvent((DataModel)this, 4, permutation, this.m_numObs));
    }

    public void setValue(int varIndex, int obsIndex, double value) {
        double oldValue = this.m_vars[varIndex].getDoubleValue(this.m_obsHandles[obsIndex]);
        if (!this.m_vars[varIndex].setValue(this.m_obsHandles[obsIndex], value)) {
            return;
        }
        if (this.m_obsPermutations.size() > 0) {
            Iterator iterator = this.m_obsPermutations.values().iterator();
            while (iterator.hasNext()) {
                ((ObsPermutationModel)iterator.next()).valueChanged(varIndex, obsIndex);
            }
        }
        if (this.m_listenerList.size() > 0) {
            this.fireValueChange(new ValueDataEvent((DataModel)this, 1, varIndex, obsIndex, (Object)new Double(oldValue)));
        }
    }

    public void setValue(int varIndex, int fromObsIndex, int toObsIndex, double[] values) {
        int numChanges = toObsIndex - fromObsIndex + 1;
        double[] valueArray = new double[numChanges];
        SgVariable var = this.m_vars[varIndex];
        boolean changed = false;
        int i = fromObsIndex;
        int j = 0;
        while (i <= toObsIndex) {
            int obsHandle = this.m_obsHandles[i];
            valueArray[j] = var.getDoubleValue(obsHandle);
            if (var.setValue(obsHandle, values[j])) {
                changed = true;
            }
            ++i;
            ++j;
        }
        if (!changed) {
            return;
        }
        Iterator iterator = this.m_obsPermutations.values().iterator();
        while (iterator.hasNext()) {
            ((ObsPermutationModel)iterator.next()).valueChanged(varIndex, fromObsIndex, toObsIndex);
        }
        this.fireValueChange(new ValueDataEvent((DataModel)this, 1, varIndex, fromObsIndex, (Object)valueArray, numChanges));
    }

    public void setValue(int varIndex, int obsIndex, Object value) {
        int obsHandle = this.m_obsHandles[obsIndex];
        Object oldValue = this.m_vars[varIndex].getValue(obsHandle);
        if (!this.m_vars[varIndex].setValue(obsHandle, value)) {
            return;
        }
        Iterator iterator = this.m_obsPermutations.values().iterator();
        while (iterator.hasNext()) {
            ((ObsPermutationModel)iterator.next()).valueChanged(varIndex, obsIndex);
        }
        this.fireValueChange(new ValueDataEvent((DataModel)this, 1, varIndex, obsIndex, oldValue));
    }

    public void setValue(int varIndex, int fromObsIndex, int toObsIndex, Object[] values) {
        int numChanges = toObsIndex - fromObsIndex + 1;
        Object[] valueArray = new Object[numChanges];
        SgVariable var = this.m_vars[varIndex];
        boolean changed = false;
        int i = fromObsIndex;
        int j = 0;
        while (i <= toObsIndex) {
            int obsHandle = this.m_obsHandles[i];
            valueArray[j] = var.getValue(obsHandle);
            if (var.setValue(obsHandle, values[j])) {
                changed = true;
            }
            ++i;
            ++j;
        }
        if (!changed) {
            return;
        }
        Iterator iterator = this.m_obsPermutations.values().iterator();
        while (iterator.hasNext()) {
            ((ObsPermutationModel)iterator.next()).valueChanged(varIndex, fromObsIndex, toObsIndex);
        }
        this.fireValueChange(new ValueDataEvent((DataModel)this, 1, varIndex, fromObsIndex, (Object)valueArray, numChanges));
    }

    public final Object getValue(int varIndex, int obsIndex) {
        return this.m_vars[varIndex].getValue(this.m_obsHandles[obsIndex]);
    }

    public final double getDoubleValue(int varIndex, int obsIndex) {
        return this.m_vars[varIndex].getDoubleValue(this.m_obsHandles[obsIndex]);
    }

    public String getStringValue(int varIndex, int obsIndex) {
        return this.m_vars[varIndex].getStringValue(this.m_obsHandles[obsIndex]);
    }

    public double getMinValue(int varIndex) {
        return this.m_vars[varIndex].getMinValue();
    }

    public double getMaxValue(int varIndex) {
        return this.m_vars[varIndex].getMaxValue();
    }

    public boolean isValueMissing(int varIndex, int obsIndex) {
        return this.m_vars[varIndex].isValueMissing(obsIndex);
    }

    public int getMaxCharLength(int varIndex, boolean formated) {
        return 1024;
    }

    public void loadFract(int varIndex, double margin) {
        this.m_vars[varIndex].setFractMargin(margin);
        this.m_vars[varIndex].setFractOn(true);
    }

    public double getFract(int varIndex, int obsIndex) {
        return this.m_vars[varIndex].getNormalizedValue(this.m_obsHandles[obsIndex]);
    }

    public long getFractLong(int varIndex, int obsIndex) {
        return this.m_vars[varIndex].getFractValue(this.m_obsHandles[obsIndex]);
    }
}

