/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sg.datamodel.impl;

import com.sas.sg.datamodel.DataModel;
import com.sas.sg.datamodel.DataReaderModel;
import com.sas.sg.datamodel.DataWriterModel;
import java.io.File;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class SgDataDriverJDBC
implements DataReaderModel,
DataWriterModel {
    protected DataModel m_dataModel;
    protected Properties m_properties;
    protected String m_url;
    protected String m_libName;
    protected String m_memName;
    protected String m_dirName;
    protected String[] m_varNames;
    protected Object m_whereClause;
    protected Driver m_driver;
    protected Connection m_db;
    protected Statement m_statement;

    protected SgDataDriverJDBC() {
    }

    public SgDataDriverJDBC(DataModel dataModel, String url, String libName, String memName) {
        this(dataModel, url, libName, memName, null, null);
    }

    public SgDataDriverJDBC(DataModel dataModel, String url, String filePath) {
        this(dataModel, url, filePath, null, null);
    }

    public SgDataDriverJDBC(DataModel dataModel, String url, String libName, String memName, String[] varNames, Object whereClause) {
        if (dataModel == null || libName == null || memName == null) {
            throw new IllegalArgumentException("null references");
        }
        this.doConstruct(dataModel, url, null, libName, memName, varNames, whereClause);
    }

    public SgDataDriverJDBC(DataModel dataModel, String url, String filePath, String[] varNames, Object whereClause) {
        if (dataModel == null || filePath == null) {
            throw new IllegalArgumentException("null references");
        }
        File path = new File(filePath);
        String fileName = path.getName();
        int i = fileName.indexOf(46);
        if (i == 0) {
            throw new IllegalArgumentException("invalid file name");
        }
        if (i > 0) {
            fileName = fileName.substring(0, i);
        }
        this.doConstruct(dataModel, url, path.getParent(), null, fileName, varNames, whereClause);
    }

    private void doConstruct(DataModel dataModel, String url, String dirName, String libName, String memName, String[] varNames, Object whereClause) {
        this.m_dataModel = dataModel;
        this.m_dirName = dirName;
        this.m_libName = libName;
        this.m_memName = memName;
        if (this.m_libName == null && this.m_dirName == null || this.m_memName == null) {
            throw new IllegalArgumentException("Data set location is not speicified correctly");
        }
        this.m_url = url == null ? "jdbc:sharenet://localhost:5002" : new String(url);
        try {
            this.m_driver = (Driver)Class.forName("com.sas.net.sharenet.ShareNetDriver").newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_properties = new Properties();
        this.m_properties.put("encryptionPolicy", new String("none"));
        this.m_properties.put("encryptionAlgorithms", new String("encryption_algorithm_value(s)"));
        if (varNames != null) {
            this.m_varNames = new String[varNames.length];
            System.arraycopy(varNames, 0, this.m_varNames, 0, varNames.length);
        }
        this.m_whereClause = whereClause;
        if (this.m_varNames != null) {
            // empty if block
        }
    }

    public void finalize() throws Throwable {
        if (this.m_statement != null) {
            this.m_statement.close();
            this.m_statement = null;
        }
        if (this.m_db != null) {
            this.m_db.close();
            this.m_db = null;
        }
        this.m_driver = null;
        this.m_properties = null;
        this.m_dataModel = null;
        this.m_varNames = null;
        this.m_whereClause = null;
        super.finalize();
    }

    public void setProperty(String key, String value) {
        this.m_properties.put(key, value);
    }

    public String getProperty(String key) {
        return this.m_properties.getProperty(key);
    }

    public void setWhereClause(Object whereClause) {
        this.m_whereClause = whereClause;
    }

    public Object getWhereClause() {
        return this.m_whereClause;
    }

    public void readData() {
        this.readData(this.m_varNames, this.m_whereClause);
    }

    public void readData(Object whereClause) {
        this.setWhereClause(whereClause);
        this.readData(this.m_varNames, this.m_whereClause);
    }

    protected void readData(String[] varNames, Object whereClause) {
        String libName = this.m_libName != null ? this.m_libName : "sgdata";
        this.initDB(libName, this.m_dirName);
        int[] varIndices = null;
        if (varNames != null) {
            varIndices = new int[varNames.length];
            for (int varIndex = 0; varIndex < this.m_dataModel.getNumVars(); ++varIndex) {
                String varName = this.m_dataModel.getVarName(varIndex);
                for (int i = 0; i < varNames.length; ++i) {
                    if (!varName.equals(varNames[i])) continue;
                    varIndices[i] = varIndex;
                }
            }
        }
        this.readDB(libName, this.m_memName, varIndices, whereClause);
        this.closeDB(libName);
    }

    public void writeData() {
        this.writeData((int[])null, null);
    }

    public void writeData(int[] varIndices, Object whereClause) {
        String libName = this.m_libName != null ? this.m_libName : "sgdata";
        this.writeData(libName, this.m_dirName, this.m_memName, varIndices, whereClause);
    }

    public void writeData(String filePath) {
        this.writeData(filePath, null, null);
    }

    public void writeData(String filePath, int[] varIndices, Object whereClause) {
        if (this.m_dataModel == null) {
            throw new IllegalArgumentException("null data model references");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("null file path");
        }
        File path = new File(filePath);
        String fileName = path.getName();
        int i = fileName.indexOf(46);
        if (i == 0) {
            throw new IllegalArgumentException("invalid file name");
        }
        if (i > 0) {
            fileName = fileName.substring(0, i);
        }
        String libName = "sgdata";
        this.writeData(libName, path.getParent(), fileName, varIndices, whereClause);
    }

    public void writeData(String libName, String memName) {
        this.writeData(libName, memName, null, null);
    }

    public void writeData(String libName, String memName, int[] varIndices, Object whereClause) {
        if (libName == null) {
            throw new IllegalArgumentException("null lib name");
        }
        if (memName == null) {
            throw new IllegalArgumentException("null member name");
        }
        this.writeData(libName, null, memName, varIndices, whereClause);
    }

    protected void writeData(String libName, String libRef, String memName, int[] varIndices, Object whereClause) {
        this.initDB(libName, libRef);
        this.writeDB(libName, memName, varIndices, whereClause);
        this.closeDB(libRef != null ? libName : null);
    }

    protected void initDB(String libName, String libRef) {
        if (libName != null && libRef != null) {
            this.m_properties.put("librefs", libName + " '" + libRef + "';");
        }
        try {
            this.m_db = this.m_driver.connect(this.m_url, this.m_properties);
            this.m_statement = this.m_db.createStatement();
        }
        catch (Exception e) {
            System.out.println("Could not initialize the database.");
            e.printStackTrace();
        }
    }

    protected void closeDB(String libName) {
        try {
            if (libName != null) {
                this.m_statement.execute("libname " + libName + " ' '");
            }
            if (this.m_statement != null) {
                this.m_statement.close();
                this.m_statement = null;
            }
            if (this.m_db != null) {
                this.m_db.close();
                this.m_db = null;
            }
        }
        catch (Exception e) {
            System.out.println("Could not close the current connection.");
            e.printStackTrace();
        }
    }

    protected void readDB(String libName, String memName, int[] varIndices, Object whereClause) {
        try {
            int varType;
            String sqlQuery;
            String fromData = " from " + libName + '.' + memName;
            if (whereClause != null) {
                fromData = fromData + ' ' + whereClause.toString();
            }
            ResultSet rs = this.m_statement.executeQuery("select count(*) " + fromData);
            rs.next();
            int numObs = (int)rs.getDouble(1);
            if (varIndices == null) {
                sqlQuery = "select *";
            } else {
                sqlQuery = "select ";
                for (int i = 0; i < varIndices.length; ++i) {
                    int varIndex = varIndices[i];
                    sqlQuery = sqlQuery + this.m_dataModel.getVarName(varIndex) + (i == varIndices.length - 1 ? (char)',' : ' ');
                }
            }
            sqlQuery = sqlQuery + fromData;
            rs = this.m_statement.executeQuery(sqlQuery);
            ResultSetMetaData meta = rs.getMetaData();
            int colCount = meta.getColumnCount();
            int i = 1;
            int j = 0;
            while (i <= colCount) {
                varType = meta.getColumnType(i);
                this.m_dataModel.addVars(j, 1, this.isNumericType(varType) ? "Numeric Variable" : "Charater Variable");
                this.m_dataModel.setVarName(j, meta.getColumnName(i));
                this.m_dataModel.setVarLabel(j, meta.getColumnLabel(i));
                this.m_dataModel.setVarFormat(j, (Object)meta.getColumnTypeName(i));
                ++i;
                ++j;
            }
            System.out.println("number of variables: " + this.m_dataModel.getNumVars());
            System.out.println(" number of observations:  " + numObs);
            if (numObs > 0) {
                this.m_dataModel.addObs(0, numObs);
            }
            rs = this.m_statement.executeQuery(sqlQuery);
            char[] charValue = new char[100];
            int obsIndex = 0;
            while (rs.next()) {
                i = 1;
                int varIndex = 0;
                while (i <= colCount) {
                    varType = meta.getColumnType(i);
                    if (this.isNumericType(varType)) {
                        double numericValue = rs.getDouble(i);
                        if (rs.wasNull()) {
                            numericValue = Double.NaN;
                        }
                        this.m_dataModel.setValue(varIndex, obsIndex, numericValue);
                    } else {
                        String strValue = rs.getString(i);
                        this.m_dataModel.setValue(varIndex, obsIndex, (Object)strValue);
                    }
                    ++i;
                    ++varIndex;
                }
                ++obsIndex;
            }
            if (rs != null) {
                rs.close();
            }
            this.m_dataModel.setDataName(this.m_memName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void writeDB(String libName, String memName, int[] varIndices, Object whereClause) {
        try {
            int varIndex;
            int i;
            String empty = new String();
            int numVars = varIndices == null ? this.m_dataModel.getNumVars() : varIndices.length;
            String sqlUpdate = "create table " + libName + '.' + memName + " ( ";
            for (i = 0; i < numVars; ++i) {
                varIndex = varIndices != null ? varIndices[i] : i;
                String name = this.m_dataModel.getVarName(varIndex);
                String label = this.m_dataModel.getVarLabel(varIndex);
                String format = this.m_dataModel.getVarFormat(varIndex).toString();
                String informat = this.m_dataModel.getVarInformat(varIndex).toString();
                sqlUpdate = sqlUpdate + (i > 0 ? ", " : " ") + name + ' ' + (this.m_dataModel.isVarNumeric(varIndex) ? "DOUBLE PRECISION" : "VARCHAR(256)");
                if (format != null && !format.equals(empty)) {
                    sqlUpdate = sqlUpdate + " format=" + format;
                }
                if (informat != null && !informat.equals(empty)) {
                    sqlUpdate = sqlUpdate + " informat=" + informat;
                }
                if (label == null || label.equals(empty)) continue;
                sqlUpdate = sqlUpdate + " label=\"" + label + "\"";
            }
            sqlUpdate = sqlUpdate + " )";
            this.m_statement.executeUpdate(sqlUpdate);
            boolean isBatchSupported = true;
            try {
                this.m_db.setAutoCommit(false);
                this.m_statement.clearBatch();
            }
            catch (Exception e) {
                isBatchSupported = false;
            }
            String INSERTVALUES = "insert into " + libName + '.' + memName + " values(";
            String WHERECLAUSE = " ";
            if (whereClause != null) {
                WHERECLAUSE = WHERECLAUSE + whereClause.toString();
            }
            StringBuffer buffer = new StringBuffer();
            for (int obsIndex = 0; obsIndex < this.m_dataModel.getNumObs(); ++obsIndex) {
                buffer.delete(0, buffer.length());
                buffer.append(INSERTVALUES);
                for (i = 0; i < numVars; ++i) {
                    varIndex = varIndices != null ? varIndices[i] : i;
                    buffer.append(i == 0 ? (char)' ' : ',');
                    if (this.m_dataModel.isVarNumeric(varIndex)) {
                        buffer.append(this.m_dataModel.getValue(varIndex, obsIndex));
                        continue;
                    }
                    String value = this.m_dataModel.getValue(varIndex, obsIndex).toString();
                    buffer.append('\"').append(value).append('\"');
                }
                buffer.append(')');
                buffer.append(WHERECLAUSE);
                if (isBatchSupported) {
                    this.m_statement.addBatch(buffer.toString());
                    continue;
                }
                this.m_statement.executeUpdate(buffer.toString());
            }
            if (isBatchSupported) {
                this.m_statement.executeBatch();
                this.m_statement.clearBatch();
                this.m_db.setAutoCommit(true);
            }
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    private String getVarTypeName(int sqlType) {
        String str = " ";
        switch (sqlType) {
            case 2003: {
                str = new String(" ARRAY ");
                break;
            }
            case -5: {
                str = new String(" BIGINT ");
                break;
            }
            case -2: {
                str = new String(" BINARY ");
                break;
            }
            case -7: {
                str = new String(" BIT ");
                break;
            }
            case 2004: {
                str = new String(" BLOB ");
                break;
            }
            case 1: {
                str = new String(" CHAR ");
                break;
            }
            case 2005: {
                str = new String(" CLOB ");
                break;
            }
            case 91: {
                str = new String(" DATE ");
                break;
            }
            case 3: {
                str = new String(" DECIMAL ");
                break;
            }
            case 2001: {
                str = new String(" DISTINCT ");
                break;
            }
            case 8: {
                str = new String(" DOUBLE ");
                break;
            }
            case 6: {
                str = new String(" FLOAT ");
                break;
            }
            case 4: {
                str = new String(" INTEGER ");
                break;
            }
            case 2000: {
                str = new String(" JAVA_OBJECT ");
                break;
            }
            case -4: {
                str = new String(" LONGVARBINARY ");
                break;
            }
            case -1: {
                str = new String(" LONGVARCHAR ");
                break;
            }
            case 0: {
                str = new String(" NULL ");
                break;
            }
            case 2: {
                str = new String(" NUMERIC ");
                break;
            }
            case 1111: {
                str = new String(" OTHER ");
                break;
            }
            case 7: {
                str = new String(" REAL ");
                break;
            }
            case 2006: {
                str = new String(" REF ");
                break;
            }
            case 5: {
                str = new String(" SMALLINT ");
                break;
            }
            case 2002: {
                str = new String(" STRUCT ");
                break;
            }
            case 92: {
                str = new String(" TIME ");
                break;
            }
            case 93: {
                str = new String(" TIMESTAMP ");
                break;
            }
            case -6: {
                str = new String(" TINYINT ");
                break;
            }
            case -3: {
                str = new String(" VARBINARY ");
                break;
            }
            case 12: {
                str = new String(" VARCHAR ");
            }
        }
        return str;
    }

    protected boolean isNumericType(int sqlType) {
        boolean isNumeric;
        switch (sqlType) {
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                isNumeric = true;
                break;
            }
            default: {
                isNumeric = false;
            }
        }
        return isNumeric;
    }

    public DataModel getDataModel() {
        return null;
    }

    public void addDataReaderListener() {
    }

    public void removeDataReaderListener() {
    }

    public void addDataWriterListener() {
    }

    public void removeDataWriterListener() {
    }
}

